<?php
/*
 * Created by Artureanec
*/

namespace HFE\WidgetsManager\Widgets;

use Elementor\Group_Control_Image_Size;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Aigency_Search_Widget extends Widget_Base {

    public function get_name() {
        return 'aigency_search';
    }

    public function get_title() {
        return esc_html__('Search Trigger', 'aigency-plugin');
    }

    public function get_icon() {
        return 'eicon-search';
    }

    public function get_categories() {
        return ['hfe-widgets'];
    }

    public function get_script_depends() {
        return ['elementor_widgets'];
    }

    public function is_reload_preview_required() {
        return true;
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'search_section_content',
            [
                'label' => esc_html__('Search Trigger', 'aigency-plugin')
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label'     => esc_html__('Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .aigency-search-widget' => 'text-align: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

        // ----------------------------------- //
        // ---------- Icon Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'search_icon_section_settings',
            [
                'label' => esc_html__('Icon Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label'         => esc_html__('Icon Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .search-trigger .search-trigger-icon' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs('content_icon_tabs');
            // ------ Normal Tab ------ //
            $this->start_controls_tab(
                'tab_icon_normal',
                [
                    'label'     => esc_html__('Normal', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'icon_color_normal',
                    [
                        'label'     => esc_html__('Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .search-trigger-icon' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------ Hover Tab ------ //
            $this->start_controls_tab(
                'tab_icon_hover',
                [
                    'label'     => esc_html__('Hover', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'icon_color_hover',
                    [
                        'label'     => esc_html__('Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .search-trigger-icon:hover' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        // ----------------------------------- //
        // ---------- Card Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'search_card_section_settings',
            [
                'label' => esc_html__('Card Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'search_card_padding',
            [
                'label'         => esc_html__('Search Box Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em', 'rem', 'vw'],
                'selectors'     => [
                    '#site-search-{{ID}}.site-search' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'search_card_border',
                'selector'  => '#site-search-{{ID}}.site-search',
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'search_card_border_radius',
            [
                'label'         => esc_html__('Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '#site-search-{{ID}}.site-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'search_card_margin',
            [
                'label'         => esc_html__('Search Box Margins', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '#site-search-{{ID}}.site-search.active' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'search_card_shadow',
                'selector'  => '#site-search-{{ID}}.site-search',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'hr1',
            [
                'type' => Controls_Manager::DIVIDER
            ]
        );

        $this->add_control(
            'search_card_customize_colors',
            [
                'label'         => esc_html__('Customize Colors', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'search_card_dark_text_color',
            [
                'label'     => esc_html__('Dark Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '#site-search-{{ID}}.site-search' => '--aigency-header-dark-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'search_card_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'search_card_light_text_color',
            [
                'label'     => esc_html__('Light Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '#site-search-{{ID}}.site-search' => '--aigency-header-light-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'search_card_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'search_card_border_color_1',
            [
                'label'     => esc_html__('Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '#site-search-{{ID}}.site-search' => '--aigency-header-border-color: {{VALUE}};'
                ],
                'condition' => [
                    'search_card_customize_colors' => 'yes'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'search_card_background_color',
            [
                'label'     => esc_html__('Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '#site-search-{{ID}}.site-search' => '--aigency-header-background-color: {{VALUE}};'
                ],
                'condition' => [
                    'search_card_customize_colors' => 'yes'
                ]
            ]
        );       

        $this->end_controls_section();
    }

    protected function render() {
        $widget_id = $this->get_id();
        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
            echo '<div class="aigency-search-widget">';
                echo '<div class="search-trigger" data-id="' . esc_attr($widget_id) . '">';
                    echo '<span class="search-trigger-icon"></span>';
                 echo '</div>';
            echo '</div>';

            echo '<div class="site-search" id="site-search-' . esc_attr($widget_id) . '">';
                echo '<div class="site-search-close"></div>';
                $search_args = array(
                    'echo'          => true,
                    'aria_label'    => 'global'
                );
                echo get_search_form($search_args);
            echo '</div>';
    }

    protected function content_template() {}

    public function render_plain_content() {}

}
