<?php
/*
 * Created by Artureanec
*/

namespace HFE\WidgetsManager\Widgets;

use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Aigency_Page_Title_Widget extends Widget_Base {

    public function get_name() {
        return 'aigency_page_title';
    }

    public function get_title() {
        return esc_html__('Page Title Section', 'aigency-plugin');
    }

    public function get_icon() {
        return 'eicon-archive-title';
    }

    public function get_categories() {
        return ['hfe-widgets'];
    }

    public function get_script_depends() {
        return ['elementor_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'page_title_section_content',
            [
                'label' => esc_html__('Page Title Section', 'aigency-plugin')
            ]
        );

        $this->add_responsive_control(
            'page_title_height',
            [
                'label'         => esc_html__('Page Title Height', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vh'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .page-title-container' => 'min-height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'show_page_title',
            [
                'label'         => esc_html__('Show Page Name', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'yes'
            ]
        );

        $this->add_control(
            'page_title_type',
            [
                'label'         => esc_html__('Page Name Type', 'aigency-plugin'),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'default',
                'options'       => [
                    'default'       => esc_html__('Default', 'aigency-plugin'),
                    'custom'        => esc_html__('Custom', 'aigency-plugin')
                ],
                'condition'     => [
                    'show_page_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'page_title_custom',
            [
                'label'         => esc_html__('Page Name', 'aigency-plugin'),
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
                'condition'     => [
                    'show_page_title' => 'yes',
                    'page_title_type' => 'custom'
                ]
            ]
        );

        $this->add_responsive_control(
            'page_title_alignment',
            [
                'label'     => esc_html__('Page Name Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .page-title-box' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'show_page_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_breadcrumbs',
            [
                'label'         => esc_html__('Show Breadcrumbs', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'yes',
                'separator'     => 'before'
            ]
        );

        $this->add_responsive_control(
            'breadcrumbs_alignment',
            [
                'label'     => esc_html__('Breadcrumbs Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .breadcrumbs' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'show_breadcrumbs' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_breadcrumbs_add_text',
            [
                'label'         => esc_html__('Show Breadcrumbs Additional Text', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'yes',
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'breadcrumbs_add_text',
            [
                'label'         => esc_html__('Breadcrumbs Additional Text', 'aigency-plugin'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => '',
                'condition'     => [
                    'show_breadcrumbs_add_text' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_additional_text',
            [
                'label'         => esc_html__('Show Additional Text', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'yes',
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'additional_text',
            [
                'label'         => esc_html__('Additional Text', 'aigency-plugin'),
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
                'condition'     => [
                    'show_additional_text' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();


        // ---------------------------------- //
        // ---------- Box Settings ---------- //
        // ---------------------------------- //
        $this->start_controls_section(
            'box_section_settings',
            [
                'label' => esc_html__('Block Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label'         => esc_html__('Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .page-title-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'box_background',
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}} .page-title-container'
            ]
        );

        $this->add_control(
            'show_box_overlay',
            [
                'label'         => esc_html__('Show Overlay', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no',
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'box_overlay_color',
            [
                'label'     => esc_html__('Overlay Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .page-title-bg' => 'background-color: {{VALUE}};'
                ],
                'condition' => [
                    'show_box_overlay' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'breadcrumbs_box_border_radius',
            [
                'label'         => esc_html__('Breadcrumbs Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .page-title-container .breadcrumbs-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_breadcrumbs',
                            'operator' => '===',
                            'value' => 'yes',
                        ],
                        [
                            'name' => 'show_breadcrumbs_add_text',
                            'operator' => '===',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'breadcrumbs_background',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Breadcrumbs Block Background', 'aigency-plugin'),
                    ]
                ],
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}} .page-title-container .breadcrumbs-wrapper',
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_breadcrumbs',
                            'operator' => '===',
                            'value' => 'yes',
                        ],
                        [
                            'name' => 'show_breadcrumbs_add_text',
                            'operator' => '===',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();


        // ---------------------------------- //
        // ------- Page Name Settings ------- //
        // ---------------------------------- //
        $this->start_controls_section(
            'page_name_section_settings',
            [
                'label'     => esc_html__('Page Name Settings', 'aigency-plugin'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_page_title' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'page_name_typography',
                'label'     => esc_html__('Page Name Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .page-title-container .page-title-row .page-title'
            ]
        );

        $this->add_control(
            'page_name_color',
            [
                'label'     => esc_html__('Page Name Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .page-title-row .page-title' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'page_name_width',
            [
                'label'         => esc_html__('Page Name Width', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vh'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .page-title-box' => 'max-width: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();


        // ------------------------------------ //
        // ------- Breadcrumbs Settings ------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'breadcrumbs_section_settings',
            [
                'label'     => esc_html__('Breadcrumbs Settings', 'aigency-plugin'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_breadcrumbs' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'breadcrumbs_typography',
                'label'     => esc_html__('Breadcrumbs Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .page-title-container .breadcrumbs'
            ]
        );

        $this->add_control(
            'breadcrumbs_color',
            [
                'label'     => esc_html__('Breadcrumbs Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .breadcrumbs,
                     {{WRAPPER}} .page-title-container .breadcrumbs a' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'breadcrumbs_color_hover',
            [
                'label'     => esc_html__('Breadcrumbs Hover Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .breadcrumbs a:hover' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'breadcrumbs_sep_color',
            [
                'label'     => esc_html__('Breadcrumbs Separator Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .breadcrumbs .delimiter' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        // ---------------------------------------------------- //
        // ------- Breadcrumbs Additional Text Settings ------- //
        // ---------------------------------------------------- //
        $this->start_controls_section(
            'breadcrumbs_text_section_settings',
            [
                'label'     => esc_html__('Breadcrumbs Additional Text Settings', 'aigency-plugin'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_breadcrumbs_add_text' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'breadcrumbs_text_typography',
                'label'     => esc_html__('Breadcrumbs Additional Text Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .page-title-container .page-title-breadcrumbs-text'
            ]
        );

        $this->add_control(
            'breadcrumbs_text_color',
            [
                'label'     => esc_html__('Breadcrumbs Additional Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .page-title-breadcrumbs-text' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();


        // ------------------------------------ //
        // ----- Additional Text Settings ----- //
        // ------------------------------------ //
        $this->start_controls_section(
            'additional_text_section_settings',
            [
                'label'     => esc_html__('Additional Text Settings', 'aigency-plugin'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_additional_text' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'additional_text_typography',
                'label'     => esc_html__('Additional Text Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .page-title-container .page-title-additional'
            ]
        );

        $this->add_control(
            'additional_text_color',
            [
                'label'     => esc_html__('Additional Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .page-title-container .page-title-additional' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();        
    }

    protected function render() {
        $settings                   = $this->get_settings();

        $show_page_title            = $settings['show_page_title'];
        $page_title_type            = $settings['page_title_type'];
        $page_title_custom          = $settings['page_title_custom'];

        $show_breadcrumbs           = $settings['show_breadcrumbs'];
        $show_breadcrumbs_add_text  = $settings['show_breadcrumbs_add_text'];
        $breadcrumbs_add_text       = $settings['breadcrumbs_add_text'];

        $show_additional_text       = $settings['show_additional_text'];
        $additional_text            = $settings['additional_text'];

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>
            <div class="page-title-container">
                <div class="page-title-bg"></div>
                <div class="page-title-row">
                    <div class="page-title-wrapper">
                        <div class="page-title-box">
                            <?php
                                if ( $show_page_title == 'yes' ) {
                                    echo '<h1 class="page-title">';
                                        echo ( $page_title_type == 'custom' ? wp_kses($page_title_custom, 'post') : wp_kses(aigency_get_page_title(), 'post') );
                                    echo '</h1>';
                                }
                            ?>
                        </div>
                    </div>                        
                </div>
                <?php
                    if ( ( $show_additional_text == 'yes' ) && !empty($additional_text) ) {
                        echo '<div class="page-title-additional">' . esc_html($additional_text) . '</div>';
                    }
                ?>
                <?php
                    if ( $show_breadcrumbs == 'yes' || $show_breadcrumbs_add_text == 'yes' ) {
                        echo '<div class="breadcrumbs-wrapper">';
                            if ( $show_breadcrumbs == 'yes') {
                                aigency_breadcrumbs();
                            }
                            if ( $show_breadcrumbs_add_text == 'yes') {
                                if ( !empty($breadcrumbs_add_text) ) {
                                    echo '<h6 class="page-title-breadcrumbs-text">' . esc_html($breadcrumbs_add_text) . '</h6>';
                                }
                            }                            
                        echo '</div>';
                    }
                ?>
            </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}
