<?php
/*
 * Created by Artureanec
*/

namespace HFE\WidgetsManager\Widgets;

use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Aigency_Navigation_Menu_Widget extends Widget_Base {

    public function get_name() {
        return 'aigency_navigation_menu';
    }

    public function get_title() {
        return esc_html__('Navigation Menu', 'aigency-plugin');
    }

    public function get_icon() {
        return 'eicon-nav-menu';
    }

    public function get_categories() {
        return ['hfe-widgets'];
    }

    public function get_script_depends() {
        return ['elementor_widgets'];
    }

    public function is_reload_preview_required() {
        return true;
    }

    protected function register_controls() {

        // ---------------------------- //
        // --------- Nav Menu --------- //
        // ---------------------------- //
        $this->start_controls_section(
            'section_nav_menu',
            [
                'label' => esc_html__('Navigation Menu', 'aigency-plugin')
            ]
        );

        $this->add_control(
            'menu',
            [
                'label'         => esc_html__('Select Menu', 'aigency-plugin'),
                'label_block'   => true,
                'type'          => Controls_Manager::SELECT,
                'options'       => aigency_get_all_menu_list(),
                'default'       => 'default'
            ]
        );

        $this->add_control(
            'menu_style',
            [
                'label'         => esc_html__('Menu Style', 'aigency-plugin'),
                'label_block'   => true,
                'type'          => Controls_Manager::SELECT,                
                'default'       => 'standard',
                'options'       => [
                    'standard'   => esc_html__('Standard', 'aigency-plugin'),
                    'compact'    => esc_html__('Compact', 'aigency-plugin')
                ]
            ]
        );

        $this->add_control(
            'menu_label',
            [
                'label'     => esc_html__('Compact Menu Label', 'aigency-plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Menu', 'aigency-plugin'),
                'condition' => [
                    'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'compact_close_text',
            [
                'label'     => esc_html__('Compact Menu Close Button Text', 'aigency-plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Close', 'aigency-plugin'),
                'description'   => esc_html__('After changing this setting you need to Update changes to page via \'Apply\' button', 'aigency-plugin'),
                'condition' => [
                    'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'menu_type',
            [
                'label'         => esc_html__('Menu Type', 'aigency-plugin'),
                'label_block'   => true,
                'type'          => Controls_Manager::SELECT,                
                'default'       => 'default',
                'options'       => [
                    'default'   => esc_html__('Default', 'aigency-plugin'),
                    'logo'      => esc_html__('With Logo', 'aigency-plugin')
                ],
                'condition' => [
                    'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'menu_logo',
            [
                'label'     => esc_html__('Menu Logo', 'aigency-plugin'),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'           => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                	'menu_style' => 'standard',
                    'menu_type' => 'logo'
                ]
            ]
        );

        $this->add_responsive_control(
            'logo_width',
            [
                'label' => esc_html__( 'Menu Logo Width', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => 'px',
                ],
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container img' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                	'menu_style' => 'standard',
                    'menu_type' => 'logo'
                ]
            ]
        );

        $this->add_responsive_control(
            'logo_spacing',
            [
                'label' => esc_html__( 'Menu Logo Spacing', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => '%',
                ],
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .logo-link' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                	'menu_style' => 'standard',
                    'menu_type' => 'logo'
                ]
            ]
        );

        $this->add_responsive_control(
            'menu_alignment',
            [
                'label'     => esc_html__('Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container nav,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main,
                     {{WRAPPER}} .compact-menu' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'menu_type' => 'default'
                ]
            ]
        );

        $this->add_responsive_control(
            'menu_alignment_logo',
            [
                'label'     => esc_html__('Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'flex-start'      => [
                        'title'     => esc_html__('Left', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-center',
                    ],
                    'flex-end'     => [
                        'title'     => esc_html__('Right', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container.with-logo nav' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                	'menu_style' => 'standard',
                    'menu_type' => 'logo'
                ]
            ]
        );

        $this->add_control(
            'breakpoint',
            [
                'label'         => esc_html__('Breakpoint', 'aigency-plugin'),
                'label_block'   => true,
                'type'          => Controls_Manager::SELECT,
                'options'       => aigency_get_active_breakpoints(['widescreen']),
                'default'       => 'none',
                'responsive'    => true,
                'prefix_class'  => 'aigency-breakpoint-',
                'selectors'     => [
                    '(mobile){{WRAPPER}}.aigency-breakpoint-mobile .header-menu-container'             => 'display: none;',
                    '(mobile){{WRAPPER}}.aigency-breakpoint-mobile #mega-menu-wrap-main'               => 'display: none;',
                    '(mobile){{WRAPPER}}.aigency-breakpoint-mobile .compact-menu'                      => 'display: none;',
                    '(mobile_extra){{WRAPPER}}.aigency-breakpoint-mobile_extra .header-menu-container' => 'display: none;',
                    '(mobile_extra){{WRAPPER}}.aigency-breakpoint-mobile_extra #mega-menu-wrap-main'   => 'display: none;',
                    '(mobile_extra){{WRAPPER}}.aigency-breakpoint-mobile_extra .compact-menu'          => 'display: none;',
                    '(tablet){{WRAPPER}}.aigency-breakpoint-tablet .header-menu-container'             => 'display: none;',
                    '(tablet){{WRAPPER}}.aigency-breakpoint-tablet #mega-menu-wrap-main'               => 'display: none;',
                    '(tablet){{WRAPPER}}.aigency-breakpoint-tablet .compact-menu'                      => 'display: none;',
                    '(tablet_extra){{WRAPPER}}.aigency-breakpoint-tablet_extra .header-menu-container' => 'display: none;',
                    '(tablet_extra){{WRAPPER}}.aigency-breakpoint-tablet_extra #mega-menu-wrap-main'   => 'display: none;',
                    '(tablet_extra){{WRAPPER}}.aigency-breakpoint-tablet_extra .compact-menu'          => 'display: none;',
                    '(laptop){{WRAPPER}}.aigency-breakpoint-laptop .header-menu-container'             => 'display: none;',
                    '(laptop){{WRAPPER}}.aigency-breakpoint-laptop #mega-menu-wrap-main'               => 'display: none;',
                    '(laptop){{WRAPPER}}.aigency-breakpoint-laptop .compact-menu'                      => 'display: none;',
                    '(mobile){{WRAPPER}}.aigency-breakpoint-mobile .menu-trigger, 
                     {{WRAPPER}}.aigency-breakpoint-mobile .mobile-header-menu-container'                    => 'display: block;',
                    '(mobile_extra){{WRAPPER}}.aigency-breakpoint-mobile_extra .menu-trigger, 
                     {{WRAPPER}}.aigency-breakpoint-mobile_extra .mobile-header-menu-container'  => 'display: block;',
                    '(tablet){{WRAPPER}}.aigency-breakpoint-tablet .menu-trigger, 
                     {{WRAPPER}}.aigency-breakpoint-tablet .mobile-header-menu-container'                    => 'display: block;',
                    '(tablet_extra){{WRAPPER}}.aigency-breakpoint-tablet_extra .menu-trigger, 
                     {{WRAPPER}}.aigency-breakpoint-tablet_extra .mobile-header-menu-container'  => 'display: block;',
                    '(laptop){{WRAPPER}}.aigency-breakpoint-laptop .menu-trigger, 
                     {{WRAPPER}}.aigency-breakpoint-laptop .mobile-header-menu-container'                    => 'display: block;'
                ]
            ]
        );

        $this->add_control(
            'menu_sidebar',
            [
                'label'         => esc_html__('Select Menu Sidebar', 'aigency-plugin'),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'sidebar-menu',
                'options'       => aigency_get_all_sidebar_list(),
                'condition'     => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->end_controls_section();

        // ---------------------------- //
        // ----- Mobile Menu Icon ----- //
        // ---------------------------- //
        $this->start_controls_section(
            'section_mobile_menu_icon',
            [
                'label' => esc_html__('Mobile Menu Icon', 'aigency-plugin')
            ]
        );

        $this->add_responsive_control(
            'icon_alignment',
            [
                'label'     => esc_html__('Icon Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .menu-trigger' => 'text-align: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();


        // ---------------------------- //
        // ----- Mobile Menu Card ----- //
        // ---------------------------- //
        $this->start_controls_section(
            'section_mobile_menu_card',
            [
                'label' => esc_html__('Mobile Menu Card', 'aigency-plugin')
            ]
        );

        $this->add_control(
            'mobile_menu_trigger_style',
            [
                'label' => esc_html__( 'Mobile Menu Trigger Style', 'aigency-plugin' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'fullwidth',
                'options' => [
                    'fullwidth' => esc_html__( 'Fullwidth', 'aigency-plugin' ),
                    'inline'    => esc_html__( 'Inline', 'aigency-plugin' ),
                ],
                'description'   => esc_html__('After changing this setting you need to Update changes to page via \'Apply\' button', 'aigency-plugin')
            ]
        );

        if ( class_exists('WooCommerce') ) {
            $this->add_control(
                'show_cart',
                [
                    'label'         => esc_html__('Show Cart Icon', 'aigency-plugin'),
                    'type'          => Controls_Manager::SWITCHER,
                    'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                    'label_on'      => esc_html__('Show', 'aigency-plugin'),
                    'return_value'  => 'yes',
                    'default'       => 'no'
                ]
            );
        }

        $this->add_control(
            'show_search',
            [
                'label'         => esc_html__('Show Search Icon', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'yes'
            ]
        );

        $this->add_control(
            'hr1',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'show_contacts_title',
            [
                'label'         => esc_html__('Show Contacts Title', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'contacts_title',
            [
                'label'         => esc_html__('Contacts Title', 'aigency-plugin'),
                'type'          => Controls_Manager::TEXT,
                'default'       => '',
                'condition'     => [
                    'show_contacts_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_contact_phone',
            [
                'label'         => esc_html__('Show Phone', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'contact_phone_text',
            [
                'label'         => esc_html__( 'Phone Text', 'aigency-plugin' ),
                'type'          => Controls_Manager::WYSIWYG,
                'default'       => '',
                'condition'     => [
                    'show_contact_phone' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'hr2',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'show_contact_email',
            [
                'label'         => esc_html__('Show Email', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'contact_email_text',
            [
                'label'         => esc_html__( 'Email Text', 'aigency-plugin' ),
                'type'          => Controls_Manager::WYSIWYG,
                'default'       => '',
                'condition'     => [
                    'show_contact_email' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'hr3',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'show_contact_address',
            [
                'label'         => esc_html__('Show Address', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'contact_address_text',
            [
                'label'         => esc_html__( 'Address Text', 'aigency-plugin' ),
                'type'          => Controls_Manager::WYSIWYG,
                'default'       => '',
                'condition'     => [
                    'show_contact_address' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'hr4',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'show_socials',
            [
                'label'         => esc_html__('Show Social Buttons', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'social_icon',
            [
                'label'             => esc_html__('Icon', 'aigency-plugin'),
                'type'              => Controls_Manager::ICONS,
                'label_block'       => true,
                'fa4compatibility'  => 'social',
                'default'           => [
                    'value'     => 'fa fa-wordpress',
                    'library'   => 'brand'
                ]
            ]
        );

        $repeater->add_control(
            'social_link',
            [
                'label'         => esc_html__('Link', 'aigency-plugin'),
                'type'          => Controls_Manager::URL,
                'label_block'   => true,
                'default'       => [
                    'url'           => '',
                    'is_external'   => 'true',
                ],
                'placeholder'   => esc_html__( 'http://your-link.com', 'aigency-plugin' )
            ]
        );

        $this->add_control(
            'socials',
            [
                'label'         => esc_html__('Social Icons', 'aigency-plugin'),
                'type'          => Controls_Manager::REPEATER,
                'default'       => [],
                'fields'        => $repeater->get_controls(),
                'title_field'   => '{{{elementor.helpers.renderIcon(this, social_icon, {}, "i", "panel")}}}',
                'prevent_empty' => false,
                'condition'     => [
                    'show_socials' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'hr5',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'show_button',
            [
                'label'         => esc_html__('Show Button', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'     => esc_html__('Button Text', 'aigency-plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Button', 'aigency-plugin'),
                'condition'     => [
                    'show_button' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label'         => esc_html__('Button Link', 'aigency-plugin'),
                'type'          => Controls_Manager::URL,
                'label_block'   => true,
                'default'       => [
                    'url'           => '',
                    'is_external'   => 'true',
                ],
                'placeholder'   => esc_html__( 'http://your-link.com', 'aigency-plugin' ),
                'condition'     => [
                    'show_button' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();


        // --------------------------------------- //
        // ---------- Nav Menu Settings ---------- //
        // --------------------------------------- //
        $this->start_controls_section(
            'section_nav_menu_settings',
            [
                'label' => esc_html__('Desktop Menu', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'nav_menu_title',
            [
                'label' => esc_html__( 'Main Menu', 'aigency-plugin' ),
                'type'  => Controls_Manager::HEADING
            ]
        );

        $this->add_responsive_control(
            'compact_menu_trigger_size',
            [
                'label'         => esc_html__('Compact Menu Trigger Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .compact-menu .compact-menu-trigger' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_responsive_control(
            'compact_menu_spacing',
            [
                'label'         => esc_html__('Compact Menu Spacing', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .compact-menu .compact-menu-trigger' => is_rtl() ? 'margin-right: {{SIZE}}{{UNIT}};' : 'margin-left: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'compact_menu_label_typography',
                'label'     => esc_html__('Compact Menu Label Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .compact-menu .compact-menu-label',
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_menu_item_spacing',
            [
                'label'         => esc_html__('Space Between Items', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li:not(:last-of-type),
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item' => 'margin-right: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_menu_padding',
            [
                'label'         => esc_html__('Desktop Menu Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .header-menu-container, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_menu_border_radius',
            [
                'label'         => esc_html__('Desktop Menu Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .header-menu-container, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_menu_item_padding',
            [
                'label'         => esc_html__('Item Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_menu_link_padding',
            [
                'label'         => esc_html__('Item Link Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li > a,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item > a.mega-menu-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_menu_current_link_padding',
            [
                'label'         => esc_html__('Current Item Link Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li.menu-item-has-children > a,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-menu-item-has-children > a.mega-menu-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'nav_menu_item_typography',
                'label'     => esc_html__('Item Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .header-menu-container .main-menu > li > a, 
                 {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item > a.mega-menu-link',
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );        

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'nav_submenu_item_typography',
                'label'     => esc_html__('Submenu Item Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu > li > a,
                 {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link, {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link, {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link',
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'nav_menu_item_color',
            [
                'label'     => esc_html__('Item Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li > a, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item > a.mega-menu-link' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'nav_menu_item_hover_color',
            [
                'label'     => esc_html__('Hover Item Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li:hover > a,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item > a.mega-menu-link:hover,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item > a.mega-menu-link:focus,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-toggle-on > a.mega-menu-link' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'nav_menu_item_bg_hover_color',
            [
                'label'     => esc_html__('Hover Item Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li:hover > a,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item > a.mega-menu-link:hover,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item > a.mega-menu-link:focus,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-toggle-on > a.mega-menu-link' => 'background-color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'nav_menu_item_active_color',
            [
                'label'     => esc_html__('Active Item Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li.current-menu-ancestor > a, 
                     {{WRAPPER}} .header-menu-container .main-menu > li.current-menu-parent > a, 
                     {{WRAPPER}} .header-menu-container .main-menu > li.current-menu-item > a,
                     {{WRAPPER}} .header-menu-container .main-menu > li.active > a,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-item:hover > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-ancestor:hover > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-page-ancestor:hover > a.mega-menu-link,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-item.mega-toggle-on > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-ancestor.mega-toggle-on > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-page-ancestor.mega-toggle-on > a.mega-menu-link' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'nav_menu_item_bg_active_color',
            [
                'label'     => esc_html__('Active Item Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li.current-menu-ancestor > a, 
                     {{WRAPPER}} .header-menu-container .main-menu > li.current-menu-parent > a, 
                     {{WRAPPER}} .header-menu-container .main-menu > li.current-menu-item > a,
                     {{WRAPPER}} .header-menu-container .main-menu > li.active > a,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-item:hover > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-ancestor:hover > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-page-ancestor:hover > a.mega-menu-link,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-item.mega-toggle-on > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-ancestor.mega-toggle-on > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-page-ancestor.mega-toggle-on > a.mega-menu-link' => 'background-color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'nav_menu_bg_color',
            [
                'label'     => esc_html__('Desktop Menu Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main' => 'background-color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_label_color',
            [
                'label'     => esc_html__('Compact Menu Label Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .compact-menu .compact-menu-label' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_trigger_color',
            [
                'label'     => esc_html__('Compact Menu Trigger Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .compact-menu .compact-menu-trigger span:before,
                     {{WRAPPER}} .compact-menu .compact-menu-trigger span:after' => 'background-color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'hr6',
            [
                'type' => Controls_Manager::DIVIDER
            ]
        );

        $this->add_control(
            'nav_submenu_title',
            [
                'label' => esc_html__( 'Submenu', 'aigency-plugin' ),
                'type'  => Controls_Manager::HEADING,
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_title',
            [
                'label' => esc_html__( 'Compact Menu', 'aigency-plugin' ),
                'type'  => Controls_Manager::HEADING,
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_submenu_box_width',
            [
                'label'         => esc_html__('Submenu Box Width', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu,
                    {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu' => 'width: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_submenu_box_padding',
            [
                'label'         => esc_html__('Submenu Box Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', 'rem', 'vw'],
                'selectors'     => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .header-menu-container .main-menu li:hover > ul.sub-menu ul.sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu'          => 'margin: 0 0 0 calc({{RIGHT}}{{UNIT}} + 1px); top: calc(-{{TOP}}{{UNIT}});',
                    '{{WRAPPER}} .header-menu-container .main-menu li:hover > ul.sub-menu ul.sub-menu:before'   => 'width: {{RIGHT}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_submenu_border_radius',
            [
                'label'         => esc_html__('Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu,
                     .alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-bg,
                     .alter-menu-wrapper#alter-menu-wrapper-{{ID}}:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'compact_menu_offset',
            [
                'label'         => esc_html__('Compact Menu Offset', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_submenu_top_spacing',
            [
                'label'         => esc_html__('Submenu Space Top', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li > ul.sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout > ul.mega-sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .header-menu-container .main-menu > li > ul.sub-menu:before,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout > ul.mega-sub-menu:before,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu:before' => 'height: {{SIZE}}{{UNIT}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'nav_submenu_box_background',
            [
                'label'     => esc_html__('Submenu Box Background', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#1f1f1f',
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu' => 'background-color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'compact_menu_item_typography',
                'label'     => esc_html__('Item Typography', 'aigency-plugin'),
                'selector'  => '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .main-menu > li > a',
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'compact_submenu_item_typography',
                'label'     => esc_html__('Submenu Item Typography', 'aigency-plugin'),
                'selector'  => '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .main-menu > li ul.sub-menu a',
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'compact_menu_trigger_typography',
                'label'     => esc_html__('Menu Trigger Typography', 'aigency-plugin'),
                'selector'  => '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .main-menu > li .sub-menu-trigger',
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_background',
            [
                'label'     => esc_html__('Compact Menu Background', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#1f1f1f',
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-bg,
                    .alter-menu-wrapper#alter-menu-wrapper-{{ID}}:before' => 'background-color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'compact_menu_overlay_color',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Compact Menu Overlay Color', 'aigency-plugin' )
                    ]                    
                ],
                'types' => [ 'classic', 'gradient' ],
                'selector' => '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-decorate:before',
                'condition' => [
                    'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'compact_menu_background_image',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Compact Menu Background Image', 'aigency-plugin' )
                    ]                    
                ],
                'types' => [ 'classic' ],
                'selector' => '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-bg',
                'condition' => [
                    'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'nav_submenu_item_color',
            [
                'label'     => esc_html__('Submenu Item Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu > li > a,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_item_color',
            [
                'label'     => esc_html__('Compact Menu Item Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-menu .main-menu li > a,
                    .alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-menu .main-menu > li .sub-menu-trigger' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_item_active_color',
            [
                'label'     => esc_html__('Compact Menu Active Item Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-menu .main-menu li > a:hover,
                    .alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-menu .main-menu li.current-menu-item > a,
                    .alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-menu .main-menu li.current-menu-parent > a,
                    .alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-menu .main-menu li.current-menu-ancestor > a' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'nav_submenu_item_active_color',
            [
                'label'     => esc_html__('Submenu Active Item Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => aigency_get_prefered_option('contrast_accent_text_color'),
                'selectors' => [
                    '{{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu > li.current-menu-ancestor > a, 
                     {{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu > li.current-menu-parent > a, 
                     {{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu > li.current-menu-item > a, 
                     {{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu > li.active > a,
                     {{WRAPPER}} .header-menu-container .main-menu > li ul.sub-menu > li > a:hover,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link,
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:hover, 
                     {{WRAPPER}} #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:focus' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'standard'
                ]
            ]
        );

        $this->add_control(
            'compact_close_title',
            [
                'label' => esc_html__( 'Compact Menu Close', 'aigency-plugin' ),
                'type'  => Controls_Manager::HEADING,
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'compact_menu_close_typography',
                'label'     => esc_html__('Compact Menu Close Typography', 'aigency-plugin'),
                'selector'  => '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-close',
                'exclude'   => ['line_height'],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'compact_menu_close_background_image',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Compact Menu Close Background Image', 'aigency-plugin' )
                    ]                    
                ],
                'types' => [ 'classic' ],
                'selector' => '.alter-menu-wrapper#alter-menu-wrapper-{{ID}}:before',
                'condition' => [
                    'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_close_color',
            [
                'label'     => esc_html__('Compact Menu Close Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .alter-menu-close' => 'color: {{VALUE}};'
                ],
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->end_controls_section();

        // ------------------------------------- //
        // ----- Compact Menu Sidebar Colors ----- //
        // ------------------------------------- //
        $this->start_controls_section(
            'section_compact_menu_sidebar_colors',
            [
                'label' => esc_html__('Compact Menu Sidebar', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                	'menu_style' => 'compact'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_default_text_color',
            [
                'label'     => esc_html__('Default Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-default-text-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_dark_text_color',
            [
                'label'     => esc_html__('Dark Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-dark-text-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_light_text_color',
            [
                'label'     => esc_html__('Light Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-light-text-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_accent_color',
            [
                'label'     => esc_html__('Accent Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-accent-text-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_border_color_1',
            [
                'label'     => esc_html__('Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-border-color: {{VALUE}};'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_border_hover_color',
            [
                'label'     => esc_html__('Border Hover Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-border-hover-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_background_color',
            [
                'label'     => esc_html__('Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_background_alter_color',
            [
                'label'     => esc_html__('Background Alter Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-background-alter-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_text_color',
            [
                'label'     => esc_html__('Button Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-text-color: {{VALUE}};'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_border_color',
            [
                'label'     => esc_html__('Button Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-border-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_border_color_add',
            [
                'label'     => esc_html__('Button Border Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-border-color-add: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_background_color',
            [
                'label'     => esc_html__('Button Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_background_color_add',
            [
                'label'     => esc_html__('Button Background Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-background-color-add: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_text_hover',
            [
                'label'     => esc_html__('Hover Button Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-text-hover: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_border_hover',
            [
                'label'     => esc_html__('Hover Button Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-border-hover: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_border_hover_add',
            [
                'label'     => esc_html__('Hover Button Border Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-border-hover-add: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_background_hover',
            [
                'label'     => esc_html__('Hover Button Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-background-hover: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'compact_menu_sidebar_button_background_hover_add',
            [
                'label'     => esc_html__('Hover Button Background Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.alter-menu-wrapper#alter-menu-wrapper-{{ID}} .slide-sidebar-wrapper' => '--aigency-contrast-button-background-hover-add: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();


        // -------------------------------------- //
        // ---- Mobile Menu Trigger Settings ---- //
        // -------------------------------------- //
        $this->start_controls_section(
            'section_mobile_menu_trigger_settings',
            [
                'label' => esc_html__('Mobile Menu Trigger', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_trigger_size',
            [
                'label'         => esc_html__('Mobile Menu Trigger Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .menu-trigger .menu-trigger-icon' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_trigger_color',
            [
                'label'     => esc_html__('Mobile Menu Trigger Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu-trigger .hamburger span' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_trigger_hover_color',
            [
                'label'     => esc_html__('Mobile Menu Hover Trigger Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu-trigger:hover .hamburger span' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();


        // ------------------------------------- //
        // ----- Mobile Menu Card Settings ----- //
        // ------------------------------------- //
        $this->start_controls_section(
            'section_mobile_menu_card_settings',
            [
                'label' => esc_html__('Mobile Menu Card', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_box_padding',
            [
                'label'         => esc_html__('Mobile Menu Box Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em', 'rem', 'vw'],
                'selectors'     => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'mobile_menu_box_border',
                'selector'  => '.mobile-header-menu-container#mobile-header-{{ID}}',
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_box_border_radius',
            [
                'label'         => esc_html__('Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'separator'     => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'mobile_menu_box_shadow',
                'selector'  => '.mobile-header-menu-container#mobile-header-{{ID}}',
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_box_margins',
            [
                'label'         => esc_html__('Mobile Menu Box Margins', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; height: calc(100vh - var(--wp-admin--admin-bar--height, 0px) - {{TOP}}{{UNIT}} - {{BOTTOM}}{{UNIT}});'
                ],
                'separator'     => 'before'
            ]
        );

        $this->add_control(
            'hr7',
            [
                'type' => Controls_Manager::DIVIDER
            ]
        );

        $this->add_control(
            'mobile_menu_box_customize_colors',
            [
                'label'         => esc_html__('Customize Colors', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'no'
            ]
        );

        $this->add_control(
            'mobile_menu_box_default_text_color',
            [
                'label'     => esc_html__('Default Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-default-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'mobile_menu_box_dark_text_color',
            [
                'label'     => esc_html__('Dark Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-dark-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_light_text_color',
            [
                'label'     => esc_html__('Light Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-light-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_accent_color',
            [
                'label'     => esc_html__('Accent Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-accent-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_border_color_1',
            [
                'label'     => esc_html__('Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-border-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'mobile_menu_box_border_hover_color',
            [
                'label'     => esc_html__('Border Hover Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-border-hover-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_background_color',
            [
                'label'     => esc_html__('Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-background-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_background_alter_color',
            [
                'label'     => esc_html__('Background Alter Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-background-alter-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_text_color',
            [
                'label'     => esc_html__('Button Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_border_color',
            [
                'label'     => esc_html__('Button Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-border-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_border_color_add',
            [
                'label'     => esc_html__('Button Border Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-border-color-add: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_background_color',
            [
                'label'     => esc_html__('Button Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-background-color: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_background_color_add',
            [
                'label'     => esc_html__('Button Background Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-background-color-add: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_text_hover',
            [
                'label'     => esc_html__('Hover Button Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-text-hover: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_border_hover',
            [
                'label'     => esc_html__('Hover Button Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-border-hover: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_border_hover_add',
            [
                'label'     => esc_html__('Hover Button Border Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-border-hover-add: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_background_hover',
            [
                'label'     => esc_html__('Hover Button Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-background-hover: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_background_hover_add',
            [
                'label'     => esc_html__('Hover Button Background Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}}' => '--aigency-header-button-background-hover-add: {{VALUE}};'
                ],
                'condition' => [
                    'mobile_menu_box_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_bd_style',
            [
                'label' => esc_html__( 'Button Border Style', 'aigency-plugin' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'gradient',
                'options' => [
                    'gradient' => esc_html__( 'Gradient', 'aigency-plugin' ),
                    'solid' => esc_html__( 'Solid', 'aigency-plugin' ),
                ],
                'description'   => esc_html__('After changing this setting you need to Update changes to page via \'Apply\' button', 'aigency-plugin')
            ]
        );

        $this->add_control(
            'mobile_menu_box_button_bg_style',
            [
                'label' => esc_html__( 'Button Background Style', 'aigency-plugin' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'gradient',
                'options' => [
                    'gradient' => esc_html__( 'Gradient', 'aigency-plugin' ),
                    'solid' => esc_html__( 'Solid', 'aigency-plugin' ),
                ],
                'description'   => esc_html__('After changing this setting you need to Update changes to page via \'Apply\' button', 'aigency-plugin')
            ]
        ); 

        $this->end_controls_section();


        // ------------------------------------- //
        // --------- Mobile Menu Icons --------- //
        // ------------------------------------- //
        $this->start_controls_section(
            'section_mobile_menu_icons_settings',
            [
                'label' => esc_html__('Mobile Menu Icons', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_icons_size',
            [
                'label'         => esc_html__('Icons Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .mini-cart .mini-cart-count:before'    => 'font-size: {{SIZE}}{{UNIT}};',
                    '.mobile-header-menu-container#mobile-header-{{ID}} .search-link .search-trigger-icon'  => 'font-size: calc({{SIZE}}{{UNIT}} * 0.95);',
                    '.mobile-header-menu-container#mobile-header-{{ID}} .menu-close .menu-close-icon'          => 'font-size: calc({{SIZE}}{{UNIT}} * 0.9);'
                ]
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_icons_gap',
            [
                'label'         => esc_html__('Icons Gap', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-icons-container .header-icon' => 'margin: 0 calc({{SIZE}}{{UNIT}} / 2);',
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-icons-container' => 'margin: 0 calc(-{{SIZE}}{{UNIT}} / 2); width: calc(100% + {{SIZE}}{{UNIT}});',
                ]
            ]
        );

        $this->end_controls_section();


        // ------------------------------------- //
        // ------------ Mobile Menu ------------ //
        // ------------------------------------- //
        $this->start_controls_section(
            'section_mobile_menu_settings',
            [
                'label' => esc_html__('Mobile Menu Navigation', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'              => 'mobile_menu_item_typography',
                'label'             => esc_html__('Menu Item Typography', 'aigency-plugin'),
                'selector'          => '.mobile-header-menu-container#mobile-header-{{ID}} .main-menu > li'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'              => 'mobile_submenu_item_typography',
                'label'             => esc_html__('Submenu Item Typography', 'aigency-plugin'),
                'selector'          => '.mobile-header-menu-container#mobile-header-{{ID}} .main-menu > li ul.sub-menu > li'
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_top_spacing',
            [
                'label'         => esc_html__('Menu Top Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .main-menu' => 'margin-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_bottom_spacing',
            [
                'label'         => esc_html__('Menu Bottom Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .main-menu' => 'padding-bottom: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();


        // ------------------------------------ //
        // ------- Mobile Menu Contacts ------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'section_mobile_menu_contacts_settings',
            [
                'label' => esc_html__('Mobile Menu Contacts', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'              => 'mobile_menu_contacts_title_typography',
                'label'             => esc_html__('Contacts Title Typography', 'aigency-plugin'),
                'selector'          => '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-contacts .contact-items-title'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'              => 'mobile_menu_contact_item_typography',
                'label'             => esc_html__('Contact Item Typography', 'aigency-plugin'),
                'selector'          => '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-contacts .contact-item'
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_contacts_spacing',
            [
                'label'         => esc_html__('Space Between Contact Items', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', 'vw', 'rem'],
                'range'         => [
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-contacts .contact-item + .contact-item' => 'margin-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_contacts_top_spacing',
            [
                'label'         => esc_html__('Contacts Top Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', 'vw', 'rem'],
                'range'         => [
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-contacts' => 'padding-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();


        // ------------------------------------- //
        // -------- Mobile Menu Socials -------- //
        // ------------------------------------- //
        $this->start_controls_section(
            'section_mobile_menu_socials_settings',
            [
                'label' => esc_html__('Mobile Menu Socials', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_socials_size',
            [
                'label'         => esc_html__('Social Buttons Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .wrapper-socials a:before' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_socials_gap',
            [
                'label'         => esc_html__('Social Buttons Gap', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-socials .mobile-menu-socials' => 'margin: 0 calc(-{{SIZE}}{{UNIT}} / 2) calc(-{{SIZE}}{{UNIT}} * 0.6666);',
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-socials .mobile-menu-socials li' => 'margin: 0 calc({{SIZE}}{{UNIT}} / 2) calc({{SIZE}}{{UNIT}} * 0.6666);'
                ]
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_socials_top_spacing',
            [
                'label'         => esc_html__('Socials Top Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-socials' => 'padding-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();


        // ------------------------------------ //
        // -------- Mobile Menu Button -------- //
        // ------------------------------------ //
        $this->start_controls_section(
            'section_mobile_menu_button_settings',
            [
                'label' => esc_html__('Mobile Menu Button', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'              => 'mobile_menu_button_typography',
                'label'             => esc_html__('Button Typography', 'aigency-plugin'),
                'selector'          => '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-button .aigency-button'
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_button_spacing',
            [
                'label'         => esc_html__('Button Top Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 10
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 10
                    ]
                ],
                'selectors' => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-button' => 'padding-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_button_border_radius',
            [
                'label'         => esc_html__('Button Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-button .aigency-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'mobile_menu_button_padding',
            [
                'label'         => esc_html__('Button Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '.mobile-header-menu-container#mobile-header-{{ID}} .header-mobile-button .aigency-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();        
    }

    protected function render() {

        $settings               = $this->get_settings();
        $widget_id              = $this->get_id();
        $menu                   = $settings['menu'];
        $menu_style             = $settings['menu_style'];
        $menu_type              = $settings['menu_type'];
        $menu_label             = $settings['menu_label'];
        $compact_close_text     = $settings['compact_close_text'];

        $mobile_menu_trigger_style = $settings['mobile_menu_trigger_style'];

        $show_cart              = $settings['show_cart'];
        $show_search            = $settings['show_search'];

        $show_contacts_title    = $settings['show_contacts_title'];
        $contacts_title         = $settings['contacts_title'];
        $show_contact_phone     = $settings['show_contact_phone'];
        $contact_phone_text     = $settings['contact_phone_text'];

        $show_contact_email     = $settings['show_contact_email'];
        $contact_email_text     = $settings['contact_email_text'];

        $show_contact_address   = $settings['show_contact_address'];
        $contact_address_text   = $settings['contact_address_text'];

        $show_socials           = $settings['show_socials'];
        $socials                = $settings['socials'];

        $show_button            = $settings['show_button'];
        $button_text            = $settings['button_text'];

        $mobile_menu_box_button_bd_style = $settings['mobile_menu_box_button_bd_style'];
        $mobile_menu_box_button_bg_style = $settings['mobile_menu_box_button_bg_style'];

        $sidebar    = !empty($settings['sidebar']) ? $settings['sidebar'] : 'sidebar-menu';

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //

        if ( $menu_style === 'standard' ) {
        	if ( !empty($menu) && $menu != 'default' ) {
	            if ( $menu_type === 'logo' ) {
	                global $elementor_menu_logo;
	                $elementor_menu_logo = '<a href="'. esc_attr(home_url('/')) . '" class="logo-link">' . Group_Control_Image_Size::get_attachment_image_html( $settings, 'full', 'menu_logo' ) . '</a>';
	                $menu_string = wp_nav_menu(
	                    array(
	                        'menu'              => $menu,
	                        'items_wrap'        => '%3$s',
	                        'depth'             => 1,
	                        'container'         => '',
	                        'echo'              => false
	                    )
	                );
	                $menu_array = explode('</li>', $menu_string);
	                $menu_count = count($menu_array) - 1;
	                $menu_center_item_num = ceil($menu_count / 2) - 1;
	                $menu_center_item = $menu_array[$menu_center_item_num];
	                preg_match('/menu-item-[0-9]+/u', $menu_center_item, $menu_center_item_id);
	                $menu_center_item_id = str_replace('menu-item-', '', $menu_center_item_id[0]);

	                wp_nav_menu(
	                    array(
	                        'menu'              => $menu,
	                        'menu_class'        => 'main-menu',
	                        'depth'             => 0,
	                        'container'         => 'div',
	                        'container_class'   => 'header-menu-container with-logo',
	                        'fallback_cb'       => '',
	                        'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>',
	                        'center'            => $menu_center_item_id,
	                        'walker'            => new \Aigency_Double_Menu_Walker()
	                    )
	                );
	            } else {
	                wp_nav_menu(
	                    array(
	                        'menu'              => $menu,
	                        'menu_class'        => 'main-menu',
	                        'depth'             => 0,
	                        'container'         => 'div',
	                        'container_class'   => 'header-menu-container',
	                        'fallback_cb'       => '',
	                        'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
	                    )
	                );
	            }            
	        } else {
	            $menu_locations = get_nav_menu_locations();
	            if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
	                if ( $menu_type === 'logo' ) {

	                    if( function_exists('max_mega_menu_is_enabled') && max_mega_menu_is_enabled('main') ) {
	                        wp_nav_menu(
	                            array(
	                                'theme_location'    => 'main',
	                                'menu_class'        => 'main-menu',
	                                'depth'             => 0,
	                                'container'         => 'div',
	                                'container_class'   => 'header-menu-container',
	                                'fallback_cb'       => '',
	                                'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
	                            )
	                        );
	                    } else {
	                        global $elementor_menu_logo;
	                        $elementor_menu_logo = '<a href="'. esc_attr(home_url('/')) . '" class="logo-link">' . Group_Control_Image_Size::get_attachment_image_html( $settings, 'full', 'menu_logo' ) . '</a>';
	                        $menu_string = wp_nav_menu(
	                            array(
	                                'theme_location'    => 'main',
	                                'items_wrap'        => '%3$s',
	                                'depth'             => 1,
	                                'container'         => '',
	                                'echo'              => false
	                            )                            
	                        );
	                        $menu_array = explode('</li>', $menu_string);
	                        $menu_count = count($menu_array) - 1;
	                        $menu_center_item_num = ceil($menu_count / 2) - 1;
	                        $menu_center_item = $menu_array[$menu_center_item_num];
	                        preg_match('/menu-item-[0-9]+/u', $menu_center_item, $menu_center_item_id);
	                        $menu_center_item_id = str_replace('menu-item-', '', $menu_center_item_id[0]);

	                        wp_nav_menu(
	                            array(
	                                'theme_location'    => 'main',
	                                'menu_class'        => 'main-menu',
	                                'depth'             => 0,
	                                'container'         => 'div',
	                                'container_class'   => 'header-menu-container with-logo',
	                                'fallback_cb'       => '',
	                                'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>',
	                                'center'            => $menu_center_item_id,
	                                'walker'            => new \Aigency_Double_Menu_Walker()
	                            )
	                        );
	                    }                    
	                } else {
	                    wp_nav_menu(
	                        array(
	                            'theme_location'    => 'main',
	                            'menu_class'        => 'main-menu',
	                            'depth'             => 0,
	                            'container'         => 'div',
	                            'container_class'   => 'header-menu-container',
	                            'fallback_cb'       => '',
	                            'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
	                        )
	                    );
	                }                
	            }
	        }
	    } else {
        	echo '<div class="alter-menu-wrapper" id="alter-menu-wrapper-' . esc_attr($widget_id) .'">';    
			    echo '<div class="alter-menu-close">';
			    	echo esc_html($compact_close_text);
			    echo '</div>';
			    echo '<div class="alter-menu-bg"></div>';
			    echo '<div class="alter-menu">';
			        echo '<div class="alter-menu-menu">';
			            if ( !empty(aigency_get_prefered_option('header_menu_select')) && aigency_get_prefered_option('header_menu_select') != 'default' ) {
			                wp_nav_menu(
			                    array(
			                        'menu'          => aigency_get_prefered_option('header_menu_select'),
			                        'menu_class'    => 'main-menu',
			                        'depth'         => 0,
			                        'container'     => '',
			                        'fallback_cb'   => '',
			                        'items_wrap'    => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
			                    )
			                );
			            } else {
			            	$menu_locations = get_nav_menu_locations();
			                if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
			                    wp_nav_menu(
			                        array(
			                            'theme_location'    => 'main',
			                            'menu_class'        => 'main-menu',
			                            'depth'             => 0,
			                            'container'         => '',
			                            'fallback_cb'       => '',
			                            'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
			                        )
			                    );
			                }
			            }
			        echo '</div>';
			        if ( is_active_sidebar(esc_attr($sidebar)) ) {
			        	echo '<div class="slide-sidebar-wrapper alter-menu-sidebar-wrapper">';
			                echo '<div class="slide-sidebar-content">';
			                    dynamic_sidebar(esc_attr($sidebar));
			                echo '</div>';
			            echo '</div>';
			        }        
			    echo '</div>';
			    echo '<div class="alter-menu-decorate"></div>';
			echo '</div>';

        	echo '<div class="compact-menu">';
           	    echo ( !empty($menu_label) ? '<span class="compact-menu-label">' . esc_html($menu_label) . '</span>' : '' );
                echo '<div class="compact-menu-trigger" data-id="' . esc_attr($widget_id) .'"><span></span></div>';
        	echo '</div>';
    	}?>

    	<div class="menu-trigger" data-id="<?php echo esc_attr($widget_id) ?>">
            <span class="menu-trigger-icon">
                <span class="hamburger">
                    <span></span>
                    <span></span>
                </span>
            </span>
        </div>

        <?php
        $mobile_header_container_classes = !empty($mobile_menu_box_button_bd_style) ? ' button-border-style-' . $mobile_menu_box_button_bd_style : '';
        $mobile_header_container_classes .= !empty($mobile_menu_box_button_bg_style) ? ' button-background-style-' . $mobile_menu_box_button_bg_style : '';
        ?>

        <div class="mobile-header-menu-container<?php echo esc_attr($mobile_header_container_classes); ?>" id="mobile-header-<?php echo esc_attr($widget_id); ?>">
            <div class="mobile-header-row">

                <!-- Icons Block -->
                <div class="header-icons-container">
                    <?php

                    if (
                        $show_search == 'yes' ||
                        ( class_exists('WooCommerce') && $show_cart == 'yes' )
                    ) {

                        // Mini Cart Link
                        if ( class_exists('WooCommerce') && $show_cart == 'yes' ) {
                            echo '<div class="header-icon mini-cart">';
                                echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="mini-cart-trigger">';
                                    echo '<i class="mini-cart-count">';
                                    	if ( WC()->cart && WC()->cart->cart_contents_count > 0 ) {
                                    		echo '<span>' . WC()->cart->cart_contents_count . '</span>';
                                    	}
                                    echo '</i>';
                                echo '</a>';
                            echo '</div>';
                        }

                        // Search Icon Trigger
                        if ( $show_search == 'yes' ) {
                            echo '<a class="header-icon search-link" href="' . esc_url(get_search_link()) . '">';
                                echo '<span class="search-trigger-icon"></span>';
                            echo '</a>';
                        }
                    }

                    // Close Button
                    echo '<div class="header-icon menu-close">';
                        echo '<span class="menu-close-icon"></span>';
                    echo '</div>';

                    ?>
                </div>

            </div>
            <!-- Menu Block -->
            <?php

                $menu_class = 'main-menu';
                if ( !empty($mobile_menu_trigger_style) ) {
                    $menu_class .= ' ' . esc_attr($mobile_menu_trigger_style) . '-trigger-menu';
                }
                if ( !empty($menu) && $menu != 'default' ) {
                    wp_nav_menu(
                        array(
                            'menu'          => $menu,
                            'menu_class'    => $menu_class,
                            'depth'         => 0,
                            'container'     => '',
                            'fallback_cb'   => '',
                            'items_wrap'    => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                        )
                    );
                } else {
                    $menu_locations = get_nav_menu_locations();
                    if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
                        wp_nav_menu(
                            array(
                                'theme_location'    => 'main',
                                'menu_class'        => $menu_class,
                                'depth'             => 0,
                                'container'         => '',
                                'fallback_cb'       => '',
                                'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                            )
                        );
                    }
                }
            ?>

            <?php
            if (
                ( $show_contacts_title == 'yes' && !empty($contacts_title) ) ||
                ( $show_contact_email == 'yes' && !empty($contact_email_text) ) ||
                ( $show_contact_phone == 'yes' && !empty($contact_phone_text) ) ||
                ( $show_contact_address == 'yes' && !empty($contact_address_text) )
            ) {
                echo '<div class="header-mobile-contacts">';
                    if ( $show_contacts_title == 'yes' && !empty($contacts_title) ) {
                        echo '<div class="contact-items-title">';
                            echo esc_html($contacts_title);
                        echo '</div>';
                    }                    
                    if ( $show_contact_address == 'yes' && !empty($contact_address_text) ) {
                        echo '<div class="contact-item contact-item-address">';
                            echo wp_kses($contact_address_text, 'post');
                        echo '</div>';
                    }
                    if ( $show_contact_phone == 'yes' && !empty($contact_phone_text) ) {
                        echo '<div class="contact-item contact-item-phone">';
                            echo wp_kses($contact_phone_text, 'post');
                        echo '</div>';
                    }
                    if ( $show_contact_email == 'yes' && !empty($contact_email_text) ) {
                        echo '<div class="contact-item contact-item-email">';
                            echo wp_kses($contact_email_text, 'post');
                        echo '</div>';
                    }
                echo '</div>';
            }
            ?>

            <?php
            if ( $show_socials == 'yes' && !empty($socials) ) {
                echo '<div class="header-mobile-socials">';
                    echo '<ul class="mobile-menu-socials wrapper-socials">';
                        foreach ($socials as $social) {
                            $this->remove_render_attribute( 'social' );
                            $this->add_render_attribute( 'social', 'class', esc_attr($social['social_icon']['value']) );
                            if ( empty( $social['social_link']['url'] ) ) {
                                $social['social_link']['url'] = '#';
                            }
                            $this->add_link_attributes( 'social', $social['social_link'] );

                            echo '<li>';
                                echo '<a ' . $this->get_render_attribute_string( 'social' ) . '></a>';
                            echo '</li>';
                        }
                    echo '</ul>';
                echo '</div>';
            }
            ?>

            <?php
            if ( $show_button == 'yes' && !empty($button_text) ) {
                if ( empty( $settings['button_link']['url'] ) ) {
                    $settings['button_link']['url'] = '#';
                }
                $this->add_render_attribute( 'button', 'class', 'aigency-button' );
                $this->add_link_attributes( 'button', $settings['button_link'] );

                echo '<div class="header-mobile-button">';
                    echo '<a ' . $this->get_render_attribute_string( 'button' ) . '>';
                        echo esc_html($button_text);
                        echo '<span class="button-inner"></span>';
                    echo '</a>';
                echo '</div>';
            }
            ?>

        </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}
