<?php
/*
 * Created by Artureanec
*/

namespace HFE\WidgetsManager\Widgets;

use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Aigency_Cart_Widget extends Widget_Base {

    public function get_name() {
        return 'aigency_cart';
    }

    public function get_title() {
        return esc_html__('Product Cart', 'aigency-plugin');
    }

    public function get_icon() {
        return 'eicon-cart';
    }

    public function get_categories() {
        return ['hfe-widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Product Cart', 'aigency-plugin')
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label'     => esc_html__('Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .mini-cart' => 'text-align: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

        // ----------------------------------- //
        // ---------- Icon Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'icon_section_settings',
            [
                'label' => esc_html__('Icon Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'icon_box_size',
            [
                'label'         => esc_html__('Icon Box Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', 'vw', 'rem'],
                'range'         => [
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-trigger' => 'min-width: {{SIZE}}{{UNIT}}; min-height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label'         => esc_html__('Icon Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-count:before' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_border_radius',
            [
                'label'         => esc_html__('Icon Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .mini-cart .mini-cart-trigger' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'icon_indicator_color',
            [
                'label'     => esc_html__('Icon Indicator Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-count > span' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->start_controls_tabs('content_icon_tabs');
            // ------ Normal Tab ------ //
            $this->start_controls_tab(
                'tab_icon_normal',
                [
                    'label'     => esc_html__('Normal', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'icon_color_normal',
                    [
                        'label'     => esc_html__('Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart a.mini-cart-trigger' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_bg_color_normal',
                    [
                        'label'     => esc_html__('Background Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart a.mini-cart-trigger' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------ Hover Tab ------ //
            $this->start_controls_tab(
                'tab_icon_hover',
                [
                    'label'     => esc_html__('Hover', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'icon_color_hover',
                    [
                        'label'     => esc_html__('Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart:hover a.mini-cart-trigger' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'icon_bg_color_hover',
                    [
                        'label'     => esc_html__('Background Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart:hover a.mini-cart-trigger' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        // ----------------------------------- //
        // ---------- Card Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'card_section_settings',
            [
                'label' => esc_html__('Card Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'card_width',
            [
                'label'         => esc_html__('Card Width', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', 'vw', 'rem'],
                'range'         => [
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel' => 'width: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'card_background_color',
            [
                'label'     => esc_html__('Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'card_padding',
            [
                'label'         => esc_html__('Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'card_border',
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel',
            ]
        );

        $this->add_responsive_control(
            'card_border_radius',
            [
                'label'         => esc_html__('Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'card_shadow',
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'card_title_typography',
                'label'     => esc_html__('Card Title Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel .mini-cart-title'
            ]
        );

        $this->end_controls_section();


        // ----------------------------------- //
        // ---------- Item Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'item_section_settings',
            [
                'label' => esc_html__('Item Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_separator_color',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Separator Color', 'aigency-plugin' )
                    ]                    
                ],
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .mini-cart .mini-cart-panel .total:before'
            ]
        );

        $this->add_responsive_control(
            'item_spacing',
            [
                'label'         => esc_html__('Space Between Items', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', 'vw', 'rem', '%'],
                'range'         => [
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    '%'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li:not(:first-child)' => 'margin-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'item_name_heading',
            [
                'label'     => esc_html__( 'Item Name', 'aigency-plugin' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'item_name_typography',
                'label'     => esc_html__('Item Name Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel .woocommerce-mini-cart-item__title'
            ]
        );

        $this->start_controls_tabs('content_name_tabs');
            // ------ Normal Tab ------ //
            $this->start_controls_tab(
                'tab_item_name_normal',
                [
                    'label'     => esc_html__('Normal', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'item_name_color',
                    [
                        'label'     => esc_html__('Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li a' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------ Hover Tab ------ //
            $this->start_controls_tab(
                'tab_item_name_hover',
                [
                    'label'     => esc_html__('Hover', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'item_name_color_hover',
                    [
                        'label'     => esc_html__('Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li a:hover' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'item_count_hr',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'item_count_heading',
            [
                'label' => esc_html__( 'Item Count', 'aigency-plugin' ),
                'type'  => Controls_Manager::HEADING
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'item_count_typography',
                'label'     => esc_html__('Item Count Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li .content-woocommerce-wrapper .quantity'
            ]
        );

        $this->add_control(
            'item_count_color',
            [
                'label'     => esc_html__('Item Count Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li .content-woocommerce-wrapper .quantity' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'item_price_hr',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'item_price_heading',
            [
                'label' => esc_html__( 'Item Price', 'aigency-plugin' ),
                'type'  => Controls_Manager::HEADING
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'item_price_typography',
                'label'     => esc_html__('Item Price Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li .quantity .amount'
            ]
        );

        $this->add_control(
            'item_price_color',
            [
                'label'     => esc_html__('Item Price Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li .quantity .amount' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'item_subtotal_price_hr',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'item_subtotal_price_heading',
            [
                'label' => esc_html__( 'Subtotal Item Price', 'aigency-plugin' ),
                'type'  => Controls_Manager::HEADING
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'item_subtotal_price_typography',
                'label'     => esc_html__('Subtotal Item Price Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li .subtotal'
            ]
        );

        $this->add_control(
            'item_subtotal_price_color',
            [
                'label'     => esc_html__('Subtotal Item Price Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li .subtotal' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'item_delete_hr',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'item_delete_heading',
            [
                'label' => esc_html__( 'Delete Button', 'textdomain' ),
                'type'  => Controls_Manager::HEADING
            ]
        );

        $this->add_responsive_control(
            'item_delete_size',
            [
                'label'         => esc_html__('Icon Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li a.remove_from_cart_button:before' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs('content_delete_tabs');
            // ------ Normal Tab ------ //
            $this->start_controls_tab(
                'tab_delete_normal',
                [
                    'label'     => esc_html__('Normal', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'icon_delete_normal',
                    [
                        'label'     => esc_html__('Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li a.remove_from_cart_button' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ------ Hover Tab ------ //
            $this->start_controls_tab(
                'tab_delete_hover',
                [
                    'label'     => esc_html__('Hover', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'icon_delete_hover',
                    [
                        'label'     => esc_html__('Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart .mini-cart-panel .cart_list li a.remove_from_cart_button:hover' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        // ----------------------------------- //
        // -------- Subtotal Settings -------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'subtotal_section_settings',
            [
                'label' => esc_html__('Subtotal Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'subtotal_title_typography',
                'label'     => esc_html__('Label Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel .total strong'
            ]
        );

        $this->add_control(
            'subtotal_title_color',
            [
                'label'     => esc_html__('Label Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .total strong' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'subtotal_price_typography',
                'label'     => esc_html__('Price Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .mini-cart .mini-cart-panel .total .amount',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'subtotal_price_color',
            [
                'label'     => esc_html__('Price Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .total .amount' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'subtotal_spacing',
            [
                'label'         => esc_html__('Space Before Subtotal', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', 'vw', 'rem', '%'],
                'range'         => [
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    '%'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .total' => 'margin-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();

        // ------------------------------------- //
        // ---------- Button Settings ---------- //
        // ------------------------------------- //
        $this->start_controls_section(
            'button_section_settings',
            [
                'label' => esc_html__('Button Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'button_spacing',
            [
                'label'         => esc_html__('Space Before Buttons', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', 'vw', 'rem', '%'],
                'range'         => [
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    '%'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .mini-cart .mini-cart-panel .woocommerce-mini-cart-buttons' => 'padding-top: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'button_border_radius',
            [
                'label'         => esc_html__('Button Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '{{WRAPPER}} .woocommerce-mini-cart-buttons a.button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'button_typography',
                'label'     => esc_html__('Button Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .woocommerce-mini-cart-buttons a.button'
            ]
        );

        $this->start_controls_tabs('button_settings_tabs');
            // ------ Normal Tab ------ //
            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__('Normal', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'button_color',
                    [
                        'label'     => esc_html__('Checkout Text Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-contrast-text-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_color_alt',
                    [
                        'label'     => esc_html__('Cart Text Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-text-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_border_color',
                    [
                        'label'     => esc_html__('Cart Border Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-border-color: {{VALUE}};'
                        ]
                    ]
                );


                $this->add_control(
                    'button_border_color_add',
                    [
                        'label'     => esc_html__('Cart Border Color Additional', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-border-color-add: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_background_color',
                    [
                        'label'     => esc_html__('Cart Background Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-background-color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_background_color_add',
                    [
                        'label'     => esc_html__('Cart Background Color Additional', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-background-color-add: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_background_color_alt',
                    [
                        'label'     => esc_html__('Checkout Background Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-contrast-background-alter-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
            // ------ Hover Tab ------ //
            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__('Hover', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'button_color_hover',
                    [
                        'label'     => esc_html__('Cart Text Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-text-hover: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_color_alt_hover',
                    [
                        'label'     => esc_html__('Checkout Text Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-text-hover-alt: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_border_color_hover',
                    [
                        'label'     => esc_html__('Cart Border Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-border-hover: {{VALUE}};'
                        ]
                    ]
                );


                $this->add_control(
                    'button_border_color_add_hover',
                    [
                        'label'     => esc_html__('Cart Border Color Additional', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-border-hover-add: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_background_color_hover',
                    [
                        'label'     => esc_html__('Cart Background Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-background-hover: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_background_color_add_hover',
                    [
                        'label'     => esc_html__('Cart Background Color Additional', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-background-hover-add: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_background_color_alt_hover',
                    [
                        'label'     => esc_html__('Checkout Background Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-border-color-alt: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'button_background_color_alt_hover_add',
                    [
                        'label'     => esc_html__('Checkout Background Color Additional', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .mini-cart-panel .woocommerce-mini-cart-buttons' => '--aigency-standard-button-border-color-alt-add: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>
            <div class="mini-cart">
                <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="mini-cart-trigger">
                    <i class="mini-cart-count">
                    <?php
                        if ( WC()->cart && WC()->cart->cart_contents_count > 0 ) {
                            echo '<span>' . WC()->cart->cart_contents_count . '</span>';
                        }
                    ?>
                    </i>
                </a>
                <div class="mini-cart-panel woocommerce">
                	<h5 class="mini-cart-title"><?php echo esc_html__('Cart Items', 'aigency-plugin'); ?></h5>
                    <?php 
	                    if ( WC()->cart ) {
	                    	woocommerce_mini_cart();
	                    }
                     ?>
                </div>
            </div>
        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}
