<?php
/*
Plugin Name: Aigency Plugin
Plugin URI: https://demo.artureanec.com/
Description: Register Custom Widgets and Custom Post Types for Aigency Theme.
Version: 1.0
Author: Artureanec
Author URI: https://demo.artureanec.com/
Text Domain: aigency-plugin
*/

// --- Register Custom Widgets --- //
if (!function_exists('aigency_widgets_load')) {
    function aigency_widgets_load() {
        require_once(__DIR__ . "/widgets/nav-menu.php");
        require_once(__DIR__ . "/widgets/special-text.php");
    }
}
add_action('plugins_loaded', 'aigency_widgets_load');

if (!function_exists('aigency_add_custom_widget')) {
    function aigency_add_custom_widget($name) {
        register_widget($name);
    }
}

// --- Add Mime Types --- //
function aigency_upload_mimes( $mimes = array() ) {
    // allow SVG file upload
    $mimes['svg'] = 'image/svg+xml';
    $mimes['svgz'] = 'image/svg+xml';

    return $mimes;
}
add_filter( 'upload_mimes', 'aigency_upload_mimes', 99 );

// --- Register Custom Post Types --- //
add_action('init', 'aigency_register_custom_post_types');
if (!function_exists('aigency_register_custom_post_types')) {
    function aigency_register_custom_post_types() {

        if (function_exists('aigency_get_theme_mod')) {
            # Projects
            if ( aigency_get_theme_mod('project_posts_status') == 'on' ) {
                register_taxonomy(
                    'aigency_project_category',
                    array('aigency_project'),
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Project Categories', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Project Category', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Category', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Project Categories', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Category', 'aigency-plugin'),
                            'parent_item'       => esc_html__('Parent Category', 'aigency-plugin'),
                            'parent_item_colon' => esc_html__('Parent Category:', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Category', 'aigency-plugin'),
                            'update_item'       => esc_html__('Update Category', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('Add New Category', 'aigency-plugin'),
                            'new_item_name'     => esc_html__('New Project Category', 'aigency-plugin'),
                            'menu_name'         => esc_html__('Project Categories', 'aigency-plugin'),
                        ),
                        'hierarchical'      => true,
                        'show_admin_column' => false,
                        'rewrite'           => array(
	                        'slug'              => (!empty(aigency_get_theme_mod('project_categories_slug')) ? aigency_get_theme_mod('project_categories_slug') : 'project-categories')
	                    )
                    )
                );
                register_post_type(
                    'aigency_project',
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Projects', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Project', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Project', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Projects', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Project', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Project', 'aigency-plugin'),
                            'add_new'           => esc_html__('Add New Project', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('New Project', 'aigency-plugin'),
                            'archives'          => esc_html__('Projects', 'aigency-plugin')
                        ),
                        'public'            => true,
                        'rewrite'           => array(
                            'slug'              => (!empty(aigency_get_theme_mod('project_posts_slug')) ? aigency_get_theme_mod('project_posts_slug') : 'projects'),
                            'with_front'        => false
                        ),
                        'hierarchical'      => true,
                        'menu_position'     => 5,
                        'menu_icon'         => 'dashicons-laptop',
                        'supports'          => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
                        'taxonomies'        => array( 'aigency_project_category' ),
                        'has_archive'       => true
                    )
                );
            }

            # Team
            if ( aigency_get_theme_mod('team_posts_status') == 'on' ) {
                register_taxonomy(
                    'aigency_team_department',
                    array('aigency_team_member'),
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Departments', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Department', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Departments', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Departments', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Department', 'aigency-plugin'),
                            'parent_item'       => esc_html__('Parent Department', 'aigency-plugin'),
                            'parent_item_colon' => esc_html__('Parent Department:', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Department', 'aigency-plugin'),
                            'update_item'       => esc_html__('Update Department', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('Add New Department', 'aigency-plugin'),
                            'new_item_name'     => esc_html__('New Department Name', 'aigency-plugin'),
                            'menu_name'         => esc_html__('Departments', 'aigency-plugin'),
                        ),
                        'hierarchical'      => true,
                        'show_admin_column' => false,
                        'rewrite'           => array(
	                        'slug'              => (!empty(aigency_get_theme_mod('team_categories_slug')) ? aigency_get_theme_mod('team_categories_slug') : 'team-departments')
	                    )
                    )
                );
                register_post_type('aigency_team_member',
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Team Members', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Team Member', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Team Member', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Team Members', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Team Member', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Team Member', 'aigency-plugin'),
                            'add_new'           => esc_html__('Add New Member', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('New Team Member', 'aigency-plugin'),
                            'archives'          => esc_html__('Team', 'aigency-plugin')
                        ),
                        'public'            => true,
                        'rewrite'           => array(
                            'slug'              => (!empty(aigency_get_theme_mod('team_posts_slug')) ? aigency_get_theme_mod('team_posts_slug') : 'team'),
                            'with_front'        => false
                        ),
                        'hierarchical'      => false,
                        'menu_position'     => 6,
                        'menu_icon'         => 'dashicons-groups',
                        'supports'          => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
                        'taxonomies'        => array( 'aigency_team_department' ),
                        'has_archive'       => true
                    )
                );
            }

            # Careers
            if ( aigency_get_theme_mod('vacancy_posts_status') == 'on' ) {
                register_taxonomy(
                    'aigency_careers_department',
                    array('aigency_vacancy'),
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Departments', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Department', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Departments', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Departments', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Department', 'aigency-plugin'),
                            'parent_item'       => esc_html__('Parent Department', 'aigency-plugin'),
                            'parent_item_colon' => esc_html__('Parent Department:', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Department', 'aigency-plugin'),
                            'update_item'       => esc_html__('Update Department', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('Add New Department', 'aigency-plugin'),
                            'new_item_name'     => esc_html__('New Department Name', 'aigency-plugin'),
                            'menu_name'         => esc_html__('Departments', 'aigency-plugin'),
                        ),
                        'hierarchical'      => true,
                        'show_admin_column' => false,
                        'rewrite'           => array(
                        	'slug'              => (!empty(aigency_get_theme_mod('vacancy_categories_slug')) ? aigency_get_theme_mod('vacancy_categories_slug') : 'career-departments')
                        )                        
                    )
                );
                register_post_type('aigency_vacancy',
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Careers', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Career', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Career', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Careers', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Career', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Career', 'aigency-plugin'),
                            'add_new'           => esc_html__('Add New Career', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('New Career', 'aigency-plugin'),
                            'archives'          => esc_html__('Careers', 'aigency-plugin')
                        ),
                        'public'            => true,
                        'rewrite'           => array(
                            'slug'              => (!empty(aigency_get_theme_mod('vacancy_posts_slug')) ? aigency_get_theme_mod('vacancy_posts_slug') : 'careers'),
                            'with_front'        => false
                        ),
                        'hierarchical'      => false,
                        'menu_position'     => 7,
                        'menu_icon'         => 'dashicons-megaphone',
                        'supports'          => array( 'title', 'editor', 'author', 'excerpt' ),
                        'taxonomies'        => array( 'aigency_careers_department' ),
                        'has_archive'       => true
                    )
                );
            }        

            # Services
            if ( aigency_get_theme_mod('service_posts_status') == 'on' ) {
                register_taxonomy(
                    'aigency_services_category',
                    array('aigency_service'),
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Service Categories', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Service Category', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Category', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Categories', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Category', 'aigency-plugin'),
                            'parent_item'       => esc_html__('Parent Category', 'aigency-plugin'),
                            'parent_item_colon' => esc_html__('Parent Category:', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Category', 'aigency-plugin'),
                            'update_item'       => esc_html__('Update Category', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('Add New Category', 'aigency-plugin'),
                            'new_item_name'     => esc_html__('New Category Name', 'aigency-plugin'),
                            'menu_name'         => esc_html__('Categories', 'aigency-plugin'),
                        ),
                        'hierarchical'      => true,
                        'show_admin_column' => false,
                        'rewrite'           => array(
                        	'slug'              => (!empty(aigency_get_theme_mod('service_categories_slug')) ? aigency_get_theme_mod('service_categories_slug') : 'service-categories')
                        )
                    )
                );
                register_taxonomy(
                    'aigency_services_tag',
                    array('aigency_service'),
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Service Tags', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Service Tag', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Tag', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Tags', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Tag', 'aigency-plugin'),
                            'parent_item'       => esc_html__('Parent Tag', 'aigency-plugin'),
                            'parent_item_colon' => esc_html__('Parent Tag:', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Tag', 'aigency-plugin'),
                            'update_item'       => esc_html__('Update Tag', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('Add New Tag', 'aigency-plugin'),
                            'new_item_name'     => esc_html__('New Tag Name', 'aigency-plugin'),
                            'menu_name'         => esc_html__('Tags', 'aigency-plugin'),
                        ),
                        'hierarchical'      => false,
                        'show_admin_column' => false,
                        'show_in_rest'      => true,
                        'rewrite'           => array(
                        	'slug'              => (!empty(aigency_get_theme_mod('service_tags_slug')) ? aigency_get_theme_mod('service_tags_slug') : 'service-tags')
                        )
                    )
                );
                register_post_type('aigency_service',
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Services', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Service', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Service', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Services', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Service', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Service', 'aigency-plugin'),
                            'add_new'           => esc_html__('Add New Service', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('New Service', 'aigency-plugin'),
                            'archives'          => esc_html__('Services', 'aigency-plugin')
                        ),
                        'public'            => true,
                        'rewrite'           => array(
                            'slug'              => (!empty(aigency_get_theme_mod('service_posts_slug')) ? aigency_get_theme_mod('service_posts_slug') : 'services'),
                            'with_front'        => false
                        ),
                        'hierarchical'      => false,
                        'menu_position'     => 8,
                        'menu_icon'         => 'dashicons-admin-generic',
                        'supports'          => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
                        'taxonomies'        => array( 'aigency_services_category', 'aigency_services_tag' ),
                        'has_archive'       => true
                    )
                );
            }        

            # Case Studies
            if ( aigency_get_theme_mod('case_study_posts_status') == 'on' ) {
                register_taxonomy(
                    'aigency_case_study_category',
                    array('aigency_case_study'),
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Case Study Categories', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Case Study Category', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Category', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Categories', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Category', 'aigency-plugin'),
                            'parent_item'       => esc_html__('Parent Category', 'aigency-plugin'),
                            'parent_item_colon' => esc_html__('Parent Category:', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Category', 'aigency-plugin'),
                            'update_item'       => esc_html__('Update Category', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('Add New Category', 'aigency-plugin'),
                            'new_item_name'     => esc_html__('New Category Name', 'aigency-plugin'),
                            'menu_name'         => esc_html__('Categories', 'aigency-plugin'),
                        ),
                        'hierarchical'      => true,
                        'show_admin_column' => false,
                        'show_in_rest'      => true,
                        'rewrite'           => array(
                        	'slug'              => (!empty(aigency_get_theme_mod('case_study_categories_slug')) ? aigency_get_theme_mod('case_study_categories_slug') : 'case-study-categories')
                        )
                    )
                );
                register_taxonomy(
                    'aigency_case_study_tag',
                    array('aigency_case_study'),
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Case Study Tags', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Case Study Tag', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Tag', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Tags', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Tag', 'aigency-plugin'),
                            'parent_item'       => esc_html__('Parent Tag', 'aigency-plugin'),
                            'parent_item_colon' => esc_html__('Parent Tag:', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Tag', 'aigency-plugin'),
                            'update_item'       => esc_html__('Update Tag', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('Add New Tag', 'aigency-plugin'),
                            'new_item_name'     => esc_html__('New Tag Name', 'aigency-plugin'),
                            'menu_name'         => esc_html__('Tags', 'aigency-plugin'),
                        ),
                        'hierarchical'      => false,
                        'show_admin_column' => false,
                        'show_in_rest'      => true,
                        'rewrite'           => array(
                        	'slug'              => (!empty(aigency_get_theme_mod('case_study_tags_slug')) ? aigency_get_theme_mod('case_study_tags_slug') : 'case-study-tags')
                        )
                    )
                );
                register_post_type('aigency_case_study',
                    array(
                        'label'             => null,
                        'labels'            => array(
                            'name'              => esc_html__('Case Studies', 'aigency-plugin'),
                            'singular_name'     => esc_html__('Case Study', 'aigency-plugin'),
                            'search_items'      => esc_html__('Search Case Studies', 'aigency-plugin'),
                            'all_items'         => esc_html__('All Case Studies', 'aigency-plugin'),
                            'view_item'         => esc_html__('View Case Study', 'aigency-plugin'),
                            'edit_item'         => esc_html__('Edit Case Study', 'aigency-plugin'),
                            'add_new'           => esc_html__('Add New Case Study', 'aigency-plugin'),
                            'add_new_item'      => esc_html__('New Case Study', 'aigency-plugin'),
                            'archives'          => esc_html__('Case Studies', 'aigency-plugin')
                        ),
                        'public'            => true,
                        'rewrite'           => array(
                            'slug'              => (!empty(aigency_get_theme_mod('case_study_posts_slug')) ? aigency_get_theme_mod('case_study_posts_slug') : 'case-studies'),
                            'with_front'        => false
                        ),
                        'hierarchical'      => false,
                        'menu_position'     => 9,
                        'menu_icon'         => 'dashicons-open-folder',
                        'supports'          => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
                        'taxonomies'        => array( 'aigency_case_study_category', 'aigency_case_study_tag' ),
                        'has_archive'       => true,
                        'show_in_rest'      => true
                    )
                );
            }
        }        
    }
}

// Init Custom Widgets for Elementor
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

final class Aigency_Custom_Widgets {
    const  VERSION = '1.0.0';
    const  MINIMUM_ELEMENTOR_VERSION = '2.0.0';
    const  MINIMUM_PHP_VERSION = '5.4';
    private static $_instance = null;

    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        add_action('plugins_loaded', [$this, 'init']);
        add_action('init', [$this, 'i18n'], 0);
    }

    public function i18n() {
    	load_plugin_textdomain('aigency-plugin', false, plugin_basename(dirname(__FILE__)) . '/languages');
    }

    public function init() {

        // Check if Elementor installed and activated
        if (!did_action('elementor/loaded')) {
            add_action('admin_notices', [$this, 'aigency_admin_notice_missing_main_plugin']);
            return;
        }

        // Check for required Elementor version
        if (!version_compare(ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=')) {
            add_action('admin_notices', [$this, 'aigency_admin_notice_minimum_elementor_version']);
            return;
        }

        // Check for required PHP version
        if (version_compare(PHP_VERSION, self::MINIMUM_PHP_VERSION, '<')) {
            add_action('admin_notices', [$this, 'aigency_admin_notice_minimum_php_version']);
            return;
        }

        // Add Custom Icons Group
        if ( !function_exists('aigency_add_custom_icons_group_to_elementor') ) {
            function aigency_add_custom_icons_group_to_elementor($additional_tabs) {
                $custom_groups = [
                    'theme_icons'   => [
                        'name'          => 'theme_icons',
                        'label'         => esc_html__( 'Theme Icons', 'aigency-plugin' ),
                        'labelIcon'     => 'eicon-theme-style',
                        'native'        => false,
                        'url'           => get_template_directory_uri() . '/css/fontello.css',
                        'enqueue'       => [
                            get_template_directory_uri() . '/css/fontello-enqueue.css'
                        ],
                        'prefix'        => 'icon-',
                        'displayPrefix' => 'fontello',
                        'ver'           => '1.0.0',
                        'fetchJson'     => get_template_directory_uri() . '/js/fontello.js',
                    ]
                ];
                $additional_tabs = array_merge($additional_tabs, $custom_groups);
                return $additional_tabs;
            }
        }
        add_filter( 'elementor/icons_manager/additional_tabs', 'aigency_add_custom_icons_group_to_elementor' );

        // SVG tags support
        add_filter('elementor/files/svg/allowed_elements', function($allowed_elements) {
            return array_merge($allowed_elements, array('feflood', 'feblend', 'fegaussianblur'));
        });

        // Add Custom Fonts Group
        if ( !function_exists('aigency_add_custom_fonts_group_to_elementor') ) {
            function aigency_add_custom_fonts_group_to_elementor($font_groups) {
                $additional_groups = array(
                    'theme_fonts'     => esc_html__( 'Theme Fonts', 'aigency-plugin' )
                );
                $font_groups = array_merge($font_groups, $additional_groups);
                return $font_groups;
            }
        }
        add_filter( 'elementor/fonts/groups', 'aigency_add_custom_fonts_group_to_elementor' );

        // Add Custom Fonts
        if ( !function_exists('aigency_add_custom_fonts_to_elementor') ) {
            function aigency_add_custom_fonts_to_elementor($fonts) {
                $additional_fonts = array(
                    'Manrope Alt'        => 'theme_fonts'
                );
                $fonts = array_merge($fonts, $additional_fonts);
                return $fonts;
            }
        }
        add_filter( 'elementor/fonts/additional_fonts', 'aigency_add_custom_fonts_to_elementor' );

        //Custom Animation for Elementor
        if (!function_exists('aigency_elementor_custom_animation')) {
            function aigency_elementor_custom_animation() {
                return array(
                    'Aigency Animation' => [
                        'aigency_heading_animation' => 'Heading Animation',
                        'aigency_width_animation' => 'Width Animation',
                        'aigency_clip_down' => 'Clip Down',
                        'aigency_clip_up' => 'Clip Up',
                        'aigency_clip_right' => 'Clip Right',
                        'aigency_clip_left' => 'Clip Left',
                    ]
                );
            }
        }
        add_filter( 'elementor/controls/animations/additional_animations', 'aigency_elementor_custom_animation' );

        // Add Hover Animations
        if ( !function_exists('aigency_add_hover_animations_to_elementor') ) {
            function aigency_add_hover_animations_to_elementor($animations) {
                $additional_animations = array(
                	'slide-aslant' => __('Slide Aslant', 'aigency-plugin'),
                	'aigency-grow' => __('Aigency Grow', 'aigency-plugin'),
                );
                $animations = array_merge($animations, $additional_animations);
                return $animations;
            }
        }
        add_filter( 'elementor/controls/hover_animations/additional_animations', 'aigency_add_hover_animations_to_elementor' );        

        // Include Additional Files
        add_action('elementor/init', [$this, 'aigency_include_additional_files']);

        // Add new Elementor Categories
        add_action('elementor/init', [$this, 'aigency_add_elementor_category']);

        // Register Widget Scripts
        add_action('elementor/frontend/after_register_scripts', [$this, 'aigency_register_widget_scripts']);

        add_action('wp_enqueue_scripts', function () {
            wp_localize_script('ajax_query_products', 'aigency_ajaxurl',
                array(
                    'url' => admin_url('admin-ajax.php')
                )
            );
        });

        // Register New Widgets
        add_action('elementor/widgets/register', [$this, 'aigency_widgets_register']);

        // Remove some Standard Widgets
        add_action('elementor/widgets/register', function ($widget_manager) {
            $widget_manager->unregister('hfe-breadcrumbs-widget');
            $widget_manager->unregister('hfe-search-button');
            $widget_manager->unregister('hfe-cart');
            $widget_manager->unregister('navigation-menu');
            $widget_manager->unregister('page-title');
        }, 15);

        // Register Editor Styles
        add_action('elementor/editor/before_enqueue_scripts', function () {
            wp_register_style('aigency_elementor_admin', plugins_url('aigency-plugin/css/aigency-plugin-admin.css'));
            wp_enqueue_style('aigency_elementor_admin');            
        });
    }

    public function aigency_admin_notice_missing_main_plugin() {
        $message = sprintf(
        /* translators: 1: Restbeef Core 2: Elementor */
            esc_html__('"%1$s" requires "%2$s" to be installed and activated.', 'aigency-plugin'),
            '<strong>' . esc_html__('Restbeef Core', 'aigency-plugin') . '</strong>',
            '<strong>' . esc_html__('Elementor', 'aigency-plugin') . '</strong>'
        );
        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function aigency_admin_notice_minimum_elementor_version() {
        $message = sprintf(
        /* translators: 1: Restbeef Core 2: Elementor 3: Required Elementor version */
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', 'aigency-plugin'),
            '<strong>' . esc_html__('Restbeef Core', 'aigency-plugin') . '</strong>',
            '<strong>' . esc_html__('Elementor', 'aigency-plugin') . '</strong>',
            self::MINIMUM_ELEMENTOR_VERSION
        );
        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function aigency_admin_notice_minimum_php_version() {
        $message = sprintf(
        /* translators: 1: Press Elements 2: PHP 3: Required PHP version */
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', 'aigency-plugin'),
            '<strong>' . esc_html__('Press Elements', 'aigency-plugin') . '</strong>',
            '<strong>' . esc_html__('PHP', 'aigency-plugin') . '</strong>',
            self::MINIMUM_PHP_VERSION
        );
        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function aigency_include_additional_files() {}

    public function aigency_add_elementor_category() {
        $categories = [];
        $categories['aigency_widgets'] = [
            'title' => esc_html__('Aigency Widgets', 'aigency-plugin'),
            'icon'  => 'eicon-plug'
        ];
        $old_categories = \Elementor\Plugin::$instance->elements_manager->get_categories();
        $categories     = array_merge($categories, $old_categories);

        $set_categories = function ( $categories ) {
            $this->categories = $categories;
        };
        $set_categories->call( \Elementor\Plugin::$instance->elements_manager, $categories );
    }

    public function aigency_register_widget_scripts() {
        // Lib
        wp_register_script('fancybox', plugins_url('aigency-plugin/js/lib/jquery.fancybox.min.js'), array('jquery'));
        wp_register_script('slick-slider', plugins_url('aigency-plugin/js/lib/slick.min.js'), array('jquery'));
        wp_register_script('isotope', plugins_url('aigency-plugin/js/lib/isotope.pkgd.min.js'), array('jquery'));
        wp_register_script('plugin', plugins_url('aigency-plugin/js/lib/jquery.plugin.js'), array('jquery'));        
        wp_register_script('flowmap-effect', plugins_url('aigency-plugin/js/lib/flowmap-effect.min.js'), array(), false, true );        
        wp_register_script('aat', plugins_url('aigency-plugin/js/lib/aat.min.js'), array(), false, true );
        wp_register_script('scroll-trigger', plugins_url('aigency-plugin/js/lib/ScrollTrigger.min.js'), array(), false, true );
        wp_register_script('gsap', plugins_url('aigency-plugin/js/lib/gsap.min.js'), array('scroll-trigger'), false, true );

        // Scripts
        wp_register_script('aigency_elementor_editor', plugins_url('aigency-plugin/js/elementor-scripts.js'), array('jquery'));
        wp_enqueue_script('aigency_elementor_editor');
        wp_register_script('elementor_widgets', plugins_url('aigency-plugin/js/elementor-widgets.js'), array('jquery', 'owl-carousel', 'isotope', 'aigency-theme'));
    }

    public function aigency_widgets_register() {

        // --- Include Widget Files --- //
        require_once __DIR__ . '/elements/audio-listing.php';
        require_once __DIR__ . '/elements/awards.php';
        require_once __DIR__ . '/elements/blog.php';
        require_once __DIR__ . '/elements/button.php';
        require_once __DIR__ . '/elements/content-slider.php';
        require_once __DIR__ . '/elements/custom-menu.php';
        require_once __DIR__ . '/elements/gallery.php';
        require_once __DIR__ . '/elements/heading.php';
        require_once __DIR__ . '/elements/icon-box.php';
        require_once __DIR__ . '/elements/image-carousel.php';
        require_once __DIR__ . '/elements/price-item.php';     
        require_once __DIR__ . '/elements/moving-list.php';
        require_once __DIR__ . '/elements/special-text.php';
        require_once __DIR__ . '/elements/step-carousel.php';
        require_once __DIR__ . '/elements/tabs.php';
        require_once __DIR__ . '/elements/testimonial-carousel.php';
        require_once __DIR__ . '/elements/video-button.php';        

        // --- Register Widgets --- //
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Audio_Listing_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Awards_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Blog_Listing_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Button_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Content_Slider_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Custom_Menu_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Gallery_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Heading_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Icon_Box_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Image_Carousel_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Moving_List_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Price_Item_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Special_Text_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Step_Carousel_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Tabs_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Testimonial_Carousel_Widget());
        \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Video_Button_Widget());

        if ( function_exists('aigency_get_theme_mod') ) {
        	if ( aigency_get_theme_mod('vacancy_posts_status') == 'on' ) {
	            require_once __DIR__ . '/elements/vacancies-listing.php';
	            \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Vacancies_Listing_Widget());
	        }
        	if ( aigency_get_theme_mod('case_study_posts_status') == 'on' ) {
	            require_once __DIR__ . '/elements/case-study-listing.php';
	            \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Case_Study_Widget());
	        }
        	if ( aigency_get_theme_mod('project_posts_status') == 'on' ) {
	            require_once __DIR__ . '/elements/projects-listing.php';
	            \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Projects_Listing_Widget());
	        }
	        if ( aigency_get_theme_mod('service_posts_status') == 'on' ) {
	            require_once __DIR__ . '/elements/services-listing.php';
	            \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Services_Listing_Widget());
	        }
	        if ( aigency_get_theme_mod('team_posts_status') == 'on' ) {
	            require_once __DIR__ . '/elements/team-members.php';
	            \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Team_Members_Widget());
	        }	        	        	        
        }        

        if (class_exists('WooCommerce')) {
            require_once __DIR__ . '/elements/products.php';
            \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Products_Widget());
        }

        if ( function_exists( 'wpforms' ) ) {
            require_once __DIR__ . '/elements/wpforms.php';
            \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Wpforms_Widget());
        }

        if ( function_exists( 'mc4wp' ) ) {
            require_once __DIR__ . '/elements/mailchimp.php';
            \Elementor\Plugin::instance()->widgets_manager->register(new Aigency\Widgets\Aigency_Mailchimp_Widget());
        }

        if ( function_exists('hfe_init') ) {
            require_once __DIR__ . '/elements/header-footer-elements/navigation-menu.php';
            require_once __DIR__ . '/elements/header-footer-elements/page-title.php';
            require_once __DIR__ . '/elements/header-footer-elements/search.php';
            require_once __DIR__ . '/elements/header-footer-elements/slide-sidebar.php';
                        
            \Elementor\Plugin::instance()->widgets_manager->register(new HFE\WidgetsManager\Widgets\Aigency_Navigation_Menu_Widget());
            \Elementor\Plugin::instance()->widgets_manager->register(new HFE\WidgetsManager\Widgets\Aigency_Page_Title_Widget());
            \Elementor\Plugin::instance()->widgets_manager->register(new HFE\WidgetsManager\Widgets\Aigency_Search_Widget());
            \Elementor\Plugin::instance()->widgets_manager->register(new HFE\WidgetsManager\Widgets\Aigency_Slide_Sidebar_Widget());

            if ( class_exists('WooCommerce') ) {
                require_once __DIR__ . '/elements/header-footer-elements/cart.php';
                \Elementor\Plugin::instance()->widgets_manager->register(new HFE\WidgetsManager\Widgets\Aigency_Cart_Widget());
            }
        }
    }
}

Aigency_Custom_Widgets::instance();

add_action('plugins_loaded', function() {
	
	if ( did_action( 'elementor/loaded' ) ) {

	    add_action('elementor/element/after_section_start', function ($element, $section_id, $args) {
	        if ( ('accordion' === $element->get_name() && 'section_title' === $section_id) ||
                 ('nested-accordion' === $element->get_name() && 'section_items' === $section_id)) {
	            $element->add_control(
	                'accordion_style',
	                [
	                    'label' => esc_html__( 'Accordion Style', 'aigency-plugin' ),
	                    'type' => \Elementor\Controls_Manager::SELECT,
	                    'default' => '',
	                    'options' => [
	                        '' => esc_html__( 'Default', 'aigency-plugin' ),
	                        'counter' => esc_html__( 'Counter', 'aigency-plugin' ),
	                    ],
	                    'prefix_class' => 'elementor-accordion-style-'
	                ]
	            );
	        }
	        if ('icon' === $element->get_name() && 'section_style_icon' === $section_id) {            
	            $element->add_responsive_control(
	                'icon_align',
	                [
	                    'label' => esc_html__( 'Alignment', 'aigency-plugin' ),
	                    'type' => \Elementor\Controls_Manager::CHOOSE,
	                    'options' => [
	                        'left' => [
	                            'title' => esc_html__( 'Left', 'aigency-plugin' ),
	                            'icon' => 'eicon-text-align-left',
	                        ],
	                        'center' => [
	                            'title' => esc_html__( 'Center', 'aigency-plugin' ),
	                            'icon' => 'eicon-text-align-center',
	                        ],
	                        'right' => [
	                            'title' => esc_html__( 'Right', 'aigency-plugin' ),
	                            'icon' => 'eicon-text-align-right',
	                        ],
	                    ],
	                    'default' => 'center',
	                    'selectors' => [
	                        '{{WRAPPER}}.aigency-icon-decoration-on .elementor-widget-container' => 'text-align: {{VALUE}};',
	                        '{{WRAPPER}}:not(.aigency-icon-decoration-on) .elementor-icon-wrapper' => 'text-align: {{VALUE}};',
	                    ],
	                    'prefix_class' => 'aigency-icon-alignment%s-'
	                ]
	            );
	            $element->add_control(
	                'icon_inner_bg_color',
	                [
	                    'label' => esc_html__( 'Icon Wrapper Background Color', 'aigency-plugin' ),
	                    'type' => \Elementor\Controls_Manager::COLOR,
	                    'default' => '',                    
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-icon-inner' => 'background-color: {{VALUE}};',
	                        '{{WRAPPER}}.aigency-icon-decoration-on .elementor-icon-wrapper:before,
	                        {{WRAPPER}}.aigency-icon-decoration-on .elementor-icon-wrapper:after' => 'box-shadow: 0 20px 0 0 {{VALUE}};'
	                    ],
	                    'condition' => [
	                        'add_decoration' => 'on',
	                    ],
	                ]
	            );
	        } 
	    }, 10, 3);

        add_action('elementor/element/after_section_end', function ($element, $section_id, $args) {

            if ( '_section_responsive' === $section_id ) {
                $element->start_controls_section(
                    'section_aigency_sticky_visibility',
                    [
                        'label'     => esc_html__('Sticky', 'aigency-plugin'),
                        'tab'       => \Elementor\Controls_Manager::TAB_ADVANCED
                    ]
                );
                    $element->add_control(
                        'aigency_sticky_heading_visibility',
                        [
                            'label'     => esc_html__( 'Visibility', 'aigency-plugin' ),
                            'type'      => \Elementor\Controls_Manager::HEADING,
                        ]
                    );
                    $element->add_control(
                        'aigency_hide_if_sticky',
                        [
                            'label'         => esc_html__('Hide On Sticky', 'aigency-plugin'),
                            'type'          => \Elementor\Controls_Manager::SWITCHER,
                            'label_off'     => esc_html__('Show', 'aigency-plugin'),
                            'label_on'      => esc_html__('Hide', 'aigency-plugin'),
                            'default'       => '',
                            'prefix_class'  => 'elementor-',
                            'return_value'  => 'hidden-on-sticky'
                        ]
                    );
                $element->end_controls_section();
            }

            if ( 'container' === $element->get_name() && 'section_shape_divider' === $section_id ) {
                $element->start_controls_section(
                    'section_colors',
                    [
                        'label' => esc_html__('Colors', 'aigency-plugin'),
                        'tab'   => \Elementor\Controls_Manager::TAB_STYLE
                    ]
                );

                    $element->add_control(
                        'customize_colors',
                        [
                            'label'         => esc_html__('Customize Colors', 'aigency-plugin'),
                            'type'          => \Elementor\Controls_Manager::SWITCHER,
                            'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                            'label_on'      => esc_html__('Show', 'aigency-plugin'),
                            'return_value'  => 'yes',
                            'default'       => 'no'
                        ]
                    );

                    $element->add_control(
                        'default_text_color',
                        [
                            'label'     => esc_html__('Default Text Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-default-text-color: {{VALUE}}; color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ],
                            'separator' => 'before'
                        ]
                    );

                    $element->add_control(
                        'dark_text_color',
                        [
                            'label'     => esc_html__('Dark Text Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-dark-text-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'light_text_color',
                        [
                            'label'     => esc_html__('Light Text Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-light-text-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'accent_text_color',
                        [
                            'label'     => esc_html__('Accent Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-accent-text-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'contrast_text_color',
                        [
                            'label'     => esc_html__('Contrast Text Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-contrast-text-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'input_dark_color',
                        [
                            'label'     => esc_html__('Input Dark Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-input-dark-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'border_color_1',
                        [
                            'label'     => esc_html__('Border Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-border-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ],
                            'separator' => 'before'
                        ]
                    );

                    $element->add_control(
                        'border_hover_color_1',
                        [
                            'label'     => esc_html__('Border Hover Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-border-hover-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'background_color_1',
                        [
                            'label'     => esc_html__('Background Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-background-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'background_alter_color',
                        [
                            'label'     => esc_html__('Background Alter Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-background-alter-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_text_color',
                        [
                            'label'     => esc_html__('Button Text Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-text-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ],
                            'separator' => 'before'
                        ]
                    );

                    $element->add_control(
                        'button_border_color',
                        [
                            'label'     => esc_html__('Button Border Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-border-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_border_color_add',
                        [
                            'label'     => esc_html__('Button Border Color Additional', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-border-color-add: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_background_color',
                        [
                            'label'     => esc_html__('Button Background Color', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-background-color: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_background_color_add',
                        [
                            'label'     => esc_html__('Button Background Color Additional', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-background-color-add: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_text_hover',
                        [
                            'label'     => esc_html__('Button Text Color Hover', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-text-hover: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_border_hover',
                        [
                            'label'     => esc_html__('Button Border Color Hover', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-border-hover: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_border_hover_add',
                        [
                            'label'     => esc_html__('Button Border Color Hover Additional', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-border-hover-add: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_background_hover',
                        [
                            'label'     => esc_html__('Button Background Color Hover', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-background-hover: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                    $element->add_control(
                        'button_background_hover_add',
                        [
                            'label'     => esc_html__('Button Background Color Hover Additional', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--aigency-standard-button-background-hover-add: {{VALUE}};'
                            ],
                            'condition' => [
                                'customize_colors' => 'yes'
                            ]
                        ]
                    );

                $element->end_controls_section();

                $element->start_controls_section(
                    'section_sticky_colors',
                    [
                        'label'     => esc_html__('Sticky Colors', 'aigency-plugin'),
                        'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
                        'condition' => [
                            'is_sticky' => 'on'
                        ]
                    ]
                );

                $element->add_control(
                    'customize_sticky_colors',
                    [
                        'label'         => esc_html__('Customize Sticky Colors', 'aigency-plugin'),
                        'type'          => \Elementor\Controls_Manager::SWITCHER,
                        'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                        'label_on'      => esc_html__('Show', 'aigency-plugin'),
                        'return_value'  => 'yes',
                        'default'       => 'no'
                    ]
                );

                $element->add_control(
                    'default_text_sticky_color',
                    [
                        'label'     => esc_html__('Default Text Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-default-text-color: {{VALUE}}; color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ],
                        'separator' => 'before'
                    ]
                );

                $element->add_control(
                    'dark_text_sticky_color',
                    [
                        'label'     => esc_html__('Dark Text Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-dark-text-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'light_text_sticky_color',
                    [
                        'label'     => esc_html__('Light Text Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-light-text-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'accent_text_sticky_color',
                    [
                        'label'     => esc_html__('Accent Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-accent-text-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'contrast_text_sticky_color',
                    [
                        'label'     => esc_html__('Contrast Text Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-contrast-text-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'input_dark_sticky_color',
                    [
                        'label'     => esc_html__('Input Dark Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-input-dark-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'border_sticky_color',
                    [
                        'label'     => esc_html__('Border Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-border-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ],
                        'separator' => 'before'
                    ]
                );

                $element->add_control(
                    'border_hover_sticky_color',
                    [
                        'label'     => esc_html__('Border Hover Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-border-hover-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'background_sticky_color',
                    [
                        'label'     => esc_html__('Background Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'background_alter_sticky_color',
                    [
                        'label'     => esc_html__('Background Alter Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-background-alter-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_text_sticky_color',
                    [
                        'label'     => esc_html__('Button Text Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-text-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ],
                        'separator' => 'before'
                    ]
                );

                $element->add_control(
                    'button_border_sticky_color',
                    [
                        'label'     => esc_html__('Button Border Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-border-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_border_sticky_color_add',
                    [
                        'label'     => esc_html__('Button Border Color Additional', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-border-color-add: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_background_sticky_color',
                    [
                        'label'     => esc_html__('Button Background Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-background-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_background_sticky_color_add',
                    [
                        'label'     => esc_html__('Button Background Color Additional', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-background-color-add: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_text_sticky_hover',
                    [
                        'label'     => esc_html__('Button Text Color Hover', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-text-hover: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_border_sticky_hover',
                    [
                        'label'     => esc_html__('Button Border Color Hover', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-border-hover: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_border_sticky_hover_add',
                    [
                        'label'     => esc_html__('Button Border Color Hover Additional', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-border-hover-add: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_background_sticky_hover',
                    [
                        'label'     => esc_html__('Button Background Color Hover', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-background-hover: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->add_control(
                    'button_background_sticky_hover_add',
                    [
                        'label'     => esc_html__('Button Background Color Hover Additional', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}}.sticky-container' => '--aigency-standard-button-background-hover-add: {{VALUE}};'
                        ],
                        'condition' => [
                            'customize_sticky_colors' => 'yes'
                        ]
                    ]
                );

                $element->end_controls_section();
            }

            if ( 'section' === $element->get_name() || 'container' === $element->get_name() ) {
                if ( 'section_background' === $section_id ) {
                	
                    $element->start_controls_section(
                        'section_sticky_background',
                        [
                            'label'     => esc_html__('Sticky Background', 'aigency-plugin'),
                            'tab'       => \Elementor\Controls_Manager::TAB_STYLE
                        ]
                    );
                    
                    $element->add_group_control(
                        \Elementor\Group_Control_Background::get_type(),
                        [
                            'name'      => 'sticky_background',
                            'label'     => esc_html__( 'Sticky Background', 'aigency-plugin' ),
                            'selector'  => '.elementor .elementor-element.elementor-element-{{ID}}.sticky-container, .elementor .sticky-container .elementor-element.elementor-element-{{ID}}'
                        ]
                    );
                    $element->add_control(
		                'section_sticky_filter_blur',
		                [
		                    'label' => esc_html__( 'Backdrop Blur Filter, px', 'aigency-plugin' ),
		                    'type' => \Elementor\Controls_Manager::SLIDER,
		                    'range' => [
		                        'px' => [
		                            'min' => 0,
		                            'max' => 25,
		                            'step' => 0.1,
		                        ],
		                    ],
		                    'selectors' => [
		                        '.elementor .elementor-element.elementor-element-{{ID}}.sticky-container, .elementor .sticky-container .elementor-element.elementor-element-{{ID}}' => 'backdrop-filter: blur( {{SIZE}}px ); -webkit-backdrop-filter: blur( {{SIZE}}px );',
		                    ],
		                ]            
		            );
		            $element->add_control(
                        'remove_filter_blur',
                        [
                            'label'         => esc_html__('Remove Backdrop Blur Filter', 'aigency-plugin'),
                            'type'          => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'      => esc_html__('On', 'aigency-plugin'),
                            'label_off'     => esc_html__('Off', 'aigency-plugin'),
                            'return_value'  => 'on',
                            'default'       => '',
                            'prefix_class'  => 'elementor-element-remove-filter-blur-'
                        ]
                    );
                    $element->end_controls_section();
                }
                if ( 'section_border' === $section_id ) {
                    $element->start_controls_section(
                        'section_sticky_border',
                        [
                            'label'     => esc_html__('Sticky Border', 'aigency-plugin'),
                            'tab'       => \Elementor\Controls_Manager::TAB_STYLE
                        ]
                    );
                        $element->add_group_control(
                            \Elementor\Group_Control_Border::get_type(),
                            [
                                'name'              => 'aigency_sticky_border',
                                'selector'          => '.elementor .elementor-element.elementor-element-{{ID}}.sticky-container, .elementor .sticky-container .elementor-element.elementor-element-{{ID}}'
                            ]
                        );

                        $element->add_responsive_control(
                            'aigency_sticky_border_radius',
                            [
                                'label'         => esc_html__( 'Border Radius', 'aigency-plugin' ),
                                'type'          => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units'    => [ 'px', '%', 'em', 'rem', 'custom' ],
                                'selectors'     => [
                                    '.elementor .elementor-element.elementor-element-{{ID}}.sticky-container, .elementor .sticky-container .elementor-element.elementor-element-{{ID}}' => '--border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ]
                            ]
                        );

                        $element->add_group_control(
                            \Elementor\Group_Control_Box_Shadow::get_type(),
                            [
                                'name'          => 'aigency_sticky_box_shadow',
                                'selector'      => '.elementor .elementor-element.elementor-element-{{ID}}.sticky-container, .elementor .sticky-container .elementor-element.elementor-element-{{ID}}'
                            ]
                        );
                    $element->end_controls_section();
                }
            }

	        if ( 'image' === $element->get_name() && 'section_style_image' === $section_id ) {
	        	$element->start_controls_section(
                    'section_overlay_style_image',
                    [
                        'label'     => esc_html__('Image Overlay', 'aigency-plugin'),
                        'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
                        'condition' => [
                        	'show_image_overlay' => 'yes'
                        ]
                    ]
                );

                $element->add_responsive_control(
		            'overlay_width',
		            [
		                'label' => esc_html__( 'Overlay Width', 'aigency-plugin' ),
		                'type' => \Elementor\Controls_Manager::SLIDER,
		                'size_units' => [ 'px', '%', 'vw', 'em', 'rem'],
		                'selectors' => [
		                    '{{WRAPPER}} .image-overlay .image-overlay-card' => 'width: {{SIZE}}{{UNIT}};',                  
		                ],
		            ]
		        );

                $element->add_responsive_control(
		            'overlay_content_padding',
		            [
		                'label' => esc_html__( 'Overlay Content Padding', 'aigency-plugin' ),
		                'type' => \Elementor\Controls_Manager::DIMENSIONS,
		                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		                'selectors' => [
		                    '{{WRAPPER}} .image-overlay .image-overlay-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
		            ]
		        );

		        $element->add_control(
                    'overlay_content_color',
                    [
                        'label'     => esc_html__('Overlay Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .image-overlay .image-overlay-subtitle,
                            {{WRAPPER}} .image-overlay .image-overlay-text' => 'color: {{VALUE}};'
                        ]
                    ]
                );

		        $element->add_control(
                    'overlay_background_color',
                    [
                        'label'     => esc_html__('Overlay Background Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .image-overlay .image-overlay-subtitle,
                            {{WRAPPER}} .image-overlay .image-overlay-content' => 'background-color: {{VALUE}};',
                            '{{WRAPPER}} .image-overlay .image-overlay-subtitle-wrapper:after' => 'box-shadow: 0 20px 0 0 {{VALUE}};'
                        ]
                    ]
                );

                $element->add_group_control(
		            \Elementor\Group_Control_Typography::get_type(),
		            [
		                'name'      => 'overlay_subtitle_typography',
		                'label'     => esc_html__('Subtitle Typography', 'aigency-plugin'),
		                'selector'  => '{{WRAPPER}} .image-overlay .image-overlay-subtitle'
		            ]
		        );

		        $element->add_control(
                    'overlay_subtitle_color',
                    [
                        'label'     => esc_html__('Subtitle Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .image-overlay .image-overlay-subtitle' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $element->add_group_control(
		            \Elementor\Group_Control_Typography::get_type(),
		            [
		                'name'      => 'overlay_text_typography',
		                'label'     => esc_html__('Text Typography', 'aigency-plugin'),
		                'selector'  => '{{WRAPPER}} .image-overlay .image-overlay-text'
		            ]
		        );

		        $element->add_control(
                    'overlay_text_color',
                    [
                        'label'     => esc_html__('Text Color', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .image-overlay .image-overlay-text' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $element->add_control(
                    'overlay_style_image_buttons_heading',
                    [
                        'label'     => esc_html__( 'Button Settings', 'aigency-plugin' ),
                        'type'      => \Elementor\Controls_Manager::HEADING,
                    ]
                );

                $element->add_group_control(
		            \Elementor\Group_Control_Typography::get_type(),
		            [
		                'name'      => 'button_typography',
		                'label'     => esc_html__('Button Typography', 'aigency-plugin'),
		                'selector'  => '{{WRAPPER}} .aigency-button'
		            ]
		        );

		        $element->add_control(
		            'button_border_width',
		            [
		                'label' => esc_html__( 'Border Width', 'aigency-plugin' ),
		                'type' => \Elementor\Controls_Manager::SLIDER,
		                'size_units' => [ 'px', 'em', 'rem'],
		                'selectors' => [
		                    '{{WRAPPER}} .aigency-button' => 'border-width: {{SIZE}}{{UNIT}};',
		                    '{{WRAPPER}} .aigency-button' => '--button-border-width: {{SIZE}}{{UNIT}};',                    
		                ],
		            ]
		        );

		        $element->add_control(
		            'button_border_radius',
		            [
		                'label' => esc_html__( 'Border Radius', 'aigency-plugin' ),
		                'type' => \Elementor\Controls_Manager::DIMENSIONS,
		                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
		                'selectors' => [
		                    '{{WRAPPER}} .aigency-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
		            ]
		        );

                $element->start_controls_tabs('button_settings_tabs');

		            // ------------------------ //
		            // ------ Normal Tab ------ //
		            // ------------------------ //
		            $element->start_controls_tab(
		                'tab_button_normal',
		                [
		                    'label' => esc_html__('Normal', 'aigency-plugin')
		                ]
		            );

		                $element->add_control(
		                    'button_color',
		                    [
		                        'label'     => esc_html__('Button Color', 'aigency-plugin'),
		                        'type'      => \Elementor\Controls_Manager::COLOR,
		                        'selectors' => [
		                            '{{WRAPPER}} .aigency-button' => 'color: {{VALUE}};'
		                        ]
		                    ]
		                );

		                $element->add_control(
		                    'button_border_color',
		                    [
		                        'label'     => esc_html__('Button Border Color', 'aigency-plugin'),
		                        'type'      => \Elementor\Controls_Manager::COLOR,
		                        'selectors' => [
		                            '{{WRAPPER}} .aigency-button' => 'border-color: {{VALUE}};'
		                        ],
		                        'condition' => [
		                            'button_border_style' => 'solid'
		                        ]
		                    ]
		                );

		                $element->add_group_control(
		                    \Elementor\Group_Control_Background::get_type(),
		                    [
		                        'name' => 'button_border_color_gradient',
		                        'fields_options' => [
		                            'background' => [
		                                'label' => esc_html__( 'Border Color Gradient', 'aigency-plugin' )
		                            ]                    
		                        ],
		                        'types' => [ 'gradient' ],
		                        'selector' => '{{WRAPPER}} .aigency-button:after',
		                        'condition' => [
		                            'button_border_style' => 'gradient'
		                        ]
		                    ]
		                );

		                $element->add_control(
		                    'button_background_color',
		                    [
		                        'label'     => esc_html__('Button Background Color', 'aigency-plugin'),
		                        'type'      => \Elementor\Controls_Manager::COLOR,
		                        'selectors' => [
		                            '{{WRAPPER}} .aigency-button' => 'background-color: {{VALUE}};'
		                        ],
		                        'condition' => [
		                            'button_background_style' => 'solid'
		                        ]
		                    ]
		                );

		                $element->add_group_control(
		                    \Elementor\Group_Control_Background::get_type(),
		                    [
		                        'name' => 'button_bg_color_gradient',
		                        'fields_options' => [
		                            'background' => [
		                                'label' => esc_html__( 'Background Color Gradient', 'aigency-plugin' )
		                            ]                    
		                        ],
		                        'types' => [ 'gradient' ],
		                        'selector' => '{{WRAPPER}} .aigency-button .button-inner:before',
		                        'condition' => [
		                            'button_background_style' => 'gradient'
		                        ]
		                    ]
		                );

		                $element->add_group_control(
		                    \Elementor\Group_Control_Box_Shadow::get_type(),
		                    [
		                        'name' => 'button_box_shadow',
		                        'selector' => '{{WRAPPER}} .aigency-button',
		                        'condition' => [
		                            'remove_box_shadow!' => 'yes'
		                        ]
		                    ]
		                );

		            $element->end_controls_tab();

		            // ----------------------- //
		            // ------ Hover Tab ------ //
		            // ----------------------- //
		            $element->start_controls_tab(
		                'tab_button_hover',
		                [
		                    'label' => esc_html__('Hover', 'aigency-plugin')
		                ]
		            );

		                $element->add_control(
		                    'button_color_hover',
		                    [
		                        'label'     => esc_html__('Button Color', 'aigency-plugin'),
		                        'type'      => \Elementor\Controls_Manager::COLOR,
		                        'selectors' => [
		                            '{{WRAPPER}} .aigency-button:hover' => 'color: {{VALUE}};'
		                        ]
		                    ]
		                );

		                $element->add_control(
		                    'button_border_color_hover',
		                    [
		                        'label'     => esc_html__('Button Border Color', 'aigency-plugin'),
		                        'type'      => \Elementor\Controls_Manager::COLOR,
		                        'selectors' => [
		                            '{{WRAPPER}} .aigency-button:hover' => 'border-color: {{VALUE}};'
		                        ],
		                        'condition' => [
		                            'button_border_style' => 'solid'
		                        ]
		                    ]
		                );

		                $element->add_group_control(
		                    \Elementor\Group_Control_Background::get_type(),
		                    [
		                        'name' => 'button_border_color_gradient_hover',
		                        'fields_options' => [
		                            'background' => [
		                                'label' => esc_html__( 'Border Color Gradient', 'aigency-plugin' )
		                            ]                    
		                        ],
		                        'types' => [ 'gradient' ],
		                        'selector' => '{{WRAPPER}} .aigency-button:hover:after',
		                        'condition' => [
		                            'button_border_style' => 'gradient'
		                        ]
		                    ]
		                );

		                $element->add_control(
		                    'button_background_color_hover',
		                    [
		                        'label'     => esc_html__('Button Background Color', 'aigency-plugin'),
		                        'type'      => \Elementor\Controls_Manager::COLOR,
		                        'selectors' => [
		                            '{{WRAPPER}} .aigency-button:hover' => 'background-color: {{VALUE}};',
		                        ],
		                        'condition' => [
		                            'button_background_style' => 'solid'
		                        ]
		                    ]
		                );

		                $element->add_group_control(
		                    \Elementor\Group_Control_Background::get_type(),
		                    [
		                        'name' => 'button_bg_color_gradient_hover',
		                        'fields_options' => [
		                            'background' => [
		                                'label' => esc_html__( 'Background Color Gradient', 'aigency-plugin' )
		                            ]                    
		                        ],
		                        'types' => [ 'gradient' ],
		                        'selector' => '{{WRAPPER}} .aigency-button .button-inner:after',
		                        'condition' => [
		                            'button_background_style' => 'gradient'
		                        ]
		                    ]
		                );

		                $element->add_group_control(
		                    \Elementor\Group_Control_Box_Shadow::get_type(),
		                    [
		                        'name' => 'button_box_shadow_hover',
		                        'selector' => '{{WRAPPER}} .aigency-button',
		                        'condition' => [
		                            'remove_box_shadow!' => 'yes'
		                        ]
		                    ]
		                );

		            $element->end_controls_tab();

		        $element->end_controls_tabs();

	        	$element->add_control(
		            'button_border_style',
		            [
		                'label' => esc_html__( 'Button Border Style', 'aigency-plugin' ),
		                'type' => \Elementor\Controls_Manager::SELECT,
		                'default' => 'gradient',
		                'options' => [
		                    'gradient' => esc_html__( 'Gradient', 'aigency-plugin' ),
		                    'solid' => esc_html__( 'Solid', 'aigency-plugin' ),
		                ],
		                'prefix_class' => 'aigency-button-border-style-',
		            ]
		        );

		        $element->add_control(
		            'button_background_style',
		            [
		                'label' => esc_html__( 'Button Background Style', 'aigency-plugin' ),
		                'type' => \Elementor\Controls_Manager::SELECT,
		                'default' => 'solid',
		                'options' => [
		                    'gradient' => esc_html__( 'Gradient', 'aigency-plugin' ),
		                    'solid' => esc_html__( 'Solid', 'aigency-plugin' ),
		                ],
		                'prefix_class' => 'aigency-button-bakground-style-',
		            ]
		        );
                $element->end_controls_section();
	        }
        }, 10, 3);
	    
	    add_action('elementor/element/before_section_end', function ($element, $section_id, $args) {

	    	if ( 'container' === $element->get_name() && 'section_background_overlay' === $section_id ) {
	    		$element->add_control(
                    'add_bg_overlay_animation',
                    [
                        'label'         => esc_html__( 'Add Background Overlay Hover Animation', 'aigency-plugin' ),
                        'type'          => \Elementor\Controls_Manager::SWITCHER,
                        'label_on'      => esc_html__( 'On', 'aigency-plugin' ),
                        'label_off'     => esc_html__( 'Off', 'aigency-plugin' ),
                        'return_value'  => 'on',
                        'default'       => '',
                        'prefix_class'  => 'container-overlay-hover-animation-'
                    ]
                );
	    	}

	        if ( 'section' === $element->get_name() || 'container' === $element->get_name() ) {

                if ( 'section_background' === $section_id ) {
                    $element->add_control(
                        'background_clip',
                        [
                            'label'         => esc_html__( 'Background Clip', 'aigency-plugin' ),
                            'type'          => \Elementor\Controls_Manager::SELECT,
                            'options'       => [
                                ''              => esc_html__( 'Default', 'aigency-plugin' ),
                                'border-box'    => 'Border Box',
                                'padding-box'   => 'Padding Box',
                                'content-box'   => 'Content Box',
                                'text'          => 'Text',
                                'inherit'       => 'Inherit',
                                'initial'       => 'Initial',
                            ],
                            'selectors'     => [
                                '{{WRAPPER}}' => 'background-clip: {{VALUE}}',
                            ],
                        ]
                    );
                    $element->add_control(
                        'use_parallax',
                        [
                            'label'         => esc_html__( 'Parallax Effect', 'aigency-plugin' ),
                            'type'          => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'      => esc_html__( 'On', 'aigency-plugin' ),
                            'label_off'     => esc_html__( 'Off', 'aigency-plugin' ),
                            'return_value'  => 'yes',
                            'default'       => 'no'
                        ]
                    );
                    $element->add_control(
                        'add_flowmap_animation',
                        [
                            'label'         => esc_html__( 'Add Flowmap Animation', 'aigency-plugin' ),
                            'type'          => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'      => esc_html__( 'On', 'aigency-plugin' ),
                            'label_off'     => esc_html__( 'Off', 'aigency-plugin' ),
                            'return_value'  => 'on',
                            'default'       => ''
                        ]
                    );
                    $element->add_control(
                        'flowmap_image',
                        [
                            'label'     => esc_html__('Flowmap Image', 'aigency-plugin'),
                            'type'      => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'add_flowmap_animation' => 'on'
                            ]
                        ]
                    );
                    $element->add_group_control(
                        \Elementor\Group_Control_Css_Filter::get_type(),
                        [
                            'name'          => 'flowmap_css_filters',
                            'selector'      => '{{WRAPPER}} .flowmap-deformation-wrapper',
                            'condition' => [
                                'add_flowmap_animation' => 'on'
                            ]
                        ]
                    );                    
                    $element->add_control(
		                'section_filter_blur',
		                [
		                    'label' => esc_html__( 'Backdrop Blur Filter, px', 'aigency-plugin' ),
		                    'type' => \Elementor\Controls_Manager::SLIDER,
		                    'range' => [
		                        'px' => [
		                            'min' => 0,
		                            'max' => 25,
		                            'step' => 0.1,
		                        ],
		                    ],
		                    'selectors' => [
		                        '{{WRAPPER}}' => 'backdrop-filter: blur( {{SIZE}}px ); -webkit-backdrop-filter: blur( {{SIZE}}px );',
		                    ],
		                ]            
		            );
		            $element->add_control(
		                'section_inner_scroll_animation',
		                [
		                    'label'         => esc_html__( 'Add Scroll Animation', 'aigency-plugin' ),
		                    'type'          => \Elementor\Controls_Manager::SWITCHER,
		                    'label_on'      => esc_html__( 'On', 'aigency-plugin' ),
		                    'label_off'     => esc_html__( 'Off', 'aigency-plugin' ),
		                    'return_value'  => 'on',
		                    'default'       => '',
		                    'prefix_class'  => 'elementor-section-scroll-animation-',
		                    'hide_in_top' => true,
		                ]
		            );
                }
                if ( 'section_effects' === $section_id ) {
                    $element->add_control(
                        'is_sticky',
                        [
                            'label'         => esc_html__('Sticky (Aigency theme)', 'aigency-plugin'),
                            'type'          => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'      => esc_html__('On', 'aigency-plugin'),
                            'label_off'     => esc_html__('Off', 'aigency-plugin'),
                            'return_value'  => 'on',
                            'default'       => '',
                            'separator'     => 'before',
                            'prefix_class'  => 'sticky-container-'
                        ]
                    );
                    $element->add_control(
                        'add_sticky_animation',
                        [
                            'label'         => esc_html__('Add Sticky Animation', 'aigency-plugin'),
                            'type'          => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'      => esc_html__('On', 'aigency-plugin'),
                            'label_off'     => esc_html__('Off', 'aigency-plugin'),
                            'return_value'  => 'on',
                            'default'       => '',
                            'separator'     => 'before',
                            'prefix_class'  => 'sticky-animation-',
                            'condition'     => [
                                'is_sticky' => 'on'
                            ]
                        ]
                    );
                }	            
	        }

	        if ('section' === $element->get_name() && 'section_layout' === $section_id) {
	            $element->add_control(
	                'section_container_padding',
	                [
	                    'label'         => esc_html__( 'Remove Container Padding', 'aigency-plugin' ),
	                    'description'    => esc_html__('Container paddings are added to no gap stretched section`s container'),
	                    'type'          => \Elementor\Controls_Manager::SWITCHER,
	                    'label_on'      => esc_html__( 'On', 'aigency-plugin' ),
	                    'label_off'     => esc_html__( 'Off', 'aigency-plugin' ),
	                    'return_value'  => 'container-padding-remove',
	                    'default'       => '',
	                    'prefix_class'  => 'elementor-section-',
	                    'hide_in_inner' => true,
	                    'condition'     => [
	                        'stretch_section' => 'section-stretched',
	                        'gap!'       => 'no'
	                    ] 
	                ]
	            );

	            $element->add_control(
	                'section_inner_container_padding',
	                [
	                    'label'         => esc_html__( 'Remove Container Padding', 'aigency-plugin' ),
	                    'description'    => esc_html__('Container paddings are added to inner section container in stretched parent section with no gap'),
	                    'type'          => \Elementor\Controls_Manager::SWITCHER,
	                    'label_on'      => esc_html__( 'On', 'aigency-plugin' ),
	                    'label_off'     => esc_html__( 'Off', 'aigency-plugin' ),
	                    'return_value'  => 'container-padding-remove',
	                    'default'       => '',
	                    'prefix_class'  => 'elementor-section-',
	                    'hide_in_top' => true,
	                    'condition'     => [
	                        'gap!'       => 'no'
	                    ] 
	                ]
	            );

	            $element->add_control(
	                'section_inner_fit_height',
	                [
	                    'label'         => esc_html__( 'Fit Column Height', 'aigency-plugin' ),
	                    'type'          => \Elementor\Controls_Manager::SWITCHER,
	                    'label_on'      => esc_html__( 'On', 'aigency-plugin' ),
	                    'label_off'     => esc_html__( 'Off', 'aigency-plugin' ),
	                    'return_value'  => 'fit-height',
	                    'default'       => '',
	                    'prefix_class'  => 'elementor-section-',
	                    'hide_in_top' => true,
	                ]
	            );	            
	        }
	        if ('text-editor' === $element->get_name() && 'section_style' === $section_id) {
                $element->add_responsive_control(
                    'blockquote_icon_size',
                    [
                        'label'     => esc_html__('Blockquote Icon Size', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::SLIDER,
                        'size_units' => [ 'px', 'em', '%'],
                        'selectors' => [
                            '{{WRAPPER}} blockquote:before' => 'font-size: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );
	            $element->add_control(
	                'blockquote_icon_color',
	                [
	                    'label'     => esc_html__( 'Blockquote Icon Color', 'elementor' ),
	                    'type'      => \Elementor\Controls_Manager::COLOR,
	                    'selectors' => [
	                        '{{WRAPPER}} blockquote:before' => 'color: {{VALUE}};',
	                    ],
	                ]
	            );
                $element->add_responsive_control(
                    'blockquote_icon_spacing',
                    [
                        'label'     => esc_html__('Blockquote Icon Spacing', 'aigency-plugin'),
                        'type'      => \Elementor\Controls_Manager::SLIDER,
                        'size_units' => [ 'px', 'em', '%'],
                        'selectors' => [
                            '{{WRAPPER}} blockquote' => is_rtl() ? 'padding-right: {{SIZE}}{{UNIT}};' : 'padding-left: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );
                $element->add_control(
                    'blockquote_cite_color',
                    [
                        'label'     => esc_html__( 'Blockquote Cite Color', 'elementor' ),
                        'type'      => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} blockquote cite' => 'color: {{VALUE}};',
                        ],
                    ]
                );
	        }

	        if ('icon' === $element->get_name() && 'section_icon' === $section_id) {            
	            $element->add_control(
	                'add_decoration',
	                [
	                    'label'         => esc_html__('Add Decoration', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::SWITCHER,
	                    'default'       => '',
	                    'return_value'  => 'on',
	                    'label_off'     => esc_html__('No', 'aigency-plugin'),
	                    'label_on'      => esc_html__('Yes', 'aigency-plugin'),
	                    'separator'     => 'before',
	                    'prefix_class'  => 'aigency-icon-decoration-'
	                ]
	            );
	        }

	        if ('icon' === $element->get_name() && 'section_style_icon' === $section_id) {
	            $element->remove_responsive_control('align');
	            $element->add_responsive_control(
	                'icon_inner_padding',
	                [
	                    'label'         => esc_html__('Icon Wrapper Padding', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::DIMENSIONS,
	                    'size_units'    => ['px', 'em', '%'],
	                    'selectors'     => [
	                        '{{WRAPPER}} .elementor-icon-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
	                    ],
	                    'condition' => [
	                        'add_decoration' => 'on'
	                    ]
	                ]
	            );

	            $element->add_responsive_control(
	                'border_radius_inner',
	                [
	                    'label' => esc_html__( 'Icon Wrapper Border Radius', 'aigency-plugin' ),
	                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
	                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-icon-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                    ],
	                    'condition' => [
	                        'add_decoration' => 'on'
	                    ]
	                ]
	            );
	        }

	        if ( 'image' === $element->get_name() && 'section_image' === $section_id ) {
	            $element->add_control(
	                'show_hover_text',
	                [
	                    'label'         => esc_html__('Show hover text', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::SWITCHER,
	                    'label_off'     => esc_html__('Hide', 'aigency-plugin'),
	                    'label_on'      => esc_html__('Show', 'aigency-plugin'),
	                    'default'       => 'no',
	                    'return_value'  => 'yes'
	                ]
	            );
	            $element->add_control(
	                'subtitle',
	                [
	                    'label'         => esc_html__('Subtitle', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::TEXT,
	                    'default'       => '',
	                    'condition'     => [
	                        'show_hover_text'   => 'yes'
	                    ]
	                ]
	            );
	            $element->add_control(
	                'title',
	                [
	                    'label'         => esc_html__('Title', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::TEXT,
	                    'default'       => '',
	                    'condition'     => [
	                        'show_hover_text'   => 'yes'
	                    ]
	                ]
	            );
	            $element->add_control(
	                'hover_text_color',
	                [
	                    'label'     => esc_html__( 'Hover Text Color', 'aigency-plugin' ),
	                    'type'      => \Elementor\Controls_Manager::COLOR,
	                    'selectors' => [
	                        '{{WRAPPER}} .hovered-text-title, {{WRAPPER}} .hovered-text-subtitle' => 'color: {{VALUE}};',
	                    ],
	                    'condition'     => [
	                        'show_hover_text'   => 'yes'
	                    ]
	                ]
	            );
	            $element->add_control(
	                'hover_text_bg_color',
	                [
	                    'label'     => esc_html__( 'Hover Text Background Color', 'aigency-plugin' ),
	                    'type'      => \Elementor\Controls_Manager::COLOR,
	                    'selectors' => [
	                        '{{WRAPPER}} .hovered-text-title, {{WRAPPER}} .hovered-text-subtitle' => 'background-color: {{VALUE}};',
	                        '{{WRAPPER}} .hovered-text-subtitle-wrapper:after' => 'box-shadow: 0 20px 0 0 {{VALUE}};'
	                    ],
	                    'condition'     => [
	                        'show_hover_text'   => 'yes'
	                    ]
	                ]
	            );
	            $element->add_control(
	                'add_scroll_animation',
	                [
	                    'label'         => esc_html__('Add Scroll Animation', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::SWITCHER,
	                    'label_off'     => esc_html__('No', 'aigency-plugin'),
	                    'label_on'      => esc_html__('Yes', 'aigency-plugin'),
	                    'default'       => '',
	                    'return_value'  => 'on',
	                    'prefix_class'  => 'elementor-image-scroll-animation-'
	                ]
	            );

	            $element->add_control(
		            'box_overflow',
		            [
		                'label' => esc_html__( 'Image Box Overflow', 'aigency-plugin' ),
		                'type' => \Elementor\Controls_Manager::SELECT,
		                'default' => '',
		                'options' => [
		                    '' => esc_html__( 'Default', 'aigency-plugin' ),
		                    'hidden' => esc_html__( 'Hidden', 'aigency-plugin' ),
		                ],
		                'selectors' => [
		                    '{{WRAPPER}} .elementor-widget-container' => 'overflow: {{VALUE}}',
		                ],
		            ]
		        );

		        $element->add_control(
	                'show_image_overlay',
	                [
	                    'label'         => esc_html__('Show Image Overlay', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::SWITCHER,
	                    'label_off'     => esc_html__('Hide', 'aigency-plugin'),
	                    'label_on'      => esc_html__('Show', 'aigency-plugin'),
	                    'default'       => 'no',
	                    'return_value'  => 'yes'
	                ]
	            );
		        $element->add_control(
	                'overlay_subtitle',
	                [
	                    'label'         => esc_html__('Overlay Subtitle', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::TEXT,
	                    'default'       => '',
	                    'condition'     => [
	                        'show_image_overlay'   => 'yes'
	                    ]
	                ]
	            );
		        $element->add_control(
	                'overlay_text',
	                [
	                    'label'         => esc_html__('Overlay Text', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::WYSIWYG,
	                    'default'       => '',
	                    'condition'     => [
	                        'show_image_overlay'   => 'yes'
	                    ]
	                ]
	            );

	            $repeater = new \Elementor\Repeater();

		        $repeater->add_control(
		            'overlay_button_text',
		            [
		                'label'         => esc_html__('Overlay Button Text', 'aigency-plugin'),
		                'type'          => \Elementor\Controls_Manager::TEXT,
		                'label_block'   => true,
		                'default'       => ''
		            ]
		        );
		        $repeater->add_control(
		            'overlay_button_link',
		            [
		                'label'         => esc_html__('Overlay Button Link', 'aigency-plugin'),
		                'type'          => \Elementor\Controls_Manager::URL,
		                'label_block'   => true,
		                'default'       => [
		                    'url'           => '',
		                    'is_external'   => 'true',
		                ],
		                'placeholder'   => esc_html__( 'http://your-link.com', 'aigency-plugin' )
		            ]
		        );
		        $element->add_control(
		            'overlay_buttons',
		            [
		                'label'         => esc_html__('Overlay Buttons', 'aigency-plugin'),
		                'type'          => \Elementor\Controls_Manager::REPEATER,
		                'fields'        => $repeater->get_controls(),
		                'title_field'   => '{{{name}}}',
		                'prevent_empty' => false,
		                'condition'     => [
	                        'show_image_overlay'   => 'yes'
	                    ]
		            ]
		        );  
	        }

	        if ('image-box' === $element->get_name() && 'section_style_box' === $section_id) {
	            $element->add_responsive_control(
	                'image_box_padding',
	                [
	                    'label'         => esc_html__('Image Padding', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::DIMENSIONS,
	                    'size_units'    => ['px', 'em', '%'],
	                    'selectors'     => [
	                        '{{WRAPPER}} .elementor-image-box-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
	                    ]
	                ]
	            );

	            $element->add_responsive_control(
	                'image_box_bd_radius',
	                [
	                    'label' => esc_html__( 'Image Box Border Radius', 'aigency-plugin' ),
	                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
	                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-image-box-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                    ]
	                ]
	            );

	            $element->add_control(
	                'image_box_bg_color',
	                [
	                    'label'     => esc_html__( 'Image Background Color', 'aigency-plugin' ),
	                    'type'      => \Elementor\Controls_Manager::COLOR,
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-image-box-img' => 'background-color: {{VALUE}};',
	                    ],
	                ]
	            );
	        }

	        if ('image-box' === $element->get_name() && 'section_style_content' === $section_id) {
	            $element->add_responsive_control(
	                'content_border_width',
	                [
	                    'label'     => esc_html__('Border Width', 'aigency-plugin'),
	                    'type'      => \Elementor\Controls_Manager::SLIDER,
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-content' => 'border-bottom-width: {{SIZE}}{{UNIT}}; border-bottom-style: solid;',
	                    ]
	                ]
	            );

	            $element->add_control(
	                'content_border_color',
	                [
	                    'label'     => esc_html__('Border Color', 'aigency-plugin'),
	                    'type'      => \Elementor\Controls_Manager::COLOR,
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-content' => 'border-color: {{VALUE}};'
	                    ]
	                ]
	            );

	            $element->add_responsive_control(
	                'content_border_spacing',
	                [
	                    'label'     => esc_html__('Border Spacing', 'aigency-plugin'),
	                    'type'      => \Elementor\Controls_Manager::SLIDER,
	                    'range'     => [
	                        'px'        => [
	                            'min'       => 0,
	                            'max'       => 100
	                        ]
	                    ],
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-content' => 'padding-bottom: {{SIZE}}{{UNIT}};',
	                    ]
	                ]
	            );            
	        }

	        if ('counter' === $element->get_name() && 'section_counter_style' === $section_id) {
	        	$element->add_responsive_control(
					'number_vertical_alignment',
					[
						'label' => esc_html__( 'Number Vertical Alignment', 'aigency-plugin' ),
						'type' => \Elementor\Controls_Manager::CHOOSE,
						'options' => [
							'start' => [
								'title' => esc_html__( 'Top', 'aigency-plugin' ),
								'icon' => 'eicon-v-align-top',
							],
							'center' => [
								'title' => esc_html__( 'Middle', 'aigency-plugin' ),
								'icon' => 'eicon-v-align-middle',
							],
							'end' => [
								'title' => esc_html__( 'Bottom', 'aigency-plugin' ),
								'icon' => 'eicon-v-align-bottom',
							],
						],
						'selectors' => [
							'{{WRAPPER}} .elementor-counter-number-wrapper' => 'align-items: {{VALUE}};',
						],
						'condition' => [
							'title!' => '',
							'title_position' => [ 'start', 'end' ],
						],
					]
				);
	        	$element->add_responsive_control(
					'horizontal_title_gap',
					[
						'label' => esc_html__( 'Title Gap', 'aigency-plugin' ),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', 'rem', 'custom' ],
						'selectors' => [
							'{{WRAPPER}} .elementor-counter' => 'gap: {{SIZE}}{{UNIT}};',
						],
						'condition' => [
							'title!' => '',
							'title_position' => [ 'start', 'end' ],
						],
					]
				);
	            $element->add_control(
	                'counter_filter_blur',
	                [
	                    'label' => esc_html__( 'Counter Backdrop Blur Filter, px', 'aigency-plugin' ),
	                    'type' => \Elementor\Controls_Manager::SLIDER,
	                    'range' => [
	                        'px' => [
	                            'min' => 0,
	                            'max' => 25,
	                            'step' => 0.1,
	                        ],
	                    ],
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-widget-container' => 'backdrop-filter: blur( {{SIZE}}px ); -webkit-backdrop-filter: blur( {{SIZE}}px );',
	                    ],
	                ]            
	            );
	        }

	        if ('counter' === $element->get_name() && 'section_number' === $section_id) {    		
	            $element->add_group_control(
	                \Elementor\Group_Control_Background::get_type(),
	                [
	                    'name' => 'pagination_border_color_gradient',
	                    'fields_options' => [
	                        'background' => [
	                            'label' => esc_html__( 'Text Stroke Gradient', 'aigency-plugin' )
	                        ]                    
	                    ],
	                    'types' => [ 'gradient' ],
	                    'selector' => '{{WRAPPER}} .elementor-counter-number-wrapper',
	                ]
	            );

	            $element->add_responsive_control(
	                'number_padding',
	                [
	                    'label'         => esc_html__('Number Padding', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::DIMENSIONS,
	                    'size_units'    => ['px', 'em', '%', 'custom'],
	                    'selectors'     => [
	                        '{{WRAPPER}} .elementor-counter-number-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
	                    ]
	                ]
	            );
	        }

	        if ( 'video' === $element->get_name() && 'section_image_overlay' === $section_id ) {
	            $element->add_control(
	                'show_color_overlay',
	                [
	                    'label'                 => esc_html__( 'Color Overlay', 'aigency-plugin' ),
	                    'type'                  => \Elementor\Controls_Manager::SWITCHER,
	                    'label_off'             => esc_html__( 'Hide', 'aigency-plugin' ),
	                    'label_on'              => esc_html__( 'Show', 'aigency-plugin' ),
	                    'frontend_available'    => true,
	                    'condition'             => [
	                        'show_image_overlay'    => 'yes'
	                    ],
	                    'separator'             => 'before'
	                ]
	            );

	            $element->start_controls_tabs(
	                'tabs_background_overlay',
	                [
	                    'condition' => [
	                        'show_image_overlay'    => 'yes',
	                        'show_color_overlay'    => 'yes'
	                    ],
	                ]
	            );

	                $element->start_controls_tab(
	                    'tab_background_overlay_normal',
	                    [
	                        'label' => esc_html__( 'Normal', 'aigency-plugin' ),
	                    ]
	                );

	                    $element->add_group_control(
	                        \Elementor\Group_Control_Background::get_type(),
	                        [
	                            'name'      => 'background_overlay',
	                            'selector'  => '{{WRAPPER}} .elementor-custom-embed-image-overlay:before',
	                        ]
	                    );

	                    $element->add_control(
	                        'background_overlay_opacity',
	                        [
	                            'label'     => esc_html__( 'Opacity', 'aigency-plugin' ),
	                            'type'      => \Elementor\Controls_Manager::SLIDER,
	                            'default'   => [
	                                'size'      => .5,
	                            ],
	                            'range'     => [
	                                'px'        => [
	                                    'max'       => 1,
	                                    'step'      => 0.01,
	                                ],
	                            ],
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-custom-embed-image-overlay:before' => 'opacity: {{SIZE}};',
	                            ],
	                            'condition' => [
	                                'background_overlay_background' => [ 'classic', 'gradient' ],
	                            ],
	                        ]
	                    );

	                    $element->add_group_control(
	                        \Elementor\Group_Control_Css_Filter::get_type(),
	                        [
	                            'name'          => 'bg_css_filters',
	                            'selector'      => '{{WRAPPER}} .elementor-custom-embed-image-overlay:before',
	                            'conditions'    => [
	                                'relation'      => 'or',
	                                'terms'         => [
	                                    [
	                                        'name'      => 'background_overlay_image[url]',
	                                        'operator'  => '!==',
	                                        'value'     => '',
	                                    ],
	                                    [
	                                        'name'      => 'background_overlay_color',
	                                        'operator'  => '!==',
	                                        'value'     => '',
	                                    ],
	                                ],
	                            ],
	                        ]
	                    );

	                    $element->add_control(
	                        'overlay_blend_mode',
	                        [
	                            'label'         => esc_html__( 'Blend Mode', 'aigency-plugin' ),
	                            'type'          => \Elementor\Controls_Manager::SELECT,
	                            'options'       => [
	                                ''              => esc_html__( 'Normal', 'aigency-plugin' ),
	                                'multiply'      => 'Multiply',
	                                'screen'        => 'Screen',
	                                'overlay'       => 'Overlay',
	                                'darken'        => 'Darken',
	                                'lighten'       => 'Lighten',
	                                'color-dodge'   => 'Color Dodge',
	                                'saturation'    => 'Saturation',
	                                'color'         => 'Color',
	                                'luminosity'    => 'Luminosity',
	                            ],
	                            'selectors'     => [
	                                '{{WRAPPER}} .elementor-custom-embed-image-overlay:before' => 'mix-blend-mode: {{VALUE}}',
	                            ],
	                            'conditions'    => [
	                                'relation'      => 'or',
	                                'terms'         => [
	                                    [
	                                        'name'      => 'background_overlay_image[url]',
	                                        'operator'  => '!==',
	                                        'value'     => '',
	                                    ],
	                                    [
	                                        'name'      => 'background_overlay_color',
	                                        'operator'  => '!==',
	                                        'value'     => '',
	                                    ],
	                                ],
	                            ],
	                        ]
	                    );

	                $element->end_controls_tab();

	                $element->start_controls_tab(
	                    'tab_background_overlay_hover',
	                    [
	                        'label' => esc_html__( 'Hover', 'aigency-plugin' ),
	                    ]
	                );

	                    $element->add_group_control(
	                        \Elementor\Group_Control_Background::get_type(),
	                        [
	                            'name'      => 'background_overlay_hover',
	                            'selector'  => '{{WRAPPER}}:hover .elementor-custom-embed-image-overlay:before',
	                        ]
	                    );

	                    $element->add_control(
	                        'background_overlay_hover_opacity',
	                        [
	                            'label'     => esc_html__( 'Opacity', 'aigency-plugin' ),
	                            'type'      => \Elementor\Controls_Manager::SLIDER,
	                            'default'   => [
	                                'size'      => .5,
	                            ],
	                            'range'     => [
	                                'px'        => [
	                                    'max'       => 1,
	                                    'step'      => 0.01,
	                                ],
	                            ],
	                            'selectors' => [
	                                '{{WRAPPER}}:hover .elementor-custom-image-color-overlay:before' => 'opacity: {{SIZE}};',
	                            ],
	                            'condition' => [
	                                'background_overlay_hover_background' => [ 'classic', 'gradient' ],
	                            ],
	                        ]
	                    );

	                    $element->add_group_control(
	                        \Elementor\Group_Control_Css_Filter::get_type(),
	                        [
	                            'name'      => 'bg_css_filters_hover',
	                            'selector'  => '{{WRAPPER}}:hover .elementor-custom-embed-image-overlay:before',
	                        ]
	                    );

	                    $element->add_control(
	                        'background_overlay_hover_transition',
	                        [
	                            'label'         => esc_html__( 'Transition Duration', 'aigency-plugin' ),
	                            'type'          => \Elementor\Controls_Manager::SLIDER,
	                            'default'       => [
	                                'size'  => 0.3,
	                            ],
	                            'range'         => [
	                                'px'    => [
	                                    'max'       => 3,
	                                    'step'      => 0.1,
	                                ],
	                            ],
	                            'render_type'   => 'ui',
	                            'separator'     => 'before',
	                        ]
	                    );

	                $element->end_controls_tab();

	            $element->end_controls_tabs();
	        }
	        if ( 'video' === $element->get_name() && 'section_video_style' === $section_id ) {
	            $element->add_responsive_control(
	                'video_width',
	                [
	                    'label'         => esc_html__('Video Max Width', 'aigency-plugin'),
	                    'type'          => \Elementor\Controls_Manager::SLIDER,
	                    'size_units'    => [ 'px', '%' ],
	                    'range'         => [
	                        'px'            => [
	                            'min'           => 100,
	                            'max'           => 1170,
	                        ],
	                        '%'             => [
	                            'min'           => 1,
	                            'max'           => 100,
	                        ]
	                    ],
	                    'selectors'     => [
	                        '{{WRAPPER}} .elementor-widget-container' => 'max-width: {{SIZE}}{{UNIT}};'
	                    ]
	                ]
	            );

	            $element->add_responsive_control(
	                'video_alignment',
	                [
	                    'label'     => esc_html__('Video Position', 'aigency-plugin'),
	                    'type'      => \Elementor\Controls_Manager::CHOOSE,
	                    'options'   => [
	                        'left'      => [
	                            'title'     => esc_html__('Left', 'aigency-plugin'),
	                            'icon'      => 'eicon-text-align-left',
	                        ],
	                        'center'      => [
	                            'title'     => esc_html__('Center', 'aigency-plugin'),
	                            'icon'      => 'eicon-text-align-center',
	                        ],
	                        'right'     => [
	                            'title'     => esc_html__('Right', 'aigency-plugin'),
	                            'icon'      => 'eicon-text-align-right',
	                        ]
	                    ],
	                    'default'   => 'left',
	                    'selectors_dictionary' => [
	                        'left' => 'margin-right: auto; margin-left: 0;',
	                        'center' => 'margin-right: auto; margin-left: auto;',
	                        'right' => 'margin-left: auto; margin-right: 0;',
	                    ],
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-widget-container' => '{{VALUE}}',
	                    ],
	                ]
	            );
	        }

	        if ('image-carousel' === $element->get_name() && 'section_style_image' === $section_id) {
	            $element->remove_control('image_spacing');
	            $element->remove_control('image_spacing_custom');
	            $element->add_group_control(
	                \Elementor\Group_Control_Box_Shadow::get_type(),
	                [
	                    'name'      => 'image_shadow',
	                    'selector'  => '{{WRAPPER}} .elementor-image-carousel-wrapper .elementor-image-carousel .swiper-slide-image',
	                ]
	            );

	            $element->add_control(
	                'carousel_image_spacing',
	                [
	                    'label'     => esc_html__( 'Spacing', 'aigency-plugin' ),
	                    'type'      => \Elementor\Controls_Manager::SELECT,
	                    'options'   => [
	                        ''          => esc_html__( 'Default', 'aigency-plugin' ),
	                        'custom'    => esc_html__( 'Custom', 'aigency-plugin' ),
	                    ],
	                    'default'   => '',
	                    'condition' => [
	                        'slides_to_show!' => '1',
	                    ],
	                ]
	            );
	            $element->add_control(
	                'carousel_image_spacing_custom',
	                [
	                    'label'                 => esc_html__( 'Image Spacing', 'aigency-plugin' ),
	                    'type'                  => \Elementor\Controls_Manager::SLIDER,
	                    'range'                 => [
	                        'px'                    => [
	                            'max'                   => 100,
	                        ],
	                    ],
	                    'default'               => [
	                        'size'                  => 20,
	                    ],
	                    'show_label'            => false,
	                    'condition'             => [
	                        'carousel_image_spacing'         => 'custom',
	                        'slides_to_show!'       => '1',
	                    ],
	                    'frontend_available'    => true,
	                    'render_type'           => 'none',
	                    'separator'             => 'after',
	                    'selectors'             => [
	                        '{{WRAPPER}} .elementor-image-carousel-wrapper' => 'margin: -{{SIZE}}px; padding: {{SIZE}}px !important;'
	                    ],
	                ]
	            );

	            $element->add_control(
	                'icon_color',
	                [
	                    'label'     => esc_html__('Icon Color', 'aigency-plugin'),
	                    'type'      => \Elementor\Controls_Manager::COLOR,
	                    'selectors' => [
	                        '{{WRAPPER}} .swiper-slide a:after' => 'color: {{VALUE}};'
	                    ],
	                    'separator' => 'before',
	                    'condition' => [
	                        'link_to'   => ['file', 'custom']
	                    ]
	                ]
	            );

	            $element->add_control(
	                'icon_bg_color',
	                [
	                    'label'     => esc_html__('Icon Background Color', 'aigency-plugin'),
	                    'type'      => \Elementor\Controls_Manager::COLOR,
	                    'selectors' => [
	                        '{{WRAPPER}} .swiper-slide a:after' => 'background-color: {{VALUE}};'
	                    ],
	                    'condition' => [
	                        'link_to'   => ['file', 'custom']
	                    ]
	                ]
	            );

	            $element->add_control(
	                'overlay_color',
	                [
	                    'label'     => esc_html__('Image Overlay Color', 'aigency-plugin'),
	                    'type'      => \Elementor\Controls_Manager::COLOR,
	                    'selectors' => [
	                        '{{WRAPPER}} .swiper-slide a:before' => 'background-color: {{VALUE}};'
	                    ],
	                    'condition' => [
	                        'link_to'       => ['file', 'custom'],
	                        'view_style'    => 'style_2'
	                    ]
	                ]
	            );


	            $element->start_controls_tabs('frame_settings_tabs');

	                // ------------------------ //
	                // ------ Normal Tab ------ //
	                // ------------------------ //
	                $element->start_controls_tab(
	                    'frame_normal',
	                    [
	                        'label'     => esc_html__('Normal', 'aigency-plugin'),
	                        'condition' => [
	                            'link_to'    => ['file', 'custom'],
	                            'view_style' => 'style_2'
	                        ]
	                    ]
	                );

	                    $element->add_control(
	                        'frame_color',
	                        [
	                            'label'     => esc_html__('Frame Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'selectors' => [
	                                '{{WRAPPER}} .swiper-slide a:before' => 'border-color: {{VALUE}};'
	                            ],
	                            'condition' => [
	                                'link_to'    => ['file', 'custom'],
	                                'view_style' => 'style_2'
	                            ]
	                        ]
	                    );

	                $element->end_controls_tab();

	                // ------------------------ //
	                // ------ Active Tab ------ //
	                // ------------------------ //
	                $element->start_controls_tab(
	                    'frame_hover',
	                    [
	                        'label'     => esc_html__('Hover', 'aigency-plugin'),
	                        'condition' => [
	                            'link_to'    => ['file', 'custom'],
	                            'view_style' => 'style_2'
	                        ]
	                    ]
	                );

	                    $element->add_control(
	                        'frame_color_hover',
	                        [
	                            'label'     => esc_html__('Frame Color on Hover', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'selectors' => [
	                                '{{WRAPPER}} .swiper-slide a:hover:before' => 'border-color: {{VALUE}};'
	                            ],
	                            'condition' => [
	                                'link_to'    => ['file', 'custom'],
	                                'view_style' => 'style_2'
	                            ]
	                        ]
	                    );

	                $element->end_controls_tab();

	            $element->end_controls_tabs();
	        }        

	        if ('accordion' === $element->get_name() && 'section_title_style' === $section_id) {
	            $element->add_responsive_control(
	                'space_between',
	                [
	                    'label'     => esc_html__( 'Space Between', 'aigency-plugin' ),
	                    'type'      => \Elementor\Controls_Manager::SLIDER,
	                    'range'     => [
	                        'px'        => [
	                            'min'       => 0,
	                            'max'       => 100,
	                        ],
	                    ],
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-accordion-item:not(:last-of-type)' => 'margin-bottom: {{SIZE}}{{UNIT}}',
	                    ],
	                ]
	            );
	            $element->add_group_control(
	                \Elementor\Group_Control_Box_Shadow::get_type(),
	                [
	                    'name'      => 'box_shadow',
	                    'selector'  => '{{WRAPPER}} .elementor-accordion-item',
	                ]
	            );
	        }

            if ('nested-accordion' === $element->get_name() && 'section_accordion_style' === $section_id) {
                $element->add_control(
                    'accordion_item_heading',
                    [
                        'label' => esc_html__( 'Accordion Item Border', 'aigency-plugin' ),
                        'type' => \Elementor\Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
                );
                $element->add_group_control(
                    \Elementor\Group_Control_Border::get_type(),
                    [
                        'name' => 'accordion_item_border',
                        'selector' => '{{WRAPPER}} .e-n-accordion .e-n-accordion-item',
                    ]
                );
            }            

            if ('nested-accordion' === $element->get_name() && 'section_header_style' === $section_id) {
                $element->add_group_control(
                    \Elementor\Group_Control_Typography::get_type(),
                    [
                        'name' => 'counter_typography',
                        'label' => esc_html__( 'Counter Typography', 'aigency-plugin' ),
                        'selector' => '{{WRAPPER}} .e-n-accordion .e-n-accordion-item-title-header:before',
                        'condition' => [
                            'accordion_style' => 'counter'
                        ]
                    ]
                );

                $element->add_responsive_control(
                    'counter_title_padding',
                    [
                        'label' => esc_html__( 'Counter Title Padding', 'aigency-plugin' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                        'selectors' => [
                            '{{WRAPPER}} .e-n-accordion .e-n-accordion-item-title-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'accordion_style' => 'counter'
                        ]
                    ]
                );
            }

            if ('nested-accordion' === $element->get_name() && 'section_content_style' === $section_id) {
                $element->add_responsive_control(
                    'counter_content_padding',
                    [
                        'label' => esc_html__( 'Counter Content Padding', 'aigency-plugin' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                        'selectors' => [
                            '{{WRAPPER}} .e-n-accordion .e-n-accordion-item-title + .elementor-element' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'condition' => [
                            'accordion_style' => 'counter'
                        ]
                    ]
                );
            }

	        if ('accordion' === $element->get_name() && 'section_toggle_style_title' === $section_id) {
	            $element->remove_control('title_background');
	            $element->remove_control('title_color');
	            $element->remove_control('tab_active_color');

	            $element->add_group_control(
	                \Elementor\Group_Control_Typography::get_type(),
	                [
	                    'name' => 'counter_typography',
	                    'label' => esc_html__( 'Counter Typography', 'aigency-plugin' ),
	                    'selector' => '{{WRAPPER}} .elementor-accordion .elementor-accordion-title:before',
	                    'condition' => [
	                        'accordion_style' => 'counter'
	                    ]
	                ]
	            );

	            $element->add_responsive_control(
	                'counter_title_padding',
	                [
	                    'label' => esc_html__( 'Counter Title Padding', 'aigency-plugin' ),
	                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
	                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
	                    'selectors' => [
	                        '{{WRAPPER}} .elementor-accordion .elementor-accordion-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                    ],
	                    'condition' => [
	                        'accordion_style' => 'counter'
	                    ]
	                ]
	            );

	            $element->start_controls_tabs('title_colors_tabs');

	                // ------------------------ //
	                // ------ Normal Tab ------ //
	                // ------------------------ //
	                $element->start_controls_tab(
	                    'title_colors_normal',
	                    [
	                        'label' => esc_html__('Normal', 'aigency-plugin')
	                    ]
	                );

	                    $element->add_control(
	                        'accordion_title_color',
	                        [
	                            'label'     => esc_html__('Title Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'default'   => '',
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-tab-title:not(.elementor-active) .elementor-accordion-title' => 'color: {{VALUE}};'
	                            ]
	                        ]
	                    );

	                    $element->add_control(
	                        'title_bg_color',
	                        [
	                            'label'     => esc_html__('Title Background Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'default'   => '',
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-tab-title:not(.elementor-active)' => 'background-color: {{VALUE}};'
	                            ]
	                        ]
	                    );

	                $element->end_controls_tab();

	                // ------------------------ //
	                // ------ Active Tab ------ //
	                // ------------------------ //
	                $element->start_controls_tab(
	                    'title_colors_active',
	                    [
	                        'label' => esc_html__('Active', 'aigency-plugin')
	                    ]
	                );

	                    $element->add_control(
	                        'active_title_color',
	                        [
	                            'label'     => esc_html__('Title Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'default'   => '',
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-tab-title.elementor-active .elementor-accordion-title' => 'color: {{VALUE}};'
	                            ]
	                        ]
	                    );

	                    $element->add_control(
	                        'active_title_bg_color',
	                        [
	                            'label'     => esc_html__('Title Background Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'default'   => '',
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-tab-title.elementor-active' => 'background-color: {{VALUE}};'
	                            ]
	                        ]
	                    );

	                $element->end_controls_tab();

	            $element->end_controls_tabs();
	        }

	        if ('toggle' === $element->get_name() && 'section_toggle_style_title' === $section_id) {
	            $element->remove_control('title_background');
	            $element->remove_control('title_color');
	            $element->remove_control('tab_active_color');

	            $element->start_controls_tabs('title_colors_tabs');

	                // ------------------------ //
	                // ------ Normal Tab ------ //
	                // ------------------------ //
	                $element->start_controls_tab(
	                    'title_colors_normal',
	                    [
	                        'label' => esc_html__('Normal', 'aigency-plugin')
	                    ]
	                );

	                    $element->add_control(
	                        'toggle_title_color',
	                        [
	                            'label'     => esc_html__('Title Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'default'   => '',
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-tab-title:not(.elementor-active) .elementor-toggle-title' => 'color: {{VALUE}};'
	                            ]
	                        ]
	                    );

	                    $element->add_control(
	                        'title_bg_color',
	                        [
	                            'label'     => esc_html__('Title Background Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'default'   => '',
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-tab-title:not(.elementor-active)' => 'background-color: {{VALUE}};'
	                            ]
	                        ]
	                    );

	                $element->end_controls_tab();

	                // ------------------------ //
	                // ------ Active Tab ------ //
	                // ------------------------ //
	                $element->start_controls_tab(
	                    'title_colors_active',
	                    [
	                        'label' => esc_html__('Active', 'aigency-plugin')
	                    ]
	                );

	                    $element->add_control(
	                        'active_title_color',
	                        [
	                            'label'     => esc_html__('Title Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'default'   => '',
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-tab-title.elementor-active .elementor-toggle-title' => 'color: {{VALUE}};'
	                            ]
	                        ]
	                    );

	                    $element->add_control(
	                        'active_title_bg_color',
	                        [
	                            'label'     => esc_html__('Title Background Color', 'aigency-plugin'),
	                            'type'      => \Elementor\Controls_Manager::COLOR,
	                            'default'   => '',
	                            'selectors' => [
	                                '{{WRAPPER}} .elementor-tab-title.elementor-active' => 'background-color: {{VALUE}};'
	                            ]
	                        ]
	                    );

	                $element->end_controls_tab();

	            $element->end_controls_tabs();
	        }

	    }, 10, 3);

	    add_action('elementor/frontend/section/before_render', function( \Elementor\Element_Base $element ) {
	        $settings = $element->get_settings();
	        if ( $settings['use_parallax'] == 'yes' ) {
	            $element->add_render_attribute('_wrapper', [
	                'data-parallax'    => 'scroll'
	            ] );
	        }
	        if ( $settings['add_flowmap_animation'] == 'on' && !empty($settings['flowmap_image']['url']) ) {
	        	wp_enqueue_script('flowmap-effect');
	            $metadata = wp_get_attachment_metadata($settings['flowmap_image']['id']);
	            $element->add_render_attribute('_wrapper', [
	            	'data-flowmap'        => 'on',
	            	'data-flowmap-url'    => esc_url($settings['flowmap_image']['url']),
	                'data-flowmap-width'  => esc_attr($metadata['width']),
	                'data-flowmap-height' => esc_attr($metadata['height'])
	            ] );
	        }
	        if ( $settings['section_inner_scroll_animation'] == 'on' ) {
	            wp_enqueue_script('aat');
	        }
	    } );

        add_action('elementor/frontend/container/before_render', function( \Elementor\Element_Base $element ) {
            $settings = $element->get_settings();
            if ( $settings['use_parallax'] == 'yes' ) {
                $element->add_render_attribute('_wrapper', [
                    'data-parallax'    => 'scroll'
                ] );
            }
            if ( $settings['add_flowmap_animation'] == 'on' && !empty($settings['flowmap_image']['url']) ) {
                wp_enqueue_script('flowmap-effect');
                $metadata = wp_get_attachment_metadata($settings['flowmap_image']['id']);
                $element->add_render_attribute('_wrapper', [
                    'data-flowmap'        => 'on',
                    'data-flowmap-url'    => esc_url($settings['flowmap_image']['url']),
                    'data-flowmap-width'  => esc_attr($metadata['width']),
                    'data-flowmap-height' => esc_attr($metadata['height'])
                ] );
            }
            if ( $settings['section_inner_scroll_animation'] == 'on' ) {
	            wp_enqueue_script('aat');
	        }
        } );

	    add_filter('elementor/widget/render_content', function( $content, $widget ) {
	        if ( 'image' === $widget->get_name() ) {
	            wp_enqueue_script('elementor_widgets');
	            $settings = $widget->get_settings();
	            if ( $settings['add_scroll_animation'] == 'on' ) {
	                wp_enqueue_script('aat');
	                wp_enqueue_script('elementor_widgets');                
	            }
	            $out = '';
	            if ( $settings['show_hover_text'] == 'yes' ) {
	                $out .= '<div class="hovered-text">';
	                    $out .= '<div class="hovered-text-card">';
	                        $out .= !empty($settings['subtitle']) ? '<div class="hovered-text-subtitle-wrapper"><div class="hovered-text-subtitle">' . esc_html($settings['subtitle']) . '</div></div>' : '';
	                        $out .= !empty($settings['title']) ? '<div class="hovered-text-title">' . esc_html($settings['title']) . '</div>' : '';
	                    $out .= '</div>';
	                $out .= '</div>';
	            }
	            if ( $settings['show_image_overlay'] == 'yes' ) {
	                $out .= '<div class="image-overlay">';
	                    $out .= '<div class="image-overlay-card">';
	                        $out .= !empty($settings['overlay_subtitle']) ? '<div class="image-overlay-subtitle-wrapper"><div class="image-overlay-subtitle">' . esc_html($settings['overlay_subtitle']) . '</div></div>' : '';
	                        $out .= '<div class="image-overlay-content">';	                        	
	                        	$out .= '<div class="image-overlay-text">' . wp_kses_post($settings['overlay_text']) . '</div>';
	                        	$overlay_buttons = $settings['overlay_buttons'];
	                        	$out .= '<div class="button-container">';
	                        	foreach ($overlay_buttons as $button) {
	                        		if ($button['overlay_button_link']['url'] === '') {
							        	$button['overlay_button_link']['url'] = '#';
							        }
							        $widget->add_link_attributes( 'link-' . $button['_id'], $button['overlay_button_link'] );
							        $out .= '<a class="aigency-button" ' . $widget->get_render_attribute_string('link-' . $button['_id']) . '>';
							        	$out .= esc_html($button['overlay_button_text']);
							        	$out .= '<span class="button-inner"></span>';
							        $out .= '</a>';
	                        	}
	                        	$out .= '</div>';
	                        $out .= '</div>';
	                    $out .= '</div>';
	                $out .= '</div>';
	            }
	            $content .= wp_kses_post($out);
	        }
	        return $content;
	    }, 10, 2);
	}
});