<?php
    defined( 'ABSPATH' ) or die();

/**
 * Partial template file for displaying & configuring the Page Title area in the default header.
 *
 * Displays a block with a background and decorative elements. Can display the page
 * or post name, breadcrumbs, and vertical additional text.
 *
 * @package WordPress
 * @subpackage Aigency
 * @author Artureanec
 * @since Aigency 1.0
 * @version 1.0
 */
?>

<!-- Page Title -->
<div class="page-title-container">
    <div class="page-title-bg"></div>
    <div class="page-title-row">
        <div class="page-title-wrapper">
            <div class="page-title-box">
                <h1 class="page-title"><?php echo wp_kses(aigency_get_page_title(), 'post'); ?></h1>
            </div>            
        </div>
    </div>
    <?php
        if ( !empty(aigency_get_prefered_option('page_title_additional_text')) ) {
            echo '<div class="page-title-additional">' . esc_html(aigency_get_prefered_option('page_title_additional_text')) . '</div>';
        }
        if ( aigency_get_prefered_option('page_title_breadcrumbs_status') == 'on' ) {
            echo '<div class="breadcrumbs-wrapper">';
                aigency_breadcrumbs();
                $breadcrumbs_text = aigency_get_prepared_option('page_title_breadcrumbs_text', '', 'page_title_breadcrumbs_status');
                if ( !empty($breadcrumbs_text) ) {
                    echo '<h6 class="page-title-breadcrumbs-text">' . esc_html($breadcrumbs_text) . '</h6>';
                }
            echo '</div>';
        }
    ?>
</div>