<?php
    defined( 'ABSPATH' ) or die();
?>

<div class="header-row">

    <!-- Left Info Block -->
    <?php
        if (
            aigency_get_prefered_option('header_logo_status') == 'on' ||
            (
                aigency_get_prefered_option('side_panel_status') == 'on' && 
                (is_active_sidebar('sidebar-side') || aigency_get_prefered_option('sidebar_logo_status') == 'on' || aigency_get_prefered_option('side_panel_socials_status') == 'on')
            )
        ) {
            echo '<div class="header-icons-container header-logo-container">';
                if ( aigency_get_prefered_option('side_panel_status') == 'on' && is_active_sidebar('sidebar-side') ) {
                    // Header Side Panel
                    echo '<div class="header-icon dropdown-trigger" data-id="default">';
                        echo '<div class="dropdown-trigger-item"></div>';
                    echo '</div>';
                }
                if ( aigency_get_prefered_option('header_logo_status') == 'on' ) {
                    // Header Logo
                    echo '<div class="logo-container">' . aigency_get_logo_output() . '</div>';
                }
            echo '</div>';
        }
    ?>
    
    <?php
        if ( aigency_get_prefered_option('header_menu_status') == 'on' ||
            aigency_get_prefered_option('header_search_status') == 'on' ||
            (
                aigency_get_prefered_option('header_button_status') == 'on' &&
                !empty(aigency_get_prefered_option('header_button_text'))
            ) ||
            (
                class_exists('WooCommerce') && aigency_get_prefered_option('header_minicart_status') == 'on'
            ) ||
            aigency_get_prefered_option('header_login_status') == 'on'
             ) {
            echo '<div class="header-main-container">';
        }
            // Menu Block
            if ( aigency_get_prefered_option('header_menu_status') == 'on' ) {
                if ( !empty(aigency_get_prefered_option('header_menu_select')) && aigency_get_prefered_option('header_menu_select') != 'default' ) {
                    wp_nav_menu(
                        array(
                            'menu'              => aigency_get_prefered_option('header_menu_select'),
                            'menu_class'        => 'main-menu',
                            'depth'             => 0,
                            'container'         => 'div',
                            'container_class'   => 'header-menu-container',
                            'fallback_cb'       => '',
                            'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                        )
                    );
                } else {
                    $menu_locations = get_nav_menu_locations();
                    if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
                        wp_nav_menu(
                            array(
                                'theme_location'    => 'main',
                                'menu_class'        => 'main-menu',
                                'depth'             => 0,
                                'container'         => 'div',
                                'container_class'   => 'header-menu-container',
                                'fallback_cb'       => '',
                                'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                            )
                        );
                    }
                }
            }
    ?>

    <!-- Right Info Block -->
    <?php
        if (
            aigency_get_prefered_option('header_search_status') == 'on' ||
            (
                aigency_get_prefered_option('header_button_status') == 'on' &&
                !empty(aigency_get_prefered_option('header_button_text'))
            ) ||
            (
                class_exists('WooCommerce') && aigency_get_prefered_option('header_minicart_status') == 'on'
            ) ||
            aigency_get_prefered_option('header_login_status') == 'on'
        ) {
            echo '<div class="header-icons-container">';

                // Header Search
                if ( aigency_get_prefered_option('header_search_status') == 'on' ) {
                    echo '<div class="header-icon search-trigger" data-id="default">';
                        echo '<span class="search-trigger-icon"></span>';
                    echo '</div>';
                }

                // Header Product Cart
                if ( class_exists('WooCommerce') && aigency_get_prefered_option('header_minicart_status') == 'on' ) {
                    echo '<div class="header-icon mini-cart">';
                        echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="mini-cart-trigger">';
                            echo '<i class="mini-cart-count">';
                                echo WC()->cart->cart_contents_count > 0 ? '<span>' . WC()->cart->cart_contents_count . '</span>' : '';
                            echo '</i>';
                        echo '</a>';
                        echo '<div class="mini-cart-panel woocommerce">';
                            echo '<h5 class="mini-cart-title">' . esc_html__('Cart Items', 'aigency') . '</h5>';
                            woocommerce_mini_cart();
                        echo '</div>';
                    echo '</div>';
                }

                // Login/Logout
                if ( aigency_get_prefered_option('header_login_status') == 'on' ) {
                    if ( class_exists('WooCommerce') ) {
                        echo '<div class="header-icon login-logout">';
                        if (is_user_logged_in()) {
                            echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'aigency') . '" class="link-logout"></a>';
                        } else {
                            echo '<a href="' . get_permalink(get_option('woocommerce_myaccount_page_id')) . '" title="' . esc_attr__('Login/Register', 'aigency') . '" class="link-login"></a>';
                        };
                        echo '</div>';
                    } else {
                        echo '<div class="header-icon login-logout">';
                        if (is_user_logged_in()) {
                            echo '<a href="' . wp_logout_url(home_url()) . '" title="' . esc_attr__('Logout', 'aigency') . '" class="link-logout"></a>';
                        } else {
                            echo '<a href="' . wp_login_url(get_permalink()) . '" title="' . esc_attr__('Login/Register', 'aigency') . '" class="link-login"></a>';
                        };
                        echo '</div>';
                    }
                }

                // Header Button
                if ( aigency_get_prefered_option('header_button_status') == 'on' && !empty(aigency_get_prefered_option('header_button_text')) ) {
                    $header_button_target = false;
                    $page_for_posts = get_option( 'page_for_posts' );
                    if( is_singular() || 
                        (class_exists('WooCommerce') && is_woocommerce()) ||
                        (is_home() && $page_for_posts)) {
                            if( !empty(aigency_get_post_option('header_button_target')) ) {
                                $header_button_target = true;
                            }
                    } else {
                        if ( !empty(aigency_get_prefered_option('header_button_target')) ) {
                            $header_button_target = true;
                        }
                    }
                    echo '<div class="header-icon header-button-container">';
                        echo '<a class="aigency-button" href="' . ( !empty(aigency_get_prefered_option('header_button_url')) ? esc_url(aigency_get_prefered_option('header_button_url')) : esc_js('javascript:void(0);')) . '"' . ( $header_button_target ? ' target="_blank"' : '' ) . '>';
                            echo esc_html(aigency_get_prefered_option('header_button_text'));
                            echo '<span class="button-inner"></span>';
                        echo '</a>';
                    echo '</div>';
                }

            echo '</div>';
        }
        if ( aigency_get_prefered_option('header_menu_status') == 'on' ||
            aigency_get_prefered_option('header_search_status') == 'on' ||
            (
                aigency_get_prefered_option('header_button_status') == 'on' &&
                !empty(aigency_get_prefered_option('header_button_text'))
            ) ||
            (
                class_exists('WooCommerce') && aigency_get_prefered_option('header_minicart_status') == 'on'
            ) ||
            aigency_get_prefered_option('header_login_status') == 'on'
             ) {
            echo '</div>';
        }
    ?>

</div>