<?php
    defined( 'ABSPATH' ) or die();

    $header_button_border_style = aigency_get_prepared_option('header_button_border_style', 'standard_button_border_style', 'header_customize');
    $header_button_background_style = aigency_get_prepared_option('header_button_background_style', 'standard_button_background_style', 'header_customize');
    $mobile_header_container_classes = !empty($header_button_border_style) ? ' button-border-style-' . $header_button_border_style : '';
    $mobile_header_container_classes .= !empty($header_button_background_style) ? ' button-background-style-' . $header_button_background_style : '';
?>
    <div class="mobile-header-menu-container<?php echo esc_attr($mobile_header_container_classes); ?>" id="mobile-header-default">
        <div class="mobile-header-row">

            <!-- Icons Block -->
            <div class="header-icons-container">
                <?php

                // Mini Cart Link
                if ( class_exists('WooCommerce') && aigency_get_prefered_option('header_minicart_status') == 'on' ) {
                    echo '<div class="header-icon mini-cart">';
                        echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="mini-cart-trigger">';
                            echo '<i class="mini-cart-count">';
                                echo WC()->cart->cart_contents_count > 0 ? '<span>' . WC()->cart->cart_contents_count . '</span>' : '';
                            echo '</i>';
                        echo '</a>';
                    echo '</div>';
                }

                // Search Icon Trigger
                if ( aigency_get_prefered_option('header_search_status') == 'on' ) {
                    echo '<div class="header-icon search-trigger" data-id="default">';
                        echo '<span class="search-trigger-icon"></span>';
                    echo '</div>';
                }
                    
                // Close Button
                echo '<div class="header-icon menu-close">';
                    echo '<span class="menu-close-icon"></span>';
                echo '</div>';

                ?>
            </div>

        </div>
        <!-- Menu Block -->
        <?php
            if ( aigency_get_prefered_option('header_menu_status') == 'on' ) {
                $header_menu_trigger_style = aigency_get_prefered_option('mobile_header_menu_style');
                $menu_class = 'main-menu';
                if ( !empty($header_menu_trigger_style) ) {
                    $menu_class .= ' ' . esc_attr($header_menu_trigger_style) . '-trigger-menu';
                }
                if ( !empty(aigency_get_prefered_option('header_menu_select')) && aigency_get_prefered_option('header_menu_select') != 'default' ) {
                    wp_nav_menu(
                        array(
                            'menu'          => aigency_get_prefered_option('header_menu_select'),
                            'menu_class'    => $menu_class,
                            'depth'         => 0,
                            'container'     => '',
                            'fallback_cb'   => '',
                            'items_wrap'    => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                        )
                    );
                } else {
                    $menu_locations = get_nav_menu_locations();
                    if ( isset($menu_locations['main']) && $menu_locations['main'] !== 0 ) {
                        wp_nav_menu(
                            array(
                                'theme_location'    => 'main',
                                'menu_class'        => $menu_class,
                                'depth'             => 0,
                                'container'         => '',
                                'fallback_cb'       => '',
                                'items_wrap'        => '<nav><ul id="%1$s" class="%2$s">%3$s</ul></nav>'
                            )
                        );
                    }
                }
            }
        ?>

        <?php
        if (
            aigency_get_prefered_option('top_bar_status') == 'on' &&
            (
                aigency_get_prefered_option('top_bar_contacts_email_status') == 'on' ||
                aigency_get_prefered_option('top_bar_contacts_phone_status') == 'on' ||
                aigency_get_prefered_option('top_bar_contacts_address_status') == 'on'
            )
        ) {
            echo '<div class="header-mobile-contacts">';
                if ( !empty(aigency_get_prefered_option('top_bar_contacts_title')) ) {
                    echo '<div class="contact-items-title">';
                        echo esc_html(aigency_get_prefered_option('top_bar_contacts_title'));
                    echo '</div>';
                }                
                $phone = aigency_get_prepared_option('top_bar_contacts_phone', '', 'top_bar_contacts_phone_status');
                $email = aigency_get_prepared_option('top_bar_contacts_email', '', 'top_bar_contacts_email_status');
                $address = aigency_get_prepared_option('top_bar_contacts_address', '', 'top_bar_contacts_address_status');
                
                if ( !empty($address) && aigency_get_prefered_option('top_bar_contacts_address_status') == 'on' ) {
                    echo '<div class="contact-item contact-item-address">';
                        echo esc_html($address);
                    echo '</div>';
                }
                if ( !empty($phone) && aigency_get_prefered_option('top_bar_contacts_phone_status') == 'on' ) {
                    echo '<div class="contact-item contact-item-phone">';
                        echo '<a href="tel:' . aigency_clear_phone($phone) . '">';
                            echo esc_html($phone);
                        echo '</a>';
                    echo '</div>';
                }
                if ( !empty($email) && aigency_get_prefered_option('top_bar_contacts_email_status') == 'on' ) {
                    echo '<div class="contact-item contact-item-email">';
                        echo '<a href="mailto:' . esc_attr($email) . '">';
                            echo esc_html($email);
                        echo '</a>';
                    echo '</div>';
                }                
            echo '</div>';
        }
        ?>

        <?php
        if (
            aigency_get_prefered_option('top_bar_status') == 'on' &&
            aigency_get_prefered_option('top_bar_socials_status') == 'on'
        ) {
            echo '<div class="header-mobile-socials">';
                echo aigency_socials_output('mobile-menu-socials wrapper-socials');
            echo '</div>';
        }
        ?>

        <?php
        if (
            aigency_get_prefered_option('header_button_status') == 'on' &&
            !empty(aigency_get_prefered_option('header_button_text'))
        ) {
            $header_button_target = false;
            $page_for_posts = get_option( 'page_for_posts' );
            if( is_singular() || 
                (class_exists('WooCommerce') && is_woocommerce()) ||
                (is_home() && $page_for_posts)) {
                    if( !empty(aigency_get_post_option('header_button_target')) ) {
                        $header_button_target = true;
                    }
            } else {
                if ( !empty(aigency_get_prefered_option('header_button_target')) ) {
                    $header_button_target = true;
                }
            }
            echo '<div class="header-mobile-button">';
                echo '<a class="aigency-button" href="' . ( !empty(aigency_get_prefered_option('header_button_url')) ? esc_url(aigency_get_prefered_option('header_button_url')) : esc_js('javascript:void(0);')) . '"' . ( $header_button_target ? ' target="_blank"' : '' ) . '>';
                    echo esc_html(aigency_get_prefered_option('header_button_text'));
                    echo '<span class="button-inner"></span>';
                echo '</a>';
            echo '</div>';
        }
        ?>

    </div>