<?php
/**
 * The main taxonomy template file
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Aigency
 * @since Aigency 1.0
 */

get_header();

$sidebar_args = aigency_get_sidebar_args();
$sidebar_position = $sidebar_args['sidebar_position'];

$content_classes = 'content-wrapper';
$content_classes .= ( aigency_get_theme_mod('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );
$content_classes .= ( aigency_get_theme_mod('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
$content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);

$wrapper_classes = 'archive-listing-wrapper';

$pagination_args = array(
	'end_size'  => 2,
    'before_page_number' => '<span class="button-inner"></span>',
    'prev_text' => esc_html__('Previous', 'aigency') . '<span class="button-inner"></span><span class="icon-button-icon"></span>',
    'next_text' => esc_html__('Next', 'aigency') . '<span class="button-inner"></span><span class="icon-button-icon"></span>'
);

if ( is_tax('aigency_project_category') ) {
	$post_type = 'aigency_project';
	$columns_number = aigency_get_theme_mod('project_archive_columns_number');
	$wrapper_classes .= ' project-listing-wrapper project-grid-listing' . (!empty($columns_number) ? ' columns-' . esc_attr($columns_number) : '');
} elseif ( is_tax('aigency_team_department') ) {
	$post_type = 'aigency_team_member';
	$columns_number = aigency_get_theme_mod('team_archive_columns_number');
	$wrapper_classes .= ' team-listing-wrapper team-grid-listing' . (!empty($columns_number) ? ' columns-' . esc_attr($columns_number) : '');
} elseif ( is_tax('aigency_careers_department') ) {
	$post_type = 'aigency_vacancy';
	$wrapper_classes .= ' project-listing-wrapper vacancy-listing-wrapper';
} elseif ( is_tax(['aigency_services_category', 'aigency_services_tag']) ) {
	$post_type = 'aigency_service';
	$columns_number = aigency_get_theme_mod('service_archive_columns_number');
	$wrapper_classes .= ' service-listing-wrapper service-grid-listing' . (!empty($columns_number) ? ' columns-' . esc_attr($columns_number) : '');
} elseif ( is_tax(['aigency_case_study_category', 'aigency_case_study_tag']) ) {
	$post_type = 'aigency_case_study';
	$columns_number = aigency_get_theme_mod('case_studies_archive_columns_number');
	$wrapper_classes .= ' service-listing-wrapper case-study-listing-wrapper case-study-grid-listing' . (!empty($columns_number) ? ' columns-' . esc_attr($columns_number) : '');
}	

?>

    <div class="<?php echo esc_attr($content_classes); ?>">
        <div class="content">
            <!-- Content Container -->
            <div class="content-inner">

                <div class="archive-listing">
                    <div class="<?php echo esc_attr($wrapper_classes); ?>">
                        <?php
                            while( have_posts() ){
                                the_post();
                                get_template_part('content', $post_type);
                            };
                        ?>
                    </div>

                    <?php
                        if (aigency_has_archive_page_pagination()) { ?>
                            <div class="content-pagination">
                                <?php
                                    echo get_the_posts_pagination($pagination_args);
                                ?>
                            </div>
                        <?php }
                    ?>
                </div>

            </div>
        </div>

        <!-- Sidebar Container -->
        <?php get_sidebar(); ?>

    </div>

<?php
get_footer();