<?php
/**
 * The template for displaying single gallery post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Aigency
 * @since Aigency 1.0
 */

the_post();
get_header();

$post_id = get_the_ID();
$post_format = get_post_format();

$post_classes = 'single-post' . ( $post_format == 'quote' && aigency_post_options() && !empty(aigency_get_post_option('post_media_quote_text')) ? '  aigency-format-quote' : '' );

if ( did_action('elementor/loaded') && \Elementor\Plugin::instance()->documents->get($post_id)->is_built_with_elementor() ) {
    echo '<div id="post-' . get_the_ID() . '" class="' . implode(' ', get_post_class($post_classes)) . '">';
        the_content();
    echo '</div>';
} else {
    $sidebar_args = aigency_get_sidebar_args();
    $sidebar_position = $sidebar_args['sidebar_position'];

    $content_classes = 'content-wrapper';
    $content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);
    $content_classes .= ( aigency_get_prefered_option('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );
    $content_classes .= ( aigency_get_prefered_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );

    ?>
        <div class="<?php echo esc_attr($content_classes); ?>">

            <!-- Content Container -->
            <div class="content">

                <div id="post-<?php the_ID(); ?>" <?php post_class($post_classes); ?>>

                    <?php
                        if (
                            aigency_get_prefered_option('post_media_image_status') == 'on' &&
                            !empty(aigency_post_media_output())
                        ) {
                            echo '<div class="post-media-wrapper">';
                                echo aigency_post_media_output();
                                if (
                                    ( aigency_get_prefered_option('post_category_status') == 'on' &&
                                    !empty(aigency_post_categories_output()) ) ||
                                    ( aigency_get_prefered_option('post_date_status') == 'on' &&
                                    !empty(aigency_post_date_output()) ) ||
                                    ( aigency_get_prefered_option('post_author_status') == 'on' &&
                                    !empty(aigency_post_author_output()) )
                                ) {
                                    echo '<div class="post-meta-header">';                            
                                        if (
                                            ( aigency_get_prefered_option('post_date_status') == 'on' &&
                                            !empty(aigency_post_date_output()) ) ||
                                            ( aigency_get_prefered_option('post_author_status') == 'on' &&
                                            !empty(aigency_post_author_output()) )
                                        ) {
                                            echo '<div class="post-meta-items-wrapper">';
                                                echo '<div class="post-meta-items">';
                                                    if ( aigency_get_prefered_option('post_date_status') == 'on' && !empty(aigency_post_date_output()) ) {
                                                        echo aigency_post_date_output(true);
                                                    }
                                                    if ( aigency_get_prefered_option('post_author_status') == 'on' && !empty(aigency_post_author_output()) ) {
                                                        echo aigency_post_author_output(true);
                                                    }
                                                echo '</div>';
                                            echo '</div>';
                                        }
                                        if(aigency_get_prefered_option('post_category_status') == 'on' &&
                                            !empty(aigency_post_categories_output())) {
                                            echo aigency_post_categories_output(true);
                                        }
                                    echo '</div>';
                                }
                            echo '</div>';
                        }

                        if (
                            ( aigency_get_prefered_option('post_media_image_status') != 'on' ||
                            empty(aigency_post_media_output()) ) &&
                            ( ( aigency_get_prefered_option('post_category_status') == 'on' &&
                              !empty(aigency_post_categories_output()) ) ||
                              ( aigency_get_prefered_option('post_date_status') == 'on' &&
                              !empty(aigency_post_date_output()) ) ||
                              ( aigency_get_prefered_option('post_author_status') == 'on' &&
                              !empty(aigency_post_author_output()) ) )
                        ) {
                            echo '<div class="post-meta-header">';                            
                                if (
                                    ( aigency_get_prefered_option('post_date_status') == 'on' &&
                                    !empty(aigency_post_date_output()) ) ||
                                    ( aigency_get_prefered_option('post_author_status') == 'on' &&
                                    !empty(aigency_post_author_output()) )
                                ) {
                                    echo '<div class="post-meta-items-wrapper">';
                                        echo '<div class="post-meta-items">';
                                            if ( aigency_get_prefered_option('post_date_status') == 'on' && !empty(aigency_post_date_output()) ) {
                                                echo aigency_post_date_output(true);
                                            }
                                            if ( aigency_get_prefered_option('post_author_status') == 'on' && !empty(aigency_post_author_output()) ) {
                                                echo aigency_post_author_output(true);
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                }
                                if(aigency_get_prefered_option('post_category_status') == 'on' &&
                                    !empty(aigency_post_categories_output())) {
                                    echo aigency_post_categories_output(true);
                                }
                            echo '</div>';
                        }                    
                    ?>

                    <?php
                        if ( aigency_get_prefered_option('post_title_status') == 'on' && !empty(get_the_title()) ) {
                            echo '<h3 class="post-title">' . get_the_title() . '</h3>';
                        }
                    ?>

                    <div class="post-content">
                        <?php the_content(); ?>
                    </div>

                    <?php
                        wp_link_pages(
                            array(
                                'before' => '<div class="content-pagination"><nav class="pagination"><div class="nav-links">',
                                'after' => '</div></nav></div>',
                                'link_before' => '<span class="button-inner"></span>'
                            )
                        );
                    ?>

                    <?php
                        if (
                            ( aigency_get_prefered_option('post_tags_status') == 'on' && !empty(aigency_post_tags_output()) ) ||
                            ( aigency_get_prefered_option('post_socials_status') == 'on' && !empty(aigency_socials_output()) ) ||
                            ( aigency_get_prefered_option('post_author_status') == 'on' && !empty(aigency_post_author_output()) )
                        ) {
                            echo '<div class="post-meta-footer">';
                                if ( aigency_get_prefered_option('post_author_status') == 'on' && !empty(aigency_post_author_output()) ) {
                                    echo aigency_post_author_output(true, esc_html__('By', 'aigency'));
                                }
                                if ( aigency_get_prefered_option('post_tags_status') == 'on' && !empty(aigency_post_tags_output()) ) {
                                    echo aigency_post_tags_output();
                                }
                                if ( aigency_get_prefered_option('post_socials_status') == 'on' && !empty(aigency_socials_output()) ) {
                                    echo '<div class="post-meta-item post-meta-item-socials">';
                                        echo aigency_socials_output('wrapper-socials');
                                    echo '</div>';
                                }
                            echo '</div>';
                        }
                    ?>

                    <?php
                        if ( comments_open() || get_comments_number() || pings_open() ) {
                            comments_template(); 
                        }
                    ?>

                    <?php
                        if (aigency_get_prefered_option('recent_posts_status') == 'on') {
                            aigency_recent_posts_output(
                                array(
                                    'orderby'               => aigency_get_prefered_option('recent_posts_order_by'),
                                    'numberposts'           => aigency_get_prefered_option('recent_posts_number'),
                                    'post_type'             => get_post_type(),
                                    'order'                 => aigency_get_prefered_option('recent_posts_order'),
                                    'show_media'            => aigency_get_prefered_option('recent_posts_image'),
                                    'show_category'         => aigency_get_prefered_option('recent_posts_category'),
                                    'show_title'            => aigency_get_prefered_option('recent_posts_title'),
                                    'show_date'             => aigency_get_prefered_option('recent_posts_date'),
                                    'show_author'           => aigency_get_prefered_option('recent_posts_author'),
                                    'show_excerpt'          => aigency_get_prefered_option('recent_posts_excerpt'),
                                    'excerpt_length'        => aigency_get_prefered_option('recent_posts_excerpt_length'),
                                    'show_tags'             => aigency_get_prefered_option('recent_posts_tags'),
                                    'show_more'             => aigency_get_prefered_option('recent_posts_more')
                                )
                            );
                        }
                    ?>

                </div>

            </div>

            <!-- Sidebar Container -->
            <?php get_sidebar(); ?>

        </div>
    <?php 
}

get_footer();