<?php
/**
 * The template for displaying single project item page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Aigency
 * @since Aigency 1.0
 */

the_post();
get_header();

$sidebar_args = aigency_get_sidebar_args();
$sidebar_position = aigency_get_prefered_option('vacancy_sidebar_position');
$sidebar_name     = $sidebar_args['sidebar_name'];

$content_classes = $additional_classes = 'content-wrapper';
$content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);
$additional_classes .= ' content-wrapper-sidebar-position-none';

$content_classes .= ( aigency_get_prefered_option('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );
if ( aigency_get_prefered_option('recent_vacancies_status') == 'on' ) {
    $additional_classes .= ( aigency_get_prefered_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
} else {
    $content_classes .= ( aigency_get_prefered_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
}
?>

    <div class="<?php echo esc_attr($content_classes); ?>">

        <!-- Content Container -->
        <div class="content">

            <div id="vacancy-<?php the_ID(); ?>" class="single-vacancy">

                <div class="vacancy-post-content">

                    <?php
                        if ( !empty(get_the_content()) ) {
                            echo '<h4 class="vacancy-content-title">' . esc_html__('Job Description:', 'aigency') . '</h4>';
                            the_content();
                        }

                        if (!empty(aigency_get_post_option('vacancy_responsibilities'))) {
                            echo '<h4 class="vacancy-content-title">' . esc_html__('Responsibilities:', 'aigency') . '</h4>';
                            echo '<div class="vacancy-responsibilities">' . wp_kses_post( do_shortcode(wpautop(rwmb_meta('vacancy_responsibilities'))) ) . '</div>';
                        }

                        if (!empty(aigency_get_post_option('vacancy_qualifications'))) {
                            echo '<h4 class="vacancy-content-title">' . esc_html__('Preferred Qualifications:', 'aigency') . '</h4>';
                            echo '<div class="vacancy-qualifications">' . wp_kses_post( do_shortcode(wpautop(rwmb_meta('vacancy_qualifications'))) ) . '</div>';
                        }
                    ?>

                    <?php
                        if ( !empty(aigency_get_post_option('vacancy_button')) ) {
                            $button = aigency_get_post_option('vacancy_button');
                            echo '<div class="vacancy-post-button">';
                                echo '<a href="' . esc_url( $button[0] ) . '" class="aigency-button">' . esc_html( $button[1] ) . '<span class="icon-button-icon"></span><span class="button-inner"></a>';
                            echo '</div>';
                        }
                    ?>

                </div>
            </div>

        </div>

        <!-- Sidebar Container -->
        <?php
            if( $sidebar_position !== 'none' ) {
                $additional_class = $sidebar_args['additional_class'];

                echo '<div class="sidebar sidebar-position-' . esc_attr($sidebar_position) . esc_attr($additional_class) . ' simple-sidebar" id="simple-sidebar-default">';
                    echo '<div class="vacancy-info">';

                        if ( !empty(aigency_get_post_option('vacancy_occupation')) || !empty(aigency_get_post_option('vacancy_location')) ) {
                            echo '<div class="vacancy-post-meta">';
                            if (!empty(aigency_get_post_option('vacancy_occupation'))) {
                                echo '<div class="vacancy-post-meta-item vacancy-occupation">';
                                    echo esc_html(aigency_get_post_option('vacancy_occupation'));
                                echo '</div>';
                            }
                            if (!empty(aigency_get_post_option('vacancy_location'))) {
                                echo '<div class="vacancy-post-meta-item">';
                                    echo esc_html(aigency_get_post_option('vacancy_location'));
                                echo '</div>';
                            }
                            echo '</div>';
                        }

                        if ( !empty(aigency_get_post_option('vacancy_salary')) ) {
                            echo '<div class="vacancy-salary">';
                                echo '<div class="vacancy-salary-value">' . esc_html(aigency_get_post_option('vacancy_salary')) . '</div>';
                            echo '</div>';
                        }

                    echo '</div>';
                    if ( $sidebar_args['sidebar_position'] !== 'none' && is_active_sidebar($sidebar_name) ) {
                        dynamic_sidebar($sidebar_name);
                    }
                    echo '<div class="shop-hidden-sidebar-close"></div>';
                echo '</div>';
                echo '<div class="simple-sidebar-trigger" data-id="default"></div>';
            }
        ?>
    </div>

    <?php
        if ( aigency_get_prefered_option('recent_vacancies_status') == 'on' ) {
            echo '<div class="' . esc_attr($additional_classes) . '">';
                echo '<div class="content">';
                    if ( !empty(aigency_get_prefered_option('recent_vacancies_section_heading')) ) {
                        echo '<h2 class="related-vacancy-title aigency-heading">';
                            echo '<span class="aigency-subheading">' . esc_html__('similar_vacancies', 'aigency') . '</span>';
                            echo '<span class="team-post-title">' . aigency_get_prefered_option('recent_vacancies_section_heading') . '</span>';
                        echo '</h2>';
                    }

                    $query = new WP_Query( [
                        'post_type'         => 'aigency_vacancy',
                        'posts_per_page'    => aigency_get_prefered_option('recent_vacancies_number'),
                        'orderby'           => aigency_get_prefered_option('recent_vacancies_order_by'),
                        'order'             => aigency_get_prefered_option('recent_vacancies_order')
                    ] );

                    echo '<div class="archive-listing">';
                        echo '<div class="archive-listing-wrapper vacancy-listing-wrapper">';
                            while( $query->have_posts() ){
                                $query->the_post();
                                get_template_part('content', 'aigency_vacancy');
                            };
                            wp_reset_postdata();
                        echo '</div>';
                    echo '</div>';

                echo '</div>';
            echo '</div>';
        }
    ?>

<?php
get_footer();