<?php
/**
 * The template for displaying single project item page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Aigency
 * @since Aigency 1.0
 */

the_post();
get_header();

$sidebar_args = aigency_get_sidebar_args();
$sidebar_position = $sidebar_args['sidebar_position'];

$content_classes = 'content-wrapper';
$content_classes .= ' content-wrapper-sidebar-position-' . esc_attr($sidebar_position);
$content_classes .= ( aigency_get_prefered_option('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );
$content_classes .= ( aigency_get_prefered_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );

?>

    <div class="<?php echo esc_attr($content_classes); ?>">

        <!-- Content Container -->
        <div class="content">

            <div id="service-<?php the_ID(); ?>" class="single-service">
                <div class="service-post-content">

                    <?php
                        if ( aigency_get_prefered_option('service_media_status') == 'on' && !empty(aigency_post_media_output()) ) {
                            echo '<div class="post-media-wrapper">';
                                echo aigency_post_media_output();
                            echo '</div>';
                        }
                        if ( aigency_get_prefered_option('service_title_status') == 'on' && !empty(get_the_title()) ) {
                            echo '<h2 class="post-title">' . get_the_title() . '</h2>';
                        }
                        
                        echo '<div class="service-main-content">';
                            the_content();
                        echo '</div>';
                    ?>

                </div>
            </div>          

        </div>

        <!-- Sidebar Container -->
        <?php get_sidebar(); ?>

    </div>   

<?php
get_footer();