<?php
/**
 * The template for displaying single project item page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Aigency
 * @since Aigency 1.0
 */

the_post();
get_header();

$content_classes = $additional_classes = 'content-wrapper content-wrapper-sidebar-position-none';
$content_classes .= ( aigency_get_prefered_option('content_top_margin') == 'on' ? ' content-wrapper-remove-top-margin' : '' );

if ( aigency_get_post_option('project_view') !== 'advanced' ) {    
    $content_classes .= ( aigency_get_prefered_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
} else {
    $additional_classes .= ' content-wrapper-may-contain-elementor-code content-wrapper-remove-top-margin';
    $additional_classes .= ( aigency_get_prefered_option('content_bottom_margin') == 'on' ? ' content-wrapper-remove-bottom-margin' : '' );
}

?>
    <div id="project-<?php the_ID(); ?>" class="single-project-wrapper<?php echo aigency_get_post_option('project_view') === 'advanced' ? ' project-view-advanced' : ''; ?>">

        <section>
            <div class="<?php echo esc_attr($content_classes); ?>">

                <!-- Content Container -->
                <div class="content">

                    <div class="single-project">

                        <?php 
                            if ( aigency_get_post_option('project_view') !== 'advanced' &&
                                (
                                    !empty(aigency_media_gallery_output('project_gallery')) || 
                                    !empty(aigency_project_video_output()) 
                                ) ) {
                                echo '<div class="project-post-gallery">';
                                    echo aigency_project_video_output();
                                    echo aigency_media_gallery_output('project_gallery');
                                echo '</div>';
                            } elseif ( aigency_get_post_option('project_view') === 'advanced' && !empty(aigency_project_logo_output()) ) {
                                echo '<div class="project-post-gallery">';
                                    echo aigency_project_logo_output();
                                echo '</div>';
                            }
                        ?>

                        <div class="project-post-content">
                            <?php
                                if ( aigency_get_prefered_option('project_title_status') == 'on' && !empty(get_the_title()) ) {
                                    echo '<h2 class="project-post-title">' . get_the_title() . '</h2>';
                                }
                            ?>

                            <?php 
                                if ( aigency_get_post_option('project_view') === 'advanced' && !empty(aigency_get_post_option('project_description')) ) {
                                    echo '<div class="project-description">' . do_shortcode( wpautop( aigency_get_post_option('project_description') ) ) . '</div>';
                                } elseif ( aigency_get_post_option('project_view') !== 'advanced' ) {
                                    the_content(); 
                                }
                            ?>

                            <?php
                                if( !empty(aigency_get_post_option('project_strategy')) ||
                                    !empty(aigency_get_post_option('project_design')) ||
                                    !empty(aigency_get_post_option('project_client')) ) { ?>
                                        <div class="project-post-meta-wrapper">
                                            <div class="project-post-meta">
                                                <?php
                                                    if ( !empty(aigency_get_post_option('project_strategy')) ) {
                                                        echo '<div class="project-post-meta-item">';
                                                            echo '<h6 class="project-post-meta-label">' . esc_html__('Strategy', 'aigency') . '</h6>';
                                                            $strategy_list = aigency_get_post_option('project_strategy');
                                                            echo wp_kses( implode('<br>', $strategy_list ), array('br' => array()) );
                                                        echo '</div>';
                                                    }
                                                    if ( !empty(aigency_get_post_option('project_design')) ) {
                                                        echo '<div class="project-post-meta-item">';
                                                            echo '<h6 class="project-post-meta-label">' . esc_html__('Design', 'aigency') . '</h6>';
                                                            $design_list = aigency_get_post_option('project_design');
                                                            echo wp_kses( implode('<br>', $design_list ), array('br' => array()) );
                                                        echo '</div>';
                                                    }
                                                    if ( !empty(aigency_get_post_option('project_client')) ) {
                                                        echo '<div class="project-post-meta-item">';
                                                            echo '<h6 class="project-post-meta-label">' . esc_html__('Client', 'aigency') . '</h6>';
                                                            echo esc_html(aigency_get_post_option('project_client'));
                                                        echo '</div>';
                                                    }
                                                ?>
                                            </div>
                                        </div>
                                <?php } ?>
                            <?php
                                if ( !empty(aigency_get_post_option('project_button')) ) {
                                    $button = aigency_get_post_option('project_button');
                                    echo '<div class="project-post-button">';
                                        echo '<a href="' . esc_url( $button[0] ) . '" class="aigency-button">' . esc_html( $button[1] ) . '<span class="icon-button-icon"></span><span class="button-inner"></a>';
                                    echo '</div>';
                                }
                            ?>

                        </div>
                    </div>

                    <?php
                        if ( aigency_get_post_option('project_view') !== 'advanced' ) {
                            $args = array(
                                'prev_label'            => esc_html__('Prev project', 'aigency'),
                                'next_label'            => esc_html__('Next project', 'aigency'),
                                'taxonomy_name'         => 'aigency_project_category',
                                'taxonomy_separator'    => ' / '
                            );
                            echo aigency_post_navigation($args);
                        }                    
                    ?>

                </div>
            </div>
        </section>

        <?php
            if ( aigency_get_post_option('project_view') === 'advanced' ) {
                echo '<section>';
                    echo '<div class="' . esc_attr($additional_classes) . '">';
                        echo '<div class="content">';
                            echo '<div class="single-project-advanced">';
                                the_content();
                            echo '</div>';
                            $args = array(
                                'prev_label'            => esc_html__('Prev project', 'aigency'),
                                'next_label'            => esc_html__('Next project', 'aigency'),
                                'taxonomy_name'         => 'aigency_project_category',
                                'taxonomy_separator'    => ' / '
                            );
                            echo aigency_post_navigation($args);
                        echo '</div>';
                    echo '</div>';
                echo '</section>';
            }
        ?>
    </div>

<?php
get_footer();