<?php
/**
 * The custom template for displaying the blank search page (but not the search results).
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-page
 *
 * @package WordPress
 * @subpackage Aigency
 * @author Artureanec
 * @since Aigency 1.0
 * @version 1.0
 */

get_header();

$content_classes = 'content-wrapper content-wrapper-sidebar-position-none';
?>

    <div class="<?php echo esc_attr($content_classes); ?>">
        <div class="content">
            <!-- Content Container -->
            <div class="content-inner">

                    <h2 class="aigency-no-results-title"><?php esc_html_e('Enter your search query', 'aigency'); ?></h2>

                    <div class="aigency-no-result-search-form">
                        <?php
                            $search_args = array(
                                'echo'          => true,
                                'aria_label'    => 'page'
                            );
                            echo aigency_get_search_form(null, $search_args, true);
                        ?>
                    </div>

            </div>
        </div>



    </div>

<?php
get_footer();