/*
 * Created by Artureanec
*/

"use strict";

function aigency_reactivate_sortable() {
    jQuery('.aigency_text_table_rows').sortable(
        {
            handle: '.aigency_text_table_row_move',
        }
    );
}

function aigency_rwmb_and_customizer_condition() {
    jQuery("[data-dependency-id]").each(function (index) {
        var aigency_target = jQuery(this).attr('data-dependency-id');
        var aigency_needed_val = jQuery(this).attr('data-dependency-val');
        var aigency_needed_val_array = new Array();
        var aigency_array_just_ok = false;

        if(aigency_needed_val.indexOf(',') + 1) {
            // Work with array value
            aigency_needed_val = aigency_needed_val.replace(/\s+/g,'');
            aigency_needed_val_array = aigency_needed_val.split(",");

            var aigency_this = jQuery(this);
            var aigency_target_array = aigency_target.replace(/\s+/g,'').split(",");
            var isOkArray = [];

            aigency_needed_val_array.forEach(function(item, i, aigency_arr) {
                if (aigency_this.hasClass('aigency_dependency_customizer')) {
                    if (aigency_array_just_ok !== true) {
                        if (jQuery('#customize-control-' + aigency_target).find('select').val() == item) {
                            aigency_array_just_ok = true;
                        }
                    }
                }
                else {
                    if (jQuery('#' + aigency_target_array[i]).val() == item) {
                        isOkArray.push(true);                        
                    } else {
                        isOkArray.push(false);
                    }
                }
            });
            if (!aigency_this.hasClass('aigency_dependency_customizer')) {
                aigency_array_just_ok = true;
                for(let i = 0; i < isOkArray.length; i++) {
                    if(isOkArray[i] == false) {
                        aigency_array_just_ok = false;
                        break;
                    }
                }
            }

            if (jQuery(this).hasClass('aigency_dependency_customizer')) {
                var aigency_target_status = jQuery('#customize-control-' + aigency_target).find('select').val();
                var aigency_dependency_elem_cont = jQuery(this).parents('.customize-control');
            } else {
                var aigency_target_status = jQuery('#' + aigency_target).val();
                var aigency_dependency_elem_cont = jQuery(this).parents('.rwmb-field');
            }

            if (aigency_array_just_ok == true) {
                aigency_dependency_elem_cont.show('fast');
            } else {
                aigency_dependency_elem_cont.hide('fast');
            }
        } else {
            // Just one value
            if (jQuery(this).hasClass('aigency_dependency_customizer')) {
                var aigency_target_status = jQuery('#customize-control-' + aigency_target).find('select').val();
                var aigency_dependency_elem_cont = jQuery(this).parents('.customize-control');
            } else {
                var aigency_target_status = jQuery('#' + aigency_target).val();
                var aigency_dependency_elem_cont = jQuery(this).parents('.rwmb-field');
            }

            if (aigency_needed_val == aigency_target_status) {
                aigency_dependency_elem_cont.show('fast');
            } else {
                aigency_dependency_elem_cont.hide('fast');
            }
        }
    });
}

function aigency_hide_unnecessary_options() {
    if (jQuery('.aigency_this_template_file').size() < 1) {
        var aigency_this_template_file = 'aigency_temp_333';
    }
    if (jQuery('.aigency_this_template_file').size() > 0) {
        aigency_this_template_file = jQuery('.aigency_this_template_file').val();
    }
    jQuery("[data-show-on-template-file]").each(function (index) {
        var aigency_unnecessary_target = jQuery(this).attr('data-show-on-template-file');
        if (aigency_unnecessary_target.indexOf(',') > -1) {
            var aigency_unnecessary_target_array = aigency_unnecessary_target.split(',');
            var aigency_rwmb_del_status = 'not find';
            jQuery.each(aigency_unnecessary_target_array, function (i, val) {
                if (aigency_this_template_file == val.trim()) {
                    aigency_rwmb_del_status = 'find';
                }
            });
            if (aigency_rwmb_del_status == 'not find') {
                jQuery(this).parents('.rwmb-field').remove();
            }
        } else {
            if (aigency_this_template_file !== aigency_unnecessary_target) {
                jQuery(this).parents('.rwmb-field').remove();
            }
        }
    });

    jQuery("[data-hide-on-template-file]").each(function (index) {
        var aigency_unnecessary_target = jQuery(this).attr('data-hide-on-template-file');
        if (aigency_unnecessary_target.indexOf(',') > -1) {
            var aigency_unnecessary_target_array = aigency_unnecessary_target.split(',');
            var aigency_rwmb_del_status = 'not find';
            jQuery.each(aigency_unnecessary_target_array, function (i, val) {
                if (aigency_this_template_file == val.trim()) {
                    aigency_rwmb_del_status = 'find';
                }
            });
            if (aigency_rwmb_del_status == 'find') {
                jQuery(this).parents('.rwmb-field').remove();
            }
        } else {
            if (aigency_this_template_file == aigency_unnecessary_target) {
                jQuery(this).parents('.rwmb-field').remove();
            }
        }
    });
}

function aigency_onchange_post_formats(val) {
    jQuery('#image-post-format-settings, #video-post-format-settings, #audio-past-format-settings, #quote-post-format-settings, #link-post-format-settings, #gallery-post-format-settings').hide('fast');
    switch (val) {
        case 'image':
            jQuery('#image-post-format-settings').show('fast');
            break;
        case 'gallery':
            jQuery('#gallery-post-format-settings').show('fast');
            break;
        case 'link':
            jQuery('#link-post-format-settings').show('fast');
            break;
        case 'quote':
            jQuery('#quote-post-format-settings').show('fast');
            break;
        case 'video':
            jQuery('#video-post-format-settings').show('fast');
            break;
        case 'audio':
            jQuery('#audio-past-format-settings').show('fast');
            break;
        default:
            return false;
    }
}

jQuery(document).ready(function () {
    
    // Show post format meta fields
    function aigency_get_post_format() {
        if ( wp && wp.data && wp.data.select('core/editor') ) {
            const getPostFormat = () => wp.data.select('core/editor').getEditedPostAttribute('format');
            let postFormat = getPostFormat();
            wp.data.subscribe(() => {
                const newPostFormat = getPostFormat();
                if (postFormat !== newPostFormat) {
                    postFormat = newPostFormat;
                    aigency_onchange_post_formats(postFormat);
                }
            });
        }
    }
    aigency_get_post_format();

    if (jQuery('#centered_content_hide').length) {
        if (jQuery('#centered_content_hide').val() == 'yes') {
            jQuery('body').addClass('aigency_hide_content');
        } else {
            jQuery('body').removeClass('aigency_hide_content');
        }
    }
    jQuery('#centered_content_hide').on('change', function(){
        if (jQuery(this).val() == 'yes') {
            jQuery('body').addClass('aigency_hide_content');
        } else {
            jQuery('body').removeClass('aigency_hide_content');
        }
    });
    if (jQuery('#page_template').size() > 0 && jQuery('#page_template').val() !== 'default') {
        jQuery('body').addClass(jQuery('#page_template').val().split('.')[0]);
    }

    jQuery("[data-dependency-id]").parents('.rwmb-field').hide();

    aigency_rwmb_and_customizer_condition();
    aigency_hide_unnecessary_options();

    jQuery('.rwmb-select, .customize-control-select select').change(function () {
        aigency_rwmb_and_customizer_condition();
    });

    jQuery('.aigency_reset_all_settings').on("click", function () {
        if (confirm("Are you sure? All settings will be reset to default state.")) {
            jQuery.post(ajaxurl, {
                action: 'aigency_reset_all_settings'
            }, function (response) {
                alert(response);
            });
        }
    });

    jQuery(document).on("click", '.aigency_text_table_add_row', function () {
        var aigency_text_table_data_storage_name = jQuery(this).parents('.widget-content').find('.aigency_text_table_data_storage_name').val();
        var aigency_text_table_name_text = jQuery(this).parents('.widget-content').find('.aigency_text_table_name_text').val();
        var aigency_text_table_value_text = jQuery(this).parents('.widget-content').find('.aigency_text_table_value_text').val();

        jQuery(this).parents('.widget-content').find('.aigency_text_table_rows').append('<div class="aigency_text_table_row aigency_dn"><div class="aigency_50_dib"><label>' + aigency_text_table_name_text + ':</label><input class="widefat" type="text" name="' + aigency_text_table_data_storage_name + '[][name]" value=""></div><div class="aigency_50_dib"><label>' + aigency_text_table_value_text + ':</label><textarea class="widefat" type="text" name="' + aigency_text_table_data_storage_name + '[][value]"></textarea></div><div class="aigency_text_table_row_remove"><i class="fa fa-trash"></i></div><div class="aigency_text_table_row_move"><i class="fa fa-arrows"></i></div></div>');
        jQuery('.aigency_dn').slideDown("fast").removeClass('aigency_dn');
    });

    jQuery(document).on("click", '.aigency_text_table_row_remove', function () {
        jQuery(this).parents('.aigency_text_table_row').slideUp("normal", function () {
            jQuery(this).remove();
        });
    });

    jQuery(document).on("click", '.widget-control-save', function () {
        setTimeout(function () {
            aigency_reactivate_sortable()
        }, 1000);
        setTimeout(function () {
            aigency_reactivate_sortable()
        }, 2000);
        setTimeout(function () {
            aigency_reactivate_sortable()
        }, 3000);
    });

    aigency_reactivate_sortable();

    function media_upload() {
        var _custom_media = true,
            _orig_send_attachment = wp.media.editor.send.attachment;
        jQuery('body').on('click', '.js_custom_upload_media', function () {
            var button_id   = jQuery(this).attr('id'),
                preview_url = '';
            wp.media.editor.send.attachment = function (props, attachment) {
                if ( typeof attachment !== 'undefined' ) {
                    if (_custom_media) {
                        if (typeof attachment.sizes.medium !== 'undefined') {
                            preview_url = attachment.sizes.medium.url;
                        } else {
                            preview_url = attachment.sizes.full.url;
                        }
                        jQuery('.' + button_id + '_img').attr('src', preview_url).removeClass('hidden');
                        jQuery('.' + button_id + '_url').val(attachment.url).change();
                        jQuery('.' + button_id + '_id').val(attachment.id).change();
                    } else {
                        return _orig_send_attachment.apply(jQuery('#' + button_id), [props, attachment]);
                    }
                    jQuery('#' + button_id).removeClass('empty').addClass('hidden');
                    jQuery('.media-widget-buttons', jQuery(this).parents('.media-widget-control')).find('.js_custom_remove_media').removeClass('hidden');
                }
            };
            if ( typeof wp !== 'undefined' && wp.media && wp.media.editor ) {
                wp.media.editor.open(jQuery('#' + button_id));
            }

            return false;
        });
    }
    media_upload();

    function media_remove() {
        jQuery('body').on('click', '.js_custom_remove_media', function() {
            jQuery('.media_image', jQuery(this).parents('.media-widget-control')).find('input.widefat').val('').change();
            jQuery('.media_image', jQuery(this).parents('.media-widget-control')).find('input.widefat2').val('').change();
            jQuery('.media_image', jQuery(this).parents('.media-widget-control')).find('img').attr('src', '').addClass('hidden');
            jQuery('.media_image', jQuery(this).parents('.media-widget-control')).find('.js_custom_upload_media').addClass('empty').removeClass('hidden');
            jQuery(this).addClass('hidden');
        });
    }
    media_remove();
});

jQuery('.aigency_color_picker .rwmb-color').each(function(){
    var color = jQuery(this).attr('placeholder');

    if (jQuery(this).val() === '') {
        jQuery(this).val(color);
    }
});

function iconSearch(i) {
    var t = i.parent().next().find('.iconpicker-items'),
        c = i.val().toLowerCase();

    if ( c.length > 0 ) {
        t.children().each( function() {
            if ( jQuery(this).filter("[title*=".concat(c)).length > 0 || c.length < 1 ) {
                jQuery(this).show();
            } else {
                jQuery(this).hide();
            }
        })
    } else {
        t.children().show();
    }
}

jQuery('.rwmb-benefits-wrapper, .rwmb-iconpicker-wrapper').on('click', '.icp-auto', function(){
    jQuery(this).parent().next().addClass('iconpicker-visible').find('.iconpicker-search').focus().val('').keyup();
    jQuery(document).on('mouseup', function(i) {
        var t = jQuery('.iconpicker-popover');
        t.is(i.target) || 0 !== t.has(i.target).length || t.removeClass('iconpicker-visible');
    });
    jQuery('.iconpicker-items > i').on('click', function(){
        var i = jQuery(this).attr('class');
        (n = jQuery(this).parents('.iconpicker-popover').prev().find('.icp')).val(i);
        n.attr('value', i);
        var t = n.next('.input-group-addon'),
            c = '<i class="' . concat(i, '"></i>');
        t.empty();
        t.append(c);
        var n, r = jQuery(this).parent().parent().parent();
        (n = jQuery('.iconpicker-popover')).removeClass('iconpicker-visible');
        n.trigger('change');
    });
    jQuery('.iconpicker-search').on('keyup', function() {
        iconSearch(jQuery(this));
    });
});