<?php
/*
 * Created by Artureanec
*/

# General
add_theme_support('title-tag');
add_theme_support('automatic-feed-links');
add_theme_support('post-formats', array('video', 'gallery', 'quote'));
add_theme_support('html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );

if( !isset( $content_width ) ) $content_width = 1340;

# ADD Localization Folder
add_action('init', 'aigency_pomo', 1);
if (!function_exists('aigency_pomo')) {
    function aigency_pomo() {
        load_theme_textdomain('aigency', get_template_directory() . '/languages');
    }
}

require_once(get_template_directory() . '/core/helper-functions.php');
require_once(get_template_directory() . '/core/layout-functions.php');
require_once(get_template_directory() . '/core/init.php');

// Add new body classes
if ( !function_exists('aigency_add_body_classes') ) {
    function aigency_add_body_classes($classes) {
        $body_classes = [];
        if ( did_action('elementor/loaded') ) {
            $elementor_preview_active = \Elementor\Plugin::$instance->preview->is_preview_mode();
            if ( !$elementor_preview_active ) $body_classes[] = 'aigency-front-end';
        } else {
            $body_classes[] = 'aigency-front-end';
        }

        return array_merge($classes, $body_classes);
    }
}
add_filter('body_class', 'aigency_add_body_classes');

# Register CSS/JS
add_action('wp_enqueue_scripts', 'aigency_css_js');
if (!function_exists('aigency_css_js')) {
    function aigency_css_js() {
        # CSS
        wp_enqueue_style('aigency-theme', get_template_directory_uri() . '/css/theme.css', array(), wp_get_theme()->get('Version'));
        wp_style_add_data('aigency-theme', 'rtl', 'replace'); 

        if (class_exists('WooCommerce')) {
            wp_enqueue_style('aigency-woocommerce', get_template_directory_uri() . '/css/woocommerce.css', array(), wp_get_theme()->get('Version'));
            wp_style_add_data('aigency-woocommerce', 'rtl', 'replace');
            wp_enqueue_style('aigency-style', get_template_directory_uri() . '/style.css', array('aigency-theme', 'aigency-woocommerce'), wp_get_theme()->get('Version') );
        } else {
            wp_enqueue_style('aigency-style', get_template_directory_uri() . '/style.css', array('aigency-theme'), wp_get_theme()->get('Version') );
        }

        # JS
        wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), false, true);
        wp_enqueue_script('isotope', get_template_directory_uri() . '/js/isotope.min.js', array(), false, true );

        wp_register_script('aigency-theme', get_template_directory_uri() . '/js/theme.js', array('jquery', 'owl-carousel', 'isotope'), false, true);
        wp_localize_script( 'aigency-theme', 'ajax_params', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
        wp_enqueue_script('aigency-theme');


        if (is_singular() && comments_open()) {
            wp_enqueue_script('comment-reply');
        }

        wp_localize_script('aigency-theme', 'aigency_ajaxurl',
            array(
                'url' => esc_url(admin_url('admin-ajax.php'))
            )
        );

        $localize_theme = array();
        $localize_theme['rtl'] = (bool)is_rtl();
        wp_localize_script('aigency-theme', 'theme',
            $localize_theme
        );

        # Colors
        require_once(get_template_directory() . "/css/custom/custom.php");

        global $aigency_custom_css;
        wp_add_inline_style('aigency-theme', $aigency_custom_css);
    }
}

# Register CSS/JS for Admin Settings
add_action('admin_enqueue_scripts', 'aigency_admin_css_js');
if (!function_exists('aigency_admin_css_js')) {
    function aigency_admin_css_js() {
        # CSS
        wp_enqueue_style('aigency-admin', get_template_directory_uri() . '/css/admin.css');
        # JS
        wp_enqueue_script('aigency-admin', get_template_directory_uri() . '/js/admin.js', array('jquery', 'jquery-ui-core', 'jquery-ui-sortable'), false, true);
    }
}

# Register Google Fonts
add_action('wp_enqueue_scripts', 'aigency_register_theme_fonts');
if (!function_exists('aigency_register_theme_fonts')) {
    function aigency_register_theme_fonts() {
        $fonts_list = array('header_menu_font', 'header_sub_menu_font', 'page_title_heading_font', 'page_title_breadcrumbs_font', 'page_title_additional_text_font', 'main_font', 'additional_font', 'additional_font_family', 'h1_font', 'h2_font', 'h3_font', 'h4_font', 'h5_font', 'h6_font', 'buttons_font');
        $font_control_list      = get_theme_mod('current_fonts', $fonts_list);
        $current_fonts_array    = array();
        $families               = array();
        $result                 = array();
        foreach ( $font_control_list as $control ) {
            $values = aigency_get_theme_mod($control);
            $values = json_decode($values, true);
            if ( isset($values['font_family']) && !empty($values['font_family']) ) {
                $current_font = array();
                $current_font['font_family'] = $values['font_family'];
                $current_font['font_styles'] = $values['font_styles'];
                $current_font['font_subset'] = $values['font_subset'];
                $current_fonts_array[$control] = $current_font;
            }
        }

        if ( !empty($current_fonts_array) && is_array($current_fonts_array) ) {
            foreach ( $current_fonts_array as $item ) {
                if ( !in_array($item['font_family'], $families) ) {
                    $families[] = $item['font_family'];
                }
            }
            foreach ( $families as $variant ) {
                foreach ( $current_fonts_array as $key => $item ) {
                    if ( $variant == $item['font_family'] ) {
                        $result[$variant]['font_styles'] = empty($result[$variant]['font_styles']) ? $item['font_styles'] : $result[$variant]['font_styles'] . ',' . $item['font_styles'];
                        $result[$variant]['font_subset'] = empty($result[$variant]['font_subset']) ? $item['font_subset'] : $result[$variant]['font_subset'] . ',' . $item['font_subset'];
                    }
                }
            }
            foreach ( $result as $key => $value ) {
                $styles = array_unique(explode(',', $result[$key]['font_styles']));
                asort($styles, SORT_NUMERIC );
                $subset = array_unique(explode(',', $result[$key]['font_subset']));
                asort($subset, SORT_NUMERIC );
                $result[$key]['font_styles'] = implode( ',', $styles );
                $result[$key]['font_subset'] = implode( ',', $subset );
            }
            if ( !empty($result) && is_array($result) ) {
                $fonts = array();
                foreach ( $result as $font_name => $font_params ) {
                    // exclude local fonts
                    if ( $font_name != 'Manrope Alt' ) {
                        $fonts[] = $font_name . ':' . $font_params['font_styles'] . '&subset=' . $font_params['font_subset'];
                    }
                }
                $fonts_url = '//fonts.googleapis.com/css?family=' . urlencode( implode('|', $fonts) );
                wp_enqueue_style('aigency-fonts', $fonts_url);
            }
        }
    }
}

add_action('pre_get_posts', 'aigency_archive_custom_query');
if (!function_exists('aigency_archive_custom_query')) {
    function aigency_archive_custom_query($query) {
        if ( ! is_admin() && $query->is_main_query() ) {
            if( is_post_type_archive('aigency_case_study') || is_tax(['aigency_case_study_category', 'aigency_case_study_tag']) ) {
                $posts_per_page = aigency_get_theme_mod('case_studies_archive_posts_per_page');
            } elseif( is_post_type_archive('aigency_project') || is_tax('aigency_project_category') ) {
                $posts_per_page = aigency_get_theme_mod('project_archive_posts_per_page');
            } elseif( is_post_type_archive('aigency_service') || is_tax(['aigency_services_category', 'aigency_services_tag']) ) {
                $posts_per_page = aigency_get_theme_mod('service_archive_posts_per_page');
            } elseif( is_post_type_archive('aigency_team_member') || is_tax('aigency_team_department') ) {
                $posts_per_page = aigency_get_theme_mod('team_archive_posts_per_page');
            } elseif( is_post_type_archive('aigency_vacancy') || is_tax('aigency_careers_department') ) {
                $posts_per_page = aigency_get_theme_mod('vacancy_archive_posts_per_page');
            }
            if( isset($posts_per_page) ) {
                $query->set('posts_per_page', $posts_per_page);
            }            
        }
    }
}

# WP Footer
add_action('wp_footer', 'aigency_wp_footer');
if (!function_exists('aigency_wp_footer')) {
    function aigency_wp_footer() {
        Aigency_Helper::getInstance()->echoFooter();
    }
}

# Register Menu
add_action('init', 'aigency_register_menu');
if (!function_exists('aigency_register_menu')) {
    function aigency_register_menu() {
        register_nav_menus(
            [
                'main'              => esc_html__('Main menu', 'aigency'),
                'footer_add_menu'   => esc_html__('Footer Additional Menu', 'aigency')
            ]
        );
    }
}

# Register Sidebars
add_action('init', 'aigency_widgets_init');
if (!function_exists('aigency_widgets_init')) {
    function aigency_widgets_init() {
        register_sidebar(
            array(
                'name'          => esc_html__('Page Sidebar', 'aigency'),
                'id'            => 'sidebar',
                'description'   => esc_html__('Widgets in this area will be shown on all pages.', 'aigency'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Post Sidebar', 'aigency'),
                'id'            => 'sidebar-post',
                'description'   => esc_html__('Widgets in this area will be shown on all posts.', 'aigency'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        if ( aigency_get_theme_mod('vacancy_posts_status') == 'on' ) {
            register_sidebar(
                array(
                    'name'          => esc_html__('Career Sidebar', 'aigency'),
                    'id'            => 'sidebar-vacancy',
                    'description'   => esc_html__('Widgets in this area will be shown on all career pages.', 'aigency'),
                    'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h5 class="widget-title"><span>',
                    'after_title'   => '</span></h5>',
                )
            );
        }

        if ( aigency_get_theme_mod('service_posts_status') == 'on' ) {
            register_sidebar(
                array(
                    'name'          => esc_html__('Service Sidebar', 'aigency'),
                    'id'            => 'sidebar-service',
                    'description'   => esc_html__('Widgets in this area will be shown on all service pages.', 'aigency'),
                    'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h5 class="widget-title"><span>',
                    'after_title'   => '</span></h5>',
                )
            );
        }

        if ( aigency_get_theme_mod('case_study_posts_status') == 'on' ) {
            register_sidebar(
                array(
                    'name'          => esc_html__('Case Study Sidebar', 'aigency'),
                    'id'            => 'sidebar-case-study',
                    'description'   => esc_html__('Widgets in this area will be shown on all case study pages.', 'aigency'),
                    'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h5 class="widget-title"><span>',
                    'after_title'   => '</span></h5>',
                )
            );
        }        

        register_sidebar(
            array(
                'name'          => esc_html__('Archive Sidebar', 'aigency'),
                'id'            => 'sidebar-archive',
                'description'   => esc_html__('Widgets in this area will be shown on all posts and archive pages.', 'aigency'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('FAQ Sidebar', 'aigency'),
                'id'            => 'sidebar-faq',
                'description'   => esc_html__('Widgets in this area will be shown on FAQ page.', 'aigency'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Side Panel Sidebar', 'aigency'),
                'id'            => 'sidebar-side',
                'description'   => esc_html__('Widgets in this area will be shown on side panel.', 'aigency'),
                'before_widget' => '<div id="%1$s" class="widget side-widget %2$s"><div class="widget-wrapper side-widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title side-widget-title">',
                'after_title'   => '</h5>',
            )
        );

        register_sidebar(
            array(
                'name'          => esc_html__('Menu Sidebar', 'aigency'),
                'id'            => 'sidebar-menu',
                'description'   => esc_html__('Widgets in this area will be shown on compact menu panel.', 'aigency'),
                'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-wrapper">',
                'after_widget'  => '</div></div>',
                'before_title'  => '<h5 class="widget-title"><span>',
                'after_title'   => '</span></h5>',
            )
        );

        if ( !did_action('elementor/loaded') || !function_exists('hfe_init') ) {
            register_sidebar(
                array(
                    'name'          => esc_html__('Footer Sidebar', 'aigency'),
                    'id'            => 'sidebar-footer',
                    'description'   => esc_html__('Widgets in this area will be shown on footer area.', 'aigency'),
                    'before_widget' => '<div id="%1$s" class="widget footer-widget %2$s"><div class="widget-wrapper footer-widget-wrapper">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h6 class="widget-title footer-widget-title">',
                    'after_title'   => '</h6>',
                )
            );
        }        

        if (class_exists('WooCommerce')) {
            register_sidebar(
                array(
                    'name'          => esc_html__('Sidebar WooCommerce', 'aigency'),
                    'id'            => 'sidebar-woocommerce',
                    'description'   => esc_html__('Widgets in this area will be shown on Woocommerce Pages.', 'aigency'),
                    'before_widget' => '<div id="%1$s" class="widget wooсommerce-widget %2$s"><div class="widget-wrapper">',
                    'after_widget'  => '</div></div>',
                    'before_title'  => '<h5 class="widget-title"><span>',
                    'after_title'   => '</span></h5>',
                )
            );
        }
    }
}

// Init Custom Widgets
if ( function_exists('aigency_add_custom_widget') ) {
    add_action('widgets_init', 'aigency_custom_widgets_init');
    function aigency_custom_widgets_init() {
        aigency_add_custom_widget('Aigency_Nav_Menu_Widget');
        aigency_add_custom_widget('Aigency_Special_Text_Widget');
    }
}

// Init Elementor for Custom Post Types
if ( !function_exists('aigency_init_elementor_for_custom_post_types') ) {
    function aigency_init_elementor_for_custom_post_types() {
        if ( did_action('elementor/loaded') ) {
            if ( aigency_get_theme_mod('project_posts_status') == 'on' ) add_post_type_support('aigency_project', 'elementor');
            if ( aigency_get_theme_mod('vacancy_posts_status') == 'on' ) add_post_type_support('aigency_vacancy', 'elementor');
            if ( aigency_get_theme_mod('team_posts_status') == 'on' ) add_post_type_support('aigency_team_member', 'elementor');
            if ( aigency_get_theme_mod('service_posts_status') == 'on' ) add_post_type_support('aigency_service', 'elementor');
            if ( aigency_get_theme_mod('case_study_posts_status') == 'on' ) add_post_type_support('aigency_case_study', 'elementor');
        }
    }
}
add_action('init', 'aigency_init_elementor_for_custom_post_types');

# WooCommerce
if (class_exists('WooCommerce')) {
    require_once( get_template_directory() . '/woocommerce/wooinit.php');
}

// Remove standard WP gallery styles
add_filter( 'use_default_gallery_style', '__return_false' );

// Register custom image sizes
if ( function_exists( 'add_theme_support' ) ) {
    add_theme_support( 'post-thumbnails' );
    set_post_thumbnail_size( 1340, 638, true );
}
if ( function_exists( 'add_image_size' ) ) {
    add_image_size( 'aigency_post_thumbnail_mobile', 575, 274, array('center', 'center') );
    add_image_size( 'aigency_post_thumbnail_tablet', 991, 472, array('center', 'center') );

    add_image_size( 'aigency_post_grid_2_columns', 960, 718, array('center', 'center') );
    add_image_size( 'aigency_post_grid_3_columns', 640, 478, array('center', 'center') );
    add_image_size( 'aigency_post_grid_4_columns', 500, 374, array('center', 'center') );
    add_image_size( 'aigency_post_grid_5_columns', 384, 287, array('center', 'center') );
    add_image_size( 'aigency_post_grid_6_columns', 320, 239, array('center', 'center') );

    add_image_size( 'aigency_portfolio_thumbnail', 835, 653, array('center', 'center') );
    add_image_size( 'aigency_portfolio_grid_1_columns', 1340, 1340, array('center', 'center') );
    add_image_size( 'aigency_portfolio_grid_2_columns', 960, 960, array('center', 'center') );
    add_image_size( 'aigency_portfolio_grid_3_columns', 640, 640, array('center', 'center') );
    add_image_size( 'aigency_portfolio_grid_4_columns', 500, 500, array('center', 'center') );
    add_image_size( 'aigency_portfolio_grid_5_columns', 384, 384, array('center', 'center') );
    add_image_size( 'aigency_portfolio_grid_6_columns', 320, 320, array('center', 'center') );

    add_image_size( 'aigency_project_modern_1_columns', 1340, 689, array('center', 'center') );

    add_image_size( 'aigency_portfolio_masonry_1_columns', 1920, 1920, array('center', 'center') );
    add_image_size( 'aigency_portfolio_masonry_2_columns', 960, 960, array('center', 'center') );
    add_image_size( 'aigency_portfolio_masonry_3_columns', 640, 640, array('center', 'center') );
    add_image_size( 'aigency_portfolio_masonry_4_columns', 500, 500, array('center', 'center') );
    add_image_size( 'aigency_portfolio_masonry_5_columns', 384, 384, array('center', 'center') );
    add_image_size( 'aigency_portfolio_masonry_6_columns', 320, 320, array('center', 'center') );

    add_image_size( 'aigency_team_thumbnail', 535, 551, array('right', 'center') );
}

//Remove 1536x1536 and 2048x2048 image sizes
if (!function_exists('aigency_remove_image_sizes')) {
    function aigency_remove_image_sizes() {
        remove_image_size('1536x1536');
        remove_image_size('2048x2048');
    }
}
add_action('init', 'aigency_remove_image_sizes');

// Media Upload
if (!function_exists('aigency_enqueue_media')) {
    function aigency_enqueue_media() {
        wp_enqueue_media();
    }
}
add_action( 'admin_enqueue_scripts', 'aigency_enqueue_media' );

// Responsive video
add_filter('embed_oembed_html', 'aigency_wrap_oembed_video', 99, 4);
if (!function_exists('aigency_wrap_oembed_video')) {
    function aigency_wrap_oembed_video($html, $url, $attr, $post_id) {
        return '<div class="video-embed">' . $html . '</div>';
    }
}

// Custom Search form
add_filter('get_search_form', 'aigency_get_search_form', 10, 2);
if ( !function_exists('aigency_get_search_form') ) {
    function aigency_get_search_form($form, $args) {
        $search_rand = mt_rand(0, 999);
        $search_js = 'javascript:document.getElementById("search-' . esc_js($search_rand) . '").submit();';
        $placeholder = ( $args['aria_label'] == 'global' ? esc_attr__('Type Your Search...', 'aigency') : esc_attr__('Search...', 'aigency') );

        $form = '<form name="search_form" method="get" action="' . esc_url(home_url('/')) . '" class="search-form" id="search-' . esc_attr($search_rand) . '">';
            $form .= '<span class="search-form-icon" onclick="' . esc_js($search_js) . '"></span>';
            $form .= '<input type="text" name="s" value="" placeholder="' . esc_attr($placeholder) . '" title="' . esc_attr__('Search', 'aigency') . '" class="search-form-field">';
        $form .= '</form>';

        return $form;
    }
}

// Customize WP Categories Widget
add_filter('wp_list_categories', 'aigency_customize_categories_widget', 10, 2);
if ( !function_exists('aigency_customize_categories_widget') ) {
    function aigency_customize_categories_widget($output, $args) {
        $args['use_desc_for_title'] = false;
        if ( $args['hierarchical'] ) {
            $output = str_replace('"cat-item', '"cat-item cat-item-hierarchical', $output);
        }

        return $output;
    }
}

// Add Buttons to Tiny MCE text editor
add_action( 'init', 'aigency_tiny_mce_background_color' );
if ( !function_exists('aigency_tiny_mce_background_color') ) {
    function aigency_tiny_mce_background_color() {
        add_filter('mce_buttons_2', 'aigency_tiny_mce_background_color_button', 999, 1);
    }
}
if ( !function_exists('aigency_tiny_mce_background_color_button') ) {
    function aigency_tiny_mce_background_color_button($buttons) {
        array_unshift($buttons, 'fontsizeselect');
        array_splice($buttons, 4, 0, 'backcolor');
        return $buttons;
    }
}
if ( !function_exists('aigency_tinymce_fontsize') ) {
    function aigency_tinymce_fontsize($sizes) {
        $sizes['fontsize_formats'] = "10px 14px 16px 20px 24px 28px 32px 36px 40px 46px 50px";
        return $sizes;
    }
}
add_filter('tiny_mce_before_init', 'aigency_tinymce_fontsize');

// Customize Comment fields
add_filter('comment_form_defaults', 'aigency_customize_comment_fields');
if ( !function_exists('aigency_customize_comment_fields') ) {
    function aigency_customize_comment_fields($args) {
        $format = current_theme_supports('html5', 'comment-form') ? 'html5' : 'xhtml';
        $commenter          = wp_get_current_commenter();
        $req                = get_option( 'require_name_email' );
        $html5              = 'html5' === $format;

        $html_req           = ( $html5 ? ' required' : ' required="required"' );
        $html_consent       = ( $html5 ? ' checked' : ' checked="checked"' );
        $consent            = empty( $commenter['comment_author_email'] ) ? '' : esc_attr($html_consent);
        $comment_form_args  = array(
            'title_reply'           => esc_html__('Leave a Comment', 'aigency'),
                'cancel_reply_link'     => esc_html__('(Cancel reply)', 'aigency'),
                'title_reply_to'        => esc_html__('Leave a Reply to %s', 'aigency'),
                'title_reply_before'    => '<h4 id="reply-title" class="comment-reply-title">',
                'title_reply_after'     => '</h4>',
                'fields'                => array(
                    'author'    => sprintf('<div class="form-fields"><div class="form-field form-name"><input placeholder="'. esc_attr__('Full name', 'aigency'). ( $req ? '*' : '' ) . '" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" size="30"%s/></div>', ( $req ? $html_req : '' )),
                    'email'     => sprintf('<div class="form-field form-email"><input placeholder="' . esc_attr__('Email', 'aigency') . ( $req ? '*' : '' ) . '" name="email" type="text" value="' . esc_attr($commenter['comment_author_email']) . '" size="30"%s/></div>', ( $req ? $html_req : '' )),
                    'cookies'   => '<div class="form-field form-cookies comment-form-cookies-consent">'.
                                         sprintf( '<input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"%s />', $consent ) . '
                                         <label for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email and message in this browser for the next time I comment.', 'aigency' ) . '</label>
                                    </div></div>',
                ),
                'comment_field'         => '<div class="form-field form-message"><textarea name="comment" cols="45" rows="6" placeholder="' . esc_attr__('Message', 'aigency') . '" id="comment-message"></textarea></div>',
                'label_submit'          => esc_html__('Send a message', 'aigency'),
                'logged_in_as'          => '<p><a class="logged-in-as">' . esc_html__('Logged in as ', 'aigency') . '<a href="' . esc_url(admin_url( 'profile.php' )) . '">' . esc_html(wp_get_current_user()->display_name) . '</a>. ' . '<a href="' . wp_logout_url( apply_filters( 'the_permalink', get_permalink() ) ) . '">' . esc_html__('Log out?', 'aigency') . '</a>' . '</p>',
                'submit_button'         => '<button name="%1$s" id="%2$s" class="%3$s">%4$s<span class="icon-button-icon"></span><span class="button-inner"></span></button>',
                'submit_field'          => '%1$s %2$s',
                'format' => $format
            );

        return $comment_form_args;
    }
}    

// Move Comment Message field in Comment form
add_filter( 'comment_form_fields', 'aigency_move_comment_fields' );
if ( !function_exists('aigency_move_comment_fields') ) {
    function aigency_move_comment_fields($fields) {
        if ( !function_exists('is_product') || !is_product() ) {
            $comment_field = $fields['comment'];
            $cookies_field = $fields['cookies'];
            unset($fields['comment']);
            unset($fields['cookies']);
            $fields['comment'] = $comment_field;
            $fields['cookies'] = $cookies_field;
        }
        return $fields;
    }
}

// WPForms Plugin Dropdown Menu Fix
if ( function_exists( 'wpforms') ) {
    add_action( 'wpforms_display_field_select', 'aigency_wpform_start_select_wrapper', 5, 1 );
    if ( !function_exists('aigency_wpform_start_select_wrapper') ) {
        function aigency_wpform_start_select_wrapper($field) {
            echo '<div class="select-wrap' . (isset($field['multiple']) && !empty($field['multiple']) ? ' multiple' : '') . (!empty($field['size']) && isset($field['size']) ? ' wpforms-field-' . esc_attr($field['size']) : '') . '">';
        }
    }
    add_action( 'wpforms_display_field_select', 'aigency_wpform_finish_select_wrapper', 15 );
    if ( !function_exists('aigency_wpform_finish_select_wrapper') ) {
        function aigency_wpform_finish_select_wrapper() {
            echo '</div>';
        }
    }
}

// Custom Password Form
add_filter( 'the_password_form', 'aigency_password_form' );
if ( !function_exists('aigency_password_form') ) {
    function aigency_password_form() {
        global $post;
        $out = '<form action="' . esc_url(site_url('wp-login.php?action=postpass', 'login_post')) . '" class="post-password-form" method="post"><p>' . esc_html__('This content is password protected. To view it please enter your password below:', 'aigency') . '</p><p><label for="password"><input name="post_password" id="password" type="password" placeholder="' . esc_attr__('Password', 'aigency') . '" size="20" required /></label><button name="Submit">' . esc_html__('Enter', 'aigency') . '</button></p></form>';
        return $out;
    }
}

// Set Elementor Features Default Values
add_action( 'elementor/experiments/feature-registered', 'aigency_elementor_features_set_default', 10, 2 );
if ( !function_exists('aigency_elementor_features_set_default') ) {
    function aigency_elementor_features_set_default( Elementor\Core\Experiments\Manager $experiments_manager ) {
        $experiments_manager->set_feature_default_state('e_dom_optimization', 'inactive');
    }
}

// Set custom palette in customizer colorpicker
add_action( 'customize_controls_enqueue_scripts', 'aigency_custom_color_palette' );
if ( !function_exists('aigency_custom_color_palette') ) {
    function aigency_custom_color_palette() {
        $color_palettes = json_encode(aigency_get_custom_color_palette());
        wp_add_inline_script('wp-color-picker', 'jQuery.wp.wpColorPicker.prototype.options.palettes = ' . sprintf('%s', $color_palettes) . ';');
    }
}

// Filter for widgets
add_filter( 'dynamic_sidebar_params', 'aigency_dynamic_sidebar_params' );
if (!function_exists('aigency_dynamic_sidebar_params')) {
    function aigency_dynamic_sidebar_params($sidebar_params) {
        if (is_admin()) {
            return $sidebar_params;
        }
        global $wp_registered_widgets;
        $widget_id = $sidebar_params[0]['widget_id'];
        $wp_registered_widgets[$widget_id]['original_callback'] = $wp_registered_widgets[$widget_id]['callback'];
        $wp_registered_widgets[$widget_id]['callback'] = 'aigency_widget_callback_function';

        return $sidebar_params;
    }
}
add_filter( 'widget_output', 'aigency_output_filter', 10, 3 );
if (!function_exists('aigency_output_filter')) {
    function aigency_output_filter($widget_output, $widget_id_base, $widget_id) {
        if ($widget_id_base != 'woocommerce_product_categories' && $widget_id_base != 'wpforms-widget' && $widget_id_base != 'block') {
            $widget_output = str_replace('<select', '<div class="select-wrap"><select', $widget_output);
            $widget_output = str_replace('</select>', '</select></div>', $widget_output);
        }

        return $widget_output;
    }
}

// Admin Footer
add_filter('admin_footer', 'aigency_admin_footer');
if (!function_exists('aigency_admin_footer')) {
    function aigency_admin_footer() {
        if (strlen(get_page_template_slug())>0) {
            echo "<input type='hidden' name='' value='" . (get_page_template_slug() ? get_page_template_slug() : '') . "' class='aigency_this_template_file'>";
        }
    }
}

// Remove post format parameter
add_filter('preview_post_link', 'aigency_remove_post_format_parameter', 9999);
if (!function_exists('aigency_remove_post_format_parameter')) {
    function aigency_remove_post_format_parameter($url) {
        $url = remove_query_arg('post_format', $url);
        return $url;
    }
}

// Post excerpt customize
add_filter( 'excerpt_length', function() {
    return 41;
} );
add_filter( 'excerpt_more', function(){
    return '...';
} );

// Wrap pagination links
add_filter( 'paginate_links_output', 'aigency_wrap_pagination_links', 10, 2 );
if ( !function_exists('aigency_wrap_pagination_links') ) {
    function aigency_wrap_pagination_links($template, $args) {
        if(class_exists('WooCommerce') && (is_shop() || is_product_category() || is_product_taxonomy() || is_product_tag() || wc_get_loop_prop('is_shortcode'))) {
            $template = '<nav class="navigation pagination" role="navigation">' .
                '<h2 class="screen-reader-text">' . esc_html__('Pagination', 'aigency') . '</h2>' .
                '<div class="nav-links">' . 
                    $template . 
                '</div>' .
            '</nav>';
        }
        return $template;
    }
}

//Add Ajax Actions
add_action('wp_ajax_pagination', 'aigency_ajax_pagination');
add_action('wp_ajax_nopriv_pagination', 'aigency_ajax_pagination');

//Construct Loop & Results
if ( !function_exists('aigency_ajax_pagination') ) {
    function aigency_ajax_pagination() {

        $paged              = (isset($_POST['paged'])) ? intval($_POST['paged']) : 1;
        $filter_term        = (isset($_POST['filter_term'])) ? sanitize_key($_POST['filter_term']) : null;
        $filter_taxonomy    = (isset($_POST['filter_taxonomy'])) ? sanitize_key($_POST['filter_taxonomy']) : null;
        $args               = (isset($_POST['args'])) ? json_decode(stripslashes($_POST['args']), true) : array();
        $args               = array_merge($args, array('paged' => $paged));
        if (!empty($filter_term) && !empty($filter_taxonomy) && $filter_term != 'all') {
            $args = array_merge($args, array($filter_taxonomy => $filter_term));
        }
        $post_type          = isset($args['post_type']) ? sanitize_key($args['post_type']) : 'post';
        $widget             = (isset($_POST['widget'])) ? json_decode(stripslashes($_POST['widget']), true) : array();
        $listing_type       = isset($widget['listing_type']) ? sanitize_key($widget['listing_type']) : '';
        $query              = new WP_Query($args);

        $wrapper_class      = isset($_POST['classes']) ? sanitize_text_field($_POST['classes']) : '';
        $id                 = isset($_POST['id']) ? sanitize_text_field($_POST['id']) : '';

        echo '<div class="' . esc_attr($wrapper_class) . '">';
	        while ($query->have_posts()) {
	            $query->the_post();
	            get_template_part('content', $post_type, $widget);
	        };
	        if ( $listing_type == 'masonry') {
	            echo '<div class="grid-sizer"></div>';
	        }
	        wp_reset_postdata();
	    echo '</div>';

        if(isset($widget['show_pagination']) && $widget['show_pagination'] == 'yes' && $query->max_num_pages > 1) {
	        echo '<div class="content-pagination">';
	            echo '<nav class="navigation pagination" role="navigation">';
	                echo '<h2 class="screen-reader-text">' . esc_html__('Pagination', 'aigency') . '</h2>';
	                echo '<div class="nav-links">';
	                    echo paginate_links( array(
	                        'base'      => ( isset($args['link_base']) ? esc_url($args['link_base']) : '' ) . '/?' . esc_attr($id) . '-paged=%#%',
	                        'current'   => max( 1, absint($paged) ),
	                        'total'     => absint($query->max_num_pages),
	                        'end_size'  => 2,
	                        'before_page_number' => '<span class="button-inner"></span>',
	                        'prev_text' => esc_html__('Previous', 'aigency') . '<span class="button-inner"></span><span class="icon-button-icon"></span>',
	                        'next_text' => esc_html__('Next', 'aigency') . '<span class="button-inner"></span><span class="icon-button-icon"></span>',                        
	                        'add_args'  => false
	                    ) );
	                echo '</div>';
	            echo '</nav>';
	        echo '</div>';
	    }

        die();
    }
}

// Customize WP-Blocks Output
if ( !function_exists('aigency_wpblock_widget_render') ) {
    function aigency_wpblock_widget_render($block_content, $block) {

        if ( $block['blockName'] == 'core/file' ) {
            $block_content = str_replace('</a></div>', '<span class="button-inner"></span><span class="icon-button-icon"></span></a></div>', $block_content);
        }

        if ( $block['blockName'] == 'core/list' ) {
            $classes = 'wp-block-list';
            if(!empty($block['attrs']['fontSize'])) {
                $classes .= ' has-' . $block['attrs']['fontSize'] . '-font-size';
            }
            if(!empty($block['attrs']['textColor'])) {
                $classes .= ' has-text-color has-' . $block['attrs']['textColor'] . '-color';
            }
            if(!empty($block['attrs']['backgroundColor'])) {
                $classes .= ' has-background has-' . $block['attrs']['backgroundColor'] . '-background-color';
            }
            if(!empty($block['attrs']['style']['color']['background'])) {
                $classes .= ' has-background';
            }
            
            $block_content = str_replace('<ul', '<ul class="' . esc_attr($classes) . '"', $block_content);
        }

        if (
            isset($block['attrs']['displayAsDropdown']) && $block['attrs']['displayAsDropdown'] === true
        ) {
            $block_content = str_replace('<select', '<div class="select-wrap"><select', $block_content);
            $block_content = str_replace('</select>', '</select></div>', $block_content);
        }

        if ( $block['blockName'] == 'core/button' ) {
            if(strpos($block['innerHTML'], 'is-style-outline') === false && strpos($block['innerHTML'], 'is-style-fill') === false) {
                $block_content = str_replace('</a>', '<span class="button-inner"></span></a>', $block_content);
            }
        }

        if (
            ( $block['blockName'] == 'core/search') ||
            ( $block['blockName'] == 'woocommerce/product-search' )
        ) {
            $block_content = str_replace('</button>', '<span class="button-inner"></span></button>', $block_content);
        }

        if (
            ( $block['blockName'] == 'core/search' && isset($block['attrs']['buttonUseIcon']) && $block['attrs']['buttonUseIcon'] === true ) ||
            ( $block['blockName'] == 'woocommerce/product-search' )
        ) {
            $block_content = preg_replace('/<svg\s+.*(<\/svg>)/s', '', $block_content);
        }

        if ( $block['blockName'] == 'core/loginout' && isset($block['attrs']['displayLoginAsForm']) && $block['attrs']['displayLoginAsForm'] === true ) {
            $block_content = str_replace('id="user_login"', 'id="user_login" placeholder="' . esc_html__('Username or Email Address', 'aigency') . '"', $block_content);
            $block_content = str_replace('id="user_pass"', 'id="user_pass" placeholder="' . esc_html__('Password', 'aigency') . '"', $block_content);
            $block_content = preg_replace('/<label for.*<\/label>/', '', $block_content);
        }

        if (
            $block['blockName'] == 'core/latest-posts'
        ) {
            if ( isset($block['attrs']['displayFeaturedImage']) && $block['attrs']['displayFeaturedImage'] == true && isset($block['attrs']['featuredImageAlign']) && ($block['attrs']['featuredImageAlign'] == 'left' || $block['attrs']['featuredImageAlign'] == 'right') ) {
                $block_content = str_replace('<a class="wp-block-latest-posts__post-title', '<div class="wp-block-latest-posts__content"><a class="wp-block-latest-posts__post-title', $block_content);
                $block_content = str_replace('</li>', '</div></li>', $block_content);
            }
        }

        return $block_content;
    }
}

add_filter( 'render_block', 'aigency_wpblock_widget_render', 10, 2 );

// Adding New Style to WP Blocks
if ( !function_exists('filter_metadata_registration') ) {
    function filter_metadata_registration($metadata) {        
        if ( $metadata['name'] == 'core/button' ) {
            $styles_button = [
                [
                    'name'      => 'fill',
                    'label'     => esc_html__('Fill', 'aigency')
                ],
                [
                    'name'      => 'outline',
                    'label'     => esc_html__('Outline', 'aigency'),
                ],
                [
                    'name'      => 'theme',
                    'label'     => esc_html__('Theme', 'aigency'),
                    'isDefault' => true
                ],
            ];
            $metadata['styles'] = $styles_button;
        }
        return $metadata;
    }
}
add_filter( 'block_type_metadata', 'filter_metadata_registration', 10, 2 );