<?php
/**
 * This is an auxiliary file of dynamic theme styles.
 * Here all the theme typography settings are connected to the styles.
 *
 * @package WordPress
 * @subpackage Aigency
 * @author Artureanec
 * @since Aigency 1.0
 * @version 1.0
 */

// -------------------------------- //
// ------- Additional Fonts ------- //
// -------------------------------- //
$aigency_custom_css .= "        
    @font-face {
        font-family: 'Manrope Alt';
        src: url('" . get_template_directory_uri() . "/fonts/Manrope-ExtraLight.ttf') format('truetype');             
        font-weight: 200;
        font-style: normal;
    }
    @font-face {
        font-family: 'Manrope Alt';
        src: url('" . get_template_directory_uri() . "/fonts/Manrope-Light.ttf') format('truetype');             
        font-weight: 300;
        font-style: normal;
    }    
    @font-face {
        font-family: 'Manrope Alt';
        src: url('" . get_template_directory_uri() . "/fonts/Manrope-Regular.ttf') format('truetype');             
        font-weight: normal;
        font-style: normal;
    }
    @font-face {
        font-family: 'Manrope Alt';
        src: url('" . get_template_directory_uri() . "/fonts/Manrope-Medium.ttf') format('truetype');             
        font-weight: 500;
        font-style: normal;
    }
    @font-face {
        font-family: 'Manrope Alt';
        src: url('" . get_template_directory_uri() . "/fonts/Manrope-SemiBold.ttf') format('truetype');             
        font-weight: 600;
        font-style: normal;
    }
    @font-face {
        font-family: 'Manrope Alt';
        src: url('" . get_template_directory_uri() . "/fonts/Manrope-Bold.ttf') format('truetype');             
        font-weight: bold;
        font-style: normal;
    }
    @font-face {
        font-family: 'Manrope Alt';
        src: url('" . get_template_directory_uri() . "/fonts/Manrope-ExtraBold.ttf') format('truetype');             
        font-weight: 800;
        font-style: normal;
    }
";

// --------------------------------- //
// ------ Typography Settings ------ //
// --------------------------------- //

if ( did_action('elementor/loaded') ) {
    $kit                    = \Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend();
    $active_breakpoints     = array_reverse($kit->get_settings('active_breakpoints'));
    $properties             = ['font_size', 'line_height', 'letter_spacing', 'word_spacing', 'font_family', 'text_transform', 'font_style', 'font_weight', 'text_decoration'];
    $tags                   = ['body', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'button'];
    $flag                   = false;
    $part_css               = '';

    foreach ($tags as $tag) {
        $tag_css = '';

        foreach ($properties as $property) {
            if (
                $kit->get_settings($tag . '_typography_typography') == 'custom' &&
                is_array($kit->get_settings($tag . '_typography_' . $property)) &&
                isset($kit->get_settings($tag . '_typography_' . $property)['size']) &&
                !empty($kit->get_settings($tag . '_typography_' . $property)['size'])
            ) {
                $tag_css .= "\t" . str_replace('_', '-', $property) . ': ' . esc_attr($kit->get_settings($tag . '_typography_' . $property)['size'] . $kit->get_settings($tag . '_typography_' . $property)['unit']) . ';' . PHP_EOL;
            } else if (
                $kit->get_settings($tag . '_typography_typography') == 'custom' &&
                !is_array($kit->get_settings($tag . '_typography_' . $property)) &&
                !empty($kit->get_settings($tag . '_typography_' . $property))
            ) {
                $tag_css .= "\t" . str_replace('_', '-', $property) . ': ' . esc_attr($kit->get_settings($tag . '_typography_' . $property)) . ';' . PHP_EOL;
            }
        }
        if ( $kit->get_settings($tag . '_typography_typography') == 'custom' && !empty($tag_css) ) {
            switch ($tag) {
                case 'body':
                    $part_css .=
                        '.wp-block-post-content,' . PHP_EOL .
                        '.aigency-front-end {' . PHP_EOL;
                    break;
                case 'button':
                    $part_css .=
                        '.wp-block-button .wp-block-button__link,' . PHP_EOL .
                        'button[type="submit"],' . PHP_EOL .
                        'button.submit,' . PHP_EOL .
                        'div.wpforms-container-full input[type=submit],' . PHP_EOL .
                        'div.wpforms-container-full button[type=submit],' . PHP_EOL .
                        'div.wpforms-container-full .wpforms-page-button,' . PHP_EOL .
                        '.woocommerce button.button,' . PHP_EOL .
                        '.woocommerce a.button,' . PHP_EOL .
                        '.woocommerce input.button,' . PHP_EOL .
                        '.woocommerce a.added_to_cart,' . PHP_EOL .
                        '#add_payment_method .wc-proceed-to-checkout a.checkout-button,' . PHP_EOL .
                        '.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,' . PHP_EOL .
                        '.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,' . PHP_EOL .
                        '.wp-block-file a.wp-block-file__button,' . PHP_EOL .
                        '.aigency-button {' . PHP_EOL;
                    break;
                default:
                    $part_css .=
                        '.wp-block-post-content ' . esc_attr($tag) . ',' . PHP_EOL .
                        'body.aigency-front-end ' . esc_attr($tag) . ',' . PHP_EOL .
                        '.wp-block-post-content .aigency-title-' . esc_attr($tag) . ',' . PHP_EOL .
                        'body.aigency-front-end .aigency-title-' . esc_attr($tag) . ' {' . PHP_EOL;
            }
                $part_css .= strip_tags($tag_css);
            $part_css .= '}' . PHP_EOL;
        }
    }
    if (
        is_array($kit->get_settings('paragraph_spacing')) &&
        isset($kit->get_settings('paragraph_spacing')['size']) &&
        !empty($kit->get_settings('paragraph_spacing')['size'])
    ) {
        $flag = true;
        $part_css .=
            '.body-container p,' . PHP_EOL .
            '.wp-block-post-content p,' . PHP_EOL .
            '.aigency-front-end p {' . PHP_EOL .
                "\t" . 'margin-top: ' . esc_attr($kit->get_settings('paragraph_spacing')['size'] . $kit->get_settings('paragraph_spacing')['unit']) . ';' . PHP_EOL .
                "\t" . 'margin-bottom: ' . esc_attr($kit->get_settings('paragraph_spacing')['size'] . $kit->get_settings('paragraph_spacing')['unit']) . ';' . PHP_EOL .
            '}' . PHP_EOL;
    } else {
        $part_css .=
            '.body-container p,' . PHP_EOL .
            '.wp-block-post-content p,' . PHP_EOL .
            '.aigency-front-end p {' . PHP_EOL .
                "\t" . 'margin-top: 1.875em;' . PHP_EOL .
                "\t" . 'margin-bottom: 1.875em;' . PHP_EOL .
            '}' . PHP_EOL;
    }
    if ( !empty($part_css) ) {
        $aigency_custom_css .= strip_tags($part_css);
    }

    foreach ($active_breakpoints as $name) {
        $slug       = str_replace('viewport_', '', $name);
        $part_css   = '';

        foreach ($tags as $tag) {
            $tag_css = '';

            foreach ($properties as $property) {
                if (
                    $kit->get_settings($tag . '_typography_typography') == 'custom' &&
                    is_array($kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))) &&
                    isset($kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))['size']) &&
                    !empty($kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))['size'])
                ) {
                    $flag = true;
                    $tag_css .= "\t\t" . str_replace('_', '-', $property) . ': ' . esc_attr($kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))['size'] . $kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))['unit']) . ';' . PHP_EOL;
                }
            }
            if ( $kit->get_settings($tag . '_typography_typography') == 'custom' && !empty($tag_css) ) {
                switch ($tag) {
                    case 'body':
                        $part_css .=
                            "\t" . '.wp-block-post-content,' . PHP_EOL .
                            "\t" . '.aigency-front-end {' . PHP_EOL;
                        break;
                    case 'button':
                        $part_css .= 
                        "\t" . '.wp-block-button .wp-block-button__link,' . PHP_EOL .
                        "\t" . 'button[type="submit"],' . PHP_EOL .
                        "\t" . 'button.submit,' . PHP_EOL .
                        "\t" . 'div.wpforms-container-full input[type=submit],' . PHP_EOL .
                        "\t" . 'div.wpforms-container-full button[type=submit],' . PHP_EOL .
                        "\t" . 'div.wpforms-container-full .wpforms-page-button,' . PHP_EOL .
                        "\t" . '.woocommerce button.button,' . PHP_EOL .
                        "\t" . '.woocommerce a.button,' . PHP_EOL .
                        "\t" . '.woocommerce input.button,' . PHP_EOL .
                        "\t" . '.woocommerce a.added_to_cart,' . PHP_EOL .
                        "\t" . '#add_payment_method .wc-proceed-to-checkout a.checkout-button,' . PHP_EOL .
                        "\t" . '.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,' . PHP_EOL .
                        "\t" . '.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,' . PHP_EOL .
                        "\t" . '.wp-block-file a.wp-block-file__button,' . PHP_EOL .
                        "\t" . '.aigency-button {' . PHP_EOL;
                        break;
                    default:
                        $part_css .=
                            "\t" . '.wp-block-post-content ' . esc_attr($tag) . ',' . PHP_EOL .
                            "\t" . 'body.aigency-front-end ' . esc_attr($tag) . ',' . PHP_EOL .
                            "\t" . '.wp-block-post-content .aigency-title-' . esc_attr($tag) . ',' . PHP_EOL .
                            "\t" . 'body.aigency-front-end .aigency-title-' . esc_attr($tag) . ' {' . PHP_EOL;
                }
                    $part_css .= strip_tags($tag_css);
                $part_css .= "\t" . '}' . PHP_EOL;
            }
        }
        if (
            is_array($kit->get_settings('paragraph_spacing_' . esc_attr($slug))) &&
            isset($kit->get_settings('paragraph_spacing_' . esc_attr($slug))['size']) &&
            !empty($kit->get_settings('paragraph_spacing_' . esc_attr($slug))['size'])
        ) {
            $flag = true;
            $part_css .=
                "\t" . '.body-container p,' . PHP_EOL .
                "\t" . '.wp-block-post-content p,' . PHP_EOL .
                "\t" . '.aigency-front-end p {' . PHP_EOL .
                    "\t\t" . 'margin-top: ' . esc_attr($kit->get_settings('paragraph_spacing_' . esc_attr($slug))['size'] . $kit->get_settings('paragraph_spacing_' . esc_attr($slug))['unit']) . ';' . PHP_EOL .
                    "\t\t" . 'margin-bottom: ' . esc_attr($kit->get_settings('paragraph_spacing_' . esc_attr($slug))['size'] . $kit->get_settings('paragraph_spacing_' . esc_attr($slug))['unit']) . ';' . PHP_EOL .
                "\t" . '}' . PHP_EOL;
        }
        if ( $flag && !empty($part_css) ) {
            $aigency_custom_css .= '@media only screen and (' . ($name == 'viewport_widescreen' ? 'min-width' : 'max-width') . ': ' . esc_attr($kit->get_settings($name)) . 'px) {' . PHP_EOL . strip_tags($part_css) . '}' . PHP_EOL;
        }
    }    

} else {
    # Main Font
    $main_font          = aigency_get_prepared_option('main_font');
    $main_font_array    = json_decode($main_font, true);
    if (
        !empty($main_font_array['font_family']) ||
        !empty($main_font_array['font_size']) ||
        !empty($main_font_array['line_height']) ||
        !empty($main_font_array['text_transform']) ||
        !empty($main_font_array['letter_spacing']) ||
        !empty($main_font_array['word_spacing']) ||
        !empty($main_font_array['font_style']) ||
        !empty($main_font_array['font_weight'])
    ) {
        $aigency_custom_css .= '
            .wp-block-post-content,
            .aigency-front-end {' .
                aigency_print_font_styles( $main_font, array('font_family', 'font_size', 'line_height', 'text_transform', 'letter_spacing', 'word_spacing', 'font_style', 'font_weight') ) .
            '}
        ';
    }

    # Headings
    
    // H1
    $h1_font        = aigency_get_prepared_option('h1_font');
    $h1_font_array  = json_decode($h1_font, true);
    if (
        !empty($h1_font_array['font_family']) ||
        !empty($h1_font_array['text_transform']) ||
        !empty($h1_font_array['font_style']) ||
        !empty($h1_font_array['font_size']) ||
        !empty($h1_font_array['line_height']) ||
        !empty($h1_font_array['font_weight']) ||
        !empty($h1_font_array['letter_spacing']) ||
        !empty($h1_font_array['word_spacing'])
    ) {
        $aigency_custom_css .= '
            .wp-block-post-content h1,
            .aigency-front-end h1,
            .wp-block-post-content .aigency-title-h1,
            .aigency-front-end .aigency-title-h1 {' .
                aigency_print_font_styles( $h1_font, array('font_family', 'text_transform', 'font_style', 'font_size', 'line_height', 'font_weight', 'letter_spacing', 'word_spacing') ) .
            '}
        ';
    }

    // H2
    $h2_font        = aigency_get_prepared_option('h2_font');
    $h2_font_array  = json_decode($h2_font, true);
    if (
        !empty($h2_font_array['font_family']) ||
        !empty($h2_font_array['text_transform']) ||
        !empty($h2_font_array['font_style']) ||
        !empty($h2_font_array['font_size']) ||
        !empty($h2_font_array['line_height']) ||
        !empty($h2_font_array['font_weight']) ||
        !empty($h2_font_array['letter_spacing']) ||
        !empty($h2_font_array['word_spacing'])
    ) {
        $aigency_custom_css .= '
            .wp-block-post-content h2,
            .aigency-front-end h2,
            .wp-block-post-content .aigency-title-h2,
            .aigency-front-end .aigency-title-h2 {' .
                aigency_print_font_styles( $h2_font, array('font_family', 'text_transform', 'font_style', 'font_size', 'line_height', 'font_weight', 'letter_spacing', 'word_spacing') ) .
            '}
        ';
    }

    // H3
    $h3_font        = aigency_get_prepared_option('h3_font');
    $h3_font_array  = json_decode($h3_font, true);
    if (
        !empty($h3_font_array['font_family']) ||
        !empty($h3_font_array['text_transform']) ||
        !empty($h3_font_array['font_style']) ||
        !empty($h3_font_array['font_size']) ||
        !empty($h3_font_array['line_height']) ||
        !empty($h3_font_array['font_weight']) ||
        !empty($h3_font_array['letter_spacing']) ||
        !empty($h3_font_array['word_spacing'])
    ) {
        $aigency_custom_css .= '
            .wp-block-post-content h3,
            .aigency-front-end h3,
            .wp-block-post-content .aigency-title-h3,
            .aigency-front-end .aigency-title-h3 {' .
                aigency_print_font_styles( $h3_font, array('font_family', 'text_transform', 'font_style', 'font_size', 'line_height', 'font_weight', 'letter_spacing', 'word_spacing') ) .
            '}
        ';
    }

    // H4
    $h4_font        = aigency_get_prepared_option('h4_font');
    $h4_font_array  = json_decode($h4_font, true);
    if (
        !empty($h4_font_array['font_family']) ||
        !empty($h4_font_array['text_transform']) ||
        !empty($h4_font_array['font_style']) ||
        !empty($h4_font_array['font_size']) ||
        !empty($h4_font_array['line_height']) ||
        !empty($h4_font_array['font_weight']) ||
        !empty($h4_font_array['letter_spacing']) ||
        !empty($h4_font_array['word_spacing'])
    ) {
        $aigency_custom_css .= '
            .wp-block-post-content h4,
            .aigency-front-end h4,
            .wp-block-post-content .aigency-title-h4,
            .aigency-front-end .aigency-title-h4 {' .
                aigency_print_font_styles( $h4_font, array('font_family', 'text_transform', 'font_style', 'font_size', 'line_height', 'font_weight', 'letter_spacing', 'word_spacing') ) .
            '}
        ';
    }

    // H5
    $h5_font        = aigency_get_prepared_option('h5_font');
    $h5_font_array  = json_decode($h5_font, true);
    if (
        !empty($h5_font_array['font_family']) ||
        !empty($h5_font_array['text_transform']) ||
        !empty($h5_font_array['font_style']) ||
        !empty($h5_font_array['font_size']) ||
        !empty($h5_font_array['line_height']) ||
        !empty($h5_font_array['font_weight']) ||
        !empty($h5_font_array['letter_spacing']) ||
        !empty($h5_font_array['word_spacing'])
    ) {
        $aigency_custom_css .= '
            .wp-block-post-content h5,
            .aigency-front-end h5,
            .widget_block .widget-wrapper h1,
            .widget_block .widget-wrapper h2,
            .widget_block .widget-wrapper h3,
            .widget_block .widget-wrapper h4,
            .wp-block-search .wp-block-search__label,
            .wp-block-post-content .aigency-title-h5,
            .aigency-front-end .aigency-title-h5 {' .
                aigency_print_font_styles( $h5_font, array('font_family', 'text_transform', 'font_style', 'font_size', 'line_height', 'font_weight', 'letter_spacing', 'word_spacing') ) .
            '}
        ';
    }

    // H6
    $h6_font        = aigency_get_prepared_option('h6_font');
    $h6_font_array  = json_decode($h6_font, true);
    if (
        !empty($h6_font_array['font_family']) ||
        !empty($h6_font_array['text_transform']) ||
        !empty($h6_font_array['font_style']) ||
        !empty($h6_font_array['font_size']) ||
        !empty($h6_font_array['line_height']) ||
        !empty($h6_font_array['font_weight']) ||
        !empty($h6_font_array['letter_spacing']) ||
        !empty($h6_font_array['word_spacing'])
    ) {
        $aigency_custom_css .= '
            .wp-block-post-content h6,
            .aigency-front-end h6,
            .wp-block-post-content .aigency-title-h6,
            .aigency-front-end .aigency-title-h6 {' .
                aigency_print_font_styles( $h6_font, array('font_family', 'text_transform', 'font_style', 'font_size', 'line_height', 'font_weight', 'letter_spacing', 'word_spacing') ) .
            '}
        ';
    }

    # Buttons
    $buttons_font       = aigency_get_prepared_option('buttons_font');
    $buttons_font_array = json_decode($buttons_font, true);
    if (
        !empty($buttons_font_array['font_family']) ||
        !empty($buttons_font_array['font_size']) ||
        !empty($buttons_font_array['text_transform']) ||
        !empty($buttons_font_array['letter_spacing']) ||
        !empty($buttons_font_array['word_spacing']) ||
        !empty($buttons_font_array['font_style']) ||
        !empty($buttons_font_array['font_weight'])
    ) {
        $aigency_custom_css .= '            
            .wp-block-button .wp-block-button__link,
            button[type="submit"],
            button.submit,
            div.wpforms-container-full input[type=submit],
            div.wpforms-container-full button[type=submit],
            div.wpforms-container-full .wpforms-page-button,
            .woocommerce button.button,
            .woocommerce a.button,
            .woocommerce input.button,
            .woocommerce a.added_to_cart,
            #add_payment_method .wc-proceed-to-checkout a.checkout-button, 
            .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, 
            .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,
            .wp-block-file a.wp-block-file__button,
            .aigency-button {' .
                aigency_print_font_styles( $buttons_font, array('font_family', 'font_size', 'text_transform', 'letter_spacing', 'word_spacing', 'font_style', 'font_weight') ) .
            '}
        ';
    }

    # Responsive styles
    $viewport_tablet    = aigency_get_breackpoint_value('viewport_tablet');
    if ( !empty($viewport_tablet) ) {
        $aigency_custom_css .=
        '@media only screen and (max-width: ' . esc_attr($viewport_tablet) . 'px) {' . PHP_EOL .
            "\t" . '.wp-block-post-content,' . PHP_EOL .
            "\t" . '.aigency-front-end {' . PHP_EOL .
                "\t\t" . 'font-size: 16px;' . PHP_EOL .
            "\t" . '}' . PHP_EOL .
            "\t" . '.wp-block-post-content h1,' . PHP_EOL .
            "\t" . '.aigency-front-end h1 {' . PHP_EOL .
                "\t\t" . 'font-size: 60px;' . PHP_EOL .
            "\t" . '}' . PHP_EOL .
            "\t" . '.wp-block-post-content h2,' . PHP_EOL .
            "\t" . '.aigency-front-end h2 {' . PHP_EOL .
                "\t\t" . 'font-size: 35px;' . PHP_EOL .
            "\t" . '}' . PHP_EOL .
            "\t" . '.wp-block-post-content h3,' . PHP_EOL .
            "\t" . '.aigency-front-end h3 {' . PHP_EOL .
                "\t\t" . 'font-size: 30px;' . PHP_EOL .
            "\t" . '}' . PHP_EOL .
            "\t" . '.wp-block-post-content h4,' . PHP_EOL .
            "\t" . '.aigency-front-end h4 {' . PHP_EOL .
                "\t\t" . 'font-size: 25px;' . PHP_EOL .
            "\t" . '}' . PHP_EOL .
            "\t" . '.widget_block .widget-wrapper h1,' . PHP_EOL .
            "\t" . '.widget_block .widget-wrapper h2,' . PHP_EOL .
            "\t" . '.widget_block .widget-wrapper h3,' . PHP_EOL .
            "\t" . '.widget_block .widget-wrapper h4,' . PHP_EOL .
            "\t" . '.wp-block-search .wp-block-search__label,' . PHP_EOL .            
            "\t" . '.wp-block-post-content h5,' . PHP_EOL .
            "\t" . '.aigency-front-end h5 {' . PHP_EOL .
                "\t\t" . 'font-size: 20px;' . PHP_EOL .
            "\t" . '}' . PHP_EOL .
            "\t" . '.wp-block-post-content h6,' . PHP_EOL .
            "\t" . '.aigency-front-end h6 {' . PHP_EOL .
                "\t\t" . 'font-size: 18px;' . PHP_EOL .
            "\t" . '}' . PHP_EOL .
        '}' . PHP_EOL;
    }    
}