<?php

// ----------------------------- //
// ------ Standard Colors ------ //
// ----------------------------- //

$standard_default_text_color = aigency_get_prefered_option('standard_default_text_color');
$standard_accent_text_color = aigency_get_prefered_option('standard_accent_text_color');
$standard_border_color = aigency_get_prefered_option('standard_border_color');


if ( !empty($standard_default_text_color) ) {
    $aigency_custom_css .= '
        .footer .footer-columns-row,
        .footer .footer-columns-row a,
        .footer .footer-additional-menu li a {
            color: rgba(' . esc_attr(aigency_hex2rgb($standard_default_text_color)) . ', 0.75);
        }
    ';
}

if ( !empty($standard_border_color) ) {
    $aigency_custom_css .= '
        .team-contact-info-card .team-contact-info {
            border-color: rgba(' . esc_attr(aigency_hex2rgb($standard_border_color)) . ', 0.5);
        }
        .aigency-step-widget .step-item.step-item-type-extended .step-image:before {
            border-color: rgba(' . esc_attr(aigency_hex2rgb($standard_border_color)) . ', 0.3);
        }
    ';
}

$standard_button_border_style = aigency_get_prefered_option('standard_button_border_style');
if ( $standard_button_border_style == 'solid' ) {
    $aigency_custom_css .= '
        #form-preview button .button-inner,
        .body-container .aigency-button .button-inner,
        .elementor .aigency-button .button-inner,
        .body-container button:not(.customize-partial-edit-shortcut-button) .button-inner,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit] .button-inner, 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button .button-inner,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link:not(.has-background) .button-inner,
        .content-pagination .page-numbers .button-inner, 
        .content-pagination .post-page-numbers .button-inner,
        .filter-control-wrapper .filter-control-list .dot .button-inner, 
        .filter-control-wrapper .gallery-filter-control-list .dot .button-inner,
        .woocommerce #review_form #respond .submit .button-inner,
        .body-container .mc4wp-form .mc4wp-form-fields button .button-inner {
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
        }
    ';
}

$standard_button_border_color = aigency_get_prefered_option('standard_button_border_color');
$standard_button_border_color_add = aigency_get_prefered_option('standard_button_border_color_add');
if( $standard_button_border_style == 'gradient' && ( !empty($standard_button_border_color) && !empty($standard_button_border_color_add) )) {
    $aigency_custom_css .= '
        #form-preview button:after,
        .body-container .aigency-button:after,
        .elementor .aigency-button:after,
        .body-container button:not(.customize-partial-edit-shortcut-button):after,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit]:after, 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button:after,
        .body-container .mc4wp-form .mc4wp-form-fields button:after,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link:after,
        .content-pagination .page-numbers:after, 
        .content-pagination .post-page-numbers:after,
        .filter-control-wrapper .filter-control-list .dot:after, 
        .filter-control-wrapper .gallery-filter-control-list .dot:after,
        .woocommerce #review_form #respond .submit:after {
            background: linear-gradient(var(--button-border-gradient-angle), var(--aigency-standard-button-border-color) var(--button-gradient-colorstop-1), var(--aigency-standard-button-border-color-add) var(--button-gradient-colorstop-2));
        }
    ';
} elseif ( $standard_button_border_style == 'solid' && !empty($standard_button_border_color)) {
    $aigency_custom_css .= '
        #form-preview button,
        .body-container .aigency-button,
        .elementor .aigency-button,
        .body-container button:not(.customize-partial-edit-shortcut-button),
        .body-container div.wpforms-container-full .wpforms-form button[type=submit], 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button,
        .body-container .mc4wp-form .mc4wp-form-fields button,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link,        
        .content-pagination .page-numbers, 
        .content-pagination .post-page-numbers,
        .filter-control-wrapper .filter-control-list .dot, 
        .filter-control-wrapper .gallery-filter-control-list .dot,
        .woocommerce #review_form #respond .submit {
            border-color: var(--aigency-standard-button-border-color);
        }
    ';
}

if( !empty($standard_button_border_color) && !empty($standard_button_border_color_add) ) {
    $aigency_custom_css .= '        
        .single-post .post-meta-footer:not(:first-child):before {
            background: linear-gradient(var(--button-border-gradient-angle), var(--aigency-standard-button-border-color) var(--button-gradient-colorstop-1), var(--aigency-standard-button-border-color-add) var(--button-gradient-colorstop-2));
        }
        .sidebar .widget .widget-title:first-child, 
        .sidebar .widget .wp-block-heading:first-child, 
        .sidebar .widget .wp-block-search__label:first-child {
            border-image: linear-gradient(var(--button-border-gradient-angle), var(--aigency-standard-button-border-color) var(--button-gradient-colorstop-1), var(--aigency-standard-button-border-color-add) var(--button-gradient-colorstop-2)) 30;
        }
    ';
} elseif( !empty($standard_button_border_color) ) {
    $aigency_custom_css .= '
        .single-post .post-meta-footer:not(:first-child):before {
            background-color: var(--aigency-standard-button-border-color);
        }
        .sidebar .widget .widget-title:first-child, 
        .sidebar .widget .wp-block-heading:first-child, 
        .sidebar .widget .wp-block-search__label:first-child {
            border-color: var(--aigency-standard-button-border-color);
        }
    ';
}

if ( !empty($standard_button_border_color) ) {
    $aigency_custom_css .= '
        .wp-block-gallery .blocks-gallery-grid .blocks-gallery-item a:before, 
        .media_gallery .blocks-gallery-grid .blocks-gallery-item a:before,
        body .content-wrapper .gallery .gallery-item .gallery-icon a:before {
             background-color: rgba(' . esc_attr(aigency_hex2rgb($standard_accent_text_color)) . ', 0.5);
        }
    ';
}

$standard_button_background_style = aigency_get_prefered_option('standard_button_background_style');
$standard_button_background_color = aigency_get_prefered_option('standard_button_background_color');
$standard_button_background_color_add = aigency_get_prefered_option('standard_button_background_color_add');
if( $standard_button_background_style == 'gradient' && ( !empty($standard_button_background_color) && !empty($standard_button_background_color_add) )) {
    $aigency_custom_css .= '
        #form-preview button,
        .body-container button:not(.customize-partial-edit-shortcut-button),
        .body-container .aigency-button .button-inner:before,
        .elementor .aigency-button .button-inner:before,
        .comment-form button.submit .button-inner:before,
        .body-container input[type="submit"],
        .body-container input[type="button"],
        .body-container input[type="reset"],
        .body-container div.wpforms-container-full .wpforms-form input[type=submit]:not(:hover):not(:active),
        .body-container .aigency-button .button-inner:before,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit] .button-inner:before, 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button .button-inner:before,
        .body-container .wp-block-search .wp-block-search__button .button-inner:before,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link:not(.has-background) .button-inner:before,
        .content-pagination .page-numbers .button-inner:before, 
        .content-pagination .post-page-numbers .button-inner:before,
        .filter-control-wrapper .filter-control-list .dot .button-inner:before, 
        .filter-control-wrapper .gallery-filter-control-list .dot .button-inner:before,
        .woocommerce #review_form #respond .submit .button-inner:before,
        .body-container .mc4wp-form .mc4wp-form-fields button .button-inner:before {
            background: linear-gradient(var(--button-border-gradient-angle), var(--aigency-standard-button-background-color) var(--button-gradient-colorstop-1), var(--aigency-standard-button-background-color-add) var(--button-gradient-colorstop-2));
        }
        .comment-form button.submit,
        .body-container .wp-block-search .wp-block-search__button,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit], 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button,
        .body-container .mc4wp-form .mc4wp-form-fields button,
        .woocommerce #review_form #respond .submit,
        .project-listing-wrapper .project-audio-wrapper .aigency-button {
            background: none;
        }
    ';
} elseif ( $standard_button_background_style == 'solid' && !empty($standard_button_background_color)) {
    $aigency_custom_css .= '
        #form-preview button,
        .body-container .aigency-button,
        .elementor .aigency-button,
        .comment-form button.submit,
        .body-container button:not(.customize-partial-edit-shortcut-button),
        .body-container input[type="submit"],
        .body-container input[type="button"],
        .body-container input[type="reset"],
        .body-container div.wpforms-container-full .wpforms-form input[type=submit]:not(:hover):not(:active),   
        .body-container div.wpforms-container-full .wpforms-form button[type=submit]:not(:hover):not(:active), 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button:not(:hover):not(:active),
        .body-container .mc4wp-form .mc4wp-form-fields button,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link:not(.has-background),
        .content-pagination .page-numbers, 
        .content-pagination .post-page-numbers,
        .filter-control-wrapper .filter-control-list .dot, 
        .filter-control-wrapper .gallery-filter-control-list .dot,
        .woocommerce #review_form #respond .submit {
            background-color: var(--aigency-standard-button-background-color);
        }
    ';
}

$standard_button_border_hover = aigency_get_prefered_option('standard_button_border_hover');
$standard_button_border_hover_add = aigency_get_prefered_option('standard_button_border_hover_add');
if( $standard_button_border_style == 'gradient' && ( !empty($standard_button_border_hover) && !empty($standard_button_border_hover_add) )) {
    $aigency_custom_css .= '
        #form-preview button:hover:after,
        .body-container .aigency-button:hover:after,
        .elementor .aigency-button:hover:after,
        .body-container button:not(.customize-partial-edit-shortcut-button):hover:after,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link:hover:after,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit]:hover:after, 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button:hover:after,
        .body-container .mc4wp-form .mc4wp-form-fields button:hover:after,
        .content-pagination a.page-numbers:hover:after, 
        .content-pagination a.post-page-numbers:hover:after,
        .content-pagination .page-numbers.current:after, 
        .content-pagination .post-page-numbers.current:after,
        .filter-control-wrapper .filter-control-list .dot:hover:after, 
        .filter-control-wrapper .gallery-filter-control-list .dot:hover:after,
        .filter-control-wrapper .filter-control-list .dot.active:after, 
        .filter-control-wrapper .gallery-filter-control-list .dot.active:after,
        .project-slider-listing.content-type-audio .project-audio-wrapper .aigency-button.active:after,
        .woocommerce #review_form #respond .submit:hover:after {
            background: linear-gradient(var(--button-border-gradient-angle), var(--aigency-standard-button-border-hover) var(--button-gradient-colorstop-1), var(--aigency-standard-button-border-hover-add) var(--button-gradient-colorstop-2));
        }
    ';
} elseif ( $standard_button_border_style == 'solid' && !empty($standard_button_border_hover)) {
    $aigency_custom_css .= '
        #form-preview button:hover,
        .body-container .aigency-button:hover,
        .elementor .aigency-button:hover,
        .body-container button:not(.customize-partial-edit-shortcut-button):hover,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link:hover,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit]:hover, 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button:hover,
        .body-container .mc4wp-form .mc4wp-form-fields button:hover,
        .content-pagination a.page-numbers:hover, 
        .content-pagination a.post-page-numbers:hover,
        .content-pagination .page-numbers.current, 
        .content-pagination .post-page-numbers.current,
        .filter-control-wrapper .filter-control-list .dot:hover, 
        .filter-control-wrapper .gallery-filter-control-list .dot:hover,
        .filter-control-wrapper .filter-control-list .dot.active, 
        .filter-control-wrapper .gallery-filter-control-list .dot.active,
        .project-slider-listing.content-type-audio .project-audio-wrapper .aigency-button.active,
        .woocommerce #review_form #respond .submit:hover {
            border-color: var(--aigency-standard-button-border-hover);
        }
    ';
}

$standard_button_background_style = aigency_get_prefered_option('standard_button_background_style');
$standard_button_background_hover = aigency_get_prefered_option('standard_button_background_hover');
$standard_button_background_hover_add = aigency_get_prefered_option('standard_button_background_hover_add');
if( $standard_button_background_style == 'gradient' && ( !empty($standard_button_background_hover) && !empty($standard_button_background_hover_add) )) {
    $aigency_custom_css .= '
        #form-preview button:hover,
        .body-container button:not(.customize-partial-edit-shortcut-button):hover,
        .body-container input[type="submit"]:hover,
        .body-container input[type="button"]:hover,
        .body-container input[type="reset"]:hover,
        .body-container div.wpforms-container-full .wpforms-form input[type=submit]:hover,
        .body-container .aigency-button .button-inner:after,
        .elementor .aigency-button .button-inner:after,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit] .button-inner:after, 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button .button-inner:after,
        .body-container .wp-block-search .wp-block-search__button .button-inner:after,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link:not(.has-background) .button-inner:after,
        .content-pagination .page-numbers .button-inner:after, 
        .content-pagination .post-page-numbers .button-inner:after,
        .body-container .comment-form button.submit .button-inner:after,
        .filter-control-wrapper .filter-control-list .dot .button-inner:after, 
        .filter-control-wrapper .gallery-filter-control-list .dot .button-inner:after,
        .project-slider-listing.content-type-audio .project-audio-wrapper .aigency-button.active:after,
        .woocommerce #review_form #respond .submit .button-inner:after,
        .body-container .mc4wp-form .mc4wp-form-fields button .button-inner:after {
            background: linear-gradient(var(--button-border-gradient-angle), var(--aigency-standard-button-background-hover) var(--button-gradient-colorstop-1), var(--aigency-standard-button-background-hover-add) var(--button-gradient-colorstop-2));
        }
        .body-container .comment-form button.submit:hover,
        .body-container .wp-block-search .wp-block-search__button:hover,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit]:hover,
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button:hover,
        .body-container .mc4wp-form .mc4wp-form-fields button:hover,
        .project-listing-wrapper .project-audio-wrapper .aigency-button:hover {
            background: none;
        }
    ';
} elseif ( $standard_button_background_style == 'solid' && !empty($standard_button_background_hover)) {
    $aigency_custom_css .= '
        #form-preview button:hover,
        .body-container .aigency-button:hover,
        .elementor .aigency-button:hover,
        .body-container button:not(.customize-partial-edit-shortcut-button):hover,
        .body-container input[type="submit"]:hover,
        .body-container input[type="button"]:hover,
        .body-container input[type="reset"]:hover,
        .body-container div.wpforms-container-full .wpforms-form input[type=submit]:hover,
        .body-container div.wpforms-container-full .wpforms-form button[type=submit]:hover, 
        .body-container div.wpforms-container-full .wpforms-form .wpforms-page-button:hover,
        .sidebar .wp-block-button:not(.is-style-outline):not(.is-style-fill) .wp-block-button__link:not(.has-background):hover,
        .content-pagination .page-numbers.current, 
        .content-pagination .post-page-numbers.current,
        .content-pagination .page-numbers:hover, 
        .content-pagination .post-page-numbers:hover,
        .body-container .comment-form button.submit:hover,
        .filter-control-wrapper .filter-control-list .dot:hover, 
        .filter-control-wrapper .gallery-filter-control-list .dot:hover,
        .filter-control-wrapper .filter-control-list .dot.active, 
        .filter-control-wrapper .gallery-filter-control-list .dot.active,
        .project-slider-listing.content-type-audio .project-audio-wrapper .aigency-button.active,
        .woocommerce #review_form #respond .submit:hover,
        .body-container .mc4wp-form .mc4wp-form-fields button:hover {
            background-color: var(--aigency-standard-button-background-hover);
        }
    ';
}

if( function_exists('hfe_init') && class_exists( 'Mega_Menu' ) ) {
    $standard_dark_text_color = aigency_get_prefered_option('standard_dark_text_color');
    if ( !empty($standard_dark_text_color) ) {
        $aigency_custom_css .= '
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item > a.mega-menu-link,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title {
                color: var(--aigency-header-dark-text-color, var(--aigency-standard-dark-text-color));
            }
        ';
    }

    $standard_accent_text_color = aigency_get_prefered_option('standard_accent_text_color');
    if ( !empty($standard_accent_text_color) ) {
        $aigency_custom_css .= '
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item a.mega-menu-link:hover, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:hover,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:focus,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, 
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link,
            .mobile-header-menu-container #mega-menu-wrap-main #mega-menu-main > li.mega-menu-flyout.mega-menu-item.mega-toggle-on a.mega-menu-link {
                color: var(--aigency-header-accent-text-color, var(--aigency-standard-accent-text-color));
            }
        ';
    }
}