<?php
/**
 * This is an auxiliary file of dynamic theme styles.
 * This is where all CSS variables of the theme are defined
 * and connected to styles.
 *
 * @package WordPress
 * @subpackage Aigency
 * @author Artureanec
 * @since Aigency 1.0
 * @version 1.0
 */

global $aigency_custom_css;

// ----------------------- //
// ------ Variables ------ //
// ----------------------- //

$aigency_custom_css .= ':root {' . PHP_EOL;

// Layout variables
    $viewport_mobile = aigency_get_breackpoint_value('viewport_mobile');
    if ( !empty($viewport_mobile) ) $aigency_custom_css .= "\t" . '--aigency-viewport-mobile: ' . esc_attr($viewport_mobile) . 'px;' . PHP_EOL;

    $viewport_mobile_extra = aigency_get_breackpoint_value('viewport_mobile_extra');
    if ( !empty($viewport_mobile_extra) ) $aigency_custom_css .= "\t" . '--aigency-viewport-mobile-extra: ' . esc_attr($viewport_mobile_extra) . 'px;' . PHP_EOL;

    $viewport_tablet = aigency_get_breackpoint_value('viewport_tablet');
    if ( !empty($viewport_tablet) ) $aigency_custom_css .= "\t" . '--aigency-viewport-tablet: ' . esc_attr($viewport_tablet) . 'px;' . PHP_EOL;

    $viewport_tablet_extra = aigency_get_breackpoint_value('viewport_tablet_extra');
    if ( !empty($viewport_tablet_extra) ) $aigency_custom_css .= "\t" . '--aigency-viewport-tablet-extra: ' . esc_attr($viewport_tablet_extra) . 'px;' . PHP_EOL;

    $viewport_laptop = aigency_get_breackpoint_value('viewport_laptop');
    if ( !empty($viewport_laptop) ) $aigency_custom_css .= "\t" . '--aigency-viewport-laptop: ' . esc_attr($viewport_laptop) . 'px;' . PHP_EOL;

    $viewport_widescreen = aigency_get_breackpoint_value('viewport_widescreen');
    if ( !empty($viewport_widescreen) ) $aigency_custom_css .= "\t" . '--aigency-viewport-widescreen: ' . esc_attr($viewport_widescreen) . 'px;' . PHP_EOL;

    $aigency_custom_css .= PHP_EOL; // CSS section separator

    $content_width = aigency_get_elementor_setting_value('container_width');
    if ( !empty($content_width['size']) ) $aigency_custom_css .= "\t" . '--aigency-content-width: ' . esc_attr($content_width['size']) . esc_attr($content_width['unit']) . ';' . PHP_EOL;

    $aigency_custom_css .= PHP_EOL; // CSS section separator


// Standard color variables
    $standard_colors     = ['default_text_color', 'dark_text_color', 'light_text_color', 'accent_text_color', 'contrast_text_color', 'input_dark_color', 'border_color', 'border_hover_color', 'background_color', 'background_alter_color', 'button_text_color', 'button_border_color', 'button_border_color_add', 'button_background_color', 'button_background_color_add', 'button_text_hover', 'button_border_hover', 'button_border_hover_add', 'button_background_hover', 'button_background_hover_add'];
    $variable   = '';

    foreach ($standard_colors as $color) {
        $variable = aigency_get_prefered_option('standard_' . $color);
        if ( !empty($variable) ) $aigency_custom_css .= "\t" . '--aigency-standard-' . str_replace('_', '-', $color) . ': ' . esc_attr($variable) . ';' . PHP_EOL;
    }
    $aigency_custom_css .= PHP_EOL; // CSS section separator

// Contrast color variables
    $excluded_colors = ['contrast_text_color'];
    $contrast_colors = array_diff($standard_colors, $excluded_colors);
    foreach ($contrast_colors as $color) {
        $variable = aigency_get_prefered_option('contrast_' . $color);
        if ( !empty($variable) ) $aigency_custom_css .= "\t" . '--aigency-contrast-' . str_replace('_', '-', $color) . ': ' . esc_attr($variable) . ';' . PHP_EOL;
    }

    if( aigency_get_prefered_option('footer_scrolltop_status') == 'on' ) {
    	// Scroll Top Colors
	    $footer_scrolltop_bg_color = aigency_get_prepared_option('footer_scrolltop_bg_color', 'standard_accent_text_color', 'footer_scrolltop_status');
		if ( !empty($footer_scrolltop_bg_color) ) {
		    $aigency_custom_css .= "\t" . '--aigency-footer-scrolltop-bg-color: ' . esc_attr($footer_scrolltop_bg_color) . ';' . PHP_EOL;	    
		}

        $footer_scrolltop_bg_color_add = aigency_get_prepared_option('footer_scrolltop_bg_color_add', 'standard_accent_text_color', 'footer_scrolltop_status');
        if ( !empty($footer_scrolltop_bg_color_add) ) {
            $aigency_custom_css .= "\t" . '--aigency-footer-scrolltop-bg-color-add: ' . esc_attr($footer_scrolltop_bg_color_add) . ';' . PHP_EOL;       
        }

		$footer_scrolltop_bg_color_hover = aigency_get_prepared_option('footer_scrolltop_bg_color_hover', 'standard_dark_text_color', 'footer_scrolltop_status');
		if ( !empty($footer_scrolltop_bg_color_hover) ) {
		    $aigency_custom_css .= "\t" . '--aigency-footer-scrolltop-bg-color-hover: ' . esc_attr($footer_scrolltop_bg_color_hover) . ';' . PHP_EOL;	    
		}

        $footer_scrolltop_bg_color_hover_add = aigency_get_prepared_option('footer_scrolltop_bg_color_hover_add', 'standard_dark_text_color', 'footer_scrolltop_status');
        if ( !empty($footer_scrolltop_bg_color_hover_add) ) {
            $aigency_custom_css .= "\t" . '--aigency-footer-scrolltop-bg-color-hover-add: ' . esc_attr($footer_scrolltop_bg_color_hover_add) . ';' . PHP_EOL;       
        }

		$footer_scrolltop_color = aigency_get_prepared_option('footer_scrolltop_color', 'standard_dark_text_color', 'footer_scrolltop_status');
		if ( !empty($footer_scrolltop_color) ) {
		    $aigency_custom_css .= "\t" . '--aigency-footer-scrolltop-color: ' . esc_attr($footer_scrolltop_color) . ';' . PHP_EOL;	    
		}

		$footer_scrolltop_color_hover = aigency_get_prepared_option('footer_scrolltop_color_hover', 'standard_contrast_text_color', 'footer_scrolltop_status');
		if ( !empty($footer_scrolltop_color_hover) ) {
		    $aigency_custom_css .= "\t" . '--aigency-footer-scrolltop-color-hover: ' . esc_attr($footer_scrolltop_color_hover) . ';' . PHP_EOL;	    
		}
    }

// Body Lines
	$body_lines_color = aigency_get_prepared_option('body_lines_color', 'standard_border_color', 'body_lines_status');
	if ( !empty($body_lines_color) ) {
		$aigency_custom_css .= "\t" . '--aigency-body-lines-color: ' . esc_attr($body_lines_color) . ';' . PHP_EOL;
	}

// Page Top
	$page_top_background_color = aigency_get_prefered_option('page_top_background_color');
	if ( !empty('page_top_background_color') ) {
	    $aigency_custom_css .= "\t" . '--aigency-page-top-background-color: ' . esc_attr($page_top_background_color) . ';' . PHP_EOL;
	}

// Additional Font
    $additional_font  = aigency_get_prepared_option('additional_font_family');
    $additional_font_array    = json_decode($additional_font, true);
    if ( !empty($additional_font_array['font_family']) ) {
        $aigency_custom_css .= "\t" . '--aigency-additional-font-font-family: ' . aigency_get_font_style_value('font_family', $additional_font) . ';' . PHP_EOL;
    }

// Typography variables
    if ( did_action('elementor/loaded') ) {
        $properties             = ['font_size', 'line_height', 'letter_spacing', 'word_spacing', 'font_family', 'text_transform', 'font_style', 'font_weight', 'text_decoration'];
        $tags                   = ['body', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'button'];
        $kit                    = \Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend();
        $active_breakpoints     = array_reverse($kit->get_settings('active_breakpoints'));
        foreach ($tags as $tag) {
            foreach ($properties as $property) {
                if (
                    $kit->get_settings($tag . '_typography_typography') == 'custom' &&
                    is_array($kit->get_settings($tag . '_typography_' . $property)) &&
                    isset($kit->get_settings($tag . '_typography_' . $property)['size']) &&
                    !empty($kit->get_settings($tag . '_typography_' . $property)['size'])
                ) {
                    $aigency_custom_css .= "\t" . '--aigency-' . str_replace('_', '-', $tag) . '-' . str_replace('_', '-', $property) . ': ' . esc_attr($kit->get_settings($tag . '_typography_' . $property)['size'] . $kit->get_settings($tag . '_typography_' . $property)['unit']) . ';' . PHP_EOL;
                } elseif (
                    did_action('elementor/loaded') &&
                    $kit->get_settings($tag . '_typography_typography') == 'custom' &&
                    !is_array($kit->get_settings($tag . '_typography_' . $property)) &&
                    !empty($kit->get_settings($tag . '_typography_' . $property))
                ) {
                    $aigency_custom_css .= "\t" . '--aigency-' . str_replace('_', '-', $tag) . '-' . str_replace('_', '-', $property) . ': ' . esc_attr($kit->get_settings($tag . '_typography_' . $property)) . ';' . PHP_EOL;
                }
            }
            $aigency_custom_css .= PHP_EOL; // CSS section separator
        }

        if (
            is_array($kit->get_settings('paragraph_spacing')) &&
            isset($kit->get_settings('paragraph_spacing')['size']) &&
            !empty($kit->get_settings('paragraph_spacing')['size'])
        ) {
            $aigency_custom_css .= "\t" . '--aigency-paragraph-spacing: ' . esc_attr($kit->get_settings('paragraph_spacing')['size'] . $kit->get_settings('paragraph_spacing')['unit']) . ';' . PHP_EOL;
        }
        $aigency_custom_css .= PHP_EOL; // CSS section separator

        $properties             = ['font_size', 'line_height', 'letter_spacing', 'word_spacing'];
        foreach ($active_breakpoints as $name) {
            $slug = str_replace('viewport_', '', $name);
            foreach ($tags as $tag) {
                foreach ($properties as $property) {
                    if (
                        $kit->get_settings($tag . '_typography_typography') == 'custom' &&
                        is_array($kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))) &&
                        isset($kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))['size']) &&
                        !empty($kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))['size'])
                    ) {
                        $aigency_custom_css .= "\t" . '--aigency-' . str_replace('_', '-', $tag) . '-' . str_replace('_', '-', $property) . '-' .  str_replace('_', '-', $slug) . ': ' . esc_attr($kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))['size'] . $kit->get_settings($tag . '_typography_' . $property . '_' . esc_attr($slug))['unit']) . ';' . PHP_EOL;
                    }
                }
            }
            if (
                is_array($kit->get_settings('paragraph_spacing' . '_' . esc_attr($slug))) &&
                isset($kit->get_settings('paragraph_spacing' . '_' . esc_attr($slug))['size']) &&
                !empty($kit->get_settings('paragraph_spacing' . '_' . esc_attr($slug))['size'])
            ) {
                $aigency_custom_css .= "\t" . '--aigency-paragraph-spacing' . '-' .  str_replace('_', '-', $slug) . ': ' . esc_attr($kit->get_settings('paragraph_spacing' . '_' . esc_attr($slug))['size'] . $kit->get_settings('paragraph_spacing' . '_' . esc_attr($slug))['unit']) . ';' . PHP_EOL;
            }
        }
    } else {
        $properties             = ['font_size', 'line_height', 'letter_spacing', 'word_spacing', 'font_family', 'text_transform', 'font_style', 'font_weight'];
        $tags                   = ['main', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'additional', 'buttons', 'header_menu', 'header_sub_menu', 'page_title_heading', 'page_title_breadcrumbs', 'page_title_additional_text'];
        foreach ($tags as $tag) {
            foreach ($properties as $property) {
                $font          = aigency_get_prepared_option($tag . '_font');
                $font_array    = json_decode($font, true);
                if ( !empty($font_array[$property]) ) {
                    $aigency_custom_css .= "\t" . '--aigency-' . str_replace('_', '-', ($tag == 'main' ? 'body' : $tag)) . '-' . str_replace('_', '-', $property) . ': ' . aigency_get_font_style_value($property, $font) . ';' . PHP_EOL;
                }
            }
            $aigency_custom_css .= PHP_EOL; // CSS section separator
        }
        $aigency_custom_css .= "\t" . '--aigency-paragraph-spacing: 1.875em;' . PHP_EOL;
    }

$aigency_custom_css .= '}' . PHP_EOL;
$aigency_custom_css .= PHP_EOL; // CSS section separator

if ( !did_action('elementor/loaded') || !function_exists('hfe_init') ) {
// Header Colors
	if ( aigency_get_prefered_option('header_status') === 'on' ) {
	    $excluded_colors = ['contrast_text_color', 'input_dark_color'];
	    $header_colors = array_diff($standard_colors, $excluded_colors);
	    $aigency_custom_css .= '.header, .mobile-header, .mobile-header-menu-container, .site-search {' . PHP_EOL;
	        foreach ($header_colors as $color) {
	            $variable = aigency_get_prepared_option('header_' . $color, 'standard_' . $color, 'header_customize');
	            if ( !empty($variable) ) $aigency_custom_css .= "\t" . '--aigency-header-' . str_replace('_', '-', $color) . ': ' . esc_attr($variable) . ';' . PHP_EOL;
	        }    

	    $header_current_text_color = aigency_get_prepared_option('header_current_text_color', 'contrast_dark_text_color', 'header_customize');
		if ( !empty($header_current_text_color) ) {
		    $aigency_custom_css .= "\t" . '--aigency-header-current-text-color: ' . esc_attr($header_current_text_color) . ';' . PHP_EOL;
		}
		$header_current_background_color = aigency_get_prepared_option('header_current_background_color', '', 'header_customize');
		if ( !empty($header_current_background_color) ) {
		    $aigency_custom_css .= "\t" . '--aigency-header-current-background-color: ' . esc_attr($header_current_background_color) . ';' . PHP_EOL;
		}
		$header_menu_text_color = aigency_get_prepared_option('header_menu_text_color', '', 'header_customize');
		if ( !empty($header_menu_text_color) ) {
		    $aigency_custom_css .= "\t" . '--aigency-header-menu-text-color: ' . esc_attr($header_menu_text_color) . ';' . PHP_EOL;
		}
		$header_menu_text_color_hover = aigency_get_prepared_option('header_menu_text_color_hover', '', 'header_customize');
		if ( !empty($header_menu_text_color_hover) ) {
		    $aigency_custom_css .= "\t" . '--aigency-header-menu-text-hover: ' . esc_attr($header_menu_text_color_hover) . ';' . PHP_EOL;
		}
		$header_menu_text_background_color_hover = aigency_get_prepared_option('header_menu_text_background_color_hover', '', 'header_customize');
		if ( !empty($header_menu_text_background_color_hover) ) {
		    $aigency_custom_css .= "\t" . '--aigency-header-menu-text-background-hover: ' . esc_attr($header_menu_text_background_color_hover) . ';' . PHP_EOL;
		}
		$header_menu_background_color = aigency_get_prepared_option('header_menu_background_color', '', 'header_customize');
		if ( !empty($header_menu_background_color) ) {
		    $aigency_custom_css .= "\t" . '--aigency-header-menu-background-color: ' . esc_attr($header_menu_background_color) . ';' . PHP_EOL;
		}	
		$aigency_custom_css .= '}' . PHP_EOL;
    }

// Footer Colors
    if ( aigency_get_prefered_option('footer_status') === 'on' ) {
    	$excluded_colors = ['contrast_text_color'];
	    $footer_colors = array_diff($standard_colors, $excluded_colors);
	    $aigency_custom_css .= '.footer-wrapper {' . PHP_EOL;
	        foreach ($footer_colors as $color) {
	            $variable = aigency_get_prepared_option('footer_' . $color, 'contrast_' . $color, 'footer_customize');
	            if ( !empty($variable) ) $aigency_custom_css .= "\t" . '--aigency-footer-' . str_replace('_', '-', $color) . ': ' . esc_attr($variable) . ';' . PHP_EOL;
	        }
	    $aigency_custom_css .= '}' . PHP_EOL;
    }    

// Top Bar Colors
    if ( aigency_get_prefered_option('top_bar_status') === 'on' ) {    	
	    $excluded_colors = ['contrast_text_color', 'input_dark_color', 'button_border_color_add', 'button_background_color_add','button_border_hover_add', 'button_background_hover_add'];
	    $top_bar_colors = array_diff($standard_colors, $excluded_colors);
	    $aigency_custom_css .= '.top-bar {' . PHP_EOL;
	        foreach ($top_bar_colors as $color) {
	            $variable = aigency_get_prepared_option('top_bar_' . $color, 'contrast_' . $color, 'top_bar_customize');
	            if ( !empty($variable) ) $aigency_custom_css .= "\t" . '--aigency-top-bar-' . str_replace('_', '-', $color) . ': ' . esc_attr($variable) . ';' . PHP_EOL;
	        }
	    $aigency_custom_css .= '}' . PHP_EOL;
    }

// Page Title Colors
    if ( aigency_get_prefered_option('page_title_status') === 'on' ) {
    	$excluded_colors = ['contrast_text_color', 'input_dark_color', 'background_alter_color', 'button_border_color_add','button_border_hover_add', 'button_background_hover_add'];
	    $page_title_colors = array_diff($standard_colors, $excluded_colors);
	    $aigency_custom_css .= '.page-title-container {' . PHP_EOL;
	        foreach ($page_title_colors as $color) {
	            $variable = aigency_get_prepared_option('page_title_' . $color, 'contrast_' . $color, 'page_title_customize');
	            if ( !empty($variable) ) $aigency_custom_css .= "\t" . '--aigency-page-title-' . str_replace('_', '-', $color) . ': ' . esc_attr($variable) . ';' . PHP_EOL;
	        }
	    $page_title_background_alter_color = aigency_get_prepared_option('page_title_background_alter_color', 'page_top_background_color', 'page_title_customize');
		if ( !empty($page_title_background_alter_color) ) {
		    $aigency_custom_css .= "\t" . '--aigency-page-title-background-alter-color: ' . esc_attr($page_title_background_alter_color) . ';' . PHP_EOL;
		}
	    $page_title_overlay_color = aigency_get_prepared_option('page_title_overlay_color', '', 'page_title_overlay_status');
	    if (!empty($page_title_overlay_color)) $aigency_custom_css .= "\t" . '--aigency-page-title-overlay-color: ' . esc_attr($page_title_overlay_color) . ';' . PHP_EOL;	    
	    $page_title_breadcrumbs_text_color = aigency_get_prepared_option('page_title_breadcrumbs_text_color', '', 'page_title_breadcrumbs_status');
		if ( !empty($page_title_breadcrumbs_text_color) ) {
		    $aigency_custom_css .= "\t" . '--aigency-page-title-breadcrumbs-text-color: ' . esc_attr($page_title_breadcrumbs_text_color) . ';' . PHP_EOL;
		}
		$aigency_custom_css .= '}' . PHP_EOL;
    }    
}