<?php
# One Click Demo Content Import
if (!function_exists('aigency_ocdi_import_files')) {
    function aigency_ocdi_import_files() {
        return array(
            array(
                'import_file_name'              => 'Aigency',
                'categories'                    => array('With Images'),
                'import_file_url'               => trailingslashit(get_template_directory_uri()) . 'core/import/import.xml',
                'import_widget_file_url'        => trailingslashit(get_template_directory_uri()) . 'core/import/widgets.xml',
                'import_customizer_file_url'    => trailingslashit(get_template_directory_uri()) . 'core/import/customizer.xml',
                'import_preview_image_url'      => trailingslashit(get_template_directory_uri()) . 'screenshot.png',
                'preview_url'                   => 'https://demo.artureanec.com/themes/aigency',
            ),
            array(
                'import_file_name'              => 'Aigency Dark',
                'categories'                    => array('With Images'),
                'import_file_url'               => trailingslashit(get_template_directory_uri()) . 'core/import/import2.xml',
                'import_widget_file_url'        => trailingslashit(get_template_directory_uri()) . 'core/import/widgets2.xml',
                'import_customizer_file_url'    => trailingslashit(get_template_directory_uri()) . 'core/import/customizer2.xml',
                'import_preview_image_url'      => trailingslashit(get_template_directory_uri()) . 'screenshot2.png',
                'preview_url'                   => 'https://demo.artureanec.com/themes/aigency-dark',
            )
        );
    }
}
add_filter( 'ocdi/import_files', 'aigency_ocdi_import_files' );

# Remove Branding Message
add_filter( 'ocdi/disable_pt_branding', '__return_true' );

# Disable Regenerate for Thumbs
//add_filter( 'ocdi/regenerate_thumbnails_in_content_import', '__return_false' ); // This will greatly improve the time needed to import the content (images), but only the original sized images will be imported.

if (!function_exists('ocdi_change_time_of_single_ajax_call')) {
    function ocdi_change_time_of_single_ajax_call() {
        return 10;
    }
}
add_filter( 'ocdi/time_for_one_ajax_call', 'ocdi_change_time_of_single_ajax_call' );

if (!function_exists('aigency_after_activation')) {
    function aigency_after_activation() {
        function aigency_after_switch_theme_message() {
            echo '<div class="updated notice is-dismissible"><p>' . esc_html__('After activating all the recommended plugins, you can import all demo content in one-touch. Appearance > Import Demo Data.', 'aigency') . '</p></div>';
        }
        add_action('admin_notices', 'aigency_after_switch_theme_message');
    }
}
add_action('after_switch_theme', 'aigency_after_activation', 10 , 2);

# Remove all posts, pages and products before content import
if ( !function_exists('aigency_ocdi_before_content_import') ) {
    function aigency_ocdi_before_content_import() {
        $allposts= get_posts( array(
            'post_type'     => array('post', 'page', 'products', 'attachment', 'product_variation', 'shop_coupon', 'aigency_project', 'aigency_service', 'aigency_vacancy', 'aigency_case_study', 'aigency_team_member'),
            'numberposts'   => -1
        ) );
        foreach ($allposts as $eachpost) {
            wp_delete_post( $eachpost->ID, true );
        }
    }
}
add_action( 'ocdi/before_content_import', 'aigency_ocdi_before_content_import' );

# Clear sidebars before the widgets get imported
if ( !function_exists('aigency_ocdi_before_widgets_import') ) {
    function aigency_ocdi_before_widgets_import() {
        update_option( 'sidebars_widgets', array() );
    }
}
add_action( 'ocdi/before_widgets_import', 'aigency_ocdi_before_widgets_import' );


if (!function_exists('aigency_ocdi_after_import_setup')) {
    function aigency_ocdi_after_import_setup($selected_import) {
        // Assign menus to their locations.
        $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

        set_theme_mod('nav_menu_locations', array(
            'main' => $main_menu->term_id
        ));

        // Assign front page and posts page (blog page).
        $front_page_id = get_page_by_path('/home/');
        # $blog_page_id  = get_page_by_path( '/blog/');
        update_option('show_on_front', 'page');
        update_option('page_on_front', $front_page_id->ID);
        // update_option( 'page_for_posts', $blog_page_id->ID );
        update_option( 'permalink_structure', '/%postname%/' );
        flush_rewrite_rules();

        // Set Mailchimp for WP options
        if ( function_exists( 'mc4wp' ) ) {
            $has_forms = get_posts(
                array(
                    'post_type'   => 'mc4wp-form',
                    'post_status' => 'publish',
                    'numberposts' => 1,
                )
            );
            update_option( 'mc4wp_default_form_id', $has_forms[0]->ID );
        }

        // Set WooCommerce options
        if ( class_exists('WooCommerce') ) {
            if (!wc_update_product_lookup_tables_is_running()) {
                wc_update_product_lookup_tables();
            }
            $args = array(
                'post_type'     => 'product',
                'post_status'   => 'publish',
                'orderby'       => 'date',
                'order'         => 'ASC'
            );
            $loop = new WP_Query($args);
            while ($loop->have_posts()) {
                $loop->the_post();
                global $product;
                wc_delete_product_transients($product->get_id());
            }

            $shop_page_id       = get_page_by_path('/shop/');
            $cart_page_id       = get_page_by_path('/cart/');
            $checkout_page_id   = get_page_by_path('/checkout/');
            $account_page_id    = get_page_by_path('/my-account/');
            update_option( 'woocommerce_shop_page_id', $shop_page_id->ID );
            update_option( 'woocommerce_cart_page_id', $cart_page_id->ID );
            update_option( 'woocommerce_checkout_page_id', $checkout_page_id->ID );
            update_option( 'woocommerce_myaccount_page_id', $account_page_id->ID );
            update_option( 'woocommerce_queue_flush_rewrite_rules', 'yes' );    
        }

        // Set Elementor options
        if ( did_action('elementor/loaded') ) {

        	update_option('elementor_cpt_support', array('post', 'page', 'aigency_project', 'aigency_service', 'aigency_vacancy', 'aigency_case_study', 'aigency_team_member', 'elementor-hf'));
            update_option('elementor_disable_color_schemes', 'yes');
            update_option('elementor_disable_typography_schemes', 'yes');

            update_option('elementor_optimized_gutenberg_loading', 0);
            update_option('elementor_unfiltered_files_upload', 1);
            update_option('elementor_optimized_image_loading', 1);
            update_option('elementor_lazy_load_background_images', 1);

            update_option('elementor_experiment-e_optimized_markup', 'inactive');
            update_option('elementor_experiment-e_element_cache', 'inactive');
            update_option('elementor_experiment-cloud-library', 'inactive');
            update_option('elementor_experiment-e_font_icon_svg', 'inactive');
            update_option('elementor_experiment-additional_custom_breakpoints', 'active');
            update_option('elementor_experiment-container', 'active');
            update_option('elementor_experiment-e_local_google_fonts', 'inactive');
            update_option('elementor_experiment-nested-elements', 'active');
            update_option('elementor_experiment-editor_v2', 'inactive');

            $kit = \Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend();
            $kit->update_settings(
                [
                    'container_width'       => [
                        'unit'  => 'px',
                        'size'  => 1380,
                        'sizes' => []
                    ],
                    'container_padding'     => [
                        'top'         => '0',
                        'right'       => '0',
                        'bottom'      => '0',
                        'left'        => '0',
                        'isLinked'    => false,
                        'unit'        => 'px'
                    ],
                    'viewport_mobile' => 575,
                    'viewport_mobile_extra' => 767,
                    'viewport_md' => 576,
                    'viewport_lg' => 992,
                    'viewport_tablet' => 991,
                    'viewport_tablet_extra' => 1279,
                    'viewport_widescreen' => 1921,
                    'viewport_laptop' => 1600,
                    'active_breakpoints' => [
                        'viewport_mobile',
                        'viewport_mobile_extra',
                        'viewport_tablet',
                        'viewport_tablet_extra',
                        'viewport_laptop',
                        'viewport_widescreen'
                    ],
                    'system_colors'         => [
                        0       => [
                            '_id'   => 'primary',
                            'title' => esc_html__('Primary', 'aigency'),
                            'color' => '#111111'
                        ],
                        1       => [
                            '_id'   => 'secondary',
                            'title' => esc_html__('Secondary', 'aigency'),
                            'color' => '#F0F2F4'
                        ],
                        2       => [
                            '_id'   => 'text',
                            'title' => esc_html__('Text', 'aigency'),
                            'color' => '#333333'
                        ],
                        3       => [
                            '_id'   => 'accent',
                            'title' => esc_html__('Accent', 'aigency'),
                            'color' => '#5091D9'
                        ]
                    ],
                    'global_image_lightbox' => '',

                    'body_typography_typography'                => 'custom',
                    'body_typography_font_family'               => 'Manrope',
                    'body_typography_font_size'                 => [
                        'unit'      => 'px',
                        'size'      => 16,
                        'sizes'     => []
                    ],
                    'body_typography_font_weight'               => '500',
                    'body_typography_font_style'                => 'normal',
                    'body_typography_text_decoration'           => 'none',
                    'body_typography_line_height'               => [
                        'unit'      => 'em',
                        'size'      => 1.875,
                        'sizes'     => []
                    ],
                    'paragraph_spacing'                         => [
                        'unit'      => 'em',
                        'size'      => 1.875,
                        'sizes'     => []
                    ],

                    'h1_typography_typography'                  => 'custom',
                    'h1_typography_font_family'                 => 'DM Sans',
                    'h1_typography_font_size'                   => [
                        'unit'      => 'px',
                        'size'      => 100,
                        'sizes'     => []
                    ],
                    'h1_typography_font_weight'                 => '500',
                    'h1_typography_line_height'                 => [
                        'unit'      => 'em',
                        'size'      => 1.125,
                        'sizes'     => []
                    ],
                    'h1_typography_letter_spacing'              => [
                        'unit'      => 'em',
                        'size'      => -0.05,
                        'sizes'     => []
                    ],

                    'h2_typography_typography'                  => 'custom',
                    'h2_typography_font_family'                 => 'DM Sans',
                    'h2_typography_font_size'                   => [
                        'unit'      => 'px',
                        'size'      => 80,
                        'sizes'     => []
                    ],
                    'h2_typography_font_weight'                 => '500',
                    'h2_typography_line_height'                 => [
                        'unit'      => 'em',
                        'size'      => 1,
                        'sizes'     => []
                    ],
                    'h2_typography_letter_spacing'              => [
                        'unit'      => 'em',
                        'size'      => -0.05,
                        'sizes'     => []
                    ],

                    'h3_typography_typography'                  => 'custom',
                    'h3_typography_font_family'                 => 'DM Sans',
                    'h3_typography_font_size'                   => [
                        'unit'      => 'px',
                        'size'      => 40,
                        'sizes'     => []
                    ],
                    'h3_typography_font_weight'                 => '500',
                    'h3_typography_line_height'                 => [
                        'unit'      => 'em',
                        'size'      => 1.25,
                        'sizes'     => []
                    ],
                    'h3_typography_letter_spacing'              => [
                        'unit'      => 'em',
                        'size'      => -0.05,
                        'sizes'     => []
                    ],

                    'h4_typography_typography'                  => 'custom',
                    'h4_typography_font_family'                 => 'DM Sans',
                    'h4_typography_font_size'                   => [
                        'unit'      => 'px',
                        'size'      => 30,
                        'sizes'     => []
                    ],
                    'h4_typography_font_weight'                 => '500',
                    'h4_typography_line_height'                 => [
                        'unit'      => 'em',
                        'size'      => 1.16666,
                        'sizes'     => []
                    ],
                    'h4_typography_letter_spacing'              => [
                        'unit'      => 'em',
                        'size'      => -0.05,
                        'sizes'     => []
                    ],

                    'h5_typography_typography'                  => 'custom',
                    'h5_typography_font_family'                 => 'DM Sans',
                    'h5_typography_font_size'                   => [
                        'unit'      => 'px',
                        'size'      => 25,
                        'sizes'     => []
                    ],
                    'h5_typography_font_weight'                 => '500',
                    'h5_typography_line_height'                 => [
                        'unit'      => 'em',
                        'size'      => 1.4,
                        'sizes'     => []
                    ],
                    'h5_typography_letter_spacing'              => [
                        'unit'      => 'em',
                        'size'      => -0.05,
                        'sizes'     => []
                    ],

                    'h6_typography_typography'                  => 'custom',
                    'h6_typography_font_family'                 => 'DM Sans',
                    'h6_typography_font_size'                   => [
                        'unit'      => 'px',
                        'size'      => 20,
                        'sizes'     => []
                    ],
                    'h6_typography_font_weight'                 => '500',
                    'h6_typography_line_height'                 => [
                        'unit'      => 'em',
                        'size'      => 1.5,
                        'sizes'     => []
                    ],
                    'h6_typography_letter_spacing'              => [
                        'unit'      => 'em',
                        'size'      => -0.05,
                        'sizes'     => []
                    ],

                    'h1_typography_font_size_tablet'            => [
                        'unit'      => 'px',
                        'size'      => 60,
                        'sizes'     => []
                    ],
                    'h1_typography_font_size_mobile_extra'      => [
                        'unit'      => 'px',
                        'size'      => 50,
                        'sizes'     => []
                    ],
                    'h2_typography_font_size_tablet'            => [
                        'unit'      => 'px',
                        'size'      => 45,
                        'sizes'     => []
                    ],
                    'h2_typography_font_size_mobile_extra'      => [
                        'unit'      => 'px',
                        'size'      => 35,
                        'sizes'     => []
                    ],
                    'h3_typography_font_size_tablet'            => [
                        'unit'      => 'px',
                        'size'      => 30,
                        'sizes'     => []
                    ],
                    'h3_typography_font_size_mobile_extra'      => [
                        'unit'      => 'px',
                        'size'      => 25,
                        'sizes'     => []
                    ],
                    'h4_typography_font_size_tablet'            => [
                        'unit'      => 'px',
                        'size'      => 25,
                        'sizes'     => []
                    ],
                    'h4_typography_font_size_mobile_extra'      => [
                        'unit'      => 'px',
                        'size'      => 22,
                        'sizes'     => []
                    ],
                    'h5_typography_font_size_tablet'            => [
                        'unit'      => 'px',
                        'size'      => 20,
                        'sizes'     => []
                    ],
                    'h6_typography_font_size_tablet'            => [
                        'unit'      => 'px',
                        'size'      => 18,
                        'sizes'     => []
                    ],

                    'button_typography_typography'              => 'custom',
                    'button_typography_font_family'             => 'Manrope',
                    'button_typography_font_weight'             => '500',
                    'button_typography_font_size'               => [
                        'unit'      => 'px',
                        'size'      => '14',
                        'sizes'     => []
                    ],
                    'button_typography_text_transform'          => 'uppercase',                    
                ]
            );
        }

        // Import forms
        if ( function_exists('wpforms') ) {
            $title = esc_html__('Contact Form', 'aigency');
            $form_id = wpforms()->form->add($title);
            $form_id = wpforms()->form->update(
                $form_id,
                array(
                    'id'        => '243',
                    'field_id'  => 5,
                    'fields'    => array(
                        '1'                         => array(
                            'id'                        => '1',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Full Name', 'aigency'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Full Name', 'aigency'),
                            'default_value'             => '',
                            'input_mask'                => '',
                            'css'                       => '',
                            'label_hide'                => '1',
                            'sublabel_hide'             => '1',
                        ),
                        '2'                         => array(
                            'id'                        => '2',
                            'type'                      => 'email',
                            'label'                     => esc_html__('Email', 'aigency'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Email', 'aigency'),
                            'confirmation_placeholder'  => '',
                            'default_value'             => '',
                            'filter_type'               => '',
                            'allowlist'                 => '',
                            'denylist'                  => '',
                            'css'                       => '',
                            'label_hide'                => '1',
                            'sublabel_hide'             => '1',
                        ),
                        '4'                         => array(
                            'id'                        => '4',
                            'type'                      => 'text',
                            'label'                     => esc_html__('Subject', 'aigency'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Subject', 'aigency'),
                            'default_value'             => '',
                            'input_mask'                => '',
                            'css'                       => '',
                            'label_hide'                => '1',
                            'sublabel_hide'             => '1',
                        ),
                        '3'                         => array(
                            'id'                        => '3',
                            'type'                      => 'textarea',
                            'label'                     => esc_html__('Message', 'aigency'),
                            'description'               => '',
                            'size'                      => 'small',
                            'placeholder'               => esc_attr__('Message', 'aigency'),
                            'limit_count'               => '1',
                            'limit_mode'                => 'characters',
                            'default_value'             => '',
                            'css'                       => '',
                            'label_hide'                => '1',
                            'sublabel_hide'             => '1',
                        ),
                    ),
                    'settings' => array(
                        'form_title'                => $title,
                        'form_desc'                 => esc_html__('Define your goals and identify areas where AI can add value to your business', 'aigency'),
                        'submit_text'               => esc_html__('Send a Message', 'aigency'),
                        'submit_text_processing'    => esc_html__('Sending...', 'aigency'),
                        'antispam'                  => '1',
                        'form_class'                => '',
                        'submit_class'              => '',
                        'ajax_submit'               => '1',
                        'notification_enable'       => '1',
                        'notifications'             => array(
                            '1'                         => array(
                                'email'                     => '{admin_email}',
                                'subject'                   => esc_html__('New Contact Form Entry', 'aigency'),
                                'sender_name'               => 'Aigency',
                                'sender_address'            => '{admin_email}',
                                'replyto'                   => '',
                                'message'                   => '{all_fields}',
                            ),
                        ),
                        'confirmations'             => array(
                            '1'                         => array(
                                'type'                      => 'message',
                                'message'                   => '<p>' . esc_html__('Thanks for contacting us! We will be in touch with you shortly.', 'aigency') . '</p>',
                                'message_scroll'            => '1',
                                'page'                      => '395',
                                'redirect'                  => '',
                            ),
                        ),
                    ),
                    'meta'                      => array(
                        'template'                  => 'blank',
                    ),
                )
            );
            wp_update_post(
                array(
                    'ID'         => $form_id,
                    'post_title' => $title,
                )
            );

            $title1 = esc_html__('Chatbot Form', 'aigency');
            $form_id1 = wpforms()->form->add($title1);
            $form_id1 = wpforms()->form->update(
                $form_id1,
                array(
                    'id'        => '4248',
                    'field_id'  => 3,
                    'fields'    => array(
                        '2'                         => array(
                            'id'                        => '2',
                            'type'                      => 'email',
                            'label'                     => esc_html__('Email', 'aigency'),
                            'description'               => '',
                            'required'                  => '1',
                            'size'                      => 'large',
                            'placeholder'               => esc_attr__('Enter your email', 'aigency'),
                            'confirmation_placeholder'  => '',
                            'default_value'             => '',
                            'filter_type'               => '',
                            'allowlist'                 => '',
                            'denylist'                  => '',
                            'css'                       => '',
                            'label_hide'                => '1',
                            'sublabel_hide'             => '1',
                        ),
                    ),
                    'settings' => array(
                        'form_title'                => $title1,
                        'form_desc'                 => '',
                        'submit_text'               => esc_html__('Submit', 'aigency'),
                        'submit_text_processing'    => esc_html__('Sending...', 'aigency'),
                        'antispam'                  => '1',
                        'form_class'                => '',
                        'submit_class'              => 'hide',
                        'ajax_submit'               => '1',
                        'notification_enable'       => '1',
                        'notifications'             => array(
                            '1'                         => array(
                                'email'                     => '{admin_email}',
                                'subject'                   => esc_html__('New Contact Form Entry', 'aigency'),
                                'sender_name'               => 'Aigency',
                                'sender_address'            => '{admin_email}',
                                'replyto'                   => '',
                                'message'                   => '{all_fields}',
                            ),
                        ),
                        'confirmations'             => array(
                            '1'                         => array(
                                'type'                      => 'message',
                                'message'                   => '<p>' . esc_html__('Thanks for contacting us! We will be in touch with you shortly.', 'aigency') . '</p>',
                                'message_scroll'            => '1',
                                'page'                      => '395',
                                'redirect'                  => '',
                            ),
                        ),
                    ),
                    'meta'                      => array(
                        'template'                  => 'blank',
                    ),
                )
            );
            wp_update_post(
                array(
                    'ID'         => $form_id1,
                    'post_title' => $title1,
                )
            );
        }
    }
}
add_action( 'ocdi/after_import', 'aigency_ocdi_after_import_setup' );