<?php
/*
 * Created by Artureanec
*/

require_once(get_template_directory() . "/core/customizer/customizer-sanitize-functions.php");
require_once(get_template_directory() . "/core/customizer/customizer-defaults.php");
require_once(get_template_directory() . "/core/customizer/customizer-controls.php");

# Register Customizer
add_action('customize_register', 'aigency_customizer_register');
if (!function_exists('aigency_customizer_register')) {
    function aigency_customizer_register($wp_customize) {
        global $aigency_customizer_default_values;

        // ----------------------------------------------- //
        // ---------- Page Settings Panel ---------- //
        // ----------------------------------------------- //
        $wp_customize->add_panel('aigency_page_settings',
            array(
                'title'     => esc_html__('Page Settings', 'aigency'),
                'priority'  => 125
            )
        );

        $wp_customize->add_section('aigency_page_sidebar_settings',
            array(
                'title'     => esc_html__('Page Sidebar', 'aigency'),
                'panel'  => 'aigency_page_settings'
            )
        );

        // ----------------------------- //
        // --- Page Sidebar Position --- //
        // ----------------------------- //
        $wp_setting_name = 'sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Page Sidebar Position', 'aigency'),
                'section'   => 'aigency_page_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // --------------------------- //
        // --- Page Sidebar Select --- //
        // --------------------------- //
        $wp_setting_name = 'page_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Page Sidebar', 'aigency'),
                'section'       => 'aigency_page_sidebar_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));        

        if ( !did_action('elementor/loaded') || !function_exists('hfe_init') ) { 

        	// ---###################--- //
	        // ---### Page Top Background ###--- //
	        // ---###################--- //
	        $wp_customize->add_section('aigency_page_top_bg',
	            array(
	                'title' => esc_html__('Page Top Background', 'aigency'),
	                'panel' => 'aigency_page_settings'
	            )
	        );

        	// --------------------------------- //
	        // --- Page Top Background Color --- //
	        // --------------------------------- //
	        $wp_setting_name = 'page_top_background_color';
	        $wp_customize->add_setting(
	            $wp_setting_name,
	            array(
	                'default'           => $aigency_customizer_default_values[$wp_setting_name],
	                'sanitize_callback' => 'aigency_sanitize_alpha_color'
	            )
	        );
	        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
	            $wp_customize,
	            $wp_setting_name,
	            array(
	                'label'         => esc_html__('Page Top Background Color', 'aigency'),
	                'section'       => 'aigency_page_top_bg',
	                'settings'      => $wp_setting_name,
	                'show_opacity'  => true,
	                'palette'       => aigency_get_custom_color_palette()
	            )
	        ));

	        // ----------------------------- //
	        // --- Page Top Border Radius --- //
	        // ---------------------------- //
	        $wp_setting_name = 'page_top_border_radius';
	        $wp_customize->add_setting(
	            $wp_setting_name,
	            array(
	                'default'           => $aigency_customizer_default_values[$wp_setting_name],
	                'sanitize_callback' => 'aigency_sanitize_choice'
	            )
	        );
	        $wp_customize->add_control(new Aigency_Customize_Control(
	            $wp_customize,
	            $wp_setting_name,
	            array(
	                'label'         => esc_html__('Page Top Border Radius', 'aigency'),
	                'section'       => 'aigency_page_top_bg',
	                'type'          => 'select',
	                'settings'      => $wp_setting_name,
	                'choices'       => array(
	                    'on'        => esc_html__('On', 'aigency'),
	                    'off'       => esc_html__('Off', 'aigency')
	                )
	            )
	        ));
        }        

        // ---###################--- //
        // ---### Body Lines ###--- //
        // ---###################--- //
        $wp_customize->add_section('aigency_page_body_lines',
            array(
                'title' => esc_html__('Body Lines', 'aigency'),
                'panel' => 'aigency_page_settings'
            )
        );

        // ------------------ //
        // --- Body Lines --- //
        // ------------------ //
        $wp_setting_name = 'body_lines_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show page background lines', 'aigency'),
                'section'   => 'aigency_page_body_lines',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------ //
        // --- Body Lines Color --- //
        // ------------------------ //
        $wp_setting_name = 'body_lines_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Lines Color', 'aigency'),
                'section'       => 'aigency_page_body_lines',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'body_lines_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---###################--- //
        // ---### Body Lines ###--- //
        // ---###################--- //
        $wp_customize->add_section('aigency_page_bottom_blur',
            array(
                'title' => esc_html__('Page Bottom Blur', 'aigency'),
                'panel' => 'aigency_page_settings'
            )
        );

        // ------------------ //
        // --- Body Lines --- //
        // ------------------ //
        $wp_setting_name = 'page_bottom_blur_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show page bottom blur', 'aigency'),
                'section'   => 'aigency_page_bottom_blur',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        if ( !did_action('elementor/loaded') || !function_exists('hfe_init') ) {

            // -------------------------------------------- //
            // ---------- Top Bar Settings Panel ---------- //
            // -------------------------------------------- //
            $wp_customize->add_panel('aigency_top_bar_settings',
                array(
                    'title'     => esc_html__('Top Bar Settings', 'aigency'),
                    'priority'  => 130
                )
            );

            // ---#######################--- //
            // ---### Top Bar General ###--- //
            // ---#######################--- //
            $wp_customize->add_section('aigency_top_bar_general',
                array(
                    'title' => esc_html__('General', 'aigency'),
                    'panel' => 'aigency_top_bar_settings'
                )
            );

            // ---------------------- //
            // --- Top Bar Status --- //
            // ---------------------- //
            $wp_setting_name = 'top_bar_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Top Bar', 'aigency'),
                    'section'   => 'aigency_top_bar_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------------- //
            // --- Top Bar Customize --- //
            // ------------------------- //
            $wp_setting_name = 'top_bar_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Customize', 'aigency'),
                    'section'   => 'aigency_top_bar_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ---------------------------------- //
            // --- Top Bar Default Text Color --- //
            // ---------------------------------- //
            $wp_setting_name = 'top_bar_default_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Default Text Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ------------------------------- //
            // --- Top Bar Dark Text Color --- //
            // ------------------------------- //
            $wp_setting_name = 'top_bar_dark_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Dark Text Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Top Bar Light Text Color --- //
            // -------------------------------- //
            $wp_setting_name = 'top_bar_light_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Light Text Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------- //
            // --- Top Bar Accent Text Color --- //
            // --------------------------------- //
            $wp_setting_name = 'top_bar_accent_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Accent Text Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------- //
            // --- Top Bar Border Color --- //
            // ---------------------------- //
            $wp_setting_name = 'top_bar_border_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Border Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ------------------------------------ //
            // --- Top Bar Hovered Border Color --- //
            // ------------------------------------ //
            $wp_setting_name = 'top_bar_border_hover_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Hovered Border Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Top Bar Background Color --- //
            // -------------------------------- //
            $wp_setting_name = 'top_bar_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // -------------------------------------------- //
            // --- Top Bar Alternative Background Color --- //
            // -------------------------------------------- //
            $wp_setting_name = 'top_bar_background_alter_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Alternative Background Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------- //
            // --- Top Bar Button Text Color --- //
            // --------------------------------- //
            $wp_setting_name = 'top_bar_button_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Text Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ----------------------------------- //
            // --- Top Bar Button Border Color --- //
            // ----------------------------------- //
            $wp_setting_name = 'top_bar_button_border_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------------- //
            // --- Top Bar Button Background Color --- //
            // --------------------------------------- //
            $wp_setting_name = 'top_bar_button_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Color', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------- //
            // --- Top Bar Button Text Hover --- //
            // --------------------------------- //
            $wp_setting_name = 'top_bar_button_text_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Text Hover', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------------------- //
            // --- Top Bar Button Border Hover --- //
            // ----------------------------------- //
            $wp_setting_name = 'top_bar_button_border_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Hover', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------------- //
            // --- Top Bar Button Background Hover --- //
            // --------------------------------------- //
            $wp_setting_name = 'top_bar_button_background_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Hover', 'aigency'),
                    'section'       => 'aigency_top_bar_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));


            // ---##############################--- //
            // ---### Top Bar Social Buttons ###--- //
            // ---##############################--- //
            $wp_customize->add_section('aigency_top_bar_socials',
                array(
                    'title' => esc_html__('Social Buttons', 'aigency'),
                    'panel' => 'aigency_top_bar_settings'
                )
            );

            // ------------------------------ //
            // --- Top Bar Socials Status --- //
            // ------------------------------ //
            $wp_setting_name = 'top_bar_socials_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Social Buttons', 'aigency'),
                    'section'   => 'aigency_top_bar_socials',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ---------------------------- //
            // --- Top Bar Socials Title --- //
            // ---------------------------- //
            $wp_setting_name = 'top_bar_socials_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Social Buttons Title', 'aigency'),
                    'section'       => 'aigency_top_bar_socials',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_socials_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));  

            // ---########################--- //
            // ---### Top Bar Contacts ###--- //
            // ---########################--- //
            $wp_customize->add_section('aigency_top_bar_contacts',
                array(
                    'title' => esc_html__('Contacts', 'aigency'),
                    'panel' => 'aigency_top_bar_settings'
                )
            );

            // ---------------------------- //
            // --- Top Bar Contacts Title --- //
            // ---------------------------- //
            $wp_setting_name = 'top_bar_contacts_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Mobile Menu Contacts Title', 'aigency'),
                    'section'       => 'aigency_top_bar_contacts',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name
                )
            ));

            // ----------------------------------- //
            // --- Top Bar Phone Number Status --- //
            // ----------------------------------- //
            $wp_setting_name = 'top_bar_contacts_phone_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Phone Number', 'aigency'),
                    'section'   => 'aigency_top_bar_contacts',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ---------------------------- //
            // --- Top Bar Phone Title --- //
            // ---------------------------- //
            $wp_setting_name = 'top_bar_contacts_phone_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Phone Title', 'aigency'),
                    'section'       => 'aigency_top_bar_contacts',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_contacts_phone_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------- //
            // --- Top Bar Phone Number --- //
            // ---------------------------- //
            $wp_setting_name = 'top_bar_contacts_phone';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Phone Number', 'aigency'),
                    'section'       => 'aigency_top_bar_contacts',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_contacts_phone_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------ //
            // --- Top Bar Email Address Status --- //
            // ------------------------------------ //
            $wp_setting_name = 'top_bar_contacts_email_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Email Address', 'aigency'),
                    'section'   => 'aigency_top_bar_contacts',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ---------------------------- //
            // --- Top Bar Email Title --- //
            // ---------------------------- //
            $wp_setting_name = 'top_bar_contacts_email_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Email Title', 'aigency'),
                    'section'       => 'aigency_top_bar_contacts',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_contacts_email_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------------- //
            // --- Top Bar Email Address --- //
            // ----------------------------- //
            $wp_setting_name = 'top_bar_contacts_email';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_email'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Email Address', 'aigency'),
                    'section'       => 'aigency_top_bar_contacts',
                    'type'          => 'email',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_contacts_email_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));        

            // ------------------------------ //
            // --- Top Bar Address Status --- //
            // ------------------------------ //
            $wp_setting_name = 'top_bar_contacts_address_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Address', 'aigency'),
                    'section'   => 'aigency_top_bar_contacts',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

             // ------------------------- //
            // --- Top Address Title --- //
            // ------------------------- //
            $wp_setting_name = 'top_bar_contacts_address_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Address Title', 'aigency'),
                    'section'       => 'aigency_top_bar_contacts',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_contacts_address_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------- //
            // --- Top Bar Address --- //
            // ----------------------- //
            $wp_setting_name = 'top_bar_contacts_address';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Address', 'aigency'),
                    'section'       => 'aigency_top_bar_contacts',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'top_bar_contacts_address_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------------- //
            // ---------- Header Settings Panel ---------- //
            // ------------------------------------------- //
            $wp_customize->add_panel('aigency_header_settings',
                array(
                    'title'     => esc_html__('Header Settings', 'aigency'),
                    'priority'  => 130
                )
            );

            // ---######################--- //
            // ---### Header General ###--- //
            // ---######################--- //
            $wp_customize->add_section('aigency_header_general',
                array(
                    'title' => esc_html__('General', 'aigency'),
                    'panel' => 'aigency_header_settings'
                )
            );

            // --------------------- //
            // --- Header Status --- //
            // --------------------- //
            $wp_setting_name = 'header_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Header', 'aigency'),
                    'section'   => 'aigency_header_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ----------------------- //
            // --- Header Position --- //
            // ----------------------- //
            $wp_setting_name = 'header_position';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Header Position', 'aigency'),
                    'section'   => 'aigency_header_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'above'     => esc_html__('Above', 'aigency'),
                        'over'      => esc_html__('Over', 'aigency')
                    )
                )
            ));


            // ------------------------- //
            // --- Header Transparent --- //
            // ------------------------- //
            $wp_setting_name = 'header_transparent';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Transparent Header', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_position',
                            'operator'  => '==',
                            'value'     => 'over'
                        ]
                    ]
                )
            ));        

            // ------------------------- //
            // --- Header Border --- //
            // ------------------------- //
            $wp_setting_name = 'header_border';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Border Style', 'aigency'),
                    'section'   => 'aigency_header_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'none'    => esc_html__('No Border', 'aigency'),
                        'border'  => esc_html__('Border', 'aigency')
                    )
                )
            ));

            // ------------------------ //
            // --- Header Customize --- //
            // ------------------------ //
            $wp_setting_name = 'header_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Customize', 'aigency'),
                    'section'   => 'aigency_header_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------------- //
            // --- Header Top Offset --- //
            // ------------------------- //
            $wp_setting_name = 'header_offset_top';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Header Offset Top, in px', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'type'          => 'number',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'           => 'header_customize',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------- //
            // --- Header Default Text Color --- //
            // --------------------------------- //
            $wp_setting_name = 'header_default_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Default text color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ------------------------------ //
            // --- Header Dark Text Color --- //
            // ------------------------------ //
            $wp_setting_name = 'header_dark_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Dark text color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------- //
            // --- Header Light Text Color --- //
            // ------------------------------- //
            $wp_setting_name = 'header_light_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Light text color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Header Accent Text Color --- //
            // -------------------------------- //
            $wp_setting_name = 'header_accent_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Accent text color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Header Current Text Color --- //
            // -------------------------------- //
            $wp_setting_name = 'header_current_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Current Page/Post Text Color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Header Current Text Color --- //
            // -------------------------------- //
            $wp_setting_name = 'header_current_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Current Page/Post Background Color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------- //
            // --- Header Border Color --- //
            // --------------------------- //
            $wp_setting_name = 'header_border_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Border color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ----------------------------------- //
            // --- Header Hovered Border Color --- //
            // ----------------------------------- //
            $wp_setting_name = 'header_border_hover_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Hovered Border color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------- //
            // --- Header Background Color --- //
            // ------------------------------- //
            $wp_setting_name = 'header_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ------------------------------------------- //
            // --- Header Background Alternative Color --- //
            // ------------------------------------------- //
            $wp_setting_name = 'header_background_alter_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Alternative background color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Header Button Text Color --- //
            // -------------------------------- //
            $wp_setting_name = 'header_button_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Text color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ---------------------------------- //
            // --- Header Button Border Color --- //
            // ---------------------------------- //
            $wp_setting_name = 'header_button_border_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Header Button Border Color 2 --- //
            // ---------------------------------- //
            $wp_setting_name = 'header_button_border_color_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border color Additional', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Header Button Background Color --- //
            // -------------------------------------- //
            $wp_setting_name = 'header_button_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Header Button Background Color 2 --- //
            // -------------------------------------- //
            $wp_setting_name = 'header_button_background_color_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Color Additional', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Header Button Text Hover --- //
            // -------------------------------- //
            $wp_setting_name = 'header_button_text_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Text Hover', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Header Button Border Hover --- //
            // ---------------------------------- //
            $wp_setting_name = 'header_button_border_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Hover', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Header Button Border Hover 2 --- //
            // ---------------------------------- //
            $wp_setting_name = 'header_button_border_hover_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Hover Additional', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Header Button Background Hover --- //
            // -------------------------------------- //
            $wp_setting_name = 'header_button_background_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Hover', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Header Button Background Hover 2 --- //
            // -------------------------------------- //
            $wp_setting_name = 'header_button_background_hover_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Hover Additional', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------------- //
            // --- Header Button Border Style --- //
            // ---------------------------------------- //
            $wp_setting_name = 'header_button_border_style';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Button Border Style', 'aigency'),
                    'section'   => 'aigency_header_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'gradient'    => esc_html__('Gradient', 'aigency'),
                        'solid'       => esc_html__('Solid', 'aigency')
                    ),
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------------- //
            // --- Header Button Background Style --- //
            // ---------------------------------------- //
            $wp_setting_name = 'header_button_background_style';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Button Background Style', 'aigency'),
                    'section'   => 'aigency_header_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'gradient'    => esc_html__('Gradient', 'aigency'),
                        'solid'       => esc_html__('Solid', 'aigency')
                    ),
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Header Menu Text Color --- //
            // ---------------------------------- //
            $wp_setting_name = 'header_menu_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Header Menu Text Color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Header Menu Text Color --- //
            // ---------------------------------- //
            $wp_setting_name = 'header_menu_text_color_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Header Menu Text Hover Color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------------------ //
            // --- Header Menu Text Background Color Hover --- //
            // ----------------------------------------------- //
            $wp_setting_name = 'header_menu_text_background_color_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Header Menu Text Background Hover Color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Header Menu Background Color --- //
            // ---------------------------------- //
            $wp_setting_name = 'header_menu_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Header Menu Background Color', 'aigency'),
                    'section'       => 'aigency_header_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));            

            // ---#####################--- //
            // ---### Sticky Header ###--- //
            // ---#####################--- //
            $wp_customize->add_section('aigency_header_sticky',
                array(
                    'title' => esc_html__('Sticky Header', 'aigency'),
                    'panel' => 'aigency_header_settings'
                )
            );


            // --------------------- //
            // --- Sticky Header --- //
            // --------------------- //
            $wp_setting_name = 'sticky_header_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Sticky Header', 'aigency'),
                    'section'   => 'aigency_header_sticky',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------------ //
            // --- Sticky Header Blur --- //
            // ------------------------- //
            $wp_setting_name = 'sticky_header_blur';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Sticky Header Blur', 'aigency'),
                    'section'   => 'aigency_header_sticky',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'    => esc_html__('On', 'aigency'),
                        'off'   => esc_html__('Off', 'aigency'),
                    ),
                    'dependency'    => [
                        [
                            'control'   => 'sticky_header_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));



            // ---#####################--- //
            // ---### Mobile Header ###--- //
            // ---#####################--- //
            $wp_customize->add_section('aigency_header_mobile',
                array(
                    'title' => esc_html__('Mobile Header', 'aigency'),
                    'panel' => 'aigency_header_settings'
                )
            );

            // -------------------------------- //
            // --- Mobile Header Breakpoint --- //
            // -------------------------------- //
            $wp_setting_name = 'mobile_header_breakpoint';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'absint'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Mobile Header Breakpoint, in px', 'aigency'),
                    'section'       => 'aigency_header_mobile',
                    'type'          => 'number',
                    'settings'      => $wp_setting_name
                )
            ));        

            // -------------------------- //
            // --- Mobile Header Menu Style --- //
            // -------------------------- //
            $wp_setting_name = 'mobile_header_menu_style';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Mobile Header Menu Trigger Style', 'aigency'),
                    'section'   => 'aigency_header_mobile',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'fullwidth'    => esc_html__('Fullwidth', 'aigency'),
                        'inline'       => esc_html__('Inline', 'aigency')
                    )
                )
            ));


            // ---#####################--- //
            // ---### Logo Settings ###--- //
            // ---#####################--- //
            $wp_customize->add_section('aigency_header_logo',
                array(
                    'title' => esc_html__('Logo', 'aigency'),
                    'panel' => 'aigency_header_settings'
                )
            );

            // -------------------------- //
            // --- Header Logo Status --- //
            // -------------------------- //
            $wp_setting_name = 'header_logo_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Logo', 'aigency'),
                    'section'   => 'aigency_header_logo',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ----------------------------- //
            // --- Header Logo Customize --- //
            // ----------------------------- //
            $wp_setting_name = 'header_logo_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Customize', 'aigency'),
                    'section'   => 'aigency_header_logo',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------- //
            // --- Header Logo --- //
            // ------------------- //
            $wp_setting_name = 'header_logo_image';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'esc_url_raw'
                )
            );
            $wp_customize->add_control(new Aigency_Image_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Logo Image', 'aigency'),
                    'section'       => 'aigency_header_logo',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_logo_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------- //
            // --- Logo Retina --- //
            // ------------------- //
            $wp_setting_name = 'header_logo_retina';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Logo Retina', 'aigency'),
                    'section'       => 'aigency_header_logo',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_logo_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------- //
            // --- Mobile Header Logo --- //
            // -------------------------- //
            $wp_setting_name = 'header_logo_mobile_image';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'esc_url_raw'
                )
            );
            $wp_customize->add_control(new Aigency_Image_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Mobile Logo Image', 'aigency'),
                    'section'       => 'aigency_header_logo',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_logo_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // -------------------------- //
            // --- Mobile Logo Retina --- //
            // -------------------------- //
            $wp_setting_name = 'header_logo_mobile_retina';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Mobile Logo Retina', 'aigency'),
                    'section'       => 'aigency_header_logo',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_logo_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));


            // ---#####################--- //
            // ---### Header Button ###--- //
            // ---#####################--- //
            $wp_customize->add_section('aigency_header_button',
                array(
                    'title' => esc_html__('Header Button', 'aigency'),
                    'panel' => 'aigency_header_settings'
                )
            );

            // --------------------- //
            // --- Header Button --- //
            // --------------------- //
            $wp_setting_name = 'header_button_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show header button', 'aigency'),
                    'section'   => 'aigency_header_button',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // -------------------------- //
            // --- Header Button Text --- //
            // -------------------------- //
            $wp_setting_name = 'header_button_text';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Header button text', 'aigency'),
                    'section'       => 'aigency_header_button',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_button_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------- //
            // --- Header Button URL ---- //
            // -------------------------- //
            $wp_setting_name = 'header_button_url';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'esc_url_raw'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Header button link', 'aigency'),
                    'section'       => 'aigency_header_button',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_button_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------- //
            // --- Header Button Target --- //
            // ------------------------- //
            $wp_setting_name = 'header_button_target';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Open Link in New Tab', 'aigency'),
                    'section'       => 'aigency_header_button',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_button_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));   


            // ---############################--- //
            // ---### Header Menu Settings ###--- //
            // ---############################--- //
            $wp_customize->add_section('aigency_header_menu',
                array(
                    'title' => esc_html__('Header Menu', 'aigency'),
                    'panel' => 'aigency_header_settings'
                )
            );

            // -------------------------- //
            // --- Header Menu Status --- //
            // -------------------------- //
            $wp_setting_name = 'header_menu_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show header menu', 'aigency'),
                    'section'   => 'aigency_header_menu',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------------- //
            // --- Header Menu Style --- //
            // ------------------------- //
            $wp_setting_name = 'header_menu_style';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Menu Style', 'aigency'),
                    'section'       => 'aigency_header_menu',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => array(
                        'standard'      => esc_html__('Standard', 'aigency'),
                        'compact'       => esc_html__('Compact', 'aigency')
                    )
                )
            ));

            // ------------------------------- //
            // --- Header Menu Image Status --- //
            // ------------------------------ //
            $wp_setting_name = 'header_menu_bg_image_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Header Menu Background Image', 'aigency'),
                    'section'   => 'aigency_header_menu',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    ),
                    'dependency'    => [
                        [
                            'control'   => 'header_menu_style',
                            'operator'  => '==',
                            'value'     => 'compact'
                        ]
                    ]
                )
            ));

            // ------------------------------------- //
            // --- Header Menu Background Image --- //
            // ------------------------------------ //
            $wp_setting_name = 'header_menu_bg_image';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'esc_url_raw'
                )
            );
            $wp_customize->add_control(new Aigency_Image_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Header Menu Background Image', 'aigency'),
                    'section'       => 'aigency_header_menu',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_menu_bg_image_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ],
                        [
                            'control'   => 'header_menu_style',
                            'operator'  => '==',
                            'value'     => 'compact'
                        ]
                    ]
                )
            ));

            // -------------------------- //
            // --- Header Menu Select --- //
            // -------------------------- //
            $wp_setting_name = 'header_menu_select';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Select Menu', 'aigency'),
                    'section'       => 'aigency_header_menu',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_all_menu_list()
                )
            ));

            // ------------------------- //
            // --- Header Menu Label --- //
            // ------------------------- //
            $wp_setting_name = 'header_menu_label';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Menu label', 'aigency'),
                    'section'       => 'aigency_header_menu',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'header_menu_style',
                            'operator'  => '==',
                            'value'     => 'compact'
                        ]
                    ]
                )
            ));

            // ----------------------------- //
            // --- Header Menu Customize --- //
            // ----------------------------- //
            $wp_setting_name = 'header_menu_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Customize', 'aigency'),
                    'section'   => 'aigency_header_menu',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------- //
            // --- Header Font --- //
            // ------------------- //
            $wp_setting_name = 'header_menu_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Menu Font', 'aigency'),
                    'section'       => 'aigency_header_menu',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'text_transform'    => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_style'        => true,
                        'font_weight'       => true
                    ],
                    'dependency'            => [
                        [
                            'control'           => 'header_menu_customize',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));

            // --------------------- //
            // --- Sub Menu Font --- //
            // --------------------- //
            $wp_setting_name = 'header_sub_menu_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Sub Menu Font', 'aigency'),
                    'section'       => 'aigency_header_menu',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'text_transform'    => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_style'        => true,
                        'font_weight'       => true
                    ],
                    'separator'     => 'before',
                    'dependency'    => [
                        [
                            'control'           => 'header_menu_customize',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));


            // ---####################--- //
            // ---### Header Icons ###--- //
            // ---####################--- //
            $wp_customize->add_section('header_icons',
                array(
                    'title' => esc_html__('Header Icons', 'aigency'),
                    'panel' => 'aigency_header_settings'
                )
            );

            // ------------------------- //
            // --- Header Side Panel --- //
            // ------------------------- //
            $wp_setting_name = 'side_panel_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show side panel trigger', 'aigency'),
                    'section'   => 'header_icons',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // --------------------- //
            // --- Header Search --- //
            // --------------------- //
            $wp_setting_name = 'header_search_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show header search', 'aigency'),
                    'section'   => 'header_icons',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));


            if ( class_exists('WooCommerce') ) {
                // ------------------------ //
                // --- Header Mini Cart --- //
                // ------------------------ //
                $wp_setting_name = 'header_minicart_status';
                $wp_customize->add_setting(
                    $wp_setting_name,
                    array(
                        'default'           => $aigency_customizer_default_values[$wp_setting_name],
                        'sanitize_callback' => 'aigency_sanitize_choice'
                    )
                );
                $wp_customize->add_control(new Aigency_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label'     => esc_html__('Show product cart', 'aigency'),
                        'section'   => 'header_icons',
                        'type'      => 'select',
                        'settings'  => $wp_setting_name,
                        'choices'   => array(
                            'on'        => esc_html__('Yes', 'aigency'),
                            'off'       => esc_html__('No', 'aigency')
                        )
                    )
                ));
            }

            // ------------------------------- //
            // ---------- Page Tile ---------- //
            // ------------------------------- //
            $wp_customize->add_panel('aigency_page_title_settings',
                array(
                    'title'     => esc_html__('Page Title Settings', 'aigency'),
                    'priority'  => 140
                )
            );

            // ---########################--- //
            // ---### General Settings ###--- //
            // ---########################--- //
            $wp_customize->add_section('aigency_page_title_general',
                array(
                    'title' => esc_html__('General', 'aigency'),
                    'panel' => 'aigency_page_title_settings'
                )
            );

            // ------------------------- //
            // --- Page Title Status --- //
            // ------------------------- //
            $wp_setting_name = 'page_title_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show page title', 'aigency'),
                    'section'   => 'aigency_page_title_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // -------------------------- //
            // --- Page Title Overlay --- //
            // -------------------------- //
            $wp_setting_name = 'page_title_overlay_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show overlay', 'aigency'),
                    'section'   => 'aigency_page_title_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // -------------------------------- //
            // --- Page Title Overlay Color --- //
            // -------------------------------- //
            $wp_setting_name = 'page_title_overlay_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Overlay color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_overlay_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------- //
            // --- Page Title Customize --- //
            // ---------------------------- //
            $wp_setting_name = 'page_title_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Customize', 'aigency'),
                    'section'   => 'aigency_page_title_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    ),
                    'separator' => 'before'
                )
            ));

            // ------------------------------- //
            // --- Page Title Block Height --- //
            // ------------------------------- //
            $wp_setting_name = 'page_title_height';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Page title height, in px', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'type'          => 'number',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------- //
            // --- Page Title Default Text Color --- //
            // ------------------------------------- //
            $wp_setting_name = 'page_title_default_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Default text color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ---------------------------------- //
            // --- Page Title Dark Text Color --- //
            // ---------------------------------- //
            $wp_setting_name = 'page_title_dark_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Dark text color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------------------- //
            // --- Page Title Light Text Color --- //
            // ----------------------------------- //
            $wp_setting_name = 'page_title_light_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Light text color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------ //
            // --- Page Title Accent Text Color --- //
            // ------------------------------------ //
            $wp_setting_name = 'page_title_accent_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Accent text color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------- //
            // --- Page Title Border Color --- //
            // ------------------------------- //
            $wp_setting_name = 'page_title_border_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Border color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // --------------------------------------- //
            // --- Page Title Hovered Border Color --- //
            // --------------------------------------- //
            $wp_setting_name = 'page_title_border_hover_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Hovered border color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------------------- //
            // --- Page Title Background Color --- //
            // ----------------------------------- //
            $wp_setting_name = 'page_title_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ----------------------------------------------- //
            // --- Page Title Alternative Background Color --- //
            // ----------------------------------------------- //
            $wp_setting_name = 'page_title_background_alter_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Alternative background color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------ //
            // --- Page Title Button Text Color --- //
            // ------------------------------------ //
            $wp_setting_name = 'page_title_button_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Text Color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // -------------------------------------- //
            // --- Page Title Button Border Color --- //
            // -------------------------------------- //
            $wp_setting_name = 'page_title_button_border_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));


            // ------------------------------------------ //
            // --- Page Title Button Background Color --- //
            // ------------------------------------------ //
            $wp_setting_name = 'page_title_button_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Color', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Page Title Button Background Color 2 --- //
            // -------------------------------------- //
            $wp_setting_name = 'page_title_button_background_color_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Color Additional', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------ //
            // --- Page Title Button Text Hover --- //
            // ------------------------------------ //
            $wp_setting_name = 'page_title_button_text_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Text Hover', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Page Title Button Border Hover --- //
            // -------------------------------------- //
            $wp_setting_name = 'page_title_button_border_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Hover', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------------ //
            // --- Page Title Button Background Hover --- //
            // ------------------------------------------ //
            $wp_setting_name = 'page_title_button_background_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Hover', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------------------- //
            // --- Page Title Background Image --- //
            // ----------------------------------- //
            $wp_setting_name = 'page_title_background_image';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'esc_url_raw'
                )
            );
            $wp_customize->add_control(new Aigency_Image_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Image', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // -------------------------------------- //
            // --- Page Title Background Position --- //
            // -------------------------------------- //
            $wp_setting_name = 'page_title_background_position';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Position', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_background_position_options(),
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------ //
            // --- Page Title Background Repeat --- //
            // ------------------------------------ //
            $wp_setting_name = 'page_title_background_repeat';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Repeat', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_background_repeat_options(),
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Page Title Background Size --- //
            // ---------------------------------- //
            $wp_setting_name = 'page_title_background_size';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Size', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_background_size_options(),
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------------------------- //
            // --- Hide Page Title Background on Mobile Devices --- //
            // ---------------------------------------------------- //
            $wp_setting_name = 'hide_page_title_background_mobile';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Hide Background Image on Mobile Devices', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------------------------- //
            // --- Hide Page Title Background on Tablet Devices --- //
            // ---------------------------------------------------- //
            $wp_setting_name = 'hide_page_title_background_tablet';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Hide Background Image on Tablet Devices', 'aigency'),
                    'section'       => 'aigency_page_title_general',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));


            // ---########################--- //
            // ---### Heading Settings ###--- //
            // ---########################--- //
            $wp_customize->add_section('aigency_page_title_heading',
                array(
                    'title' => esc_html__('Heading', 'aigency'),
                    'panel' => 'aigency_page_title_settings'
                )
            );

            // ------------------------------------ //
            // --- Page Title Heading Customize --- //
            // ------------------------------------ //
            $wp_setting_name = 'page_title_heading_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Customize', 'aigency'),
                    'section'       => 'aigency_page_title_heading',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));            

            // ------------------------------- //
            // --- Page Title Heading Font --- //
            // ------------------------------- //
            $wp_setting_name = 'page_title_heading_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Heading Font', 'aigency'),
                    'section'       => 'aigency_page_title_heading',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'text_transform'    => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_style'        => true,
                        'font_weight'       => true
                    ],
                    'dependency'            => [
                        [
                            'control'           => 'page_title_heading_customize',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));


            // ---###########################--- //
            // ---### Subheading Settings ###--- //
            // ---###########################--- //
            $wp_customize->add_section('aigency_page_title_breadcrumbs',
                array(
                    'title' => esc_html__('Breadcrumbs', 'aigency'),
                    'panel' => 'aigency_page_title_settings'
                )
            );

            // ------------------------------------- //
            // --- Page Title Breadcrumbs Status --- //
            // ------------------------------------- //
            $wp_setting_name = 'page_title_breadcrumbs_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show page title breadcrumbs', 'aigency'),
                    'section'   => 'aigency_page_title_breadcrumbs',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ---------------------------------------- //
            // --- Page Title Breadcrumbs Customize --- //
            // ---------------------------------------- //
            $wp_setting_name = 'page_title_breadcrumbs_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Customize', 'aigency'),
                    'section'   => 'aigency_page_title_breadcrumbs',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ----------------------------------- //
            // --- Page Title Breadcrumbs Font --- //
            // ----------------------------------- //
            $wp_setting_name = 'page_title_breadcrumbs_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Breadcrumbs Font', 'aigency'),
                    'section'       => 'aigency_page_title_breadcrumbs',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'text_transform'    => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_style'        => true,
                        'font_weight'       => true
                    ],
                    'dependency'            => [
                        [
                            'control'           => 'page_title_breadcrumbs_customize',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------------------- //
            // --- Breadcrumbs Additional Text --- //
            // ----------------------------------- //
            $wp_setting_name = 'page_title_breadcrumbs_text';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Breadcrumbs Additional Text', 'aigency'),
                    'section'       => 'aigency_page_title_breadcrumbs',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'            => [
                        [
                            'control'           => 'page_title_breadcrumbs_status',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------------------------- //
            // --- Breadcrumbs Additional Text Color --- //
            // ----------------------------------------- //
            $wp_setting_name = 'page_title_breadcrumbs_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Breadcrumbs Additional Text Color', 'aigency'),
                    'section'       => 'aigency_page_title_breadcrumbs',
                    'settings'      => $wp_setting_name,
                    'dependency'            => [
                        [
                            'control'           => 'page_title_breadcrumbs_status',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));

            // ---################################--- //
            // ---### Additional Text Settings ###--- //
            // ---################################--- //
            $wp_customize->add_section('aigency_page_title_additional',
                array(
                    'title' => esc_html__('Heading Additional Text', 'aigency'),
                    'panel' => 'aigency_page_title_settings'
                )
            );

            // ----------------------- //
            // --- Additional Text --- //
            // ----------------------- //
            $wp_setting_name = 'page_title_additional_text';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Additional Text', 'aigency'),
                    'section'       => 'aigency_page_title_additional',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name
                )
            ));

            // --------------------------------- //
            // --- Additional Text Customize --- //
            // --------------------------------- //
            $wp_setting_name = 'page_title_additional_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Customize', 'aigency'),
                    'section'   => 'aigency_page_title_additional',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ----------------------------- //
            // --- Additional Text Color --- //
            // ----------------------------- //
            $wp_setting_name = 'page_title_additional_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_color'
                )
            );
            $wp_customize->add_control(new Aigency_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Additional Text Color', 'aigency'),
                    'section'       => 'aigency_page_title_additional',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'page_title_additional_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------- //
            // --- Page Title Additional Text Font --- //
            // ------------------------------------- //
            $wp_setting_name = 'page_title_additional_text_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Additional Text Font', 'aigency'),
                    'section'       => 'aigency_page_title_additional',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'text_transform'    => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_style'        => true,
                        'font_weight'       => true
                    ],
                    'dependency'            => [
                        [
                            'control'           => 'page_title_additional_customize',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------- //
            // --- Page Title Additional Text Position --- //
            // ------------------------------------- //
            $wp_setting_name = 'page_title_additional_text_bottom_position';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Additional Text Offset Bottom, in %', 'aigency'),
                    'section'       => 'aigency_page_title_additional',
                    'type'          => 'number',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'           => 'page_title_additional_customize',
                            'operator'          => '==',
                            'value'             => 'on'
                        ]
                    ]
                )
            ));
        }

        // ----------------------- //
        // --- Additional Font --- //
        // ----------------------- //
        $wp_customize->add_panel('aigency_additional_font_settings',
            array(
                'title'     => esc_html__('Additional Font', 'aigency'),
                'priority'  => 141
            )
        );

        $wp_customize->add_section('aigency_typography_form_fields_font',
            array(
                'title' => esc_html__('Form Fields Typography Settings', 'aigency'),
                'panel'  => 'aigency_additional_font_settings'
            )
        );
        
        $wp_setting_name = 'additional_font';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Form Fields Font', 'aigency'),
                'section'       => 'aigency_typography_form_fields_font',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                    'font_size'         => true,
                    'line_height'       => true,
                    'font_style'        => true,
                    'font_weight'       => true
                ]
            )
        ));

        $wp_customize->add_section('aigency_typography_additional_font',
            array(
                'title' => esc_html__('Additional Typography Settings', 'aigency'),
                'panel'  => 'aigency_additional_font_settings'
            )
        );

        $wp_setting_name = 'additional_font_family';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Additional Font', 'aigency'),
                'section'       => 'aigency_typography_additional_font',
                'settings'      => $wp_setting_name,
                'show_field'    => [
                    'font_family'       => true,
                    'font_backup'       => true,
                    'font_styles'       => true,
                    'font_subset'       => true,
                ]
            )
        ));

        if ( !did_action('elementor/loaded') ) {

            // -------------------------------- //
            // ---------- Typography ---------- //
            // -------------------------------- //
            $wp_customize->add_panel('aigency_typography_settings',
                array(
                    'title'     => esc_html__('Typography Settings', 'aigency'),
                    'priority'  => 142
                )
            );

            // ---#################--- //
            // ---### Main Font ###--- //
            // ---#################--- //
            $wp_customize->add_section('aigency_typography_main_font',
                array(
                    'title' => esc_html__('Main Font', 'aigency'),
                    'panel' => 'aigency_typography_settings'
                )
            );

            // ----------------- //
            // --- Main Font --- //
            // ----------------- //
            $wp_setting_name = 'main_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Main Font', 'aigency'),
                    'section'       => 'aigency_typography_main_font',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'text_transform'    => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_style'        => true,
                        'font_weight'       => true
                    ]
                )
            ));            

            // ---################--- //
            // ---### Headings ###--- //
            // ---################--- //
            $wp_customize->add_section('aigency_typography_headings',
                array(
                    'title' => esc_html__('Headings', 'aigency'),
                    'panel' => 'aigency_typography_settings'
                )
            );        

            // --------------- //
            // --- H1 Font --- //
            // --------------- //
            $wp_setting_name = 'h1_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('H1 Font', 'aigency'),
                    'section'       => 'aigency_typography_headings',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'text_transform'    => true,
                        'font_style'        => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_weight'       => true
                    ],
                    'separator'             => 'before'
                )
            ));

            // --------------- //
            // --- H2 Font --- //
            // --------------- //
            $wp_setting_name = 'h2_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('H2 Font', 'aigency'),
                    'section'       => 'aigency_typography_headings',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'text_transform'    => true,
                        'font_style'        => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_weight'       => true
                    ],
                    'separator'             => 'before'
                )
            ));

            // --------------- //
            // --- H3 Font --- //
            // --------------- //
            $wp_setting_name = 'h3_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('H3 Font', 'aigency'),
                    'section'       => 'aigency_typography_headings',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'text_transform'    => true,
                        'font_style'        => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_weight'       => true
                    ],
                    'separator'             => 'before'
                )
            ));

            // --------------- //
            // --- H4 Font --- //
            // --------------- //
            $wp_setting_name = 'h4_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('H4 Font', 'aigency'),
                    'section'       => 'aigency_typography_headings',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'text_transform'    => true,
                        'font_style'        => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_weight'       => true
                    ],
                    'separator'             => 'before'
                )
            ));

            // --------------- //
            // --- H5 Font --- //
            // --------------- //
            $wp_setting_name = 'h5_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('H5 Font', 'aigency'),
                    'section'       => 'aigency_typography_headings',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'text_transform'    => true,
                        'font_style'        => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_weight'       => true
                    ],
                    'separator'             => 'before'
                )
            ));

            // --------------- //
            // --- H6 Font --- //
            // --------------- //
            $wp_setting_name = 'h6_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('H6 Font', 'aigency'),
                    'section'       => 'aigency_typography_headings',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'text_transform'    => true,
                        'font_style'        => true,
                        'font_size'         => true,
                        'line_height'       => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_weight'       => true
                    ],
                    'separator'             => 'before'
                )
            ));

            // ---###############--- //
            // ---### Buttons ###--- //
            // ---###############--- //
            $wp_customize->add_section('aigency_typography_buttons',
                array(
                    'title' => esc_html__('Buttons', 'aigency'),
                    'panel' => 'aigency_typography_settings'
                )
            );

            // --------------------------- //
            // --- Buttons Font Family --- //
            // --------------------------- //
            $wp_setting_name = 'buttons_font';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Google_Font_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Buttons Font', 'aigency'),
                    'section'       => 'aigency_typography_buttons',
                    'settings'      => $wp_setting_name,
                    'show_field'    => [
                        'font_family'       => true,
                        'font_backup'       => true,
                        'font_styles'       => true,
                        'font_subset'       => true,
                        'font_size'         => true,
                        'text_transform'    => true,
                        'letter_spacing'    => true,
                        'word_spacing'      => true,
                        'font_style'        => true,
                        'font_weight'       => true
                    ]
                )
            ));
        }

        // ---------------------------------- //
        // ---------- Social Links ---------- //
        // ---------------------------------- //
        $wp_customize->add_section('aigency_socials_settings',
            array(
                'title'     => esc_html__('Social Links', 'aigency'),
                'priority'  => 145
            )
        );

        // ---------------------- //
        // --- Socials Target --- //
        // ---------------------- //
        $wp_setting_name = 'socials_target';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_checkbox'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Open Socials in New Tab', 'aigency'),
                'section'       => 'aigency_socials_settings',
                'type'          => 'checkbox',
                'settings'      => $wp_setting_name
            )
        ));

        // ---------------------- //
        // --- Social Buttons --- //
        // ---------------------- //
        $wp_setting_name = 'social_buttons';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'sanitize_callback' => 'aigency_sanitize_repeater'
            )
        );
        $wp_customize->add_control( new Aigency_Customize_Socials_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'                 => esc_html__('Social Buttons', 'aigency'),
                'section'               => 'aigency_socials_settings',
                'separator'             => 'before'
            )
        ));


        // ------------------------------------ //
        // ---------- Color Settings ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('aigency_color_settings',
            array(
                'title'     => esc_html__('Color Settings', 'aigency'),
                'priority'  => 150
            )
        );

        // ---################--- //
        // ---### STANDARD ###--- //
        // ---################--- //
        $wp_customize->add_section('aigency_standard_colors',
            array(
                'title' => esc_html__('Standard Colors', 'aigency'),
                'panel' => 'aigency_color_settings'
            )
        );

        // ----------------------------------- //
        // --- Standard Default Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'standard_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // -------------------------------- //
        // --- Standard Dark Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'standard_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Standard Light Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'standard_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Accent Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Contrast Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_contrast_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Contrast Text Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Input Dark Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_input_dark_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Input Dark Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));
        

        // ----------------------------- //
        // --- Standard Border Color --- //
        // ----------------------------- //
        $wp_setting_name = 'standard_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Standard Border Hover Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'standard_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Hover Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Standard Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'standard_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // --------------------------------------- //
        // --- Standard Background Alter Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'standard_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Button Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ------------------------------------ //
        // --- Standard Button Border Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'standard_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Standard Button Border Color 2 --- //
        // ------------------------------------ //
        $wp_setting_name = 'standard_button_border_color_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color Additional', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Color --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Color 2 --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_color_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color Additional', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Standard Button Text Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'standard_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Standard Button Border Hover --- //
        // ------------------------------------ //
        $wp_setting_name = 'standard_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Standard Button Border Hover 2 --- //
        // ------------------------------------ //
        $wp_setting_name = 'standard_button_border_hover_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover Additional', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Hover --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Hover 2 --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_hover_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover Additional', 'aigency'),
                'section'       => 'aigency_standard_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));


        // ---------------------------------------- //
        // --- Standard Button Border Style --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_border_style';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Button Border Style', 'aigency'),
                'section'   => 'aigency_standard_colors',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'gradient'    => esc_html__('Gradient', 'aigency'),
                    'solid'       => esc_html__('Solid', 'aigency')
                )
            )
        ));

        // ---------------------------------------- //
        // --- Standard Button Background Style --- //
        // ---------------------------------------- //
        $wp_setting_name = 'standard_button_background_style';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Button Background Style', 'aigency'),
                'section'   => 'aigency_standard_colors',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'gradient'    => esc_html__('Gradient', 'aigency'),
                    'solid'       => esc_html__('Solid', 'aigency')
                )
            )
        ));

        // ---################--- //
        // ---### CONTRAST ###--- //
        // ---################--- //
        $wp_customize->add_section('aigency_contrast_colors',
            array(
                'title' => esc_html__('Contrast Colors', 'aigency'),
                'panel' => 'aigency_color_settings'
            )
        );

        // ----------------------------------- //
        // --- Contrast Default Text Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'contrast_default_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Default Text Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // -------------------------------- //
        // --- Contrast Dark Text Color --- //
        // -------------------------------- //
        $wp_setting_name = 'contrast_dark_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Dark Text Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Contrast Light Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'contrast_light_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Light Text Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Accent Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_accent_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Accent Text Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Input Dark Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_input_dark_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Input Dark Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ----------------------------- //
        // --- Contrast Border Color --- //
        // ----------------------------- //
        $wp_setting_name = 'contrast_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ----------------------------------- //
        // --- Contrast Border Hover Color --- //
        // ----------------------------------- //
        $wp_setting_name = 'contrast_border_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Border Hover Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- Contrast Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'contrast_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // --------------------------------------- //
        // --- Contrast Background Alter Color --- //
        // --------------------------------------- //
        $wp_setting_name = 'contrast_background_alter_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Alternative Background Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Button Text Color --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_button_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'separator'     => 'before'
            )
        ));

        // ------------------------------------ //
        // --- Contrast Button Border Color --- //
        // ------------------------------------ //
        $wp_setting_name = 'contrast_button_border_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Contrast Button Border Color 2 --- //
        // ------------------------------------ //
        $wp_setting_name = 'contrast_button_border_color_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Color Additional', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Color --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Color 2 --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_color_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Color Additional', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------- //
        // --- Contrast Button Text Hover --- //
        // ---------------------------------- //
        $wp_setting_name = 'contrast_button_text_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Text Hover', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Contrast Button Border Hover --- //
        // ------------------------------------ //
        $wp_setting_name = 'contrast_button_border_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ------------------------------------ //
        // --- Contrast Button Border Hover 2 --- //
        // ------------------------------------ //
        $wp_setting_name = 'contrast_button_border_hover_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Border Hover Additional', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Hover --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Hover 2 --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_hover_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Button Background Hover Additional', 'aigency'),
                'section'       => 'aigency_contrast_colors',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Border Style --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_border_style';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Button Border Style', 'aigency'),
                'section'   => 'aigency_contrast_colors',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'gradient'    => esc_html__('Gradient', 'aigency'),
                    'solid'       => esc_html__('Solid', 'aigency')
                )
            )
        ));

        // ---------------------------------------- //
        // --- Contrast Button Background Style --- //
        // ---------------------------------------- //
        $wp_setting_name = 'contrast_button_background_style';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Button Background Style', 'aigency'),
                'section'   => 'aigency_contrast_colors',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'gradient'    => esc_html__('Gradient', 'aigency'),
                    'solid'       => esc_html__('Solid', 'aigency')
                )
            )
        ));


        if ( !did_action('elementor/loaded') || !function_exists('hfe_init') ) {

            // ------------------------------------------- //
            // ---------- Footer Settings Panel ---------- //
            // ------------------------------------------- //
            $wp_customize->add_panel('aigency_footer_settings',
                array(
                    'title'     => esc_html__('Footer Settings', 'aigency'),
                    'priority'  => 160
                )
            );

            // ---###############--- //
            // ---### General ###--- //
            // ---###############--- //
            $wp_customize->add_section('aigency_footer_general',
                array(
                    'title' => esc_html__('General', 'aigency'),
                    'panel' => 'aigency_footer_settings'
                )
            );

            // --------------------- //
            // --- Footer Status --- //
            // --------------------- //
            $wp_setting_name = 'footer_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Footer', 'aigency'),
                    'section'   => 'aigency_footer_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // -------------------- //
            // --- Footer Style --- //
            // -------------------- //
            $wp_setting_name = 'footer_style';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Footer Style', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => array(
                        'type-1'        => esc_html__('Style 1', 'aigency'),
                        'type-2'        => esc_html__('Style 2', 'aigency'),
                        'type-3'        => esc_html__('Style 3', 'aigency'),
                        'type-4'        => esc_html__('Style 4', 'aigency'),
                        'type-5'        => esc_html__('Style 5', 'aigency')
                    ),
                    'dependency'    => [
                        [
                            'control'   => 'footer_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ----------------------------- //
            // --- Footer Border Radius --- //
            // ---------------------------- //
            $wp_setting_name = 'footer_border_radius';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Footer Border Radius', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => array(
                        'on'        => esc_html__('On', 'aigency'),
                        'off'       => esc_html__('Off', 'aigency'),
                        'no-top-border-radius'       => esc_html__('No Top Border Radius', 'aigency'),
                        'no-bottom-border-radius'    => esc_html__('No Bottom Border Radius', 'aigency'),
                    ),
                    'dependency'    => [
                        [
                            'control'   => 'footer_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------ //
            // --- Footer Customize --- //
            // ------------------------ //
            $wp_setting_name = 'footer_customize';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Customize', 'aigency'),
                    'section'   => 'aigency_footer_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // --------------------------------- //
            // --- Footer Default Text Color --- //
            // --------------------------------- //
            $wp_setting_name = 'footer_default_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Default Text Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ------------------------------ //
            // --- Footer Dark Text Color --- //
            // ------------------------------ //
            $wp_setting_name = 'footer_dark_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Dark Text Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------- //
            // --- Footer Light Text Color --- //
            // ------------------------------- //
            $wp_setting_name = 'footer_light_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Light Text Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Footer Accent Text Color --- //
            // -------------------------------- //
            $wp_setting_name = 'footer_accent_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Accent Text Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Footer Input Dark Color --- //
            // -------------------------------- //
            $wp_setting_name = 'footer_input_dark_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Input Dark Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Footer Border Text Color --- //
            // -------------------------------- //
            $wp_setting_name = 'footer_border_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Border Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ---------------------------------------- //
            // --- Footer Hovered Border Text Color --- //
            // ---------------------------------------- //
            $wp_setting_name = 'footer_border_hover_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Hovered Border Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------- //
            // --- Footer Background Color --- //
            // ------------------------------- //
            $wp_setting_name = 'footer_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ------------------------------------------- //
            // --- Footer Alternative Background Color --- //
            // ------------------------------------------- //
            $wp_setting_name = 'footer_background_alter_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Alternative Background Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------------ //
            // --- Footer Button Text Color --- //
            // ------------------------------------ //
            $wp_setting_name = 'footer_button_text_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Text Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ---------------------------------- //
            // --- Footer Button Border Color --- //
            // ---------------------------------- //
            $wp_setting_name = 'footer_button_border_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Footer Button Border Color 2 --- //
            // ---------------------------------- //
            $wp_setting_name = 'footer_button_border_color_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Color Additional', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Footer Button Background Color --- //
            // -------------------------------------- //
            $wp_setting_name = 'footer_button_background_color';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Color', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Footer Button Background Color 2 --- //
            // -------------------------------------- //
            $wp_setting_name = 'footer_button_background_color_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Color Additional', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Footer Button Text Hover --- //
            // -------------------------------- //
            $wp_setting_name = 'footer_button_text_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Text Hover', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Footer Button Border Hover --- //
            // ---------------------------------- //
            $wp_setting_name = 'footer_button_border_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Hover', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------- //
            // --- Footer Button Border Hover 2 --- //
            // ---------------------------------- //
            $wp_setting_name = 'footer_button_border_hover_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Border Hover Additional', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Footer Button Background Hover --- //
            // -------------------------------------- //
            $wp_setting_name = 'footer_button_background_hover';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Hover', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------------- //
            // --- Footer Button Background Hover 2 --- //
            // -------------------------------------- //
            $wp_setting_name = 'footer_button_background_hover_add';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_alpha_color'
                )
            );
            $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Button Background Hover Additional', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'show_opacity'  => true,
                    'palette'       => aigency_get_custom_color_palette(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------------- //
            // --- Footer Button Border Style --- //
            // ---------------------------------------- //
            $wp_setting_name = 'footer_button_border_style';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Button Border Style', 'aigency'),
                    'section'   => 'aigency_footer_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'gradient'    => esc_html__('Gradient', 'aigency'),
                        'solid'       => esc_html__('Solid', 'aigency')
                    ),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ---------------------------------------- //
            // --- Footer Background Border Style --- //
            // ---------------------------------------- //
            $wp_setting_name = 'footer_button_background_style';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Button Background Style', 'aigency'),
                    'section'   => 'aigency_footer_general',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'gradient'    => esc_html__('Gradient', 'aigency'),
                        'solid'       => esc_html__('Solid', 'aigency')
                    ),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------- //
            // --- Footer Background Image --- //
            // ------------------------------- //
            $wp_setting_name = 'footer_background_image';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'esc_url_raw'
                )
            );
            $wp_customize->add_control(new Aigency_Image_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Bottom Image', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ],
                    'separator'     => 'before'
                )
            ));

            // ---------------------------------- //
            // --- Footer Background Position --- //
            // ---------------------------------- //
            $wp_setting_name = 'footer_background_position';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Position', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_background_position_options(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // -------------------------------- //
            // --- Footer Background Repeat --- //
            // -------------------------------- //
            $wp_setting_name = 'footer_background_repeat';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Repeat', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_background_repeat_options(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------ //
            // --- Footer Background Size --- //
            // ------------------------------ //
            $wp_setting_name = 'footer_background_size';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Background Size', 'aigency'),
                    'section'       => 'aigency_footer_general',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_background_size_options(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_customize',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));


            // ---######################--- //
            // ---### Footer Widgets ###--- //
            // ---######################--- //
            $wp_customize->add_section('aigency_footer_sidebar',
                array(
                    'title' => esc_html__('Footer Sidebar', 'aigency'),
                    'panel' => 'aigency_footer_settings'
                )
            );

            // ----------------------------- //
            // --- Footer Widgets Status --- //
            // ----------------------------- //
            $wp_setting_name = 'footer_sidebar_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Footer Widgets', 'aigency'),
                    'section'   => 'aigency_footer_sidebar',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ----------------------------- //
            // --- Footer Sidebar Select --- //
            // ----------------------------- //
            $wp_setting_name = 'footer_sidebar_select';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Select Sidebar', 'aigency'),
                    'section'       => 'aigency_footer_sidebar',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_all_sidebar_list(),
                    'dependency'    => [
                        [
                            'control'   => 'footer_sidebar_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));


            // ---#################--- //
            // ---### Copyright ###--- //
            // ---#################--- //
            $wp_customize->add_section('aigency_footer_copyright',
                array(
                    'title' => esc_html__('Copyright', 'aigency'),
                    'panel' => 'aigency_footer_settings'
                )
            );

            // ------------------------ //
            // --- Copyright Status --- //
            // ------------------------ //
            $wp_setting_name = 'footer_copyright_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Copyright', 'aigency'),
                    'section'   => 'aigency_footer_copyright',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ---------------------- //
            // --- Copyright Text --- //
            // ---------------------- //
            $wp_setting_name = 'footer_copyright_text';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'wp_kses_post'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Copyright Text', 'aigency'),
                    'section'       => 'aigency_footer_copyright',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name
                )
            ));

            // ---##############################--- //
            // ---### Footer Additional Menu ###--- //
            // ---##############################--- //
            $wp_customize->add_section('aigency_footer_additional_menu',
                array(
                    'title' => esc_html__('Footer Additional Menu', 'aigency'),
                    'panel' => 'aigency_footer_settings'
                )
            );

            // ------------------------------------- //
            // --- Footer Additional Menu Status --- //
            // ------------------------------------- //
            $wp_setting_name = 'footer_additional_menu_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Additional Footer Menu', 'aigency'),
                    'section'   => 'aigency_footer_additional_menu',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------------------------- //
            // --- Footer Additional Menu Select --- //
            // ------------------------------------- //
            $wp_setting_name = 'footer_additional_menu_select';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Select Menu', 'aigency'),
                    'section'   => 'aigency_footer_additional_menu',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => aigency_get_all_menu_list()
                )
            )); 
        }

        // ------------------------------ //
        // ---------- Layout Settings ---------- //
        // ------------------------------ //
        $wp_customize->add_section('aigency_layout_settings',
            array(
                'title'     => esc_html__('Layout Settings', 'aigency'),
                'priority'  => 170
            )
        );

        // ----------------------------- //
        // --- Remove Top Margin --- //
        // ----------------------------- //
        $wp_setting_name = 'content_top_margin';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Remove Content Top Margin', 'aigency'),
                'section'   => 'aigency_layout_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'      => esc_html__('Yes', 'aigency'),
                    'off'     => esc_html__('No', 'aigency')
                )
            )
        ));

        // ----------------------------- //
        // --- Remove Bottom Margin --- //
        // ----------------------------- //
        $wp_setting_name = 'content_bottom_margin';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Remove Content Bottom Margin', 'aigency'),
                'section'   => 'aigency_layout_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'      => esc_html__('Yes', 'aigency'),
                    'off'     => esc_html__('No', 'aigency')
                )
            )
        ));        

        if ( !did_action('elementor/loaded') || !function_exists('hfe_init') ) {
            
            // ---------------------------------------- //
            // ---------- Side Panel Sidebar ---------- //
            // ---------------------------------------- //
            $wp_customize->add_section('aigency_side_panel_settings', array(
                    'title'     => esc_html__('Side Panel Settings', 'aigency'),
                    'priority'  => 195
                )
            );

            // --------------------------- //
            // --- Side Sidebar Select --- //
            // --------------------------- //
            $wp_setting_name = 'side_panel_sidebar_select';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default' => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_html__('Select Sidebar', 'aigency'),
                    'section' => 'aigency_side_panel_settings',
                    'type' => 'select',
                    'settings' => $wp_setting_name,
                    'choices' => aigency_get_all_sidebar_list()
                )
            ));

            // ------------------------------- //
            // --- Side Panel Logo Status --- //
            // ------------------------------ //
            $wp_setting_name = 'sidebar_logo_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Logo', 'aigency'),
                    'section'   => 'aigency_side_panel_settings',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------------ //
            // --- Side Panel Logo --- //
            // ----------------------- //
            $wp_setting_name = 'sidebar_logo_image';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'esc_url_raw'
                )
            );
            $wp_customize->add_control(new Aigency_Image_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Logo Image', 'aigency'),
                    'section'       => 'aigency_side_panel_settings',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'sidebar_logo_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------- //
            // --- Logo Retina --- //
            // ------------------- //
            $wp_setting_name = 'sidebar_logo_retina';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Logo Retina', 'aigency'),
                    'section'       => 'aigency_side_panel_settings',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'sidebar_logo_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));
            
            // ------------------------------- //
            // --- Side Panel Image Status --- //
            // ------------------------------ //
            $wp_setting_name = 'side_panel_bg_image_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Side Panel Background Image', 'aigency'),
                    'section'   => 'aigency_side_panel_settings',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // ------------------------ //
            // --- Side Panel Background Image --- //
            // ----------------------- //
            $wp_setting_name = 'side_panel_bg_image';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'esc_url_raw'
                )
            );
            $wp_customize->add_control(new Aigency_Image_Custom_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Side Panel Background Image', 'aigency'),
                    'section'       => 'aigency_side_panel_settings',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'side_panel_bg_image_status',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // ------------------------------ //
            // --- Side Panel Socials Status --- //
            // ------------------------------ //
            $wp_setting_name = 'side_panel_socials_status';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Social Buttons', 'aigency'),
                    'section'   => 'aigency_side_panel_settings',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));
        }        

        // --------------------------------- //
        // ---------- Blog Panel ---------- //
        // --------------------------------- //
        $wp_customize->add_panel('aigency_blog_settings_panel',
            array(
                'title'     => esc_html__('Blog', 'aigency'),
                'priority'  => 205
            )
        );

        // ---####################--- //
        // ---### Blog Archive ###--- //
        // ---####################--- //
        $wp_customize->add_section('aigency_blog_archive',
            array(
                'title' => esc_html__('Archive Settings', 'aigency'),
                'panel' => 'aigency_blog_settings_panel'
            )
        );

        // -------------------------------- //
        // --- Archive Sidebar Position --- //
        // -------------------------------- //
        $wp_setting_name = 'archive_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Archive Sidebar Position', 'aigency'),
                'section'   => 'aigency_blog_archive',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ------------------------------ //
        // --- Archive Sidebar Select --- //
        // ------------------------------ //
        $wp_setting_name = 'archive_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Sidebar', 'aigency'),
                'section'       => 'aigency_blog_archive',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));   

        // ------------------------------ //
        // --- Single Post Setting ------ //
        // ------------------------------ //

        $wp_customize->add_section('aigency_single_post_settings',
            array(
                'title'     => esc_html__('Single Post Settings', 'aigency'),
                'panel'  => 'aigency_blog_settings_panel'
            )
        );

        // ------------------------------ //
        // --- Single Post Page Title --- //
        // ------------------------------ //
        $wp_setting_name = 'post_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Single Post Page Title', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'aigency')
            )
        ));

        // ------------------------------- //
        // --- Post Media Image Status --- //
        // ------------------------------- //
        $wp_setting_name = 'post_media_image_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Media Image', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ---------------------------- //
        // --- Post Category Status --- //
        // ---------------------------- //
        $wp_setting_name = 'post_category_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Categories', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------ //
        // --- Post Date Status --- //
        // ------------------------ //
        $wp_setting_name = 'post_date_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Date', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // -------------------------- //
        // --- Post Author Status --- //
        // -------------------------- //
        $wp_setting_name = 'post_author_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Author', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // -------------------------- //
        // --- Post Author Status --- //
        // -------------------------- //
        $wp_setting_name = 'post_comment_counter_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Number of Post Comments', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------- //
        // --- Post Title Status --- //
        // ------------------------- //
        $wp_setting_name = 'post_title_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Title', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------ //
        // --- Post Tags Status --- //
        // ------------------------ //
        $wp_setting_name = 'post_tags_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Tags', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // --------------------------- //
        // --- Post Socials Status --- //
        // --------------------------- //
        $wp_setting_name = 'post_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Post Social Buttons', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // --------------------------- //
        // --- Recent Posts Status --- //
        // --------------------------- //
        $wp_setting_name = 'recent_posts_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Recent Posts', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------------ //
        // --- Recent Posts Customize --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'aigency'),
                'section'   => 'aigency_single_post_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                ),
                'separator' => 'before'
            )
        ));

        // ---------------------------- //
        // --- Recent Posts Heading --- //
        // ---------------------------- //
        $wp_setting_name = 'recent_posts_section_heading';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Section Title', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------- //
        // --- Number of Posts --- //
        // ----------------------- //
        $wp_setting_name = 'recent_posts_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Number of Posts', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    '2'         => esc_html__('2 Items', 'aigency'),
                    '3'         => esc_html__('3 Items', 'aigency'),
                    '4'         => esc_html__('4 Items', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------- //
        // --- Order By --- //
        // ---------------- //
        $wp_setting_name = 'recent_posts_order_by';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Order By', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'random'        => esc_html__('Random', 'aigency'),
                    'date'          => esc_html__('Date', 'aigency'),
                    'name'          => esc_html__('Name', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------ //
        // --- Sort Order --- //
        // ------------------ //
        $wp_setting_name = 'recent_posts_order';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Sort Order', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'desc'  => esc_html__('Descending', 'aigency'),
                    'asc'   => esc_html__('Ascending', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Show Recent Post Image --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Featured Image', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'aigency'),
                    'off'   => esc_html__('Hide', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Show Recent Post Category --- //
        // --------------------------------- //
        $wp_setting_name = 'recent_posts_category';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Categories', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'aigency'),
                    'off'   => esc_html__('Hide', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------- //
        // --- Show Recent Post Date --- //
        // ----------------------------- //
        $wp_setting_name = 'recent_posts_date';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Date', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'aigency'),
                    'off'   => esc_html__('Hide', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------- //
        // --- Show Recent Post Author --- //
        // ------------------------------- //
        $wp_setting_name = 'recent_posts_author';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Author', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'aigency'),
                    'off'   => esc_html__('Hide', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------ //
        // --- Show Recent Post Title --- //
        // ------------------------------ //
        $wp_setting_name = 'recent_posts_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Title', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'aigency'),
                    'off'   => esc_html__('Hide', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- Show Recent Post Excerpt --- //
        // -------------------------------- //
        $wp_setting_name = 'recent_posts_excerpt';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Excerpt', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'aigency'),
                    'off'   => esc_html__('Hide', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------------- //
        // --- Show Recent Post Excerpt Length --- //
        // --------------------------------------- //
        $wp_setting_name = 'recent_posts_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Excerpt Length', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // ----------------------------- //
        // --- Show Recent Post Tags --- //
        // ----------------------------- //
        $wp_setting_name = 'recent_posts_tags';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts Tags', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'aigency'),
                    'off'   => esc_html__('Hide', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------------------------- //
        // --- Show Recent Post Read More Button --- //
        // ----------------------------------------- //
        $wp_setting_name = 'recent_posts_more';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Posts \'Read More\' Button', 'aigency'),
                'section'       => 'aigency_single_post_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Show', 'aigency'),
                    'off'   => esc_html__('Hide', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_posts_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------------- //
        // --- Single Post Sidebar Setting ------ //
        // -------------------------------------- //

        $wp_customize->add_section('aigency_single_post_sidebar_settings',
            array(
                'title'     => esc_html__('Single Post Sidebar Settings', 'aigency'),
                'panel'  => 'aigency_blog_settings_panel'
            )
        );

        // ------------------------------------ //
        // --- Single Post Sidebar Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'post_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Single Post Sidebar Position', 'aigency'),
                'section'   => 'aigency_single_post_sidebar_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ---------------------------------- //
        // --- Single Post Sidebar Select --- //
        // ---------------------------------- //
        $wp_setting_name = 'post_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Sidebar', 'aigency'),
                'section'       => 'aigency_single_post_sidebar_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));
        

        // ------------------------------------ //
        // ---------- Projects Panel ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('aigency_projects_settings',
            array(
                'title'     => esc_html__('Projects', 'aigency'),
                'priority'  => 206
            )
        );

        // ---#########################--- //
        // ---### Projects General ###--- //
        // ---#########################--- //
        $wp_customize->add_section('aigency_projects_general',
            array(
                'title'     => esc_html__('General', 'aigency'),
                'panel'     => 'aigency_projects_settings'
            )
        );

        // ---------------------------------- //
        // --- Project Post Type Status --- //
        // ---------------------------------- //
        $wp_setting_name = 'project_posts_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Add Project Post Type', 'aigency'),
                'section'   => 'aigency_projects_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ---########################--- //
        // ---### Projects Archive ###--- //
        // ---########################--- //
        $wp_customize->add_section('aigency_project_archive',
            array(
                'title' => esc_html__('Archive Settings', 'aigency'),
                'panel' => 'aigency_projects_settings'
            )
        );

        // ---------------------------------- //
        // --- Project Archive Page Title --- //
        // ---------------------------------- //
        $wp_setting_name = 'project_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Archive Page Title', 'aigency'),
                'section'       => 'aigency_project_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'aigency')
            )
        ));

        // -------------------------------------- //
        // --- Project Archive Columns Number --- //
        // -------------------------------------- //
        $wp_setting_name = 'project_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Archive Columns Number', 'aigency'),
                'section'       => 'aigency_project_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // -------------------------------------- //
        // --- Project Archive Posts per Page --- //
        // -------------------------------------- //
        $wp_setting_name = 'project_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Posts Per Page', 'aigency'),
                'section'       => 'aigency_project_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------ //
        // --- Project Sidebar Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'project_archive_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Archive Sidebar Position', 'aigency'),
                'section'   => 'aigency_project_archive',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ---------------------------------- //
        // ---  Project Sidebar Select --- //
        // ---------------------------------- //
        $wp_setting_name = 'project_archive_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Archive Select Sidebar', 'aigency'),
                'section'       => 'aigency_project_archive',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));

        // ------------------------------- //
        // --- Project Post URL Slug --- //
        // ------------------------------- //
        $wp_setting_name = 'project_posts_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for project posts', 'aigency'),
                'section'       => 'aigency_project_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ------------------------------------- //
        // --- Portfolio Categories URL Slug --- //
        // ------------------------------------- //
        $wp_setting_name = 'project_categories_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for project categories', 'aigency'),
                'section'       => 'aigency_project_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the category url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ---######################--- //
        // ---### Project Single ###--- //
        // ---######################--- //
        $wp_customize->add_section('aigency_project_single',
            array(
                'title' => esc_html__('Single Page Settings', 'aigency'),
                'panel' => 'aigency_projects_settings'
            )
        );

        // --------------------------------- //
        // --- Project Single Page Title --- //
        // --------------------------------- //
        $wp_setting_name = 'project_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Single Page Title', 'aigency'),
                'section'       => 'aigency_project_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'aigency')
            )
        ));

        // ------------------------- //
        // --- Project Title Status --- //
        // ------------------------- //
        $wp_setting_name = 'project_title_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Project Title', 'aigency'),
                'section'   => 'aigency_project_single',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------------------------------------ //
        // --- Project Single Navigation Max Word Count --------- //
        // ------------------------------------------------------ //
        $wp_setting_name = 'project_single_navigation_max_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Project Navigation Max Words Count', 'aigency'),
                'section'       => 'aigency_project_single',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 20,
                    'step'  => 1
                ]
            )
        ));

        // ---------------------------------------- //
        // ---------- Case Studies Panel ---------- //
        // ---------------------------------------- //
        $wp_customize->add_panel('aigency_case_studies_settings',
            array(
                'title'     => esc_html__('Case Studies', 'aigency'),
                'priority'  => 207
            )
        );

        // ---#########################--- //
        // ---### Case Studies General ###--- //
        // ---#########################--- //
        $wp_customize->add_section('aigency_case_studies_general',
            array(
                'title'     => esc_html__('General', 'aigency'),
                'panel'     => 'aigency_case_studies_settings'
            )
        );

        // ---------------------------------- //
        // --- Case Study Post Type Status --- //
        // ---------------------------------- //
        $wp_setting_name = 'case_study_posts_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Add Case Study Post Type', 'aigency'),
                'section'   => 'aigency_case_studies_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ---############################--- //
        // ---### Case Studies Archive ###--- //
        // ---############################--- //
        $wp_customize->add_section('aigency_case_studies_archive',
            array(
                'title' => esc_html__('Archive Settings', 'aigency'),
                'panel' => 'aigency_case_studies_settings'
            )
        );

        // --------------------------------------- //
        // --- Case Studies Archive Page Title --- //
        // --------------------------------------- //
        $wp_setting_name = 'case_studies_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Case Studies Archive Page Title', 'aigency'),
                'section'       => 'aigency_case_studies_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'aigency')
            )
        ));

        // ------------------------------------------- //
        // --- Case Studies Archive Excerpt Length --- //
        // ------------------------------------------- //
        $wp_setting_name = 'case_studies_archive_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Case Studies Excerpt Length', 'aigency'),
                'section'       => 'aigency_case_studies_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------------- //
        // --- Case Studies Archive Columns Number --- //
        // ------------------------------------------- //
        $wp_setting_name = 'case_studies_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Case Studies Columns Number', 'aigency'),
                'section'       => 'aigency_case_studies_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------------- //
        // --- Case Studies Archive Posts per Page --- //
        // ------------------------------------------- //
        $wp_setting_name = 'case_studies_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Case Studies Posts Per Page', 'aigency'),
                'section'       => 'aigency_case_studies_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------ //
        // --- Case Studies Sidebar Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'case_archive_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Archive Sidebar Position', 'aigency'),
                'section'   => 'aigency_case_studies_archive',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ---------------------------------- //
        // ---  Case Studies Sidebar Select --- //
        // ---------------------------------- //
        $wp_setting_name = 'case_archive_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Archive Select Sidebar', 'aigency'),
                'section'       => 'aigency_case_studies_archive',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));

        // ------------------------------- //
        // --- Case Studies Post URL Slug --- //
        // ------------------------------- //
        $wp_setting_name = 'case_study_posts_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for case study posts', 'aigency'),
                'section'       => 'aigency_case_studies_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ------------------------------------- //
        // --- Case Studies Categories URL Slug --- //
        // ------------------------------------- //
        $wp_setting_name = 'case_study_categories_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for case study categories', 'aigency'),
                'section'       => 'aigency_case_studies_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the category url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ------------------------------------- //
        // --- Case Studies Tags URL Slug --- //
        // ------------------------------------- //
        $wp_setting_name = 'case_study_tags_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for case study tags', 'aigency'),
                'section'       => 'aigency_case_studies_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the tag url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ---###########################--- //
        // ---### Case Studies Single ###--- //
        // ---###########################--- //
        $wp_customize->add_section('aigency_case_studies_single',
            array(
                'title' => esc_html__('Single Page Settings', 'aigency'),
                'panel' => 'aigency_case_studies_settings'
            )
        );

        // ------------------------------------ //
        // --- Case Studies Single Page Title --- //
        // ------------------------------------ //
        $wp_setting_name = 'case_studies_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Case Study Single Page Title', 'aigency'),
                'section'       => 'aigency_case_studies_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'aigency')
            )
        ));

        // ------------------------------------ //
        // --- Case Studies Single Sidebar Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'case_study_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Case Study Sidebar Position', 'aigency'),
                'section'   => 'aigency_case_studies_single',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ---------------------------------- //
        // ---  Case Studies Single Sidebar Select --- //
        // ---------------------------------- //
        $wp_setting_name = 'case_study_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Case Study Select Sidebar', 'aigency'),
                'section'       => 'aigency_case_studies_single',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));
                

        // ---------------------------------------- //
        // ---------- Team Members Panel ---------- //
        // ---------------------------------------- //
        $wp_customize->add_panel('aigency_team_settings',
            array(
                'title'     => esc_html__('Team Members', 'aigency'),
                'priority'  => 208
            )
        );

        // ---#########################--- //
        // ---### Team Members General ###--- //
        // ---#########################--- //
        $wp_customize->add_section('aigency_team_general',
            array(
                'title'     => esc_html__('General', 'aigency'),
                'panel'     => 'aigency_team_settings'
            )
        );

        // ---------------------------------- //
        // --- Team Member Post Type Status --- //
        // ---------------------------------- //
        $wp_setting_name = 'team_posts_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Add Team Member Post Type', 'aigency'),
                'section'   => 'aigency_team_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ---############################--- //
        // ---### Team Members Archive ###--- //
        // ---############################--- //
        $wp_customize->add_section('aigency_team_archive',
            array(
                'title' => esc_html__('Archive Settings', 'aigency'),
                'panel' => 'aigency_team_settings'
            )
        );

        // --------------------------------------- //
        // --- Team Members Archive Page Title --- //
        // --------------------------------------- //
        $wp_setting_name = 'team_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Team Members Archive Page Title', 'aigency'),
                'section'       => 'aigency_team_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'aigency')
            )
        ));

        // ------------------------------------------- //
        // --- Team Members Archive Columns Number --- //
        // ------------------------------------------- //
        $wp_setting_name = 'team_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Team Members Archive Columns Number', 'aigency'),
                'section'       => 'aigency_team_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------------- //
        // --- Team Members Archive Posts per Page --- //
        // ------------------------------------------- //
        $wp_setting_name = 'team_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Team Members Posts Per Page', 'aigency'),
                'section'       => 'aigency_team_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------- //
        // --- Team Archive Sidebar Position --- //
        // ------------------------------------- //
        $wp_setting_name = 'team_archive_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Archive Sidebar Position', 'aigency'),
                'section'   => 'aigency_team_archive',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ----------------------------------- //
        // --- Team Archive Sidebar Select --- //
        // ----------------------------------- //
        $wp_setting_name = 'team_archive_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Sidebar', 'aigency'),
                'section'       => 'aigency_team_archive',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));

        // ------------------------------- //
        // --- Team Member Post URL Slug --- //
        // ------------------------------- //
        $wp_setting_name = 'team_posts_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for team posts', 'aigency'),
                'section'       => 'aigency_team_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ------------------------------------- //
        // --- Team Member Categories URL Slug --- //
        // ------------------------------------- //
        $wp_setting_name = 'team_categories_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for team categories', 'aigency'),
                'section'       => 'aigency_team_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the category url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ---##########################--- //
        // ---### Team Member Single ###--- //
        // ---##########################--- //
        $wp_customize->add_section('aigency_team_single',
            array(
                'title' => esc_html__('Single Page Settings', 'aigency'),
                'panel' => 'aigency_team_settings'
            )
        );

        // ------------------------------------- //
        // --- Team Member Single Page Title --- //
        // ------------------------------------- //
        $wp_setting_name = 'team_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Team Member Single Page Title', 'aigency'),
                'section'       => 'aigency_team_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'aigency')
            )
        ));


        // ------------------------------------- //
        // ---------- Careers Panel ---------- //
        // ------------------------------------- //
        $wp_customize->add_panel('aigency_vacancies_settings',
            array(
                'title'     => esc_html__('Careers', 'aigency'),
                'priority'  => 209
            )
        );

        // ---#########################--- //
        // ---### Careers General ###--- //
        // ---#########################--- //
        $wp_customize->add_section('aigency_vacancy_general',
            array(
                'title'     => esc_html__('General', 'aigency'),
                'panel'     => 'aigency_vacancies_settings'
            )
        );

        // ---------------------------------- //
        // --- Career Post Type Status --- //
        // ---------------------------------- //
        $wp_setting_name = 'vacancy_posts_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Add Career Post Type', 'aigency'),
                'section'   => 'aigency_vacancy_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ---#########################--- //
        // ---### Careers Archive ###--- //
        // ---#########################--- //
        $wp_customize->add_section('aigency_vacancy_archive',
            array(
                'title' => esc_html__('Archive Settings', 'aigency'),
                'panel' => 'aigency_vacancies_settings'
            )
        );

        // ------------------------------------ //
        // --- Careers Archive Page Title --- //
        // ------------------------------------ //
        $wp_setting_name = 'vacancy_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Careers Archive Page Title', 'aigency'),
                'section'       => 'aigency_vacancy_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'aigency')
            )
        ));

        // ---------------------------------------- //
        // --- Careers Archive Excerpt Length --- //
        // ---------------------------------------- //
        $wp_setting_name = 'vacancy_archive_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Career Excerpt Length', 'aigency'),
                'section'       => 'aigency_vacancy_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // ---------------------------------------- //
        // --- Careers Archive Posts per Page --- //
        // ---------------------------------------- //
        $wp_setting_name = 'vacancy_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Career Posts Per Page', 'aigency'),
                'section'       => 'aigency_vacancy_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------- //
        // --- Career Sidebar Position --- //
        // ------------------------------------- //
        $wp_setting_name = 'vacancy_archive_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Archive Sidebar Position', 'aigency'),
                'section'   => 'aigency_vacancy_archive',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ----------------------------------- //
        // --- Career Sidebar Select --- //
        // ----------------------------------- //
        $wp_setting_name = 'vacancy_archive_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Sidebar', 'aigency'),
                'section'       => 'aigency_vacancy_archive',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));

        // ------------------------------- //
        // --- Career Post URL Slug --- //
        // ------------------------------- //
        $wp_setting_name = 'vacancy_posts_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for career posts', 'aigency'),
                'section'       => 'aigency_vacancy_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ------------------------------------- //
        // --- Career Categories URL Slug --- //
        // ------------------------------------- //
        $wp_setting_name = 'vacancy_categories_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for career categories', 'aigency'),
                'section'       => 'aigency_vacancy_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the category url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ---######################--- //
        // ---### Career Single ###--- //
        // ---######################--- //
        $wp_customize->add_section('aigency_vacancy_single',
            array(
                'title' => esc_html__('Single Page Settings', 'aigency'),
                'panel' => 'aigency_vacancies_settings'
            )
        );

        // --------------------------------- //
        // --- Career Single Page Title --- //
        // --------------------------------- //
        $wp_setting_name = 'vacancy_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Career Single Page Title', 'aigency'),
                'section'       => 'aigency_vacancy_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'aigency')
            )
        ));

        // -------------------------------- //
        // --- Career Single Sidebar Position --- //
        // -------------------------------- //
        $wp_setting_name = 'vacancy_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Career Sidebar Position', 'aigency'),
                'section'   => 'aigency_vacancy_single',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ---------------------------------- //
        // ---  Career Single Sidebar Select --- //
        // ---------------------------------- //
        $wp_setting_name = 'vacancy_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Career Select Sidebar', 'aigency'),
                'section'       => 'aigency_vacancy_single',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));

        // ------------------------------- //
        // --- Recent Careers Status --- //
        // ------------------------------- //
        $wp_setting_name = 'recent_vacancies_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Recent Careers', 'aigency'),
                'section'   => 'aigency_vacancy_single',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ---------------------------------- //
        // --- Recent Careers Customize --- //
        // ---------------------------------- //
        $wp_setting_name = 'recent_vacancies_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize', 'aigency'),
                'section'   => 'aigency_vacancy_single',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                ),
                'separator' => 'before'
            )
        ));

        // -------------------------------- //
        // --- Recent Careers Heading --- //
        // -------------------------------- //
        $wp_setting_name = 'recent_vacancies_section_heading';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Recent Careers Section Title', 'aigency'),
                'section'       => 'aigency_vacancy_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_vacancies_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ----------------------- //
        // --- Number of Posts --- //
        // ----------------------- //
        $wp_setting_name = 'recent_vacancies_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Number of Posts', 'aigency'),
                'section'       => 'aigency_vacancy_single',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'recent_vacancies_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ],
                'input_attrs'   => [
                    'min'   => 1,
                    'max'   => 20,
                    'step'  => 1
                ]
            )
        ));

        // ---------------- //
        // --- Order By --- //
        // ---------------- //
        $wp_setting_name = 'recent_vacancies_order_by';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Order By', 'aigency'),
                'section'       => 'aigency_vacancy_single',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'random'        => esc_html__('Random', 'aigency'),
                    'date'          => esc_html__('Date', 'aigency'),
                    'name'          => esc_html__('Name', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_vacancies_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------ //
        // --- Sort Order --- //
        // ------------------ //
        $wp_setting_name = 'recent_vacancies_order';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Sort Order', 'aigency'),
                'section'       => 'aigency_vacancy_single',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'desc'  => esc_html__('Descending', 'aigency'),
                    'asc'   => esc_html__('Ascending', 'aigency')
                ),
                'dependency'    => [
                    [
                        'control'   => 'recent_vacancies_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // ------------------------------------ //
        // ---------- Services Panel ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('aigency_services_settings',
            array(
                'title'     => esc_html__('Services', 'aigency'),
                'priority'  => 210
            )
        );

        // ---#########################--- //
        // ---### Services General ###--- //
        // ---#########################--- //
        $wp_customize->add_section('aigency_service_general',
            array(
                'title'     => esc_html__('General', 'aigency'),
                'panel'     => 'aigency_services_settings'
            )
        );

        // ---------------------------------- //
        // --- Service Post Type Status --- //
        // ---------------------------------- //
        $wp_setting_name = 'service_posts_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Add Service Post Type', 'aigency'),
                'section'   => 'aigency_service_general',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ---########################--- //
        // ---### Services Archive ###--- //
        // ---########################--- //
        $wp_customize->add_section('aigency_service_archive',
            array(
                'title' => esc_html__('Archive Settings', 'aigency'),
                'panel' => 'aigency_services_settings'
            )
        );

        // ----------------------------------- //
        // --- Services Archive Page Title --- //
        // ----------------------------------- //
        $wp_setting_name = 'service_archive_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Services Archive Page Title', 'aigency'),
                'section'       => 'aigency_service_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post type name', 'aigency')
            )
        ));

        // --------------------------------------- //
        // --- Services Archive Excerpt Length --- //
        // --------------------------------------- //
        $wp_setting_name = 'service_archive_excerpt_length';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Services Excerpt Length', 'aigency'),
                'section'       => 'aigency_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 0,
                    'step'  => 1
                ]
            )
        ));

        // -------------------------------------- //
        // --- Service Archive Columns Number --- //
        // -------------------------------------- //
        $wp_setting_name = 'service_archive_columns_number';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Archive Columns Number', 'aigency'),
                'section'       => 'aigency_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'max'   => 4,
                    'step'  => 1
                ]
            )
        ));

        // --------------------------------------- //
        // --- Services Archive Posts per Page --- //
        // --------------------------------------- //
        $wp_setting_name = 'service_archive_posts_per_page';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'absint'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Posts Per Page', 'aigency'),
                'section'       => 'aigency_service_archive',
                'type'          => 'number',
                'settings'      => $wp_setting_name,
                'input_attrs' => [
                    'min'   => 1,
                    'step'  => 1
                ]
            )
        ));

        // ------------------------------------- //
        // --- Service Archive Sidebar Position --- //
        // ------------------------------------- //
        $wp_setting_name = 'service_archive_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Archive Sidebar Position', 'aigency'),
                'section'   => 'aigency_service_archive',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ----------------------------------- //
        // --- Service Archive Sidebar Select --- //
        // ----------------------------------- //
        $wp_setting_name = 'service_archive_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Select Sidebar', 'aigency'),
                'section'       => 'aigency_service_archive',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));

        // ------------------------------- //
        // --- Service Post URL Slug --- //
        // ------------------------------- //
        $wp_setting_name = 'service_posts_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for service posts', 'aigency'),
                'section'       => 'aigency_service_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ------------------------------------- //
        // --- Service Categories URL Slug --- //
        // ------------------------------------- //
        $wp_setting_name = 'service_categories_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for service categories', 'aigency'),
                'section'       => 'aigency_service_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the category url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ------------------------------------- //
        // --- Service Tags URL Slug --- //
        // ------------------------------------- //
        $wp_setting_name = 'service_tags_slug';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback' => 'sanitize_key'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Slug for service tags', 'aigency'),
                'section'       => 'aigency_service_archive',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Used in the tag url address. For this value to take effect, you must update the permalinks.', 'aigency')
            )
        ));

        // ---######################--- //
        // ---### Service Single ###--- //
        // ---######################--- //
        $wp_customize->add_section('aigency_service_single',
            array(
                'title' => esc_html__('Single Page Settings', 'aigency'),
                'panel' => 'aigency_services_settings'
            )
        );

        // ---------------------------------- //
        // --- Services Single Page Title --- //
        // ---------------------------------- //
        $wp_setting_name = 'service_single_page_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Single Page Title', 'aigency'),
                'section'       => 'aigency_service_single',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Use variable \'%s\' for display Post name', 'aigency')
            )
        ));

        // ------------------------- //
        // --- Service Title Status --- //
        // ------------------------- //
        $wp_setting_name = 'service_title_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Service Title', 'aigency'),
                'section'   => 'aigency_service_single',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------- //
        // --- Service Title Status --- //
        // ------------------------- //
        $wp_setting_name = 'service_media_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Service Featured Image', 'aigency'),
                'section'   => 'aigency_service_single',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------------------ //
        // --- Service Single Sidebar Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'service_sidebar_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Service Sidebar Position', 'aigency'),
                'section'   => 'aigency_service_single',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'left'      => esc_html__('Left', 'aigency'),
                    'right'     => esc_html__('Right', 'aigency'),
                    'none'      => esc_html__('None', 'aigency')
                )
            )
        ));

        // ---------------------------------- //
        // --- Service Single Sidebar Select --- //
        // ---------------------------------- //
        $wp_setting_name = 'service_sidebar_select';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Service Select Sidebar', 'aigency'),
                'section'       => 'aigency_service_single',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_all_sidebar_list()
            )
        ));


        // ------------------------------ //
        // ------- 404 Error Page ------- //
        // ------------------------------ //
        $wp_customize->add_section('aigency_error_page_settings',
            array(
                'title'     => esc_html__('Error 404 Page', 'aigency'),
                'priority'  => 210
            )
        );

        // ----------------------- //
        // --- 404 Error Title --- //
        // ----------------------- //
        $wp_setting_name = 'error_title';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('404 Error Title', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'type'          => 'textarea',
                'settings'      => $wp_setting_name
            )
        ));

        // ---------------------- //
        // --- 404 Error Text --- //
        // ---------------------- //
        $wp_setting_name = 'error_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'wp_kses_post'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('404 Error Info Text', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'type'          => 'textarea',
                'settings'      => $wp_setting_name
            )
        ));

        // ----------------------------- //
        // --- 404 Error Logo Status --- //
        // ----------------------------- //
        $wp_setting_name = 'error_logo_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Show Logo Image', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => array(
                    'on'    => esc_html__('Yes', 'aigency'),
                    'off'   => esc_html__('No', 'aigency')
                )
            )
        ));

        // --------------------------- //
        // --- 404 Page Logo Image --- //
        // --------------------------- //
        $wp_setting_name = 'error_logo_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Aigency_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Logo Image', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'settings'      => $wp_setting_name
            )
        ));        

        // ------------------------------------ //
        // --- 404 Error Home Button Status --- //
        // ------------------------------------ //
        $wp_setting_name = 'error_button_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Home Button', 'aigency'),
                'section'   => 'aigency_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ----------------------------- //
        // --- 404 Error Button Text --- //
        // ----------------------------- //
        $wp_setting_name = 'error_button_text';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'sanitize_text_field'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Home Button Text', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'type'          => 'text',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'error_button_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- 404 Error Socials Status --- //
        // -------------------------------- //
        $wp_setting_name = 'error_socials_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Social Buttons', 'aigency'),
                'section'   => 'aigency_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // --------------------------------- //
        // --- 404 Page Text Color --- //
        // --------------------------------- //
        $wp_setting_name = 'error_text_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Text Color', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // --------------------------------- //
        // --- 404 Page Text Hover Color --- //
        // --------------------------------- //
        $wp_setting_name = 'error_text_hover_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Text Hover Color', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette()
            )
        ));

        // -------------------------------------- //
        // --- 404 Error Background Customize --- //
        // -------------------------------------- //
        $wp_setting_name = 'error_background_customize';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Customize Background', 'aigency'),
                'section'   => 'aigency_error_page_settings',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // --------------------------------- //
        // --- 404 Page Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'error_background_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Color', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- 404 Page Background Image --- //
        // --------------------------------- //
        $wp_setting_name = 'error_background_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Aigency_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Image', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'settings'      => $wp_setting_name,
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------------------ //
        // --- 404 Page Background Position --- //
        // ------------------------------------ //
        $wp_setting_name = 'error_background_position';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Position', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_background_position_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ---------------------------------- //
        // --- 404 Page Background Repeat --- //
        // ---------------------------------- //
        $wp_setting_name = 'error_background_repeat';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Repeat', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_background_repeat_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // -------------------------------- //
        // --- 404 Page Background Size --- //
        // -------------------------------- //
        $wp_setting_name = 'error_background_size';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Background Size', 'aigency'),
                'section'       => 'aigency_error_page_settings',
                'type'          => 'select',
                'settings'      => $wp_setting_name,
                'choices'       => aigency_get_background_size_options(),
                'dependency'    => [
                    [
                        'control'   => 'error_background_customize',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        if ( class_exists('WooCommerce') ) {

            // ------------------------------------------ //
            // ---------- WooCommerce Settings ---------- //
            // ------------------------------------------ //

            // ---#######################--- //
            // ---### Product Catalog ###--- //
            // ---#######################--- //

            // ------------------------------------ //
            // --- WooCommerce Sidebar Position --- //
            // ------------------------------------ //
            $wp_setting_name = 'catalog_sidebar_position';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Sidebar Position', 'aigency'),
                    'section'   => 'woocommerce_product_catalog',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'left'      => esc_html__('Left', 'aigency'),
                        'right'     => esc_html__('Right', 'aigency'),
                        'none'      => esc_html__('None', 'aigency')
                    )
                )
            ));

            // ---------------------------------- //
            // --- WooCommerce Sidebar Select --- //
            // ---------------------------------- //
            $wp_setting_name = 'catalog_sidebar_select';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback' => 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Select Sidebar', 'aigency'),
                    'section'       => 'woocommerce_product_catalog',
                    'type'          => 'select',
                    'settings'      => $wp_setting_name,
                    'choices'       => aigency_get_all_sidebar_list()
                )
            ));

            // ---######################--- //
            // ---### Single Product ###--- //
            // ---######################--- //
            $wp_customize->add_section('aigency_woocommerce_single_product',
                array(
                    'title' => esc_html__('Single Product', 'aigency'),
                    'panel' => 'woocommerce'
                )
            );

            // ----------------------------------------------- //
            // --- Single Product Related Products Section --- //
            // ----------------------------------------------- //
            $wp_setting_name = 'woo_single_product_show_related_section';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'aigency_sanitize_choice'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'     => esc_html__('Show Related Products', 'aigency'),
                    'section'   => 'aigency_woocommerce_single_product',
                    'type'      => 'select',
                    'settings'  => $wp_setting_name,
                    'choices'   => array(
                        'on'        => esc_html__('Yes', 'aigency'),
                        'off'       => esc_html__('No', 'aigency')
                    )
                )
            ));

            // -------------------------------- //
            // --- Related Products Heading --- //
            // -------------------------------- //
            $wp_setting_name = 'woo_related_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Related Products Section Title', 'aigency'),
                    'section'       => 'aigency_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'dependency'    => [
                        [
                            'control'   => 'woo_single_product_show_related_section',
                            'operator'  => '==',
                            'value'     => 'on'
                        ]
                    ]
                )
            ));

            // --------------------------------- //
            // --- Single Product Page Title --- //
            // --------------------------------- //
            $wp_setting_name = 'woo_single_product_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Single Product Page Title', 'aigency'),
                    'section'       => 'aigency_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product title', 'aigency')
                )
            ));

            // ------------------------- //
            // --- Show Product Name --- //
            // ------------------------- //
            $wp_setting_name = 'woo_single_product_show_name';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => $aigency_customizer_default_values[$wp_setting_name],
                    'sanitize_callback'	=> 'aigency_sanitize_checkbox'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Show Product name above the Price', 'aigency'),
                    'section'       => 'aigency_woocommerce_single_product',
                    'type'          => 'checkbox',
                    'settings'      => $wp_setting_name
                )
            ));


            // --------------------------------- //
            // --- Up-sells Products Heading --- //
            // --------------------------------- //
            $wp_setting_name = 'woo_upsells_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Up-sells Section Title', 'aigency'),
                    'section'       => 'aigency_woocommerce_single_product',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name
                )
            ));

            // ---##########################--- //
            // ---### Product Categories ###--- //
            // ---##########################--- //
            $wp_customize->add_section('aigency_woocommerce_product_archive',
                array(
                    'title' => esc_html__('Product Archive', 'aigency'),
                    'panel' => 'woocommerce'
                )
            );

            // -------------------------------- //
            // --- Product Categories Title --- //
            // -------------------------------- //
            $wp_setting_name = 'woo_product_categories_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Product Category Page Title', 'aigency'),
                    'section'       => 'aigency_woocommerce_product_archive',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product category name', 'aigency')
                )
            ));

            // -------------------------- //
            // --- Product Tags Title --- //
            // -------------------------- //
            $wp_setting_name = 'woo_product_tags_title';
            $wp_customize->add_setting(
                $wp_setting_name,
                array(
                    'default'           => stripslashes($aigency_customizer_default_values[$wp_setting_name]),
                    'sanitize_callback'	=> 'sanitize_text_field'
                )
            );
            $wp_customize->add_control(new Aigency_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label'         => esc_html__('Product Tag Page Title', 'aigency'),
                    'section'       => 'aigency_woocommerce_product_archive',
                    'type'          => 'text',
                    'settings'      => $wp_setting_name,
                    'description'   => esc_html__('Use variable \'%s\' for display Product tag name', 'aigency')
                )
            ));

        }        

        // ----------------------------------------------- //
        // ---------- Additional Settings Panel ---------- //
        // ----------------------------------------------- //
        $wp_customize->add_panel('aigency_additional_settings',
            array(
                'title'     => esc_html__('Additional Settings', 'aigency'),
                'priority'  => 220
            )
        );

        // ---###################--- //
        // ---### Page Loader ###--- //
        // ---###################--- //
        $wp_customize->add_section('aigency_page_loader',
            array(
                'title' => esc_html__('Page Loader', 'aigency'),
                'panel' => 'aigency_additional_settings'
            )
        );

        // -------------------------- //
        // --- Page Loader Status --- //
        // -------------------------- //
        $wp_setting_name = 'page_loader_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Page Loader', 'aigency'),
                'section'   => 'aigency_page_loader',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // ------------------------- //
        // --- Page Loader Image --- //
        // ------------------------- //
        $wp_setting_name = 'page_loader_image';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback'	=> 'esc_url_raw'
            )
        );
        $wp_customize->add_control(new Aigency_Image_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Page Loader Image', 'aigency'),
                'section'       => 'aigency_page_loader',
                'settings'      => $wp_setting_name,
                'description'   => esc_html__('Maximum 100x100px', 'aigency'),
                'dependency'    => [
                    [
                        'control'   => 'page_loader_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // ------------------------- //
        // --- Footer Scroll To Top --- //
        // ------------------------- //

        $wp_customize->add_section('aigency_footer_scrolltop',
            array(
                'title' => esc_html__('Scroll To Top Button', 'aigency'),
                'panel' => 'aigency_additional_settings'
            )
        );

        // ------------------------------------- //
        // --- Footer Scroll To Top Status --- //
        // -------------------------------------- //
        $wp_setting_name = 'footer_scrolltop_status';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_choice'
            )
        );
        $wp_customize->add_control(new Aigency_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'     => esc_html__('Show Scroll To Top Button', 'aigency'),
                'section'   => 'aigency_footer_scrolltop',
                'type'      => 'select',
                'settings'  => $wp_setting_name,
                'choices'   => array(
                    'on'        => esc_html__('Yes', 'aigency'),
                    'off'       => esc_html__('No', 'aigency')
                )
            )
        ));

        // --------------------------------- //
        // --- Scroll Top Button Background Color --- //
        // --------------------------------- //
        $wp_setting_name = 'footer_scrolltop_bg_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Scroll To Top Button Background Color', 'aigency'),
                'section'       => 'aigency_footer_scrolltop',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_scrolltop_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));   

        // --------------------------------- //
        // --- Scroll Top Button Background Color Add --- //
        // --------------------------------- //
        $wp_setting_name = 'footer_scrolltop_bg_color_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Scroll To Top Button Background Color Additional', 'aigency'),
                'section'       => 'aigency_footer_scrolltop',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_scrolltop_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Scroll Top Button Background Hover --- //
        // --------------------------------- //

        $wp_setting_name = 'footer_scrolltop_bg_color_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Scroll To Top Button Hover Background Color', 'aigency'),
                'section'       => 'aigency_footer_scrolltop',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_scrolltop_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Scroll Top Button Background Hover Add --- //
        // --------------------------------- //

        $wp_setting_name = 'footer_scrolltop_bg_color_hover_add';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Scroll To Top Button Hover Background Color Additional', 'aigency'),
                'section'       => 'aigency_footer_scrolltop',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_scrolltop_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));


        // --------------------------------- //
        // --- Scroll Top Button Color --- //
        // --------------------------------- //
        $wp_setting_name = 'footer_scrolltop_color';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Scroll To Top Button Color', 'aigency'),
                'section'       => 'aigency_footer_scrolltop',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_scrolltop_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

        // --------------------------------- //
        // --- Scroll Top Button Color Hover --- //
        // --------------------------------- //

        $wp_setting_name = 'footer_scrolltop_color_hover';
        $wp_customize->add_setting(
            $wp_setting_name,
            array(
                'default'           => $aigency_customizer_default_values[$wp_setting_name],
                'sanitize_callback' => 'aigency_sanitize_alpha_color'
            )
        );
        $wp_customize->add_control(new Aigency_Alpha_Color_Custom_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label'         => esc_html__('Scroll To Top Button Hover Color', 'aigency'),
                'section'       => 'aigency_footer_scrolltop',
                'settings'      => $wp_setting_name,
                'show_opacity'  => true,
                'palette'       => aigency_get_custom_color_palette(),
                'dependency'    => [
                    [
                        'control'   => 'footer_scrolltop_status',
                        'operator'  => '==',
                        'value'     => 'on'
                    ]
                ]
            )
        ));

    }
}