<?php
/*
 * Created by Artureanec
*/

add_action('init', 'init_aigency_customizer_default_values', 1);

if (!function_exists('init_aigency_customizer_default_values')) {
    function init_aigency_customizer_default_values() {
        global $aigency_customizer_default_values;
        $aigency_customizer_default_values = array(
            # General
                # Page Loader
                'page_loader_status'                        => 'on',
                'page_loader_image'                         => '',
                'page_bottom_blur_status'                   => 'off',

            # Top Bar
                # Top Bar General
                'top_bar_status'                            => 'off',
                'top_bar_customize'                         => 'off',
                'top_bar_default_text_color'                => '',
                'top_bar_dark_text_color'                   => '#ffffff',
                'top_bar_light_text_color'                  => '',
                'top_bar_accent_text_color'                 => '',
                'top_bar_border_color'                      => '',
                'top_bar_border_hover_color'                => '',
                'top_bar_background_color'                  => '#111111',
                'top_bar_background_alter_color'            => '',
                'top_bar_button_text_color'                 => '',
                'top_bar_button_border_color'               => '',
                'top_bar_button_background_color'           => '',
                'top_bar_button_text_hover'                 => '',
                'top_bar_button_border_hover'               => '',
                'top_bar_button_background_hover'           => '',

                # Top Bar Social Buttons
                'top_bar_socials_status'                    => 'off',
                'top_bar_socials_title'                     => '',

                # Top Bar Contacts
                'top_bar_contacts_title'                    => '',
                'top_bar_contacts_email_status'             => 'off',
                'top_bar_contacts_email_title'              => '',
                'top_bar_contacts_email'                    => '',
                'top_bar_contacts_phone_status'             => 'off',
                'top_bar_contacts_phone_title'              => '',
                'top_bar_contacts_phone'                    => '',
                'top_bar_contacts_address_status'           => 'off',
                'top_bar_contacts_address_title'            => '',
                'top_bar_contacts_address'                  => '',

            # Header Settings
                #General
                'header_status'                             => 'on',
                'header_position'                           => 'above',
                'header_transparent'                        => false,
                'header_border'                             => 'none',        
                'header_customize'                          => 'on',
                'header_offset_top'                         => '',
                'header_default_text_color'                 => '',
                'header_dark_text_color'                    => '#333333',
                'header_light_text_color'                   => '#958c8c',
                'header_accent_text_color'                  => '#4c96d8',
                'header_current_text_color'                 => '',
                'header_current_background_color'           => '',
                'header_border_color'                       => '#d9d9d9',
                'header_border_hover_color'                 => '',
                'header_background_color'                   => '',
                'header_background_alter_color'             => '',
                'header_button_text_color'                  => '#ffffff',
                'header_button_border_color'                => 'rgba(255,255,255,0)',
                'header_button_border_color_add'            => 'rgba(255,255,255,0)',
                'header_button_background_color'            => '#26c6d1',
                'header_button_background_color_add'        => '#7266e0',
                'header_button_text_hover'                  => '',
                'header_button_border_hover'                => 'rgba(255,255,255,0)',
                'header_button_border_hover_add'            => 'rgba(255,255,255,0)',
                'header_button_background_hover'            => '#1f1f1f',
                'header_button_background_hover_add'        => '#1f1f1f',
                'header_button_border_style'                => 'gradient',
                'header_button_background_style'            => 'gradient',        
                'header_menu_text_color'                    => '',
                'header_menu_text_color_hover'              => '',
                'header_menu_text_background_color_hover'   => '',
                'header_menu_background_color'              => '',

                # Sticky Header
                'sticky_header_status'                      => 'off',
                'sticky_header_blur'                        => 'off',

                # Mobile Header
                'mobile_header_breakpoint'                  => '1365',
                'mobile_header_menu_style'                  => 'fullwidth',

                # Header Logo
                'header_logo_status'                        => 'on',
                'header_logo_customize'                     => 'off',
                'header_logo_image'                         => '',
                'header_logo_retina'                        => false,
                'header_logo_mobile_image'                  => '',
                'header_logo_mobile_retina'                 => false,

                # Header Button
                'header_button_status'                      => 'off',
                'header_button_text'                        => esc_html__('Get in touch', 'aigency'),
                'header_button_url'                         => '#',
                'header_button_target'                      => false,

                # Header Menu
                'header_menu_status'                        => 'on',
                'header_menu_style'                         => 'standard',
                'header_menu_bg_image_status'               => 'off',
                'header_menu_bg_image'                      => '',
                'header_menu_select'                        => 'default',
                'header_menu_label'                         => esc_html__('Menu', 'aigency'),
                'header_menu_customize'                     => 'on',
                'header_menu_font'                          => '{"font_family":"Manrope","font_backup":"Arial, Helvetica, sans-serif","font_styles":"700","font_subset":"latin","font_size":"14","font_size_unit":"px","line_height":"1.92857","line_height_unit":"em","text_transform":"uppercase","letter_spacing":"0","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_style":"normal","font_weight":"700"}',
                'header_sub_menu_font'                      => '{"font_family":"Manrope","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400","font_subset":"latin","font_size":"17","font_size_unit":"px","line_height":"1.5","line_height_unit":"em","text_transform":"none","letter_spacing":"0","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_style":"normal","font_weight":"400"}',

                # Header Side Panel
                'side_panel_status'                         => 'off',

                # Header Search
                'header_search_status'                      => 'on',

                # Header Minicart
                'header_minicart_status'                    => 'off',

                # Header Login/Logout
                'header_login_status'                       => 'off',

            # Page Title
                # General
                'page_title_status'                         => 'on',
                'page_title_overlay_status'                 => 'off',
                'page_title_overlay_color'                  => '',
                'page_title_customize'                      => 'on',
                'page_title_height'                         => '500',
                'page_title_default_text_color'             => '#333333',
                'page_title_dark_text_color'                => '#ffffff',
                'page_title_light_text_color'               => '#c5c5c5',
                'page_title_accent_text_color'              => '#ffffff',
                'page_title_border_color'                   => '',
                'page_title_border_hover_color'             => '',
                'page_title_background_color'               => '',
                'page_title_background_alter_color'         => '',
                'page_title_button_text_color'              => '',
                'page_title_button_border_color'            => '',                
                'page_title_button_background_color'        => '',
                'page_title_button_background_color_add'    => '',
                'page_title_button_text_hover'              => '',
                'page_title_button_border_hover'            => '',
                'page_title_button_background_hover'        => '',
                'page_title_background_image'               => '',
                'page_title_background_position'            => 'center center',
                'page_title_background_repeat'              => 'no-repeat',
                'page_title_background_size'                => 'cover',
                'hide_page_title_background_mobile'         => false,
                'hide_page_title_background_tablet'         => false,

                # Heading
                'page_title_heading_customize'              => 'off',
                'page_title_heading_font'                   => '{"font_family":"Sora","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400","font_subset":"latin","font_size":"80","font_size_unit":"px","line_height":"1.125","line_height_unit":"em","text_transform":"none","letter_spacing":"-0.03","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_style":"normal","font_weight":"400"}',

                # Breadcrumbs
                'page_title_breadcrumbs_status'             => 'on',
                'page_title_breadcrumbs_customize'          => 'on',
                'page_title_breadcrumbs_font'               => '{"font_family":"Manrope","font_backup":"Arial, Helvetica, sans-serif","font_styles":"600","font_subset":"latin","font_size":"14","font_size_unit":"px","line_height":"27","line_height_unit":"px","text_transform":"none","letter_spacing":"0","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_style":"normal","font_weight":"600"}',
                'page_title_breadcrumbs_text'               => '',
                'page_title_breadcrumbs_text_color'          => '',

                # Additional
                'page_title_additional_text'                => '',
                'page_title_additional_customize'           => 'off',
                'page_title_additional_text_color'          => '',
                'page_title_additional_text_font'           => '{"font_family":"DM Mono","font_backup":"Arial, Helvetica, sans-serif","font_styles":"500","font_subset":"latin","text_transform":"none","letter_spacing":"-0.05","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_style":"normal","font_weight":"500"}',
                'page_title_additional_text_bottom_position'=> '',

            # Typography
                # Main Font
                'main_font'                                 => '{"font_family":"Manrope","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400,500,700","font_subset":"latin","font_size":"16","font_size_unit":"px","line_height":"1.875","line_height_unit":"em","text_transform":"none","letter_spacing":"0","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_style":"normal","font_weight":"500"}',

                # Additional Font
                'additional_font'                           => '{"font_family":"Manrope","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400","font_subset":"latin","font_size":"14","font_size_unit":"px","line_height":"1.92857","line_height_unit":"em","font_style":"normal","font_weight":"400"}',
                'additional_font_family'                    => '{"font_family":"DM Mono","font_backup":"Arial, Helvetica, sans-serif","font_styles":"500","font_subset":"latin"}',

                # Headings                
                'h1_font'                                   => '{"font_family":"DM Sans","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400,500,600,700","font_subset":"latin","text_transform":"none","font_style":"normal","font_size":"100","font_size_unit":"px","line_height":"1.125","line_height_unit":"em","letter_spacing":"-0.05","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_weight":"500"}',
                'h2_font'                                   => '{"font_family":"DM Sans","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400,500,600,700","font_subset":"latin","text_transform":"none","font_style":"normal","font_size":"80","font_size_unit":"px","line_height":"1","line_height_unit":"em","letter_spacing":"-0.05","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_weight":"500"}',
                'h3_font'                                   => '{"font_family":"DM Sans","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400,500,600,700","font_subset":"latin","text_transform":"none","font_style":"normal","font_size":"40","font_size_unit":"px","line_height":"1.25","line_height_unit":"em","letter_spacing":"-0.05","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_weight":"500"}',
                'h4_font'                                   => '{"font_family":"DM Sans","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400,500,600,700","font_subset":"latin","text_transform":"none","font_style":"normal","font_size":"30","font_size_unit":"px","line_height":"1.16666","line_height_unit":"em","letter_spacing":"-0.05","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_weight":"500"}',
                'h5_font'                                   => '{"font_family":"DM Sans","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400,500,600,700","font_subset":"latin","text_transform":"none","font_style":"normal","font_size":"25","font_size_unit":"px","line_height":"1.4","line_height_unit":"em","letter_spacing":"-0.05","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_weight":"500"}',
                'h6_font'                                   => '{"font_family":"DM Sans","font_backup":"Arial, Helvetica, sans-serif","font_styles":"400,500,600,700","font_subset":"latin","text_transform":"none","font_style":"normal","font_size":"20","font_size_unit":"px","line_height":"1.5","line_height_unit":"em","letter_spacing":"-0.05","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_weight":"500"}',

                # Buttons
                'buttons_font'                              => '{"font_family":"Manrope","font_backup":"Arial, Helvetica, sans-serif","font_styles":"500,600","font_subset":"latin","font_size":"14","font_size_unit":"px","text_transform":"none","letter_spacing":"0","letter_spacing_unit":"em","word_spacing":"0","word_spacing_unit":"px","font_style":"normal","font_weight":"500"}',

            # Social Links
                'socials_target'                            => true,
                'social_buttons'                            => '',

            # Color Options
                # Standard colors
                'standard_default_text_color'               => '#333333',
                'standard_dark_text_color'                  => '#111111',
                'standard_light_text_color'                 => '#9b9b9b',
                'standard_accent_text_color'                => '#5091d9',
                'standard_contrast_text_color'              => '#ffffff',
                'standard_input_dark_color'                 => '#d9d9d9',
                'standard_border_color'                     => '#adadad',
                'standard_border_hover_color'               => '#333333',
                'standard_background_color'                 => '#ffffff',
                'standard_background_alter_color'           => '#f0f2f4',
                'standard_button_text_color'                => '#333333',
                'standard_button_border_color'              => '#26c6d1',
                'standard_button_border_color_add'          => '#7266e0',
                'standard_button_background_color'          => 'rgba(255,255,255,0)',
                'standard_button_background_color_add'      => 'rgba(255,255,255,0)',
                'standard_button_text_hover'                => '#ffffff',
                'standard_button_border_hover'              => '#1f1f1f',
                'standard_button_border_hover_add'          => '#1f1f1f',
                'standard_button_background_hover'          => '#1f1f1f',
                'standard_button_background_hover_add'      => '#1f1f1f',
                'standard_button_border_style'              => 'gradient',
                'standard_button_background_style'          => 'solid',

                # Contrast colors
                'contrast_default_text_color'               => '#f5f5f5',
                'contrast_dark_text_color'                  => '#f5f5f5',
                'contrast_light_text_color'                 => '#8f8f8f',
                'contrast_accent_text_color'                => '#4c96d8',
                'contrast_input_dark_color'                 => '#d9d9d9',
                'contrast_border_color'                     => '#adadad',
                'contrast_border_hover_color'               => '#3f3f3f',
                'contrast_background_color'                 => '#1f1f1f',
                'contrast_background_alter_color'           => '#333333',
                'contrast_button_text_color'                => '#ffffff',
                'contrast_button_border_color'              => '#26c6d1',
                'contrast_button_border_color_add'          => '#7266e0',
                'contrast_button_background_color'          => '#26c6d1',
                'contrast_button_background_color_add'      => '#7266e0',
                'contrast_button_text_hover'                => '#ffffff',
                'contrast_button_border_hover'              => '#26c6d1',
                'contrast_button_border_hover_add'          => '#7266e0',
                'contrast_button_background_hover'          => 'rgba(255,255,255,0)',
                'contrast_button_background_hover_add'      => 'rgba(255,255,255,0)',
                'contrast_button_border_style'              => 'gradient',
                'contrast_button_background_style'          => 'gradient',

            # Footer
                # General
                'footer_status'                             => 'on',
                'footer_style'                              => 'type-1',
                'footer_border_radius'                      => 'on',
                'footer_customize'                          => 'on',
                'footer_default_text_color'                 => '',
                'footer_dark_text_color'                    => '',
                'footer_light_text_color'                   => '#959595',
                'footer_accent_text_color'                  => '',
                'footer_input_dark_color'                   => '',
                'footer_border_color'                       => '',
                'footer_border_hover_color'                 => '',
                'footer_background_color'                   => '',
                'footer_background_alter_color'             => '',
                'footer_button_text_color'                  => '',
                'footer_button_border_color'                => '',
                'footer_button_border_color_add'            => '',
                'footer_button_background_color'            => '',
                'footer_button_background_color_add'        => '',
                'footer_button_text_hover'                  => '',
                'footer_button_border_hover'                => '',
                'footer_button_border_hover_add'            => '',
                'footer_button_background_hover'            => '',
                'footer_button_background_hover_add'        => '',
                'footer_button_border_style'                => 'gradient',
                'footer_button_background_style'            => 'gradient',
                'footer_background_image'                   => '',
                'footer_background_position'                => 'center center',
                'footer_background_repeat'                  => 'no-repeat',
                'footer_background_size'                    => 'cover',

                # Footer Widgets
                'footer_sidebar_status'                     => 'on',
                'footer_sidebar_select'                     => 'sidebar-footer',

                # Copyright
                'footer_copyright_status'                   => 'on',
                'footer_copyright_text'                     => esc_html__('©Aigency 2025. All rights reserved.', 'aigency'),

                # Footer Additional Menu
                'footer_additional_menu_status'             => 'on',
                'footer_additional_menu_select'             => 'default',

            # Footer Scroll To Top
                'footer_scrolltop_status'                   => 'off',
                'footer_scrolltop_bg_color'                 => '',
                'footer_scrolltop_bg_color_add'             => '',
                'footer_scrolltop_color'                    => '',
                'footer_scrolltop_bg_color_hover'           => '',
                'footer_scrolltop_bg_color_hover_add'       => '',
                'footer_scrolltop_color_hover'              => '',

            # Layout Settings

                'content_top_margin'                        => 'off',
                'content_bottom_margin'                     => 'off',

            # Pages
                'sidebar_position'                          => 'right',
                'page_sidebar_select'                       => 'sidebar',

            #Archive
                'archive_sidebar_position'                  => 'right',
                'archive_sidebar_select'                    => 'sidebar-archive',

            #Side Panel Settings
                'sidebar_logo_status'                       => 'off',
                'side_panel_sidebar_select'                 => 'sidebar-side',
                'sidebar_logo_image'                        => '',
                'sidebar_logo_retina'                       => false,
                'side_panel_bg_image_status'                => 'off',
                'side_panel_bg_image'                       => '',
                'side_panel_socials_status'                 => 'off',

            # Single Post
                # Post Settings
                'post_sidebar_position'                     => 'left',
                'post_sidebar_select'                       => 'sidebar-post',
                'post_page_title'                           => esc_html__('%\s', 'aigency'),
                'post_media_image_status'                   => 'on',
                'post_category_status'                      => 'on',
                'post_date_status'                          => 'on',
                'post_author_status'                        => 'on',
                'post_comment_counter_status'               => 'off',
                'post_title_status'                         => 'on',
                'post_tags_status'                          => 'on',
                'post_socials_status'                       => 'off',

                # Recent Posts Settings
                'recent_posts_status'                       => 'off',
                'recent_posts_customize'                    => 'off',
                'recent_posts_section_heading'              => esc_html__('Recent Posts', 'aigency'),
                'recent_posts_number'                       => '2',
                'recent_posts_order_by'                     => 'random',
                'recent_posts_order'                        => 'desc',
                'recent_posts_image'                        => 'on',
                'recent_posts_category'                     => 'on',
                'recent_posts_date'                         => 'on',
                'recent_posts_author'                       => 'on',
                'recent_posts_title'                        => 'on',
                'recent_posts_excerpt'                      => 'off',
                'recent_posts_excerpt_length'               => '120',
                'recent_posts_tags'                         => 'off',
                'recent_posts_more'                         => 'on',

            # Projects
                #General
                'project_posts_status'                      => 'on',

                # Archive
                'project_archive_sidebar_position'          => 'none',
                'project_archive_sidebar_select'            => 'sidebar-archive',
                'project_archive_page_title'                => esc_html__('Projects', 'aigency'),
                'project_archive_columns_number'            => 3,
                'project_archive_posts_per_page'            => 9,
                'project_posts_slug'                        => 'projects',
                'project_categories_slug'                   => 'project-categories',

                # Single
                'project_single_page_title'                 => esc_html__('%\s', 'aigency'),
                'project_title_status'                      => 'on',
                'project_single_navigation_max_length'      => 5,
                'project_cards_image'                       => '',

            # Case Studies
                #General
                'case_study_posts_status'                   => 'on',

                # Archive
                'case_archive_sidebar_position'             => 'none',
                'case_archive_sidebar_select'               => 'sidebar-archive',
                'case_studies_archive_page_title'           => esc_html__('Case Studies', 'aigency'),
                'case_studies_archive_excerpt_length'       => 83,
                'case_studies_archive_columns_number'       => 2,
                'case_studies_archive_posts_per_page'       => 6,
                'case_study_posts_slug'                     => 'case-studies',
                'case_study_categories_slug'                => 'case-study-categories',
                'case_study_tags_slug'                      => 'case-study-tags',

                #Single
                'case_studies_single_page_title'            => esc_html__('Case Study', 'aigency'),
                'case_study_sidebar_position'               => 'right',
                'case_study_sidebar_select'                 => 'sidebar-case-study',

            # Team
                #General
                'team_posts_status'                         => 'on',

                # Archive
                'team_archive_sidebar_position'             => 'none',
                'team_archive_sidebar_select'               => 'sidebar-archive',
                'team_archive_page_title'                   => esc_html__('Team', 'aigency'),
                'team_archive_columns_number'               => 4,
                'team_archive_posts_per_page'               => 12,
                'team_posts_slug'                           => 'team',
                'team_categories_slug'                      => 'team-departments',

                # Single
                'team_single_page_title'                    => esc_html__('Team Member', 'aigency'),

            # Vacancies
                #General
                'vacancy_posts_status'                      => 'on',

                # Archive
                'vacancy_archive_sidebar_position'          => 'none',
                'vacancy_archive_sidebar_select'            => 'sidebar-archive',
                'vacancy_archive_page_title'                => esc_html__('Careers', 'aigency'),
                'vacancy_archive_excerpt_length'            => 118,
                'vacancy_archive_posts_per_page'            => 5,
                'vacancy_posts_slug'                        => 'careers',
                'vacancy_categories_slug'                   => 'career-departments',

                # Single
                'vacancy_sidebar_position'                  => 'left',
                'vacancy_sidebar_select'                    => 'sidebar-vacancy',
                'vacancy_single_page_title'                 => esc_html__('Career Details', 'aigency'),
                'recent_vacancies_status'                   => 'on',
                'recent_vacancies_customize'                => 'off',
                'recent_vacancies_section_heading'          => esc_html__('Recent Careers', 'aigency'),
                'recent_vacancies_number'                   => 3,
                'recent_vacancies_order_by'                 => 'date',
                'recent_vacancies_order'                    => 'desc',

            # Services
                #General
                'service_posts_status'                      => 'on',

                # Archive
                'service_archive_sidebar_position'          => 'none',
                'service_archive_sidebar_select'            => 'sidebar-archive',
                'service_archive_page_title'                => esc_html__('Services', 'aigency'),
                'service_archive_excerpt_length'            => 151,
                'service_archive_columns_number'            => 2,
                'service_archive_posts_per_page'            => 8,
                'service_posts_slug'                        => 'services',
                'service_categories_slug'                   => 'service-categories',
                'service_tags_slug'                         => 'service-tags',

                # Single
                'service_sidebar_position'                  => 'right',
                'service_sidebar_select'                    => 'sidebar-service',
                'service_single_page_title'                 => esc_html__('%\s', 'aigency'),
                'service_title_status'                      => 'on',
                'service_media_status'                      => 'on',

            # 404 Error Page
                'error_logo_image'                          => '',
                'error_title'                               => sprintf(esc_html__("Ooooops!%s Page not found!", 'aigency'), '<br>'),
                'error_text'                                => esc_html__("You are here because you entered the address of a page that no longer exists or has been moved to a different address", 'aigency'),
                'error_logo_status'                         => 'off',
                'error_socials_status'                      => 'on',
                'error_button_status'                       => 'on',
                'error_button_text'                         => esc_html__('Home_page', 'aigency'),
                'error_text_color'                          => '',
                'error_text_hover_color'                    => '',
                'error_background_customize'                => 'on',
                'error_background_color'                    => '',
                'error_background_image'                    => get_template_directory_uri() . '/img/404-bg.jpg',
                'error_background_position'                 => 'center center',
                'error_background_repeat'                   => 'no-repeat',
                'error_background_size'                     => 'cover',

            # Page Settings
                'page_top_background_color'                 => '#f0f2f4',
                'page_top_border_radius'                    => 'on',
                'body_lines_status'                         => 'off',
                'body_lines_color'                          => '#eceef1',

            # WooCommerce
                'catalog_sidebar_position'                  => 'left',
                'catalog_sidebar_select'                    => 'sidebar-woocommerce',
                'woo_single_product_show_related_section'   => 'on',
                'woo_related_title'                         => esc_html__('Similar products', 'aigency'),
                'woo_single_product_title'                  => esc_html__('%\s', 'aigency'),
                'woo_single_product_show_name'              => false,
                'woo_upsells_title'                         => esc_html__('Up-Sells Products', 'aigency'),
                'woo_product_categories_title'              => esc_html__('Shop Category: %\s', 'aigency'),
                'woo_product_tags_title'                    => esc_html__('Product Tag: %\s', 'aigency')
        );
    }
}