<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php wp_head(); ?>
</head>

<!-- Body -->
<body <?php body_class(); ?>>

    <?php if ( aigency_get_theme_mod('page_loader_status') == 'on' ) { ?>
            <!-- Page Pre Loader -->
            <div class="page-loader-container">
                <div class="page-loader">
                    <div class="page-loader-inner">
                        <?php
                            if ( !empty(aigency_get_theme_mod('page_loader_image')) ) {
                                $loader_image_metadata = wp_get_attachment_metadata(attachment_url_to_postid(aigency_get_theme_mod('page_loader_image')));
                                $loader_image_width = (isset($loader_image_metadata['width']) ? $loader_image_metadata['width'] : 0);
                                $loader_image_height = (isset($loader_image_metadata['height']) ? $loader_image_metadata['height'] : 0);
                                $loader_image_url = aigency_get_theme_mod('page_loader_image');

                                echo '<img width="' . esc_attr($loader_image_width) . '" height="' . esc_attr($loader_image_height) . '" src="' . esc_url($loader_image_url) . '" alt="' . esc_attr__('Page Loader Image', 'aigency') . '"  class="page-loader-logo" />';
                            } else {
                                echo '<img width="198" height="100" src="' . get_template_directory_uri() . '/img/page-loader.png' . '" alt="' . esc_attr__('Page Loader Image', 'aigency') . '"  class="page-loader-logo" />';
                            }
                        ?>
                    </div>
                </div>
            </div>
        <?php } ?>
        
    <div class="error-404-wrapper">
        <div class="error-404-container">
            <div class="error-404-inner">
                <span class="error-404-text">404</span>
                <div class="error-404-content">
                    <?php
                        if ( aigency_get_theme_mod('error_logo_status') == 'on' && !empty(aigency_get_error_logo_output()) ) {
                            echo aigency_get_error_logo_output();
                        }
                        if ( !empty(aigency_get_theme_mod('error_title')) ) {
                            echo '<h1 class="error-404-title">' . wp_kses(aigency_get_theme_mod('error_title'), array('br' => array())) . '</h1>';
                        }
                        if ( !empty(aigency_get_theme_mod('error_text')) ) {
                            echo '<p class="error-404-info-text">' . esc_html(aigency_get_theme_mod('error_text')) . '</p>';
                        }
                        if ( !empty(aigency_get_theme_mod('error_button_text')) ) {
                            echo '<div class="error-404-button">';
                                echo '<a class="error-404-home-button aigency-button" href="' . esc_url(home_url('/')) . '">' . esc_html(aigency_get_theme_mod('error_button_text')) . '<span class="icon-button-icon"></span><span class="button-inner"></span></a>';
                            echo '</div>';
                        }
                        if (aigency_get_theme_mod('error_socials_status') == 'on' && !empty(aigency_socials_output())) {
                            echo aigency_socials_output('wrapper-socials');
                        }
                    ?>
                </div>
            </div>
        </div>
    </div>

<?php
    wp_footer();
?>
</body>
</html>