<?php
/*
 * Created by Artureanec
*/

namespace HFE\WidgetsManager\Widgets;

use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Aigency_Slide_Sidebar_Widget extends Widget_Base {

    public function get_name() {
        return 'aigency_slide_sidebar';
    }

    public function get_title() {
        return esc_html__('Slide Sidebar Trigger', 'aigency-plugin');
    }

    public function get_icon() {
        return 'eicon-sidebar';
    }

    public function get_categories() {
        return ['hfe-widgets'];
    }

    public function get_script_depends() {
        return ['elementor_widgets'];
    }

    public function is_reload_preview_required() {
        return true;
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Slide Sidebar Trigger', 'aigency-plugin')
            ]
        );

        $this->add_control(
            'sidebar',
            [
                'label'         => esc_html__('Select Sidebar', 'aigency-plugin'),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'sidebar-side',
                'options'       => aigency_get_all_sidebar_list()
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label'     => esc_html__('Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title'     => esc_html__('Left', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title'     => esc_html__('Center', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title'     => esc_html__('Right', 'aigency-plugin'),
                        'icon'      => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .aigency-slide-sidebar-widget' => 'text-align: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'sidebar_logo_status',
            [
                'label'         => esc_html__('Sidebar Logo', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'yes',
                'description'   => esc_html__('After changing this setting you need to Update changes to page via \'Apply\' button', 'aigency-plugin')
            ]
        );

        $this->add_control(
            'sidebar_socials_status',
            [
                'label'         => esc_html__('Sidebar Socials', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'yes',
                'description'   => esc_html__('After changing this setting you need to Update changes to page via \'Apply\' button', 'aigency-plugin')
            ]
        );

        $this->end_controls_section();

        // ----------------------------------- //
        // ---------- Icon Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'icon_section_settings',
            [
                'label' => esc_html__('Icon Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'button_width',
            [
                'label'         => esc_html__('Button Width', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    'px'            => [
                        'min' => 0,
                        'max' => 300
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dropdown-trigger .dropdown-trigger-item' => 'width: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'button_height',
            [
                'label'         => esc_html__('Button Height', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    'px'            => [
                        'min' => 0,
                        'max' => 300
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dropdown-trigger .dropdown-trigger-item' => 'height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label'         => esc_html__('Icon Size', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%', 'vw', 'rem'],
                'range'         => [
                    '%'             => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'em'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px'            => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'rem'           => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'vw'            => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .dropdown-trigger .dropdown-trigger-item' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__('Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dropdown-trigger .dropdown-trigger-item' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();


        // ----------------------------------- //
        // ---------- Card Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'sidebar_card_section_settings',
            [
                'label' => esc_html__('Sidebar Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'close_text',
            [
                'label'     => esc_html__('Close Button Text', 'aigency-plugin'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Close', 'aigency-plugin'),
                'description'   => esc_html__('After changing this setting you need to Update changes to page via \'Apply\' button', 'aigency-plugin')
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'close_text_typography',
                'label'     => esc_html__('Close Button Typography', 'aigency-plugin'),
                'exclude'    => ['line_height'],
                'selector'  => '#side-panel-{{ID}} .slide-sidebar-close'
            ]
        );

        $this->add_control(
            'close_text_text_color',
            [
                'label'     => esc_html__('Close Button Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '#side-panel-{{ID}} .slide-sidebar-close' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'sidebar_close_background_bg_title',
            [
                'label'     => esc_html__('Slide Panel Background', 'aigency-plugin'),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'sidebar_close_background',
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '#side-panel-{{ID}}:before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'sidebar_gradient_background',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Slide Panel Gradient', 'aigency-plugin' )
                    ]                    
                ],
                'types'     => [ 'gradient' ],
                'selector'  => '#side-panel-{{ID}} .slide-sidebar-gradient:after',
            ]
        );

        $this->add_responsive_control(
            'sidebar_card_padding',
            [
                'label'         => esc_html__('Sidebar Padding', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', '%', 'em', 'rem', 'vw'],
                'selectors'     => [
                    '#side-panel-{{ID}} .slide-sidebar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;'
                ],
                'separator'     => 'before'
            ]
        );

        $this->add_responsive_control(
            'sidebar_border_radius',
            [
                'label'         => esc_html__('Border Radius', 'aigency-plugin'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em', '%', 'vw', 'vh', 'rem'],
                'selectors'     => [
                    '#side-panel-{{ID}}' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '#side-panel-{{ID}} .slide-sidebar-gradient' => 'border-radius: 0 0 {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'      => 'sidebar_shadow',
                'selector'  => '#side-panel-{{ID}}:before',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'hr1',
            [
                'type' => Controls_Manager::DIVIDER
            ]
        );

        $this->add_control(
            'sidebar_customize_colors',
            [
                'label'         => esc_html__('Customize Colors', 'aigency-plugin'),
                'type'          => Controls_Manager::SWITCHER,
                'label_off'     => esc_html__('Hide', 'aigency-plugin'),
                'label_on'      => esc_html__('Show', 'aigency-plugin'),
                'return_value'  => 'yes',
                'default'       => 'yes'
            ]
        );

        $this->add_control(
            'sidebar_default_text_color',
            [
                'label'     => esc_html__('Default Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-default-text-color: {{VALUE}};'
                ],
                'default'   => '#f5f5f5',
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'sidebar_dark_text_color',
            [
                'label'     => esc_html__('Dark Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#f5f5f5',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-dark-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_light_text_color',
            [
                'label'     => esc_html__('Light Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#8f8f8f',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-light-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_accent_color',
            [
                'label'     => esc_html__('Accent Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#4c96d8',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-accent-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_input_dark_color',
            [
                'label'     => esc_html__('Input Dark Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#d9d9d9',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-input-dark-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_border_color',
            [
                'label'     => esc_html__('Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#adadad',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-border-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'sidebar_border_hover_color',
            [
                'label'     => esc_html__('Border Hover Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#3f3f3f',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-border-hover-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_background_color',
            [
                'label'     => esc_html__('Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#1f1f1f',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-background-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_background_alter_color',
            [
                'label'     => esc_html__('Background Alter Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333333',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-background-alter-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_text_color',
            [
                'label'     => esc_html__('Button Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-text-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'sidebar_button_border_color',
            [
                'label'     => esc_html__('Button Border Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#26c6d1',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-border-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_border_color_add',
            [
                'label'     => esc_html__('Button Border Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#7266e0',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-border-color-add: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_background_color',
            [
                'label'     => esc_html__('Button Background Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#26c6d1',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-background-color: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_background_color_add',
            [
                'label'     => esc_html__('Button Background Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#7266e0',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-background-color-add: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_text_hover',
            [
                'label'     => esc_html__('Hover Button Text Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-text-hover: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_border_hover',
            [
                'label'     => esc_html__('Button Border Hover Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#26c6d1',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-border-hover: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_border_hover_add',
            [
                'label'     => esc_html__('Button Border Hover Color Additional ', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#7266e0',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-border-hover-add: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_background_hover',
            [
                'label'     => esc_html__('Button Background Hover Color', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => 'rgba(255,255,255,0)',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-background-hover: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sidebar_button_background_hover_add',
            [
                'label'     => esc_html__('Button Background Hover Color Additional', 'aigency-plugin'),
                'type'      => Controls_Manager::COLOR,
                'default'   => 'rgba(255,255,255,0)',
                'selectors' => [
                    '#side-panel-{{ID}}' => '--aigency-contrast-button-background-hover-add: {{VALUE}};'
                ],
                'condition' => [
                    'sidebar_customize_colors' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings   = $this->get_settings();

        $widget_id  = $this->get_id();
        $sidebar    = !empty($settings['sidebar']) ? $settings['sidebar'] : 'sidebar-side';
        $close_text = $settings['close_text'];
        $sidebar_logo_status = $settings['sidebar_logo_status'];
        $sidebar_socials_status = $settings['sidebar_socials_status'];

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        echo '<div class="aigency-slide-sidebar-widget">';
            echo '<div class="dropdown-trigger" data-id="' . esc_attr($widget_id) . '">';
                echo '<div class="dropdown-trigger-item"></div>';
            echo '</div>';
        echo '</div>';

        if ( $sidebar_logo_status === 'yes' || $sidebar_socials_status === 'yes' || is_active_sidebar(esc_attr($sidebar)) ) {
            $slide_sidebar_classes = 'slide-sidebar-wrapper slide-sidebar-position-left';

            echo '<div class="' . esc_attr($slide_sidebar_classes) . '" id="side-panel-' . esc_attr($widget_id) . '">';
                echo '<div class="slide-sidebar-close">' . esc_html($close_text) . '</div>';
                echo '<div class="slide-sidebar">';
                    if( $sidebar_logo_status === 'yes' ) {
                        echo '<div class="sidebar-logo-container">' . aigency_get_sidebar_logo_output() . '</div>';
                    }                    
                    echo '<div class="slide-sidebar-content">';
                        dynamic_sidebar(esc_attr($sidebar));
                    echo '</div>';
                    if( $sidebar_socials_status === 'yes' ) {
                        echo aigency_socials_output('wrapper-socials');
                    }                    
                echo '</div>';
                echo '<span class="slide-sidebar-gradient"></span>';
            echo '</div>';
        }

    }

    protected function content_template() {}

    public function render_plain_content() {}
}