<?php
/*
 * Created by Artureanec
*/

namespace Aigency\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\REPEATER;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Aigency_Custom_Menu_Widget extends Widget_Base {

    public function get_name() {
        return 'aigency_custom_menu';
    }

    public function get_title() {
        return esc_html__('Custom Menu', 'aigency-plugin');
    }

    public function get_icon() {
        return 'eicon-nav-menu';
    }

    public function get_categories() {
        return ['aigency_widgets'];
    }

    protected function register_controls() {

        // ----------------------------- //
        // ---------- Content ---------- //
        // ----------------------------- //
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Custom Menu', 'aigency-plugin')
            ]
        );

        $this->add_control(
            'menu_style',
            [
                'label'     => esc_html__('Menu Style', 'aigency-plugin'),
                'type'      => Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    ''      => esc_html__('Default', 'aigency-plugin'),
                    'inline'  => esc_html__('Inline', 'aigency-plugin'),
                ],
                'prefix_class' => 'aigency-menu-style-'
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'text',
            [
                'label'         => esc_html__('Link Text', 'aigency-plugin'),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__('Enter Link Text', 'aigency-plugin')
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label'         => esc_html__( 'Link', 'aigency-plugin' ),
                'type'          => Controls_Manager::URL,
                'placeholder'   => esc_url( 'https://your-link.com' ),
                'default'       => [
                    'url'           => ''
                ]
            ]
        );

        $this->add_control(
            'items',
            [
                'label'         => esc_html__('Menu Items', 'aigency-plugin'),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $repeater->get_controls(),
                'title_field'   => '{{{text}}}',
                'prevent_empty' => false,
                'default'       => [
                    [
                        'text'      => ''
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
            'menu_align',
            [
                'label'     => esc_html__('Alignment', 'aigency-plugin'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'          => [
                        'title'         => esc_html__('Left', 'aigency-plugin'),
                        'icon'          => 'eicon-text-align-left',
                    ],
                    'center'        => [
                        'title'         => esc_html__('Center', 'aigency-plugin'),
                        'icon'          => 'eicon-text-align-center',
                    ],
                    'right'         => [
                        'title'         => esc_html__('Right', 'aigency-plugin'),
                        'icon'          => 'eicon-text-align-right',
                    ]
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}}'   => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // ----------------------------------- //
        // ---------- Items Settings ---------- //
        // ----------------------------------- //
        $this->start_controls_section(
            'section_items_settings',
            [
                'label' => esc_html__('Menu Items Settings', 'aigency-plugin'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'items_typography',
                'label'     => esc_html__('Labels Typography', 'aigency-plugin'),
                'selector'  => '{{WRAPPER}} .aigency-custom-menu-widget li'
            ]
        );

        $this->start_controls_tabs('controls_settings_tabs');

            // ------------------------ //
            // ------ Normal Tab ------ //
            // ------------------------ //
            $this->start_controls_tab(
                'tab_control_normal',
                [
                    'label' => esc_html__('Normal', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'labels_color',
                    [
                        'label'     => esc_html__('Link Text Color', 'aigency-plugin'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .aigency-custom-menu-widget li a' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // ----------------------- //
            // ------ Hover Tab ------ //
            // ----------------------- //
            $this->start_controls_tab(
                'tab_control_hover',
                [
                    'label' => esc_html__('Hover', 'aigency-plugin')
                ]
            );

                $this->add_control(
                    'labels_color_hover',
                    [
                        'label' => esc_html__('Link Text Color', 'aigency-plugin'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .aigency-custom-menu-widget li a:hover' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'items_margin',
            [
                'label'         => esc_html__('Space Between Items', 'aigency-plugin'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%'],
                'selectors'     => [
                    '{{WRAPPER}}:not(.aigency-menu-style-inline) .aigency-custom-menu-widget li:not(:first-child)' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}}.aigency-menu-style-inline .aigency-custom-menu-widget' => 'gap: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings   = $this->get_settings();
        $items      = $settings['items'];

        // ------------------------------------ //
        // ---------- Widget Content ---------- //
        // ------------------------------------ //
        ?>

        <ul class="aigency-custom-menu-widget">
            <?php
                foreach ($items as $item) {
                    $this->remove_render_attribute( 'link' );
                    if ( empty( $item['link']['url'] ) ) {
                        $item['link']['url'] = '#';
                    }
                    $this->add_link_attributes( 'link', $item['link'] );
                    if ( !empty($item['text']) ) {
                        echo '<li><a ' . $this->get_render_attribute_string('link') . '>' . esc_html($item['text']) . '</a></li>';
                    }
                }
            ?>
        </ul>

        <?php
    }

    protected function content_template() {}

    public function render_plain_content() {}
}